/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.finalprocessing.parser.autotrans;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.finalprocessing.info.AutoTransGenVchInfo;
import kd.fi.gl.finalprocessing.parser.autotrans.AbstractAutoTransExpParser;
import kd.fi.gl.finalprocessing.parser.autotrans.AutoTransBcmFormulaParser;

public class AutoTransRptExpParser
extends AbstractAutoTransExpParser<Map<String, Object>> {
    private static final Log logger = LogFactory.getLog(AutoTransBcmFormulaParser.class);

    public AutoTransRptExpParser(AutoTransGenVchInfo schemeInfo) {
        super(schemeInfo);
    }

    @Override
    public Map<String, Object> parse() {
        Map<String, Object> result = new HashMap<String, Object>();
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        DynamicObject curPeroid = this.schemeInfo.getCurPeroid();
        parammap.put("orgnumber", this.scheme.getDynamicObject("org").getString("number"));
        parammap.put("yearnumber", curPeroid.getString("periodyear"));
        parammap.put("periodnumber", curPeroid.getString("number").substring(4).replace("T", ""));
        ArrayList entryparams = new ArrayList(this.entries.size());
        parammap.put("entryparams", entryparams);
        for (DynamicObject row : this.entries) {
            int datasourcetype = row.getInt("datasourcetype");
            switch (datasourcetype) {
                case 8: 
                case 9: {
                    HashMap<String, Object> entryparam = new HashMap<String, Object>();
                    String rptexp = row.getString("rptexp");
                    if (StringUtils.isEmpty((CharSequence)rptexp)) break;
                    entryparam.put("rownumber", row.getString("autorowid"));
                    entryparam.put("currencynumber", row.getDynamicObject("currencyid").getString("number"));
                    entryparam.put("param", SerializationUtils.deSerializeFromBase64((String)rptexp));
                    entryparams.add(entryparam);
                }
            }
        }
        if (parammap.get("entryparams") != null && !((List)parammap.get("entryparams")).isEmpty()) {
            String rptResult;
            try {
                rptResult = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"bcm", (String)"ReportToVoucherMsService", (String)"execute", (Object[])new Object[]{SerializationUtils.serializeToBase64(parammap)});
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                throw new KDBizException(ResManager.loadKDString((String)"\u53d6\u6570\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"AutoTransRptExpParser_0", (String)"fi-gl-opplugin", (Object[])new Object[0]));
            }
            if (StringUtils.isNotBlank((CharSequence)rptResult)) {
                result = (Map)SerializationUtils.deSerializeFromBase64((String)rptResult);
            }
            if (DebugTrace.enable()) {
                logger.info(String.format("financial report data fetch for input:\nwith parameter: %s \n and the result: %s", SerializationUtils.toJsonString(parammap), SerializationUtils.toJsonString(result)));
            }
        }
        return result;
    }
}

