/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.finalprocessing.validate;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.enums.AmortStyle;
import kd.fi.gl.finalprocess.info.scheme.VchAmortScheme;
import kd.fi.gl.finalprocess.service.AbstractEndingProcessingService;
import kd.fi.gl.finalprocess.service.impl.VchAmortService;
import kd.fi.gl.finalprocessing.validate.FinalProcessingGenVchValidator;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.ValidateUtils;
import kd.fi.gl.util.VoucherAmortSchemeUtils;

public class AmortGenVchValidator
extends FinalProcessingGenVchValidator {
    public AmortGenVchValidator(String org, String bookstype) {
        super(org, bookstype);
    }

    @Override
    protected AbstractEndingProcessingService getEndingProcessService(DynamicObject dataEntity) {
        return new VchAmortService(new VchAmortScheme(dataEntity));
    }

    @Override
    public String[] check(DynamicObject scheme, AccountBookInfo bookInfo) {
        Long curPeriodId;
        QFilter idFilter;
        DynamicObject curPeriodDyn;
        ArrayList<String> errList = new ArrayList<String>();
        if (scheme == null) {
            errList.add(ResManager.loadKDString((String)"\u65b9\u6848\u5df2\u88ab\u5220\u9664\u3002", (String)"AmortGenVchValidator_0", (String)"fi-gl-opplugin", (Object[])new Object[0]));
            return errList.toArray(new String[0]);
        }
        String enable = scheme.getString("billstatus");
        if ("0".equals(enable)) {
            errList.add(ResManager.loadKDString((String)"\u65b9\u6848\u5df2\u88ab\u7981\u7528\u3002", (String)"AmortGenVchValidator_1", (String)"fi-gl-opplugin", (Object[])new Object[0]));
            return errList.toArray(new String[0]);
        }
        DynamicObject org = scheme.getDynamicObject("org");
        if (bookInfo == null) {
            errList.add(ResManager.loadKDString((String)"\u65b9\u6848\u8d26\u7c3f\u4e3a\u7a7a", (String)"AmortGenVchValidator_2", (String)"fi-gl-opplugin", (Object[])new Object[0]));
            return errList.toArray(new String[0]);
        }
        String companyname = org.getString("name");
        boolean hasPermission = this.hasFunctionPermission("gl_vchamort_gen");
        if (!hasPermission) {
            errList.add(ResManager.loadKDString((String)"\u65b9\u6848%s\u6ca1\u6709\u751f\u6210\u51ed\u8bc1\u7684\u6743\u9650", (String)"AmortGenVchValidator_3", (String)"fi-gl-opplugin", (Object[])new Object[]{companyname}));
            return errList.toArray(new String[0]);
        }
        BigDecimal periodAmortVal = scheme.getBigDecimal("periodamortamount");
        if (BigDecimal.ZERO.compareTo(periodAmortVal) == 0 && !AmortStyle.isCustome((String)scheme.getString("amortstyle"))) {
            errList.add(ResManager.loadKDString((String)"\u65b9\u6848\u201c%s\u201d\u6bcf\u671f\u644a\u9500\u91d1\u989d\u4e0d\u80fd\u4e3a0\u3002", (String)"AmortGenVchValidator_4", (String)"fi-gl-opplugin", (Object[])new Object[]{companyname}));
        }
        DynamicObjectCollection targetAccounts = scheme.getDynamicObjectCollection("targetaccounts");
        DynamicObjectCollection destAccounts = scheme.getDynamicObjectCollection("destaccounts");
        DynamicObjectCollection[] allAcctsArray = new DynamicObjectCollection[]{targetAccounts, destAccounts};
        String[] accountsTypes = new String[]{"target", "dest"};
        for (int i = 0; i < allAcctsArray.length; ++i) {
            for (int j = 0; j < allAcctsArray[i].size(); ++j) {
                DynamicObject acct = ((DynamicObject)allAcctsArray[i].get(j)).getDynamicObject(accountsTypes[i] + "account");
                if (acct == null || !ValidateUtils.checkPermissionForBasedata((String)"bd_accountview", (Long)((Long)org.getPkValue()), (Long)((Long)acct.getPkValue()))) {
                    String entryName = ResManager.loadKDString((String)"\u5f85\u644a\u79d1\u76ee", (String)"AmortGenVchValidator_6", (String)"fi-gl-opplugin", (Object[])new Object[0]);
                    if (i == 1) {
                        entryName = ResManager.loadKDString((String)"\u8f6c\u5165\u79d1\u76ee", (String)"AmortGenVchValidator_7", (String)"fi-gl-opplugin", (Object[])new Object[0]);
                    }
                    errList.add(ResManager.loadKDString((String)"\u65b9\u6848\u4e2d%1$s\u5f15\u7528\u7684\u7b2c%2$s\u884c\u79d1\u76ee\u5df2\u88ab\u5220\u9664\u6216\u65e0\u6743\u9650\u4f7f\u7528", (String)"AmortGenVchValidator_8", (String)"fi-gl-opplugin", (Object[])new Object[]{entryName, j + 1}));
                    return errList.toArray(new String[0]);
                }
                if (!"0".equals(acct.getString("enable"))) continue;
                errList.add(ResManager.loadKDString((String)"\u65b9\u6848\u4e2d\u5f15\u7528\u7684%s\u88ab\u7981\u7528", (String)"AmortGenVchValidator_11", (String)"fi-gl-opplugin", (Object[])new Object[]{acct.getString("name")}));
                return errList.toArray(new String[0]);
            }
        }
        long localcurid = bookInfo.getBaseCurrencyId();
        long orgcurid = scheme.getLong("currency_id");
        if (orgcurid != localcurid) {
            boolean isTrue = true;
            DynamicObjectCollection targetaccounts = scheme.getDynamicObjectCollection("targetaccounts");
            for (int j = 0; j < targetaccounts.size(); ++j) {
                MainEntityType accountType = EntityMetadataCache.getDataEntityType((String)"bd_accountview");
                DynamicObject targetAccount = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)targetaccounts.get(j)).get("targetaccount_id"), (DynamicObjectType)accountType);
                Object accountingcurrency = targetAccount.get("acctcurrency");
                if (!"nocurrency".equals(accountingcurrency)) continue;
                isTrue = false;
                break;
            }
            if (!isTrue) {
                errList.add(ResManager.loadKDString((String)"\u65b9\u6848\u5e01\u79cd\u4e3a\u5916\u5e01\uff0c\u800c\u644a\u9500\u79d1\u76ee\u4e0d\u6838\u7b97\u5916\u5e01\uff0c\u65e0\u6cd5\u751f\u6210\u51ed\u8bc1\u3002", (String)"AmortGenVchValidator_13", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                return errList.toArray(new String[0]);
            }
        }
        if ((curPeriodDyn = BusinessDataServiceHelper.loadSingle((String)"bd_period", (String)"isadjustperiod", (QFilter[])(idFilter = new QFilter("id", "=", (Object)(curPeriodId = Long.valueOf(bookInfo.getCurPeriodId(this.specifiedPeriodId))))).toArray())) == null || curPeriodDyn.getBoolean("isadjustperiod")) {
            errList.add(ResManager.loadKDString((String)"\u65b9\u6848\u5f53\u524d\u671f\u95f4\u4e3a\u8c03\u6574\u671f\uff0c\u4e0d\u751f\u6210\u51ed\u8bc1\u3002", (String)"AmortGenVchValidator_14", (String)"fi-gl-opplugin", (Object[])new Object[0]));
            return errList.toArray(new String[0]);
        }
        boolean isAmorted = this.isCurPolicies(scheme.getDynamicObjectCollection("policies"), curPeriodId);
        if (isAmorted) {
            errList.add(ResManager.loadKDString((String)"\u65b9\u6848\u5f53\u524d\u671f\u95f4\u5df2\u751f\u6210\u51ed\u8bc1\u3002", (String)"AmortGenVchValidator_15", (String)"fi-gl-opplugin", (Object[])new Object[0]));
            return errList.toArray(new String[0]);
        }
        if ("3".equals(scheme.get("status"))) {
            errList.add(ResManager.loadKDString((String)"\u65b9\u6848\u5df2\u644a\u9500\u5b8c\u6bd5\uff0c\u4e0d\u5141\u8bb8\u518d\u751f\u6210\u51ed\u8bc1\u3002", (String)"AmortGenVchValidator_16", (String)"fi-gl-opplugin", (Object[])new Object[0]));
            return errList.toArray(new String[0]);
        }
        errList.addAll(this.checkLegalPeriod(scheme, bookInfo, curPeriodId));
        hasPermission = this.hasFunctionPermission("gl_voucher_add");
        if (!hasPermission) {
            errList.add(ResManager.loadKDString((String)"\u65b9\u6848\u6ca1\u6709\u51ed\u8bc1\u65b0\u589e\u6743\u9650\u3002", (String)"AmortGenVchValidator_19", (String)"fi-gl-opplugin", (Object[])new Object[0]));
            return errList.toArray(new String[0]);
        }
        hasPermission = this.hasFunctionPermission("bd_assistant_voucherType_view");
        if (!hasPermission) {
            errList.add(ResManager.loadKDString((String)"\u65b9\u6848\u65e0\u6743\u83b7\u53d6\u51ed\u8bc1\u7c7b\u578b\u3002", (String)"AmortGenVchValidator_20", (String)"fi-gl-opplugin", (Object[])new Object[0]));
            return errList.toArray(new String[0]);
        }
        return errList.toArray(new String[0]);
    }

    private List<String> checkLegalPeriod(DynamicObject scheme, AccountBookInfo bookInfo, Long curPeriodId) {
        ArrayList<String> result = new ArrayList<String>(1);
        String amortStyle = scheme.getString("amortstyle");
        switch (AmortStyle.getEnumObj((String)amortStyle)) {
            case DATE: {
                Long endPeriodId;
                Long startPeriodId;
                List periodIds;
                Date dateBegin = scheme.getDate("begindate");
                Date dateEnd = scheme.getDate("enddate");
                DynamicObject startPeriod = GLUtil.getPeriodByDate((Date)dateBegin, (long)bookInfo.getPeriodTypeId());
                DynamicObject endPeriod = GLUtil.getPeriodByDate((Date)dateEnd, (long)bookInfo.getPeriodTypeId());
                if (startPeriod == null || endPeriod == null || (periodIds = VoucherAmortSchemeUtils.getPeriodIds((Long)(startPeriodId = Long.valueOf(startPeriod.getLong("id"))), (Long)(endPeriodId = Long.valueOf(endPeriod.getLong("id"))))).contains(curPeriodId)) break;
                result.add(ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u4e0d\u5728\u644a\u9500\u65b9\u6848\u8bbe\u7f6e\u7684\u65e5\u671f\u8303\u56f4\u5bf9\u5e94\u671f\u95f4\u4e4b\u5185\u3002", (String)"AmortGenVchValidator_17", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                break;
            }
            case CUSTOME: {
                Optional<DynamicObject> first = scheme.getDynamicObjectCollection("custompolicies").stream().filter(v -> v.getLong("cperiod_id") == bookInfo.getCurPeriodId()).findFirst();
                if (first.isPresent()) break;
                result.add(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u644a\u9500\u671f\u95f4\u4e0d\u5305\u542b\u4f1a\u8ba1\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\u3002", (String)"AmortGenVchOperateService_0", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                break;
            }
            default: {
                int planPeriodCount = scheme.getInt("planperiod");
                int amortPeriodCount = scheme.getInt("amortperiod");
                int periodCount = planPeriodCount + amortPeriodCount;
                long startPeriodId = scheme.getLong("startperiod_id");
                long maxPeriodId = VoucherAmortSchemeUtils.getMaxPeriodIdByCount((long)startPeriodId, (int)periodCount, (String)"0");
                if (maxPeriodId >= curPeriodId && startPeriodId <= curPeriodId) break;
                result.add(ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u4e0d\u5728\u644a\u9500\u65b9\u6848\u7684\u8bbe\u7f6e\u671f\u95f4\u4e4b\u5185\u3002", (String)"AmortGenVchValidator_18", (String)"fi-gl-opplugin", (Object[])new Object[0]));
            }
        }
        return result;
    }

    private boolean hasFunctionPermission(String permission) {
        return true;
    }

    private boolean isCurPolicies(DynamicObjectCollection policies, Object curperiodid) {
        int size = policies.size();
        for (int i = 0; i < size; ++i) {
            if (!curperiodid.equals(((DynamicObject)policies.get(i)).get("period_id"))) continue;
            return true;
        }
        return false;
    }
}

