/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.opplugin;

import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.gl.opplugin.AccRiskSettingValidator;
import kd.fi.gl.util.GLUtil;

public class AccRiskSettingOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AccRiskSettingValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            DynamicObject[] cols;
            String str = dataEntity.getString("accedit");
            if (StringUtils.isBlank((CharSequence)str)) continue;
            Map riskAccMap = (Map)GLUtil.fromSerializedString((String)str);
            QFilter filter = new QFilter("id", "in", riskAccMap.keySet());
            for (DynamicObject col : cols = BusinessDataServiceHelper.load((String)"gl_bill_accriskset", (String)"id,accounts", (QFilter[])new QFilter[]{filter})) {
                long id = col.getLong("id");
                Set rmvAccSet = (Set)riskAccMap.get(id);
                DynamicObjectCollection accounts = col.getDynamicObjectCollection("accounts");
                accounts.removeIf(x -> rmvAccSet.contains(x.getLong("fbasedataid_id")));
            }
            SaveServiceHelper.save((DynamicObject[])cols);
            long[] emptyRiskIds = Stream.of(cols).filter(x -> x.getDynamicObjectCollection("accounts").size() == 0).mapToLong(y -> y.getLong("id")).toArray();
            DeleteServiceHelper.delete((String)"gl_bill_accriskset", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)emptyRiskIds)});
            dataEntity.set("accedit", (Object)"");
        }
    }
}

