/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.opplugin;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.consts.AccountType;
import kd.fi.bd.util.MultiLangPunc;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.finalprocess.constant.AdjustExchangeRateConstant;
import kd.fi.gl.finalprocess.info.scheme.AdjustExchangeRateScheme;
import kd.fi.gl.finalprocess.info.scheme.DynamicEntry;
import kd.fi.gl.finalprocess.info.scheme.DynamicEntryRow;
import kd.fi.gl.finalprocess.info.scheme.PropertyKey;
import kd.fi.gl.util.AccountUtils;
import kd.fi.gl.util.FinalProcessUtil;
import kd.fi.gl.util.QFBuilder;
import kd.fi.gl.util.TipsUtils;

public class AdjustExchangeRateSaveValidator
extends AbstractValidator {
    private Map<ExtendedDataEntity, Table<Long, Long, Set<String>>> buildResultCache;
    private Map<ExtendedDataEntity, Set<Long>> currencyCacheOnEntity;

    public void initializeConfiguration() {
        super.initializeConfiguration();
        this.setEntityKey("gl_adjustexchangerate");
    }

    protected void addMessage(ExtendedDataEntity dataEntity, String title, String content, ErrorLevel errorLevel) {
        ValidationErrorInfo operateInfo = new ValidationErrorInfo("", dataEntity, "Error001", title, content, errorLevel);
        this.getValidateResult().addErrorInfo((OperateErrorInfo)operateInfo);
    }

    public boolean isEmpty(Object str) {
        return str == null || "".equals(((String)str).trim());
    }

    public boolean isZero(long args) {
        return args == 0L;
    }

    public void validate() {
        this.buildAndCacheAllEntities();
        this.checkRepetitiveBetweenEntities();
        for (ExtendedDataEntity entity : this.dataEntities) {
            if (!this.checkSchemeCompleteness(entity)) continue;
            this.checkOpenBudget(entity);
            this.checkAdjustExchangeRateIsRepeat(entity);
            this.validateAssignedDate(entity);
            this.checkComAssistValue(entity);
            this.checkAutoAgainstValue(entity);
        }
    }

    protected void addErrorMessage(ExtendedDataEntity dataEntity, String content) {
        super.addErrorMessage(dataEntity, TipsUtils.safeSuffix((String)content, (String)MultiLangPunc.fullStop()));
    }

    private void checkOpenBudget(ExtendedDataEntity entity) {
        long plAccId;
        Set accTypeId;
        DynamicObject dataEntity = entity.getDataEntity();
        AdjustExchangeRateScheme scheme = new AdjustExchangeRateScheme(dataEntity);
        AccountBookInfo bookInfo = scheme.getAccountBookInfo();
        if (!bookInfo.isBudget() && (accTypeId = AccountUtils.getAccTypeId((long)scheme.getAccountTableId(), (boolean)bookInfo.isBudget())).contains(plAccId = scheme.getDataEntity().getDynamicObject("placcountid").getDynamicObject("accounttype").getLong("id"))) {
            this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u8c03\u6c47\u65b9\u6848 \u201c%1$s\u201d\u7684\u8d26\u7c3f\u5df2\u5173\u95ed\u9884\u7b97\u4f1a\u8ba1\u529f\u80fd\uff0c\u8be5\u65b9\u6848\u4e0d\u5141\u8bb8\u4f7f\u7528\u9884\u7b97\u4f1a\u8ba1\u79d1\u76ee\u3002", (String)"AdjustExchangeRateSaveValidator_8", (String)"fi-gl-opplugin", (Object[])new Object[0]), entity.getBillNo()));
        }
    }

    private void checkRepetitiveBetweenEntities() {
        for (int i = 0; i < this.dataEntities.length; ++i) {
            for (int j = i + 1; j < this.dataEntities.length; ++j) {
                if (!this.checkRepetitiveOnCurrency(this.dataEntities[i], this.dataEntities[j]) || !this.checkRepetitiveOnAcctAndAssistValue(this.buildResultCache.get(this.dataEntities[i]), this.buildResultCache.get(this.dataEntities[j]))) continue;
                this.addRepetitiveMsg(this.dataEntities[j], this.dataEntities[i].getBillNo(), this.dataEntities[j].getBillNo());
            }
        }
    }

    private boolean checkRepetitiveOnCurrency(ExtendedDataEntity entityCur, ExtendedDataEntity entityToCheck) {
        Set<Long> curCurrencySet = this.currencyCacheOnEntity.get(entityCur);
        Set<Long> currencySetToCheck = this.currencyCacheOnEntity.get(entityToCheck);
        return curCurrencySet.stream().anyMatch(currencySetToCheck::contains);
    }

    private void buildAndCacheAllEntities() {
        this.buildResultCache = new HashMap<ExtendedDataEntity, Table<Long, Long, Set<String>>>(this.dataEntities.length);
        this.currencyCacheOnEntity = new HashMap<ExtendedDataEntity, Set<Long>>(this.dataEntities.length);
        for (ExtendedDataEntity entity : this.dataEntities) {
            DynamicObject schemeDyo = entity.getDataEntity();
            this.buildResultCache.put(entity, this.buildAccountAssgrpKeyMap(schemeDyo));
            Set currencySet = entity.getDataEntity().getDynamicObjectCollection("locentry").stream().map(currencyRow -> currencyRow.getLong("loccurrency_id")).collect(Collectors.toSet());
            this.currencyCacheOnEntity.put(entity, currencySet);
        }
    }

    private boolean checkSchemeCompleteness(ExtendedDataEntity entity) {
        DynamicObjectCollection aeAccCol;
        String setaccountgroup;
        String setcuruencygroup = (String)entity.getValue("setcuruencygroup");
        String adjustStyle = (String)entity.getValue("adjuststyle");
        if ("2".equals(setcuruencygroup)) {
            DynamicObjectCollection locEntry = (DynamicObjectCollection)entity.getValue("locentry");
            if (locEntry.size() == 0) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u8c03\u6c47\u5e01\u79cd\u672a\u8bbe\u7f6e\uff0c\u65b9\u6848\u4fdd\u5b58\u5931\u8d25\u3002", (String)"AdjustExchangeRateSaveValidator_0", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                return false;
            }
            for (DynamicObject dynamicObject : locEntry) {
                if (StringUtils.isEmpty((Object)dynamicObject.get("loccurrency"))) {
                    this.addErrorMessage(entity, ResManager.loadKDString((String)"\u672c\u4f4d\u5e01\u5b58\u5728\u5e01\u79cd\u4e3a\u7a7a\u7684\u8bb0\u5f55\uff0c\u65b9\u6848\u4fdd\u5b58\u5931\u8d25\u3002", (String)"AdjustExchangeRateSaveValidator_1", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                    return false;
                }
                if (!"2".equals(adjustStyle) || dynamicObject.getBigDecimal("rate").compareTo(BigDecimal.ZERO) > 0) continue;
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u8c03\u6c47\u65b9\u5f0f\u4e3a\u6309\u6307\u5b9a\u6c47\u7387\u65f6\uff0c\u6c47\u7387\u5b57\u6bb5\u7684\u503c\u9700\u5927\u4e8e\u96f6", (String)"AdjustExchangeRateSaveValidator_6", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                return false;
            }
        }
        if ("2".equals(setaccountgroup = (String)entity.getValue("setaccountgroup")) && ((aeAccCol = (DynamicObjectCollection)entity.getValue("accountentry")) == null || aeAccCol.size() == 0)) {
            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6307\u5b9a\u7684\u79d1\u76ee\u3002", (String)"AdjustExchangeRateSaveValidator_2", (String)"fi-gl-opplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void validateAssignedDate(ExtendedDataEntity entity) {
        String adjustStyle = (String)entity.getValue("adjuststyle");
        String monthAt = (String)entity.getValue("ratemonthbtngrp");
        String dayAt = (String)entity.getValue("date");
        if (adjustStyle.equals("3")) {
            if (monthAt == null || StringUtils.isEmpty((Object)monthAt)) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8c03\u6c47\u65b9\u5f0f\u9009\u9879\uff0c\u5e76\u6307\u5b9a\u671f\u95f4\u3002", (String)"AdjustExchangeRateSaveValidator_3", (String)"fi-gl-opplugin", (Object[])new Object[0]));
            }
            if (dayAt == null || StringUtils.isEmpty((Object)dayAt)) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8c03\u6c47\u65b9\u5f0f\u9009\u9879\uff0c\u5e76\u6307\u5b9a\u65e5\u671f\u3002", (String)"AdjustExchangeRateSaveValidator_4", (String)"fi-gl-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private void checkAdjustExchangeRateIsRepeat(ExtendedDataEntity entity) {
        DynamicObject dataEntity = entity.getDataEntity();
        AdjustExchangeRateScheme scheme = new AdjustExchangeRateScheme(dataEntity);
        long orgId = scheme.getOrgId();
        long bookTypeId = scheme.getAccountBookInfo().getBookTypeId();
        QFBuilder filters = new QFBuilder();
        if (entity.getDataEntity().getDataEntityState().getFromDatabase()) {
            filters.add(AdjustExchangeRateConstant.Entity_ID.getFilter("!=", entity.getBillPkId()));
        }
        filters.add(AdjustExchangeRateConstant.Entity_Org.getFilter("gl_adjustexchangerate", "=", (Object)orgId)).and(AdjustExchangeRateConstant.Entity_AccountBookType.getFilter("gl_adjustexchangerate", "=", (Object)bookTypeId));
        String setcuruencygroup = dataEntity.getString(AdjustExchangeRateConstant.Entity_AdjustCurrencyType.key);
        if ("2".equals(setcuruencygroup)) {
            Set currencySet = new DynamicEntry(dataEntity, new PropertyKey[]{AdjustExchangeRateConstant.Entity_AdjustCurrency}).getEntryPropSet(AdjustExchangeRateConstant.Entity_AdjustCurrency).stream().mapToLong(currencyDyo -> (Long)((DynamicObject)currencyDyo).getPkValue()).collect(HashSet::new, Set::add, (set1, set2) -> set2.addAll(set1));
            filters.add(AdjustExchangeRateConstant.Entity_AdjustCurrencyType.getFilter("!=", (Object)"2").or(AdjustExchangeRateConstant.Entity_AdjustCurrencyType.getFilter("=", (Object)"2").and(AdjustExchangeRateConstant.Entity_AdjustCurrency.getFilter("in", (Object)currencySet))));
        }
        String setaccountgroup = dataEntity.getString(AdjustExchangeRateConstant.Entity_AdjustAccountType.key);
        HashSet<String> repetitiveSchemeNumSet = new HashSet<String>(8);
        if ("2".equals(setaccountgroup)) {
            Table<Long, Long, Set<String>> curAccountAssgrpKeyMap = this.buildAccountAssgrpKeyMap(entity);
            Collection repetitiveSchemesOnCurrency = BusinessDataServiceHelper.loadFromCache((String)"gl_adjustexchangerate", (String)PropertyKey.getSelectPropertyFields((PropertyKey[])new PropertyKey[]{AdjustExchangeRateConstant.Entity_Org, AdjustExchangeRateConstant.Entity_AccountBookType, AdjustExchangeRateConstant.Entity_BillNo, AdjustExchangeRateConstant.Entry_AdjustAccount, AdjustExchangeRateConstant.ENTITY_PL_ACCOUNT, AdjustExchangeRateConstant.Entity_BaseDataAssgrpValue, AdjustExchangeRateConstant.Entity_AssgrpType, AdjustExchangeRateConstant.Entity_HomeMadeValue}), (QFilter[])filters.toArray()).values();
            long[] compareIds = new long[2];
            compareIds[0] = scheme.getDataEntity().getDynamicObject("placcountid").getLong("id");
            for (DynamicObject dyo : repetitiveSchemesOnCurrency) {
                String schemeNum = dyo.getString("billno");
                Table<Long, Long, Set<String>> repetitiveMap = this.buildAccountAssgrpKeyMap(dyo);
                if (repetitiveMap.isEmpty()) {
                    compareIds[1] = dyo.getDynamicObject("placcountid").getLong("id");
                    DynamicObjectCollection query = QueryServiceHelper.query((String)"bd_accountview", (String)"accounttype.accounttype", (QFilter[])new QFilter("id", "in", (Object)compareIds).toArray());
                    if (query.stream().map(dyn -> AccountType.isBudGetType((String)dyn.getString("accounttype.accounttype"))).collect(Collectors.toList()).stream().distinct().count() == 1L) {
                        this.addRepetitiveMsg(entity, schemeNum, entity.getBillNo());
                    }
                }
                if (!this.checkRepetitiveOnAcctAndAssistValue(curAccountAssgrpKeyMap, repetitiveMap)) continue;
                this.addRepetitiveMsg(entity, schemeNum, entity.getBillNo());
            }
        } else {
            DynamicObjectCollection repetitiveSchemeDyo = QueryServiceHelper.query((String)"gl_adjustexchangerate", (String)"billno,placcountid", (QFilter[])filters.toArray());
            DynamicObject curSchemeAcc = QueryServiceHelper.queryOne((String)"bd_accountview", (String)"accounttype.accounttype", (QFilter[])new QFilter("id", "=", scheme.getDataEntity().getDynamicObject("placcountid").getPkValue()).toArray());
            String plAccType = curSchemeAcc.getString("accounttype.accounttype");
            for (DynamicObject dynamicObject : repetitiveSchemeDyo) {
                DynamicObject accountDyn = QueryServiceHelper.queryOne((String)"bd_accountview", (String)"accounttype.accounttype", (QFilter[])new QFilter("id", "=", (Object)dynamicObject.getLong("placcountid")).toArray());
                String accType = accountDyn.getString("accounttype.accounttype");
                if (AccountType.isBudGetType((String)plAccType) != AccountType.isBudGetType((String)accType)) continue;
                repetitiveSchemeNumSet.add(dynamicObject.getString("billno"));
            }
        }
        if (!repetitiveSchemeNumSet.isEmpty()) {
            String numberJoinStr = String.join((CharSequence)", ", repetitiveSchemeNumSet);
            this.addRepetitiveMsg(entity, numberJoinStr, entity.getBillNo());
        }
    }

    private void addRepetitiveMsg(ExtendedDataEntity repetitiveEntity, String repetitiveBillNo, String curBillNo) {
        this.addMessage(repetitiveEntity, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8c03\u6c47\u65b9\u6848 \"%1$s\" \u7684\u8c03\u6c47\u79d1\u76ee\u3001\u7ef4\u5ea6\u548c\u5e01\u79cd\u7ec4\u5408\u4e0e\u5386\u53f2\u65b9\u6848\"%2$s\"\u91cd\u590d\u3002", (String)"AdjustExchangeRateSaveValidator_5", (String)"fi-gl-opplugin", (Object[])new Object[0]), curBillNo, repetitiveBillNo));
    }

    private boolean checkRepetitiveOnAcctAndAssistValue(Table<Long, Long, Set<String>> curBuildResult, Table<Long, Long, Set<String>> buildResultToCheck) {
        HashMap<Long, Boolean> account2isRepeat = new HashMap<Long, Boolean>(16);
        for (Table.Cell entry : curBuildResult.cellSet()) {
            Long accountId = (Long)entry.getRowKey();
            Long assType = (Long)entry.getColumnKey();
            Set curValueSet = (Set)entry.getValue();
            if (buildResultToCheck.isEmpty()) {
                return false;
            }
            if (buildResultToCheck.get((Object)accountId, (Object)-1L) != null) {
                return true;
            }
            if (!buildResultToCheck.containsRow((Object)accountId)) continue;
            Set othValueSet = (Set)buildResultToCheck.get((Object)accountId, (Object)assType);
            account2isRepeat.putIfAbsent(accountId, Boolean.TRUE);
            if (!((Boolean)account2isRepeat.get(accountId)).booleanValue() || assType == -1L) continue;
            if (othValueSet != null) {
                if (othValueSet.isEmpty() || curValueSet.isEmpty()) continue;
                if (!othValueSet.stream().noneMatch(curValueSet::contains)) continue;
            }
            account2isRepeat.put(accountId, Boolean.FALSE);
        }
        return account2isRepeat.containsValue(Boolean.TRUE);
    }

    private Table<Long, Long, Set<String>> buildAccountAssgrpKeyMap(ExtendedDataEntity entity) {
        Table<Long, Long, Set<String>> cacheRes = this.buildResultCache.get(entity);
        return cacheRes != null ? cacheRes : this.buildAccountAssgrpKeyMap(entity.getDataEntity());
    }

    private Table<Long, Long, Set<String>> buildAccountAssgrpKeyMap(DynamicObject dataEntity) {
        HashBasedTable acctAssgrpTable = HashBasedTable.create();
        DynamicEntry entry = new DynamicEntry(dataEntity, new PropertyKey[]{AdjustExchangeRateConstant.Entry_AdjustAccount, AdjustExchangeRateConstant.Entity_Entry_AdjustAssgrp});
        Map<Long, Set<Long>> acctIdToLeafAcctIdMap = this.getLeafAcctId(dataEntity);
        entry.getRowList().forEach(arg_0 -> AdjustExchangeRateSaveValidator.lambda$buildAccountAssgrpKeyMap$7(acctIdToLeafAcctIdMap, (Table)acctAssgrpTable, arg_0));
        return acctAssgrpTable;
    }

    private void checkComAssistValue(ExtendedDataEntity dataEntity) {
        boolean exists = FinalProcessUtil.isComAssistExistsNoLeaf((ExtendedDataEntity)dataEntity);
        if (exists) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u516c\u5171\u7ef4\u5ea6\u503c\u5fc5\u987b\u4e3a\u660e\u7ec6\u503c\u3002", (String)"AdjustExchangeRateSaveValidator_7", (String)"fi-gl-opplugin", (Object[])new Object[0]));
        }
    }

    private Map<Long, Set<Long>> getLeafAcctId(DynamicObject dataEntity) {
        HashSet accountIdSet = new HashSet(8);
        dataEntity.getDynamicObjectCollection("accountentry").forEach(dyn -> accountIdSet.add(dyn.getLong("accountid.id")));
        long orgId = dataEntity.getLong("org.id");
        DataSet accountBook = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_accountbook", (String)"accounttable.id", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("bookstype", "=", (Object)dataEntity.getLong("bookstype.id"))}, null);
        long accountTableId = 0L;
        if (accountBook.hasNext()) {
            accountTableId = accountBook.next().getLong("accounttable.id");
        }
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(8);
        filterList.add(new QFilter("ischangecurrency", "=", (Object)"1"));
        return AccountUtils.getLeafAcctIdById((long)orgId, (long)accountTableId, accountIdSet, filterList);
    }

    private void checkAutoAgainstValue(ExtendedDataEntity dataEntity) {
        DynamicObject adjustExchangeRateDyn = dataEntity.getDataEntity();
        long orgId = (Long)adjustExchangeRateDyn.get("org.id");
        long bookTypeId = (Long)adjustExchangeRateDyn.get("bookstype_id");
        AccountBookInfo accountBookInfo = AccSysUtil.getBookFromAccSys((long)orgId, (long)bookTypeId);
        if (FinalProcessUtil.isExistVchAfterCurPeriod((long)((Long)dataEntity.getBillPkId()), (long)accountBookInfo.getCurPeriodId()) && this.isChangedAutoAgainst(adjustExchangeRateDyn)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u671f\u6216\u672a\u6765\u671f\u95f4\u5df2\u751f\u6210\u8c03\u6c47\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539<\u4e0b\u671f\u81ea\u52a8\u51b2\u9500\u914d\u7f6e>\u3002", (String)"AdjustExchangeRateSaveValidator_9", (String)"fi-gl-opplugin", (Object[])new Object[0]));
        }
    }

    private boolean isChangedAutoAgainst(DynamicObject adjustExchangeRateDyn) {
        DynamicObject oldAdjustExchangeRateDyn;
        long id = adjustExchangeRateDyn.getLong("id");
        if (id != 0L && Objects.nonNull(oldAdjustExchangeRateDyn = QueryServiceHelper.queryOne((String)"gl_adjustexchangerate", (String)"autoagainsttype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)}))) {
            return !adjustExchangeRateDyn.getString("autoagainsttype").equals(oldAdjustExchangeRateDyn.getString("autoagainsttype"));
        }
        return false;
    }

    private static /* synthetic */ void lambda$buildAccountAssgrpKeyMap$7(Map acctIdToLeafAcctIdMap, Table acctAssgrpTable, DynamicEntryRow row) {
        Long accountIDPrefix = row.getInnerLong(new PropertyKey[]{AdjustExchangeRateConstant.Entry_AdjustAccount, AdjustExchangeRateConstant.Entity_MasterID});
        DynamicObjectCollection assgrpEntryCol = row.getDynamicObjectCollection(AdjustExchangeRateConstant.Entity_Entry_AdjustAssgrp);
        Set leafAcctIdSet = acctIdToLeafAcctIdMap.getOrDefault(accountIDPrefix, new HashSet<Long>(Collections.singletonList(accountIDPrefix)));
        for (Long accountId : leafAcctIdSet) {
            if (assgrpEntryCol.isEmpty()) {
                acctAssgrpTable.put((Object)accountId, (Object)-1L, Collections.emptySet());
                continue;
            }
            assgrpEntryCol.forEach(assgrpRow -> {
                String assgrpValueType = assgrpRow.getString("fieldname.valuetype");
                HashSet<String> assgrpValueSet = new HashSet<String>(4);
                if ("3".equals(assgrpValueType)) {
                    assgrpValueSet.addAll(Arrays.asList(assgrpRow.getString("txtval").split(";")));
                } else {
                    assgrpRow.getDynamicObjectCollection("value").stream().map(baseDataAssgrpValue -> baseDataAssgrpValue.getLong("fbasedataid_id")).forEach(value -> assgrpValueSet.add(value.toString()));
                }
                Long assgrpType = assgrpRow.getLong("fieldname.id");
                acctAssgrpTable.put((Object)accountId, (Object)assgrpType, assgrpValueSet);
            });
        }
    }
}

