/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.opplugin;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.gl.opplugin.AbstractFinalProcessDeleteOp;

public class AutoTransDeleteOp
extends AbstractFinalProcessDeleteOp {
    private static final String Key_Entryentity = "autotransentry";
    private static final String Key_Rowid = "autorowid";
    private static final String Key_PercentExp = "percentexp";
    private static final String ASSGRPEXP_ROWID_KEY = "assgrprow";
    private static final String DATAEXP_ROWID_KEY = "autorowid";
    private static final String ENTITY_ASSGRP = "gl_finalprocess_assgrp";
    private static final String ENTITY_DATAEXP = "gl_autotransexpression";
    private static final String ENTITY_PERCENTEXP = "gl_autotrans_percent";

    @Override
    protected String getFinalProcessEntityKey() {
        return "gl_autotrans";
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add(Key_Entryentity);
        fieldKeys.add("autorowid");
        fieldKeys.add(Key_PercentExp);
        e.setFieldKeys(fieldKeys);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        ArrayList<String> rowids = new ArrayList<String>();
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<Long> orgids = new ArrayList<Long>(dataEntities.length);
        ArrayList<Long> percentexps = new ArrayList<Long>();
        for (DynamicObject billObj : dataEntities) {
            orgids.add(billObj.getLong("org.id"));
            DynamicObjectCollection entries = billObj.getDynamicObjectCollection(Key_Entryentity);
            for (DynamicObject row : entries) {
                String rowid = row.getString("autorowid");
                if (StringUtils.isNotBlank((CharSequence)rowid)) {
                    rowids.add(rowid);
                }
                percentexps.add(row.getLong(Key_PercentExp));
            }
        }
        if (!rowids.isEmpty() && !orgids.isEmpty()) {
            DeleteServiceHelper.delete((String)ENTITY_ASSGRP, (QFilter[])this.getFilters(orgids, rowids, ASSGRPEXP_ROWID_KEY));
            DeleteServiceHelper.delete((String)ENTITY_DATAEXP, (QFilter[])this.getFilters(orgids, rowids, "autorowid"));
        }
        DeleteServiceHelper.delete((String)ENTITY_PERCENTEXP, (QFilter[])new QFilter("id", "in", percentexps).toArray());
    }

    private QFilter[] getFilters(List<Long> orgids, List<String> rowIds, String rowidKey) {
        return new QFilter[]{new QFilter("org.id", "in", orgids), new QFilter(rowidKey, "in", rowIds)};
    }
}

