/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.opplugin;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.MultiLangPunc;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.autotrans.AutoTransType;
import kd.fi.gl.finalprocess.constant.AutoTransConstant;
import kd.fi.gl.util.FinalProcessUtil;
import kd.fi.gl.util.TipsUtils;
import kd.fi.gl.util.ValidateUtils;

public class AutoTransSaveValidator
extends AbstractValidator {
    private static final Long ZERO_L = 0L;

    public void initializeConfiguration() {
        super.initializeConfiguration();
        this.setEntityKey("gl_autotrans");
    }

    protected void addMessage(ExtendedDataEntity dataEntity, String title, String content, ErrorLevel errorLevel) {
        ValidationErrorInfo operateInfo = new ValidationErrorInfo("", dataEntity, "Error001", title, TipsUtils.safeSuffix((String)content, (String)MultiLangPunc.fullStop()), errorLevel);
        this.getValidateResult().addErrorInfo((OperateErrorInfo)operateInfo);
    }

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            boolean exists;
            long orgid = ((DynamicObject)dataEntity.getValue("org")).getLong("id");
            Long bookstype = (Long)dataEntity.getValue("bookstype_id");
            AccountBookInfo book = AccSysUtil.getBookFromAccSys((long)orgid, (long)bookstype);
            Long vouchertypeid = (Long)dataEntity.getValue("vouchertypeid_Id");
            if (book == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"AutoTransSaveValidator_0", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                return;
            }
            if (vouchertypeid.equals(ZERO_L)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51ed\u8bc1\u7c7b\u578b\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"AutoTransSaveValidator_1", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection entryCol = (DynamicObjectCollection)dataEntity.getValue("autotransentry");
            if (entryCol.isEmpty()) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5206\u5f55\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"AutoTransSaveValidator_2", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                return;
            }
            if (entryCol.size() < 2) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5206\u5f55\u81f3\u5c11\u9700\u8981\u4e24\u6761\u3002", (String)"AutoTransSaveValidator_3", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                return;
            }
            entryCol.stream().filter(row -> AutoTransType.mustInputCurrency((String)row.getString("datasourcetype"))).forEach(row -> ValidateUtils.checkLegalCurrency((DynamicObject)row.getDynamicObject(AutoTransConstant.Entry_Key_Account.key), (Long)row.getLong(AutoTransConstant.Entry_Currency.key + ".id"), (Long)orgid, (Long)bookstype).ifPresent(x -> this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\uff0c%2$s", (String)"AutoTransSaveValidator_10", (String)"fi-gl-opplugin", (Object[])new Object[0]), row.getString("seq"), x))));
            String leafInType = dataEntity.getDataEntity().getString("leafintype");
            boolean existsTransOutByExp = false;
            String transType = dataEntity.getDataEntity().getString("transfertype");
            ArrayList<Long> accountIds = new ArrayList<Long>(entryCol.size());
            for (DynamicObject entry : entryCol) {
                int percenttype = entry.getInt("percenttype");
                if (percenttype == 0 && (null == entry.get("percent") || "".equals(entry.get("percent")))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8f6c\u8d26\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AutoTransSaveValidator_4", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                    return;
                }
                if (!existsTransOutByExp) {
                    int type = entry.getInt(AutoTransConstant.Entry_AMT_FROM.getKey());
                    switch (type) {
                        case 5: 
                        case 8: 
                        case 10: {
                            existsTransOutByExp = true;
                        }
                    }
                }
                accountIds.add(entry.getLong("accountid_id"));
            }
            if ("1".equals(leafInType) && existsTransOutByExp) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8f6c\u5165\u975e\u660e\u7ec6\u79d1\u76ee\u5904\u7406\u65b9\u5f0f\u8bbe\u7f6e\u4e3a\u6309\u7f16\u7801\u5bf9\u5e94\u7ed3\u8f6c\u65f6\uff0c\u8f6c\u51fa\u5206\u5f55\u4e0d\u5141\u8bb8\u8bbe\u7f6e\u4e3a\u6309\u6307\u5b9a\u79d1\u76ee\u83b7\u53d6\u91d1\u989d\u3002", (String)"AutoTransSaveValidator_5", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                return;
            }
            if ("2".equals(transType)) {
                QFilter idFilter = new QFilter("id", "in", accountIds);
                DynamicObjectCollection accounts = QueryServiceHelper.query((String)"bd_accountview", (String)String.join((CharSequence)",", "ischangecurrency", "accounttype.accounttype"), (QFilter[])idFilter.toArray());
                boolean isAllPl = true;
                boolean isAllRights = true;
                boolean existsOtherAccount = false;
                for (DynamicObject account : accounts) {
                    String accountType = account.getString("accounttype.accounttype");
                    if ("4".equals(accountType)) {
                        isAllRights = false;
                        continue;
                    }
                    if ("2".equals(accountType) && !account.getBoolean("ischangecurrency")) {
                        isAllPl = false;
                        continue;
                    }
                    existsOtherAccount = true;
                }
                if (existsOtherAccount) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8f6c\u8d26\u7c7b\u578b\u4e3a\u201c\u7ed3\u8f6c\u635f\u76ca\u201d\u65f6\uff0c\u79d1\u76ee\u53ea\u80fd\u8bbe\u7f6e\u201c\u635f\u76ca\u7c7b\u201d\u6216\u8005\u201c\u6743\u76ca\u7c7b\u201d\u4e14\u672a\u52fe\u9009\u201c\u671f\u672b\u8c03\u6c47\u7c7b\u201d\u7684\u79d1\u76ee\u3002", (String)"AutoTransSaveValidator_6", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                    return;
                }
                if (isAllRights) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8f6c\u8d26\u7c7b\u578b\u4e3a\u7ed3\u8f6c\u635f\u76ca\uff0c\u79d1\u76ee\u4e0d\u80fd\u53ea\u6709\u6743\u76ca\u7c7b\u79d1\u76ee\u3002", (String)"AutoTransSaveValidator_7", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                    return;
                }
                if (isAllPl) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8f6c\u8d26\u7c7b\u578b\u4e3a\u7ed3\u8f6c\u635f\u76ca\uff0c\u79d1\u76ee\u4e0d\u80fd\u53ea\u6709\u635f\u76ca\u7c7b\u79d1\u76ee\u3002", (String)"AutoTransSaveValidator_8", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                    return;
                }
            }
            if (!(exists = FinalProcessUtil.isComAssistExistsNoLeaf((ExtendedDataEntity)dataEntity))) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u516c\u5171\u7ef4\u5ea6\u503c\u5fc5\u987b\u4e3a\u660e\u7ec6\u503c\u3002", (String)"AutoTransSaveValidator_9", (String)"fi-gl-opplugin", (Object[])new Object[0]));
        }
    }
}

