/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.opplugin;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.balance.CalculatorFactory;
import kd.fi.gl.balance.ICalculator;
import kd.fi.gl.balcal.AcctBalanceCalculator;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.lock.Lock;
import kd.fi.gl.lock.LockKey;
import kd.fi.gl.opplugin.CloseInitBalanceOp;
import kd.fi.gl.opplugin.CloseInitCashflowOp;
import kd.fi.gl.util.BalanceCheckHelper;

public class BalanceRecalAllOp
extends AbstractOperationServicePlugIn {
    private Log logger = LogFactory.getLog((String)"BalanceRecalAllOp");
    private final List<String> failedMessages = new ArrayList<String>(2);

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        block12: {
            block10: {
                String type;
                int size;
                int i;
                Map books;
                block13: {
                    block11: {
                        if (!BillParamUtil.getBooleanValue((String)"83bfebc8000017ac", (String)"fi.gl.recal.all", (boolean)false) || !this.getOption().containsVariable("recalall")) break block10;
                        DynamicObjectCollection bizBook = BalanceCheckHelper.getBizBook(null);
                        List<Long> bookId = bizBook.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
                        books = BusinessDataServiceHelper.loadFromCache((Object[])bookId.toArray(new Long[0]), (String)"gl_accountbook");
                        i = 0;
                        size = books.size();
                        type = this.getOption().getVariableValue("type");
                        if (!type.equals("1")) break block11;
                        for (DynamicObject book : books.values()) {
                            this.recalAcctBal(book);
                            if (DebugTrace.enable()) {
                                this.logger.info(String.format("recal finish. total:%s,index:%s", size, i));
                            }
                            ++i;
                        }
                        break block12;
                    }
                    if (!type.equals("2")) break block13;
                    for (DynamicObject book : books.values()) {
                        this.recalCfBal(book);
                        if (DebugTrace.enable()) {
                            this.logger.info(String.format("recal finish. total:%s,index:%s", size, i));
                        }
                        ++i;
                    }
                    break block12;
                }
                if (!type.equals("3")) break block12;
                for (DynamicObject book : books.values()) {
                    this.recalAcctBal(book);
                    this.recalCfBal(book);
                    if (DebugTrace.enable()) {
                        this.logger.info(String.format("recal finish. total:%s,index:%s", size, i));
                    }
                    ++i;
                }
                break block12;
            }
            String type = this.getOption().getVariableValue("type");
            String org = this.getOption().getVariableValue("org");
            long orgId = Long.parseLong(org);
            QFilter forgid = new QFilter("org", "=", (Object)orgId);
            Map books = BusinessDataServiceHelper.loadFromCache((String)"gl_accountbook", (QFilter[])new QFilter[]{forgid});
            if (type.equals("1")) {
                for (DynamicObject book : books.values()) {
                    this.recalAcctBal(book);
                }
            }
            if (type.equals("2")) {
                for (DynamicObject book : books.values()) {
                    this.recalCfBal(book);
                }
            }
        }
    }

    private void recalAcctBal(DynamicObject book) {
        long btId = book.getLong("bookstype_id");
        long startperiodd = book.getLong("startperiod_id");
        long orgId = book.getLong("org_id");
        if (!Lock.tryLock((long)orgId, (long)btId, (LockKey)LockKey.BalanceCal, () -> {
            try (TXHandle txh = TX.requiresNew();){
                this.executeSql(orgId, btId, "update t_gl_balance_log set fcalculated='1' where forgid=? and fbooktypeid=? and fcalculated='0'");
                this.executeSql(orgId, btId, "delete from t_gl_balance where forgid=? and fbooktypeid=?");
                this.executeSql(orgId, btId, "delete from t_gl_acctbalance where forgid=? and fbooktypeid=?");
                this.calculate(orgId, btId, startperiodd, "gl_balance_log");
                CloseInitBalanceOp op = new CloseInitBalanceOp();
                op.initComassist(book);
                op.initMulCur(book);
                op.doUpdate(book);
            }
            Long vperiodId = this.getMaxVchPeriodId(orgId, btId);
            long endperiodid = vperiodId != null ? vperiodId.longValue() : book.getLong("curperiod_id");
            QFilter ftypeId = new QFilter("periodtype", "=", (Object)book.getLong("periodtype_id"));
            QFilter fid1 = new QFilter("id", ">=", (Object)startperiodd);
            QFilter fid2 = new QFilter("id", "<=", (Object)endperiodid);
            DynamicObjectCollection col = QueryServiceHelper.query((String)"bd_period", (String)"id", (QFilter[])new QFilter[]{fid1, fid2, ftypeId}, (String)"id");
            if (!col.isEmpty()) {
                for (DynamicObject obj : col) {
                    this.calculate(orgId, btId, obj.getLong("id"), "gl_balance_log");
                }
            }
        })) {
            this.logger.info("get lock fail, please try later");
        }
    }

    private void recalCfBal(DynamicObject book) {
        long cashInitPeriodId = book.getLong(GLField.id_((String)"cashinitperiod"));
        if (cashInitPeriodId == 0L) {
            this.failedMessages.add("cash init period empty, skip recalculate:" + book.getString("number"));
            return;
        }
        long btId = book.getLong("bookstype_id");
        long startperiodd = book.getLong("startperiod_id");
        long orgId = book.getLong("org_id");
        book.set("curperiod", (Object)book.getDynamicObject("cashinitperiod"));
        if (!Lock.tryLock((long)orgId, (long)btId, (LockKey)LockKey.CashflowCal, () -> {
            try (TXHandle txh = TX.requiresNew();){
                this.executeSql(orgId, btId, "update t_gl_cashflow_log set fcalculated='1' where forgid=? and fbooktypeid=? and fcalculated='0'");
                this.executeSql(orgId, btId, "delete from t_gl_cashflow where forgid=? and fbooktypeid=?");
                this.calculate(orgId, btId, startperiodd, "gl_cashflow_log");
                CloseInitCashflowOp op = new CloseInitCashflowOp();
                op.initComassist(book);
                op.updateBalance(book);
            }
            Long vperiodId = this.getMaxVchPeriodId(orgId, btId);
            long endperiodid = vperiodId != null ? vperiodId.longValue() : book.getLong("curperiod_id");
            QFilter ftypeId = new QFilter("periodtype", "=", (Object)book.getLong("periodtype_id"));
            QFilter fid1 = new QFilter("id", ">=", (Object)startperiodd);
            QFilter fid2 = new QFilter("id", "<=", (Object)endperiodid);
            DynamicObjectCollection col = QueryServiceHelper.query((String)"bd_period", (String)"id", (QFilter[])new QFilter[]{fid1, fid2, ftypeId}, (String)"id");
            if (!col.isEmpty()) {
                for (DynamicObject obj : col) {
                    this.calculate(orgId, btId, obj.getLong("id"), "gl_cashflow_log");
                }
            }
        })) {
            this.logger.info("get lock fail, please try later");
        }
    }

    private void executeSql(long orgId, long btId, String sql) {
        try (TXHandle txh = TX.requiresNew();){
            DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)sql, (Object[])new Object[]{orgId, btId});
        }
    }

    private Long getMaxVchPeriodId(long orgId, long btId) {
        return (Long)DB.query((DBRoute)DBRoute.of((String)"gl"), (String)"select max(fperiodid) endperiod from t_gl_voucher where forgid=? and fbooktypeid=? and fbillstatus!='A'", (Object[])new Object[]{orgId, btId}, (ResultSetHandler)new ResultSetHandler<Long>(){

            public Long handle(ResultSet resultSet) throws Exception {
                if (resultSet.next()) {
                    return resultSet.getLong("endperiod");
                }
                return null;
            }
        });
    }

    private boolean calculate(long orgId, long bookTypeId, long periodId, String tableName) {
        Throwable throwable;
        TXHandle txh;
        int count = 0;
        ICalculator calculator = "gl_balance_log".equals(tableName) ? CalculatorFactory.createBalanceCalculator() : CalculatorFactory.createCashflowCalculator();
        AcctBalanceCalculator cal = new AcctBalanceCalculator();
        do {
            txh = TX.requiresNew();
            throwable = null;
            try {
                count = calculator.calculate(orgId, bookTypeId);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (txh != null) {
                    if (throwable != null) {
                        try {
                            txh.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        txh.close();
                    }
                }
            }
        } while (count > 0);
        txh = TX.requiresNew();
        throwable = null;
        try {
            try {
                calculator.reCalculate(orgId, bookTypeId, periodId);
                if ("gl_balance_log".equals(tableName)) {
                    cal.reCalculateAcct(orgId, bookTypeId, periodId);
                }
            }
            catch (Exception ex) {
                txh.markRollback();
                throw ex;
            }
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            if (txh != null) {
                if (throwable != null) {
                    try {
                        txh.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    txh.close();
                }
            }
        }
        return true;
    }

    public void onReturnOperation(ReturnOperationArgs e) {
        super.onReturnOperation(e);
        if (!this.failedMessages.isEmpty()) {
            e.getOperationResult().setMessage(String.join((CharSequence)";", this.failedMessages));
            this.getOperationResult().setSuccess(false);
        }
    }
}

