/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.vo.CommonAssist;
import kd.fi.gl.balcal.log.CFChangeLog;
import kd.fi.gl.balcal.log.DataChangeLog;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.lock.LockKey;
import kd.fi.gl.opplugin.CloseInitCashflowValidator;
import kd.fi.gl.opplugin.CloseInitOp;
import kd.fi.gl.util.CommonAssistUtil;
import kd.fi.gl.util.GLUtil;
import kd.sdk.fi.gl.extpoint.bal.BalKey;
import kd.sdk.fi.gl.extpoint.bal.CashflowItemKey;

public class CloseInitCashflowOp
extends CloseInitOp {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("bookstype");
        fieldKeys.add("cashinitperiod");
        fieldKeys.add("isendinit");
        fieldKeys.add("startperiod");
        fieldKeys.add("curperiod");
        fieldKeys.add("enable");
        fieldKeys.add("isendinitcashflow");
        fieldKeys.add("accounttable");
    }

    @Override
    protected boolean setBalanceUpdParam(DynamicObject book, Row initCashFlow, MainEntityType cashFlowType, List<DynamicObject> objList, List<Object> rmvList, List<BalKey> delDemension, Map<String, DataChangeLog> id2Log) {
        long cashflowPeriod = book.getLong(GLField.id_((String)"cashinitperiod"));
        long org = initCashFlow.getLong("org");
        long bookType = initCashFlow.getLong("booktype");
        long cfitem = initCashFlow.getLong("cfitem");
        long assgrp = initCashFlow.getLong("assgrp");
        long currency = initCashFlow.getLong("currency");
        BigDecimal yearamount = initCashFlow.getBigDecimal("yearamount");
        long lastPeriodId = cashflowPeriod;
        boolean exist = false;
        Boolean tabDelete = initCashFlow.getBoolean("tabdelete");
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fid,fperiodid,fendperiodid from t_gl_cashflow where ", new Object[0]);
        sql.append(" forgid = ? ", new Object[]{org});
        sql.append(" and fbooktypeid=? ", new Object[]{bookType});
        sql.append(" and fcfitemid=? ", new Object[]{cfitem});
        sql.append(" and fassgrpid=? ", new Object[]{assgrp});
        sql.append(" and fcurrencyid=? ", new Object[]{currency});
        Object[] comAssistIds = new Object[this.commonAssists.size()];
        for (int i = 1; i <= this.commonAssists.size(); ++i) {
            Long id = initCashFlow.getLong("comassist" + i) == null ? Long.valueOf(0L) : initCashFlow.getLong("comassist" + i);
            sql.append(" and fcomassist" + i + "id = ?", new Object[]{id});
            comAssistIds[i - 1] = id;
        }
        sql.append(" order by fendperiodid ", new Object[0]);
        try (DataSet balSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sql);){
            boolean first = true;
            while (balSet.hasNext()) {
                boolean isCurrYear;
                exist = true;
                Row row = balSet.next();
                Long fid = row.getLong("fid");
                Long fperiodid = row.getLong("fperiodid");
                Long fendperiodid = row.getLong("fendperiodid");
                id2Log.put(fid.toString(), (DataChangeLog)CFChangeLog.create((long)fid, (long)org, (long)bookType, (long)fperiodid, (long)fendperiodid, (long)cfitem, (long)currency, (long)assgrp, (Object[])comAssistIds));
                DynamicObject cashflowBalance = BusinessDataServiceHelper.loadSingle((Object)fid, (DynamicObjectType)cashFlowType);
                long periodId = cashflowBalance.getLong(GLField.id_((String)"period"));
                boolean bl = isCurrYear = periodId / GLUtil.YEAR_PERIOD_L == lastPeriodId / GLUtil.YEAR_PERIOD_L;
                if (periodId == cashflowPeriod) {
                    if (tabDelete.booleanValue()) {
                        if (BigDecimal.ZERO.compareTo(cashflowBalance.getBigDecimal("amount")) == 0 && cashflowBalance.getInt("count") == 0) {
                            rmvList.add(fid);
                            ArrayList<Long> comassist = new ArrayList<Long>(2);
                            for (int i = 1; i <= this.commonAssists.size(); ++i) {
                                comassist.add(initCashFlow.getLong("comassist" + i));
                            }
                            delDemension.add((BalKey)new CashflowItemKey(cfitem, assgrp, currency, fperiodid.longValue(), fendperiodid.longValue(), fid.longValue(), comassist));
                            yearamount = BigDecimal.ZERO;
                            first = false;
                            lastPeriodId = periodId;
                            continue;
                        }
                        if (cashflowBalance.getBigDecimal("amount").compareTo(cashflowBalance.getBigDecimal("yearamount")) == 0) break;
                        yearamount = cashflowBalance.getBigDecimal("amount");
                    } else {
                        if (yearamount.add(cashflowBalance.getBigDecimal("amount")).compareTo(cashflowBalance.getBigDecimal("yearamount")) == 0) break;
                        yearamount = yearamount.add(cashflowBalance.getBigDecimal("amount"));
                    }
                } else if (tabDelete.booleanValue()) {
                    if (first) {
                        if (BigDecimal.ZERO.compareTo(cashflowBalance.getBigDecimal("amount")) == 0 && cashflowBalance.getInt("count") == 0) {
                            rmvList.add(fid);
                            yearamount = BigDecimal.ZERO;
                            cashflowBalance.set("modifytime", (Object)new Date());
                            first = false;
                            lastPeriodId = periodId;
                            continue;
                        }
                        if (cashflowBalance.getBigDecimal("amount").compareTo(cashflowBalance.getBigDecimal("yearamount")) == 0) break;
                        yearamount = cashflowBalance.getBigDecimal("amount");
                    } else {
                        yearamount = isCurrYear ? yearamount.add(cashflowBalance.getBigDecimal("amount")) : cashflowBalance.getBigDecimal("amount");
                    }
                } else if (first) {
                    if (periodId <= cashflowPeriod) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u91cf\u8868\u6570\u636e\u5f02\u5e38\uff0c\u73b0\u91d1\u6d41\u91cf\u5f00\u59cb\u671f\u95f4\uff1a%1$s\uff0c\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\uff1a%2$s\u3002", (String)"CloseInitCashflowOp_0", (String)"fi-gl-opplugin", (Object[])new Object[0]), cashflowBalance.get("period.number"), book.get("curperiod.number")));
                    }
                    objList.add(this.newBalance(initCashFlow, book, periodId));
                    if (isCurrYear) {
                        yearamount = yearamount.add(cashflowBalance.getBigDecimal("amount"));
                    }
                } else {
                    yearamount = isCurrYear ? yearamount.add(cashflowBalance.getBigDecimal("amount")) : cashflowBalance.getBigDecimal("amount");
                }
                cashflowBalance.set("yearamount", (Object)yearamount);
                objList.add(cashflowBalance);
                lastPeriodId = periodId;
                first = false;
            }
            boolean bl = exist;
            return bl;
        }
    }

    @Override
    protected void saveInitFlag(DynamicObject book) {
        book.set("isendinitcashflow", (Object)true);
        BusinessDataWriter.save((IDataEntityType)book.getDataEntityType(), (Object[])new Object[]{book});
    }

    @Override
    protected DynamicObject newBalance(Row initCashFlow, DynamicObject book, long endPeriodId) {
        DynamicObject b = ORM.create().newDynamicObject(this.getFormId());
        b.set("period", (Object)book.getLong(GLField.id_((String)"curperiod")));
        b.set("org", (Object)initCashFlow.getLong("org"));
        b.set("booktype", (Object)initCashFlow.getLong("booktype"));
        b.set("endperiod", (Object)endPeriodId);
        b.set("cfitem", (Object)initCashFlow.getLong("cfitem"));
        b.set("assgrp", (Object)initCashFlow.getLong("assgrp"));
        b.set("currency", (Object)initCashFlow.getLong("currency"));
        b.set("yearamount", (Object)initCashFlow.getBigDecimal("yearamount"));
        b.set("modifytime", (Object)new Date());
        for (int i = 1; i <= this.commonAssists.size(); ++i) {
            b.set("comassist" + i, (Object)initCashFlow.getLong("comassist" + i));
        }
        return b;
    }

    @Override
    protected AbstractValidator getCloseInitValidator() {
        return new CloseInitCashflowValidator();
    }

    @Override
    protected DataSet getInitData(DynamicObject book) {
        QFilter orgF = new QFilter("org", "=", (Object)book.getLong(GLField.id_((String)"org")));
        QFilter bookTypeF = new QFilter("booktype", "=", (Object)book.getLong(GLField.id_((String)"bookstype")));
        String sel = String.join((CharSequence)",", "org", "booktype", "cfitem.masterid cfitem", "assgrp", "currency", "yearamount", "id", "tabdelete");
        sel = sel + this.getComfield();
        DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_initcashflow", (String)sel, (QFilter[])new QFilter[]{orgF, bookTypeF}, null);
        HashMap<Integer, Set> map = new HashMap<Integer, Set>();
        int assistSize = this.commonAssists.size();
        HashSet<Integer> hasMid = new HashSet<Integer>(2);
        for (int i = 1; i <= assistSize; ++i) {
            if (!CommonAssistUtil.hasMasteridProp((String)((CommonAssist)this.commonAssists.get((int)(i - 1))).valueSource)) continue;
            hasMid.add(i);
        }
        if (!hasMid.isEmpty()) {
            for (Row row : ds.copy()) {
                Iterator iterator = hasMid.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    Set ids = map.computeIfAbsent(i, x -> new HashSet());
                    ids.add(row.getLong("comassist" + i));
                }
            }
            Iterator iterator = hasMid.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                String comField = "comassist" + i;
                DataSet comds = QueryServiceHelper.queryDataSet((String)"AbstractCalculator.reCalculate", (String)((CommonAssist)this.commonAssists.get((int)(i - 1))).valueSource, (String)("id " + comField + ",masterid"), (QFilter[])new QFilter[]{new QFilter("id", "in", map.get(i))}, null);
                List fields = GLUtil.getDataSetCols((DataSet)ds);
                int finalI = i;
                fields.removeIf(x -> x.equals("comassist" + finalI));
                ds = ds.join(comds, JoinType.LEFT).on(comField, comField).select(fields.toArray(new String[0]), new String[]{"masterid " + comField}).finish();
            }
        }
        return ds;
    }

    @Override
    protected String getFormId() {
        return "gl_cashflow";
    }

    @Override
    protected LockKey getLockKey() {
        return LockKey.CashflowCal;
    }
}

