/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.opplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.fi.operation.closeperiod.result.CloseCheckItemResult;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.ExceptionUtils;
import kd.fi.gl.business.service.closeperiod.job.impl.mq.MQClosePeriodJobHelper;
import kd.fi.gl.business.service.closeperiod.job.impl.mq.MQClosePeriodSubJobState;
import kd.fi.gl.constant.closeperiod.ClosePeriodInfo;
import kd.fi.gl.enums.ClosePeriodStateEnum;
import kd.fi.gl.lock.Lock;
import kd.fi.gl.lock.LockKey;
import kd.fi.gl.util.GLUtil;

public class ClosePeriodService
implements MessageConsumer {
    private static final Log log = LogFactory.getLog(ClosePeriodService.class);
    private static final String DEFAULT_ICON = "kingdee/fi/images/pc/icon/menu/7qmjz_48_48.png";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Object message, String messageId, boolean resend, MessageAcker messageAcker) {
        try {
            log.info("ClosePeriodService_consume start");
            if (resend) {
                return;
            }
            ClosePeriodInfo closeInfo = (ClosePeriodInfo)SerializationUtils.fromJsonString((String)message.toString(), ClosePeriodInfo.class);
            List orgIds = closeInfo.getOrgs();
            if (CollectionUtils.isEmpty((Collection)orgIds)) {
                return;
            }
            HashMap<Long, Future> resultMap = new HashMap<Long, Future>(orgIds.size());
            for (Long org : orgIds) {
                resultMap.put(org, ThreadService.submit(() -> this.consume(org, closeInfo.copy()), (TaskType)TaskType.FI_GL_CLOSE_PERIOD_MESSAGE_CONSUMER));
            }
            resultMap.forEach((orgId, result) -> {
                try {
                    result.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    this.recordException(closeInfo, (Long)orgId, e);
                }
            });
        }
        finally {
            messageAcker.ack(messageId);
            log.info("ClosePeriodService_consume end");
        }
    }

    public long consume(Long orgId, ClosePeriodInfo closeInfo) {
        this.resetRequestContext(closeInfo);
        try {
            DynamicObject bookDyn;
            long bookType = StringUtils.isBlank((Object)closeInfo.getBooktype()) ? 0L : Long.parseLong(closeInfo.getBooktype().toString());
            QFilter qf = new QFilter("org", "=", (Object)orgId);
            if (bookType != 0L) {
                qf.and(new QFilter(closeInfo.getTypeFieldName(), "=", (Object)bookType));
            }
            if ("gl_accountbook".equals(closeInfo.getFormId())) {
                qf.and(new QFilter("isbizunit", "=", (Object)"1"));
                qf.and(new QFilter("isendinit", "=", (Object)"1"));
            }
            if ((bookDyn = QueryServiceHelper.queryOne((String)closeInfo.getFormId(), (String)"id", (QFilter[])qf.toArray())) == null) {
                String[] str = new String[]{String.valueOf(orgId), ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5bf9\u5e94\u6570\u636e\u3002", (String)"ClosePeriodService_0", (String)"fi-gl-opplugin", (Object[])new Object[0]), "0", DEFAULT_ICON, ResManager.loadKDString((String)"\u8be5\u516c\u53f8\u5728\u6b64\u8d26\u7c3f\u7c7b\u578b\u4e0b\u65e0\u6570\u636e\u3002", (String)"ClosePeriodService_1", (String)"fi-gl-opplugin", (Object[])new Object[0])};
                this.createFailInfo(closeInfo, str);
                return orgId;
            }
            if (!Lock.tryLock((long)orgId, (long)bookType, (LockKey)LockKey.ClosePeriod, () -> {
                try {
                    this.periodClose(orgId, closeInfo, bookDyn.getLong("id"));
                }
                catch (Exception e) {
                    this.recordException(closeInfo, orgId, e);
                }
            })) {
                String[] str = new String[]{String.valueOf(orgId), ResManager.loadKDString((String)"\u6b63\u5728\u7ed3\u8d26", (String)"ClosePeriodService_2", (String)"fi-gl-opplugin", (Object[])new Object[0]), "0", DEFAULT_ICON, ResManager.loadKDString((String)"\u8be5\u516c\u53f8\u7ed3\u8d26\u4e2d\u3002", (String)"ClosePeriodService_3", (String)"fi-gl-opplugin", (Object[])new Object[0])};
                this.createFailInfo(closeInfo, str);
            }
        }
        catch (Exception e) {
            this.recordException(closeInfo, orgId, e);
        }
        return orgId;
    }

    private void recordException(ClosePeriodInfo closeInfo, Long orgId, Exception e) {
        String[] str = new String[]{String.valueOf(orgId), ResManager.loadKDString((String)"\u7ed3\u8d26\u5931\u8d25", (String)"ClosePeriodService_4", (String)"fi-gl-opplugin", (Object[])new Object[0]), "0", DEFAULT_ICON, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)};
        this.createFailInfo(closeInfo, str);
        log.error("ClosePeriodService_consume error, orgId:" + orgId, (Throwable)e);
    }

    private void resetRequestContext(ClosePeriodInfo closeInfo) {
        try {
            String rc = closeInfo.getRequestContextStr();
            if (StringUtils.isNotBlank((CharSequence)rc)) {
                RequestContext currentRC = RequestContext.get();
                RequestContext originRC = (RequestContext)SerializationUtils.deSerializeFromBase64((String)rc);
                currentRC.setClient(originRC.getClient());
                currentRC.setLoginIP(originRC.getLoginIP());
            }
        }
        catch (Exception e) {
            log.error("resetRC error", (Throwable)e);
        }
    }

    private void createFailInfo(ClosePeriodInfo closeInfo, String ... str) {
        long org = Long.parseLong(str[0]);
        Long periodId = this.isHaveBook(org, closeInfo, "curperiod");
        if (periodId != 0L) {
            closeInfo.setCurPeriodId((Object)periodId);
        } else {
            closeInfo.setCurPeriodId(closeInfo.getAwaitPeriodId());
        }
        MQClosePeriodJobHelper.recordSubJobItemResult((String)closeInfo.getPageId(), (String)String.valueOf(org), (CloseCheckItemResult)CloseCheckItemResult.build((String)str[2], (String)str[1], (String)str[4], (String)str[3], null, null));
        closeInfo.setCloseitemPK((Object)0L);
        this.closeIsSuccess(org, closeInfo);
    }

    private void getAndSaveDynamicObject(long orgId, ClosePeriodInfo closeInfo, String closeState, long time) {
        Long bookId = this.isHaveBook(orgId, closeInfo, "id");
        DynamicObject state = this.getParams(orgId, closeInfo, bookId);
        state.set("company", (Object)orgId);
        state.set("period", closeInfo.getCurPeriodId());
        state.set("subsysformnum", (Object)closeInfo.getFormId());
        state.set("accountbooks", (Object)bookId);
        state.set("thisclosetime", (Object)time);
        state.set("linestate", (Object)"0");
        state.set("closedate", (Object)new Date());
        state.set("closestate", (Object)closeState);
        if ("gl".equals(closeInfo.getBizapp())) {
            String closeUserId = String.valueOf(RequestContext.getOrCreate().getCurrUserId());
            state.set("closeuser", (Object)closeUserId);
        }
        try (TXHandle h = TX.requiresNew((String)"gl_subsystem_save");){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{state});
                log.info("\u6570\u636e\u4fdd\u5b58\u6210\u529f........");
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private DynamicObject getParams(long companyid, ClosePeriodInfo closeInfo, long bookid) {
        QFilter org = new QFilter("company", "=", (Object)companyid);
        QFilter period = new QFilter("period", "=", closeInfo.getCurPeriodId());
        QFilter system = new QFilter("subsysformnum", "=", (Object)closeInfo.getFormId());
        QFilter accountbook = new QFilter("accountbooks", "=", (Object)String.valueOf(bookid));
        String closestate = "gl_closestate";
        DynamicObjectCollection collection = QueryServiceHelper.query((String)closestate, (String)"id", (QFilter[])new QFilter[]{org, period, accountbook, system});
        if (!collection.isEmpty()) {
            if (collection.size() > 1) {
                Object[] o = new Object[collection.size()];
                for (int i = 1; i < collection.size(); ++i) {
                    o[i] = ((DynamicObject)collection.get(i)).getPkValue();
                }
                DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)closestate), (Object[])o);
            }
            return BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)collection.get(0)).getLong("id"), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)closestate));
        }
        return BusinessDataServiceHelper.newDynamicObject((String)closestate);
    }

    private Long isHaveBook(long org, ClosePeriodInfo closeInfo, String select) {
        DynamicObjectCollection collection;
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(new QFilter("org", "=", (Object)org));
        if (closeInfo.getBooktype() != null) {
            list.add(new QFilter(closeInfo.getTypeFieldName(), "=", (Object)Long.valueOf(closeInfo.getBooktype().toString())));
        }
        if ((collection = QueryServiceHelper.query((String)closeInfo.getFormId(), (String)select, (QFilter[])list.toArray(new QFilter[0]))).isEmpty()) {
            return 0L;
        }
        return ((DynamicObject)collection.get(0)).getLong(select);
    }

    private void periodClose(long orgid, ClosePeriodInfo closeInfo, long bookId) {
        String formId = "gl_accountbook".equals(closeInfo.getFormId()) ? "gl_autocloseperiod" : closeInfo.getFormId();
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)orgid, (String)"bos_org");
        OperateOption opt = OperateOption.create();
        opt.setVariableValue("reachperiod", closeInfo.getAwaitPeriodId().toString());
        opt.setVariableValue("closeCacheKey", MQClosePeriodJobHelper.getSubJobItemResultsKey((String)closeInfo.getPageId(), (String)org.getPkValue().toString()));
        opt.setVariableValue("bizapp", closeInfo.getBizapp());
        opt.setVariableValue("booktype", closeInfo.getTypeFieldName());
        opt.setVariableValue("manual", "true");
        boolean isContinue = true;
        int i = 0;
        while (isContinue && i < 50) {
            MQClosePeriodSubJobState state;
            ++i;
            long startTime = System.currentTimeMillis();
            OperationResult result = OperationServiceHelper.executeOperate((String)"closeperiod", (String)formId, (Object[])new Object[]{bookId}, (OperateOption)opt);
            String reachPeriod = opt.getVariableValue("openedperiod", "0");
            Long reachPeriodId = Long.valueOf(reachPeriod);
            long endTime = System.currentTimeMillis();
            log.info("\u7ed3\u8d26\u64cd\u4f5c\u7ed3\u675f......");
            if (result.isSuccess()) {
                this.getCloseInfoId(closeInfo, result.getSuccessPkIds().get(0), orgid, true);
                if (this.isLessSlePeriod(orgid, closeInfo)) {
                    state = new MQClosePeriodSubJobState(ClosePeriodStateEnum.SUCCESS.getCode(), String.valueOf(orgid));
                    if (reachPeriodId > 0L) {
                        closeInfo.setCurPeriodId((Object)reachPeriodId);
                        state.setOpenedPeriodId(String.valueOf(reachPeriodId));
                    }
                    MQClosePeriodJobHelper.updateSubJobStates((String)closeInfo.getPageId(), Collections.singletonList(state));
                    isContinue = false;
                }
                this.getAndSaveDynamicObject(orgid, closeInfo, "1", endTime - startTime);
                continue;
            }
            this.getCloseInfoId(closeInfo, 0L, orgid, false);
            state = new MQClosePeriodSubJobState(ClosePeriodStateEnum.FAILED.getCode(), String.valueOf(orgid));
            if (reachPeriodId > 0L) {
                closeInfo.setCurPeriodId((Object)reachPeriodId);
                state.setOpenedPeriodId(String.valueOf(reachPeriodId));
            }
            MQClosePeriodJobHelper.updateSubJobStates((String)closeInfo.getPageId(), Collections.singletonList(state));
            isContinue = false;
            this.getAndSaveDynamicObject(orgid, closeInfo, "2", endTime - startTime);
        }
    }

    private void getCloseInfoId(ClosePeriodInfo closeInfo, Object resultid, Long orgid, boolean isSuccess) {
        Long period = this.isHaveBook(orgid, closeInfo, "curperiod");
        if (isSuccess) {
            period = GLUtil.getPreviousPeriod((Object)period).getLong("id");
        }
        closeInfo.setCurPeriodId((Object)period);
        closeInfo.setCloseitemPK(resultid);
    }

    private void closeIsSuccess(long orgid, ClosePeriodInfo closeInfo) {
        this.getAndSaveDynamicObject(orgid, closeInfo, "2", 0L);
        MQClosePeriodSubJobState state = new MQClosePeriodSubJobState(ClosePeriodStateEnum.FAILED.getCode(), String.valueOf(orgid));
        MQClosePeriodJobHelper.updateSubJobStates((String)closeInfo.getPageId(), Collections.singletonList(state));
    }

    public boolean isLessSlePeriod(long orgid, ClosePeriodInfo closeInfo) {
        String currentPer = String.valueOf(this.isHaveBook(orgid, closeInfo, "curperiod"));
        currentPer = currentPer.substring(currentPer.length() - 8, currentPer.length() - 1);
        String selectPer = String.valueOf(closeInfo.getAwaitPeriodId());
        selectPer = selectPer.substring(selectPer.length() - 8, selectPer.length() - 1);
        return Integer.parseInt(currentPer) >= Integer.parseInt(selectPer);
    }
}

