/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.opplugin;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.Row;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import kd.fi.bd.consts.MCT;
import kd.fi.gl.common.Tuple;

public class InitBalSumData {
    private final Map<String, LocalCurrencyConfigVO> configs = new HashMap<String, LocalCurrencyConfigVO>(4);
    private final Map<String, Tuple<SumData, SumData>> curType2sumData = new HashMap<String, Tuple<SumData, SumData>>(4);

    public InitBalSumData(Collection<LocalCurrencyConfigVO> configColl) {
        for (LocalCurrencyConfigVO config : configColl) {
            this.configs.put(config.getNumber(), config);
            this.curType2sumData.put(config.getNumber(), (Tuple<SumData, SumData>)new Tuple((Object)new SumData(), (Object)new SumData()));
        }
        this.curType2sumData.put("LocalCurrency", (Tuple<SumData, SumData>)new Tuple((Object)new SumData(), (Object)new SumData()));
    }

    public void sum(Row row) {
        Boolean isBw = row.getBoolean("account.bw");
        this.curType2sumData.forEach((num, sumDataTuple) -> {
            if (this.configs.containsKey(num)) {
                LocalCurrencyConfigVO config = this.configs.get(num);
                Tuple<SumData, SumData> bnAndBwSumData = this.curType2sumData.get(num);
                SumData sumData = isBw != false ? (SumData)bnAndBwSumData.item2 : (SumData)bnAndBwSumData.item1;
                sumData.addBeginCredit(row.getBigDecimal(config.getInitBalanceField(MCT.BEGIN_CREDIT).getMetaId()));
                sumData.addBeginDebit(row.getBigDecimal(config.getInitBalanceField(MCT.BEGIN_DEBIT).getMetaId()));
                sumData.addYearCredit(row.getBigDecimal(config.getInitBalanceField(MCT.YEAR_CREDIT).getMetaId()));
                sumData.addYearDebit(row.getBigDecimal(config.getInitBalanceField(MCT.YEAR_DEBIT).getMetaId()));
            } else {
                Tuple<SumData, SumData> bnAndBwSumData = this.curType2sumData.get("LocalCurrency");
                SumData sumData = isBw != false ? (SumData)bnAndBwSumData.item2 : (SumData)bnAndBwSumData.item1;
                sumData.addBeginCredit(row.getBigDecimal("begincreditlocal"));
                sumData.addBeginDebit(row.getBigDecimal("begindebitlocal"));
                sumData.addYearCredit(row.getBigDecimal("yearcreditlocal"));
                sumData.addYearDebit(row.getBigDecimal("yeardebitlocal"));
            }
        });
    }

    public Map<String, Tuple<SumData, SumData>> getCurType2sumData() {
        return this.curType2sumData;
    }

    public static class SumData {
        private BigDecimal beginCredit = BigDecimal.ZERO;
        private BigDecimal beginDebit = BigDecimal.ZERO;
        private BigDecimal yearCredit = BigDecimal.ZERO;
        private BigDecimal yearDebit = BigDecimal.ZERO;

        public BigDecimal getBeginCredit() {
            return this.beginCredit;
        }

        public void addBeginCredit(BigDecimal beginCredit) {
            this.beginCredit = this.beginCredit.add(beginCredit);
        }

        public BigDecimal getBeginDebit() {
            return this.beginDebit;
        }

        public void addBeginDebit(BigDecimal beginDebit) {
            this.beginDebit = this.beginDebit.add(beginDebit);
        }

        public BigDecimal getYearCredit() {
            return this.yearCredit;
        }

        public void addYearCredit(BigDecimal yearCredit) {
            this.yearCredit = this.yearCredit.add(yearCredit);
        }

        public BigDecimal getYearDebit() {
            return this.yearDebit;
        }

        public void addYearDebit(BigDecimal yearDebit) {
            this.yearDebit = this.yearDebit.add(yearDebit);
        }

        public String toString() {
            return Arrays.asList(this.beginCredit, this.beginDebit, this.yearCredit, this.yearDebit).toString();
        }
    }
}

