/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.gl.balcal.InitBalanceKey;
import kd.fi.gl.closeinit.BatchQueryInitInfo;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.constant.InitBalance;
import kd.fi.gl.opplugin.InitBalanceSaveValidator;

public class InitBalanceSaveOp
extends AbstractOperationServicePlugIn {
    private Set<Long> existIds;
    private List<DynamicObject> needSaveEditObject;

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new InitBalanceSaveValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        this.existIds = new HashSet<Long>();
        Map<Long, List<DynamicObject>> tableGroup = Arrays.stream(dataEntities).collect(Collectors.groupingBy(x -> x.getLong(InitBalance.id_((String)"accounttable"))));
        StringBuilder selField = new StringBuilder("id, org, booktype, accounttable, account.masterid account, assgrp, currency, measureunit");
        for (Map.Entry<Long, List<DynamicObject>> entry : tableGroup.entrySet()) {
            long acctTableID = entry.getKey();
            List<DynamicObject> entitys = entry.getValue();
            List commonAssists = ComAssistTable.get((Long)acctTableID).getCommonAssists();
            BatchQueryInitInfo info = new BatchQueryInitInfo(commonAssists.size());
            entitys.stream().forEach(x -> info.add((DynamicObject)x));
            commonAssists.stream().forEach(x -> selField.append(",").append(x.getKey()));
            QFilter[] filters = new QFilter[]{new QFilter("org", "in", info.getOrgIds()), new QFilter("booktype", "in", info.getBookType()), new QFilter("accounttable", "in", info.getAccountTable()), new QFilter("account.masterid", "in", info.getAccounts()), new QFilter("assgrp", "in", info.getAssgrps()), new QFilter("currency", "in", info.getCurrencys()), new QFilter("measureunit", "in", info.getMeasureunits())};
            Map<String, Long> keyMap = info.getKeyMap();
            DataSet ds = QueryServiceHelper.queryDataSet((String)"InitBalanceSaveOp#beforeExecuteOperationTransaction", (String)"gl_initbalance", (String)selField.toString(), (QFilter[])filters, null);
            Throwable throwable = null;
            try {
                for (Row row : ds) {
                    String key = this.getKey(row, commonAssists.size());
                    Long id = keyMap.get(key);
                    if (id == null || id.equals(row.getLong("id"))) continue;
                    this.existIds.add(row.getLong("id"));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ds == null) continue;
                if (throwable != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ds.close();
            }
        }
    }

    private String getKey(Row initBal, int comsize) {
        String key = String.join((CharSequence)"-", initBal.getString("org"), initBal.getString("booktype"), initBal.getString("accounttable"), initBal.getString("account"), initBal.getString("assgrp"), initBal.getString("currency"), initBal.getString("measureunit"));
        StringBuilder sb = new StringBuilder(key);
        for (int i = 1; i <= comsize; ++i) {
            sb.append("-").append(initBal.getLong("comassist" + i));
        }
        return sb.toString();
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        if (this.existIds.size() > 0) {
            DeleteServiceHelper.delete((String)"gl_initbalance", (QFilter[])new QFilter[]{new QFilter("id", "in", this.existIds)});
        }
        DynamicObject[] entitys = e.getDataEntities();
        this.needSaveEditObject = new ArrayList<DynamicObject>(entitys.length);
        for (DynamicObject newDyn : entitys) {
            InitBalanceKey oldBalEntity;
            InitBalanceKey newBalEntity;
            boolean fromDatabase = newDyn.getDataEntityState().getFromDatabase();
            if (!fromDatabase) continue;
            Object pkValue = newDyn.getPkValue();
            DynamicObject oldDyn = null;
            try {
                oldDyn = BusinessDataServiceHelper.loadSingle((Object)pkValue, (DynamicObjectType)newDyn.getDynamicObjectType());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (oldDyn == null || (newBalEntity = new InitBalanceKey(newDyn)).equals((Object)(oldBalEntity = new InitBalanceKey(oldDyn)))) continue;
            this.needSaveEditObject.add(InitBalanceSaveOp.createDeletedInitBalance(oldDyn));
        }
    }

    static DynamicObject createDeletedInitBalance(DynamicObject oldDyn) {
        DynamicObject saveOldDyn = BusinessDataServiceHelper.newDynamicObject((String)"gl_initbalance");
        saveOldDyn.set("org", (Object)oldDyn.getLong(InitBalance.id_((String)"org")));
        saveOldDyn.set("booktype", (Object)oldDyn.getLong(InitBalance.id_((String)"booktype")));
        saveOldDyn.set("account", (Object)oldDyn.getLong(InitBalance.id_((String)"account")));
        saveOldDyn.set("accounttable", (Object)oldDyn.getLong(InitBalance.id_((String)"accounttable")));
        saveOldDyn.set("currency", (Object)oldDyn.getLong(InitBalance.id_((String)"currency")));
        saveOldDyn.set("assgrp", (Object)oldDyn.getLong(InitBalance.id_((String)"assgrp")));
        saveOldDyn.set("measureunit", (Object)oldDyn.getLong(InitBalance.id_((String)"measureunit")));
        saveOldDyn.set("curlocal", (Object)oldDyn.getLong(InitBalance.id_((String)"curlocal")));
        ComAssistTable.getMaxCommonAssistKeys().forEach(comAssistKey -> saveOldDyn.set(comAssistKey, (Object)oldDyn.getLong(InitBalance.id_((String)comAssistKey))));
        saveOldDyn.set("isdeleted", (Object)true);
        return saveOldDyn;
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        if (this.needSaveEditObject != null) {
            SaveServiceHelper.save((DynamicObject[])this.needSaveEditObject.toArray(new DynamicObject[0]));
        }
    }
}

