/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.opplugin.reci;

import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.opplugin.reci.ReciprocalInitSaveValidator;

public class ReciprocalInitSaveOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new ReciprocalInitSaveValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        String bookKey;
        Long bookTypeId;
        Long orgId;
        super.beforeExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        HashMap<String, AccountBookInfo> bookInfoMap = new HashMap<String, AccountBookInfo>(6);
        for (DynamicObject reciprocalInit : dataEntities) {
            orgId = reciprocalInit.getLong(GLField.id_((String)"org"));
            bookTypeId = reciprocalInit.getLong(GLField.id_((String)"booktype"));
            bookKey = orgId + "_" + bookTypeId;
            bookInfoMap.computeIfAbsent(bookKey, k -> AccSysUtil.getBookFromAccSys((long)orgId, (long)bookTypeId));
        }
        for (DynamicObject reciprocalInit : dataEntities) {
            orgId = reciprocalInit.getLong(GLField.id_((String)"org"));
            bookTypeId = reciprocalInit.getLong(GLField.id_((String)"booktype"));
            bookKey = orgId + "_" + bookTypeId;
            AccountBookInfo bookInfo = (AccountBookInfo)bookInfoMap.get(bookKey);
            if (bookInfo != null) {
                DynamicObject account;
                if (reciprocalInit.getLong(GLField.id_((String)"accounttable")) == 0L && (account = (DynamicObject)reciprocalInit.get("account")) != null && account.getLong(GLField.id_((String)"accounttable")) != 0L) {
                    reciprocalInit.set(GLField.id_((String)"accounttable"), (Object)account.getLong(GLField.id_((String)"accounttable")));
                }
                if (reciprocalInit.getLong(GLField.id_((String)"curlocal")) == 0L) {
                    reciprocalInit.set(GLField.id_((String)"curlocal"), (Object)bookInfo.getBaseCurrencyId());
                }
            }
            String userId = RequestContext.get().getUserId();
            reciprocalInit.set("modifier_id", (Object)Long.valueOf(userId));
            reciprocalInit.set("modifydate", (Object)TimeServiceHelper.now());
        }
    }
}

