/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.validate.flex;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.enums.GLBillParamEnum;
import kd.fi.gl.util.QFBuilder;
import kd.fi.gl.validate.flex.FlexValueCacheManager;
import kd.fi.gl.validate.flex.FlexValueCacheSuffix;

public class FlexValueDataGetter {
    private static final Map<String, ReentrantLock> LOCK_MAP = new ConcurrentHashMap<String, ReentrantLock>(8);
    private final FlexValueCacheManager flexValueCacheManager = new FlexValueCacheManager();

    public Set<Long> getParentDataSet(String key, QFBuilder qfBuilder, String entity, String idProp) {
        return this.getDataSet(key, qfBuilder, entity, FlexValueCacheSuffix.PARENT_DATA, idProp);
    }

    public Set<Long> getDisableDataSet(String key, QFBuilder qfBuilder, String entity, String idProp) {
        return this.getDataSet(key, qfBuilder, entity, FlexValueCacheSuffix.DISABLE_DATA, idProp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Long> getDataSet(String key, QFBuilder qfBuilder, String entity, FlexValueCacheSuffix localCacheSuffix, String idProp) {
        Set<Long> dataSet;
        block9: {
            dataSet = this.flexValueCacheManager.loadDataCache(localCacheSuffix, key);
            if (dataSet == null) {
                ReentrantLock reentrantLock = LOCK_MAP.computeIfAbsent(entity, k -> new ReentrantLock());
                try {
                    if (reentrantLock.tryLock(10L, TimeUnit.SECONDS)) {
                        try {
                            dataSet = this.flexValueCacheManager.loadDataCache(localCacheSuffix, key);
                            if (dataSet == null) {
                                dataSet = this.queryData(qfBuilder, entity, idProp);
                                if (dataSet.size() > this.getCacheSize()) {
                                    throw new KDBizException(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u3010%1$s\u3011\u7981\u7528\u7684\u6570\u636e\u8fc7\u591a\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u5904\u7406\u3002", (String)"FlexValueDataGetter_0", (String)"fi-gl-opplugin", (Object[])new Object[]{entity}));
                                }
                                this.flexValueCacheManager.setDataCache(localCacheSuffix, key, dataSet);
                            }
                            break block9;
                        }
                        finally {
                            reentrantLock.unlock();
                        }
                    }
                    throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"FlexValueDataGetter_1", (String)"fi-gl-opplugin", (Object[])new Object[]{entity}));
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return dataSet;
    }

    private Set<Long> queryData(QFBuilder filter, String entity, String idProp) {
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entity, (String)idProp, (QFilter[])filter.toArray(), (String)idProp, (int)(this.getCacheSize() + 1));){
            HashSet<Long> ids = new HashSet<Long>(16);
            for (Row row : dataSet) {
                ids.add(row.getLong(idProp));
            }
            HashSet<Long> hashSet = ids;
            return hashSet;
        }
    }

    private int getCacheSize() {
        return GLBillParamEnum.VOUCHER_FLEX_VALUE_CACHE_SIZE.getIntegerValue();
    }
}

