/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.ballog;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.gl.balcal.CashflowLog;
import kd.fi.gl.balcal.CashflowLogKey;
import kd.fi.gl.balcal.Key;
import kd.fi.gl.balcal.Log;
import kd.fi.gl.balcal.LogList;
import kd.fi.gl.comassist.ComassistContext;
import kd.fi.gl.comassist.ComassistMidTransterModel;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.common.AccountType;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.enums.CashStatusType;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.voucher.util.BookKey;

public class CashflowLogCal {
    private static final String VCH_CASH_PROFITITEM = "vch_cash_profititem";
    private static final String insertCashLogSql = "INSERT INTO t_gl_cashflow_log(FID,FCREATETIME,FVOUCHERID,FORGID,FBOOKTYPEID,FPERIODID,FVCHENTRYID,FCFITEMID,FCURRENCYID,FASSGRPID,FACCOUNTID,FTYPE,FDC,FBOOKEDDATE,#FAMOUNT,FCOUNT,FOPERATION,FCALCULATED) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?@)";
    private static final int MAX_LOG_ITEM_SIZE = 2000;
    private long voucherId = -1L;
    LogList tempLogList = new LogList();
    private boolean hasCashOrPLAcct = false;
    private List<Tuple<CashflowLogKey, BigDecimal>> cashDebitInfo = new ArrayList<Tuple<CashflowLogKey, BigDecimal>>();
    private List<Tuple<CashflowLogKey, BigDecimal>> cashCreditInfo = new ArrayList<Tuple<CashflowLogKey, BigDecimal>>();
    private BigDecimal cashDebitTotalAmt = BigDecimal.ZERO;
    private BigDecimal cashCreditTotalAmt = BigDecimal.ZERO;
    private Map<Long, DynamicObject> cfItemMapCache;

    public void addCashflowLog(int negate, LogList cashFlowLogList, Row row, long acctTableId, String voucherAction, ComassistContext context, Map<Long, BigDecimal> deductInfos) {
        Long mainCFId;
        if (this.isBudgetAcct(row)) {
            return;
        }
        if (this.voucherId != -1L && this.voucherId != row.getLong("id")) {
            this.handleLogList(cashFlowLogList, this, negate, voucherAction);
            this.resetVarData();
        }
        this.voucherId = row.getLong("id");
        Long entryId = row.getLong("entries.id");
        String mainstatus = row.getString("mainstatus");
        String suppstatus = row.getString("suppstatus");
        boolean iscash = GLUtil.isCashAcct((Row)row);
        if (iscash) {
            this.addCashInfo(row, acctTableId, context);
        }
        boolean isPl = GLUtil.isPLAcct((long)row.getLong("entries.account.accounttype"));
        if ("3".equals(mainstatus)) {
            mainCFId = row.getLong("maincfitem");
            Long suppCFId = row.getLong("suppcfitem");
            if (mainCFId > 0L) {
                BigDecimal mainAmt = row.getBigDecimal("maincfamount");
                this.addMaincfLog(negate, row, context.getComassistTable(acctTableId), mainAmt);
                this.dealSuppCashLog(negate, row, context.getComassistTable(acctTableId), mainCFId, mainAmt, iscash, isPl);
            } else if (suppCFId > 0L) {
                this.addSuppLog(negate, row, context.getComassistTable(acctTableId), row.getBigDecimal("suppcfamount"));
            }
        } else if ("2".equals(mainstatus) || "1".equals(mainstatus)) {
            BigDecimal mainAmt;
            mainCFId = row.getLong("maincfitem");
            if (mainCFId > 0L) {
                mainAmt = row.getBigDecimal("maincfamount");
                this.addMaincfLog(negate, row, context.getComassistTable(acctTableId), mainAmt);
                this.dealSuppCashLog(negate, row, context.getComassistTable(acctTableId), mainCFId, mainAmt, iscash, isPl);
            } else if (!iscash) {
                mainAmt = row.getBigDecimal("creditlocal").subtract(row.getBigDecimal("debitlocal"));
                if (negate == -1 && deductInfos != null) {
                    BigDecimal deductAmt = deductInfos.get(entryId);
                    if (deductAmt != null && deductAmt.compareTo(BigDecimal.ZERO) != 0) {
                        mainAmt = deductAmt;
                        this.addMaincfLog(negate, row, context.getComassistTable(acctTableId), mainAmt);
                    }
                } else {
                    this.addMaincfLog(negate, row, context.getComassistTable(acctTableId), mainAmt);
                }
            }
        } else if (!iscash && "3".equals(suppstatus)) {
            Long suppCFId = row.getLong("suppcfitem");
            if (suppCFId > 0L) {
                this.addSuppLog(negate, row, context.getComassistTable(acctTableId), row.getBigDecimal("suppcfamount"));
            }
        } else if (!(iscash || "0".equals(suppstatus) || isPl)) {
            this.addSuppLog(negate, row, context.getComassistTable(acctTableId), row.getBigDecimal("creditlocal").subtract(row.getBigDecimal("debitlocal")));
        }
        boolean isProfitVch = "1".equals(row.getString("sourcetype"));
        if (!isProfitVch && isPl) {
            BigDecimal profitAmt = row.getBigDecimal("creditlocal").subtract(row.getBigDecimal("debitlocal"));
            this.addProfitCashflowLog(row, negate, profitAmt, acctTableId, context);
        }
        if (iscash || isPl) {
            this.hasCashOrPLAcct = true;
        }
    }

    private boolean isBudgetAcct(Row row) {
        return AccountType.isBudgetProp((String)row.getString("entries.account.accounttype.accounttype"));
    }

    private void dealSuppCashLog(int negate, Row row, ComassistMidTransterModel table, long mainCFId, BigDecimal mainAmt, boolean iscash, boolean isPl) {
        long suppCfId = row.getLong("suppcfitem");
        if (suppCfId > 0L) {
            this.addSuppLog(negate, row, table, row.getBigDecimal("suppcfamount"));
        } else {
            DynamicObject mainItem = this.batchLoadCfItem().get(mainCFId);
            if (!iscash && !isPl && mainItem.getBoolean("isdealactivity")) {
                if ("o".equals(mainItem.getString("direction"))) {
                    mainAmt = mainAmt.negate();
                }
                this.addSuppLog(negate, row, table, mainAmt);
            } else if (isPl && !mainItem.getBoolean("isdealactivity")) {
                this.addSuppLog(negate, row, table, row.getBigDecimal("debitlocal").subtract(row.getBigDecimal("creditlocal")));
            }
        }
    }

    private void addMaincfLog(int negate, Row row, ComassistMidTransterModel table, BigDecimal amount) {
        CashflowLogKey maincfKey = this.createMainCfKey(negate, row, table);
        CashflowLog mainFlowLog = this.createCashLog(negate, amount);
        this.tempLogList.add((Key)maincfKey, (Log)mainFlowLog);
    }

    private void addSuppLog(int negate, Row row, ComassistMidTransterModel table, BigDecimal amount) {
        CashflowLogKey suppFlowKey = this.createSuppCfKey(negate, row, table);
        CashflowLog suppFlowLog = this.createCashLog(negate, amount);
        this.tempLogList.add((Key)suppFlowKey, (Log)suppFlowLog);
    }

    private void addCashInfo(Row row, long acctTableId, ComassistContext context) {
        CashflowLogKey cashflowLogKey = new CashflowLogKey(row, 0L, 0L, context.getComassistTable(acctTableId), CashStatusType.CASHITEM.getValue());
        BigDecimal debit = row.getBigDecimal("debitlocal");
        if (debit.compareTo(BigDecimal.ZERO) != 0) {
            this.cashDebitTotalAmt = this.cashDebitTotalAmt.add(debit);
            this.cashDebitInfo.add((Tuple<CashflowLogKey, BigDecimal>)new Tuple((Object)cashflowLogKey, (Object)row.getBigDecimal("debitlocal")));
        } else {
            BigDecimal credit = row.getBigDecimal("creditlocal");
            this.cashCreditTotalAmt = this.cashCreditTotalAmt.add(credit);
            this.cashCreditInfo.add((Tuple<CashflowLogKey, BigDecimal>)new Tuple((Object)cashflowLogKey, (Object)credit));
        }
    }

    private void resetVarData() {
        this.cashDebitInfo.clear();
        this.cashCreditInfo.clear();
        this.tempLogList.clear();
        this.cashDebitTotalAmt = BigDecimal.ZERO;
        this.cashCreditTotalAmt = BigDecimal.ZERO;
        this.hasCashOrPLAcct = false;
    }

    public void handleLogList(LogList cashFlowLogList, CashflowLogCal logCal, int negate, String voucherAction) {
        if (!this.hasCashOrPLAcct) {
            this.tempLogList.getData().forEach((k, v) -> ((CashflowLogKey)k).setAccountId(0L));
        }
        if (logCal.cashDebitTotalAmt.compareTo(BigDecimal.ZERO) != 0 && logCal.cashCreditTotalAmt.compareTo(BigDecimal.ZERO) != 0) {
            this.calCashAcctLog(logCal, negate);
        } else if (logCal.cashCreditTotalAmt.compareTo(BigDecimal.ZERO) != 0) {
            this.tempLogList.getData().forEach((k, v) -> ((CashflowLogKey)k).setDc("-1"));
        } else {
            this.tempLogList.getData().forEach((k, v) -> ((CashflowLogKey)k).setDc("1"));
        }
        cashFlowLogList.add(this.tempLogList);
        if (cashFlowLogList.size() > 2000) {
            this.storeCashflowLog(cashFlowLogList, voucherAction);
            cashFlowLogList.clear();
        }
    }

    private void calCashAcctLog(CashflowLogCal logCal, int negate) {
        BigDecimal amt = logCal.cashDebitTotalAmt.subtract(logCal.cashCreditTotalAmt);
        if (amt.compareTo(BigDecimal.ZERO) > 0) {
            this.tempLogList.getData().forEach((k, v) -> ((CashflowLogKey)k).setDc("1"));
            BigDecimal difAmt = logCal.cashCreditTotalAmt;
            for (Tuple<CashflowLogKey, BigDecimal> tuple : logCal.cashDebitInfo) {
                if (difAmt.compareTo((BigDecimal)tuple.item2) > 0) {
                    this.addCashAcctLog(negate, (CashflowLogKey)tuple.item1, (BigDecimal)tuple.item2, "-1");
                    difAmt = difAmt.subtract((BigDecimal)tuple.item2);
                    continue;
                }
                this.addCashAcctLog(negate, (CashflowLogKey)tuple.item1, difAmt, "-1");
                break;
            }
            for (Tuple<CashflowLogKey, BigDecimal> tuple : logCal.cashCreditInfo) {
                this.addCashAcctLog(negate, (CashflowLogKey)tuple.item1, (BigDecimal)tuple.item2, "1");
            }
        } else {
            this.tempLogList.getData().forEach((k, v) -> ((CashflowLogKey)k).setDc("-1"));
            BigDecimal difAmt = logCal.cashDebitTotalAmt;
            for (Tuple<CashflowLogKey, BigDecimal> tuple : logCal.cashCreditInfo) {
                if (difAmt.compareTo((BigDecimal)tuple.item2) > 0) {
                    this.addCashAcctLog(negate, (CashflowLogKey)tuple.item1, (BigDecimal)tuple.item2, "1");
                    difAmt = difAmt.subtract((BigDecimal)tuple.item2);
                    continue;
                }
                this.addCashAcctLog(negate, (CashflowLogKey)tuple.item1, difAmt, "1");
                break;
            }
            for (Tuple<CashflowLogKey, BigDecimal> tuple : logCal.cashDebitInfo) {
                this.addCashAcctLog(negate, (CashflowLogKey)tuple.item1, (BigDecimal)tuple.item2, "-1");
            }
        }
    }

    private void addCashAcctLog(int negate, CashflowLogKey logKey, BigDecimal amt, String dc) {
        CashflowLog cashflowLog = this.createCashLog(negate, amt);
        logKey.setDc(dc);
        this.tempLogList.add((Key)logKey, (Log)cashflowLog);
    }

    private Map<Long, DynamicObject> batchLoadCfItem() {
        if (this.cfItemMapCache == null) {
            HashMap<Long, DynamicObject> cfItemMap = new HashMap<Long, DynamicObject>(8);
            Map resMap = BusinessDataServiceHelper.loadFromCache((String)"gl_cashflowitem", (String)"direction,isdealactivity,type", null);
            for (Map.Entry entry : resMap.entrySet()) {
                long id = (Long)entry.getKey();
                cfItemMap.put(id, (DynamicObject)entry.getValue());
            }
            this.cfItemMapCache = cfItemMap;
        }
        return this.cfItemMapCache;
    }

    private CashflowLogKey createMainCfKey(int negate, Row row, ComassistMidTransterModel table) {
        CashflowLogKey cashflowLogKey = new CashflowLogKey(row, row.getLong("mcfmasterid").longValue(), row.getLong("maincfassgrp").longValue(), table, CashStatusType.MAINITEM.getValue());
        cashflowLogKey.setCount(negate);
        return cashflowLogKey;
    }

    private CashflowLogKey createSuppCfKey(int negate, Row row, ComassistMidTransterModel table) {
        CashflowLogKey cashflowLogKey = new CashflowLogKey(row, row.getLong("scfmasterid").longValue(), 0L, table, CashStatusType.SUPPITEM.getValue());
        cashflowLogKey.setCount(negate);
        return cashflowLogKey;
    }

    private CashflowLog createCashLog(int negate, BigDecimal amount) {
        CashflowLog cashFlowLog = new CashflowLog();
        cashFlowLog.setAmount(amount);
        cashFlowLog.setCount(1);
        if (negate == -1) {
            cashFlowLog.negate();
        }
        return cashFlowLog;
    }

    private void addProfitCashflowLog(Row row, int negate, BigDecimal profitAmt, Long acctTableId, ComassistContext context) {
        Long orgId = row.getLong("org");
        DynamicObject profitItem = this.getProfitItem(orgId);
        if (profitItem == null) {
            return;
        }
        long profitItemId = profitItem.getLong("masterid");
        CashflowLogKey cashFlowKey = new CashflowLogKey(row, profitItemId, 0L, context.getComassistTable(acctTableId.longValue()), CashStatusType.PROFIT.getValue());
        CashflowLog cashFlowLog = new CashflowLog();
        cashFlowLog.setAmount(profitAmt);
        cashFlowLog.setCount(1);
        if (negate == -1) {
            cashFlowLog.negate();
        }
        this.tempLogList.add((Key)cashFlowKey, (Log)cashFlowLog);
    }

    private DynamicObject getProfitItem(long orgId) {
        HashMap<Long, DynamicObject> profitMap = (HashMap<Long, DynamicObject>)ThreadCache.get((Object)VCH_CASH_PROFITITEM);
        if (null == profitMap) {
            profitMap = new HashMap<Long, DynamicObject>();
            DynamicObject profitItem = this.loadProfitItem(orgId);
            profitMap.put(orgId, profitItem);
            ThreadCache.put((Object)VCH_CASH_PROFITITEM, profitMap);
            return profitItem;
        }
        if (profitMap.containsKey(orgId)) {
            return (DynamicObject)profitMap.get(orgId);
        }
        DynamicObject profitItem = this.loadProfitItem(orgId);
        profitMap.put(orgId, profitItem);
        ThreadCache.put((Object)VCH_CASH_PROFITITEM, profitMap);
        return profitItem;
    }

    private DynamicObject loadProfitItem(long orgId) {
        QFilter fid = BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)orgId);
        DynamicObject profitItem = BusinessDataServiceHelper.loadSingleFromCache((String)"gl_cashflowitem", (QFilter[])new QFilter[]{new QFilter("isprefit", "=", (Object)"1"), fid});
        return profitItem;
    }

    private String getInsertCashLogSql() {
        int size = ComAssistTable.getMaxCommonAssistKeys().size();
        return insertCashLogSql.replace("#", this.dynComassistField(size)).replace("@", this.dynParam(size));
    }

    private String dynComassistField(int size) {
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i <= size; ++i) {
            sb.append("fcomassist").append(i).append("id,");
        }
        return sb.toString();
    }

    private String dynParam(int size) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            sb.append(",?");
        }
        return sb.toString();
    }

    private List<Object[]> getInsertCashflowParams(LogList logList, String operate) {
        Map balMap = logList.getData();
        HashSet<BookKey> bookSet = (HashSet<BookKey>)ThreadCache.get((Object)"vch_cash_log_book");
        if (bookSet == null) {
            bookSet = new HashSet<BookKey>(1);
            ThreadCache.put((Object)"vch_cash_log_book", bookSet);
        }
        ArrayList<Object[]> result = new ArrayList<Object[]>(balMap.size());
        long[] balLogIds = DB.genLongIds((String)"t_gl_cashflow_log", (int)balMap.size());
        int balLogIdIndex = 0;
        for (Map.Entry entry : balMap.entrySet()) {
            CashflowLog cashLog = (CashflowLog)entry.getValue();
            if (cashLog.isZero()) continue;
            bookSet.add(new BookKey((CashflowLogKey)entry.getKey()));
            Object[] groupKey = ((CashflowLogKey)entry.getKey()).getKeyValue();
            int size = 11 + groupKey.length;
            ArrayList<Object> params = new ArrayList<Object>(size);
            long id = balLogIds[balLogIdIndex++];
            params.add(id);
            params.add(new Date());
            for (int i = 0; i < groupKey.length; ++i) {
                params.add(groupKey[i]);
            }
            params.add(cashLog.getAmount());
            params.add(cashLog.getCount());
            params.add(operate);
            params.add(false);
            result.add(params.toArray());
        }
        return result;
    }

    public void storeCashflowLog(LogList cashFlowLogList, String voucherAction) {
        List<Object[]> newCashParams;
        if (cashFlowLogList != null && !cashFlowLogList.isEmpty() && !(newCashParams = this.getInsertCashflowParams(cashFlowLogList, voucherAction)).isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)this.getInsertCashLogSql(), newCashParams);
        }
    }
}

