/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.mc.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ValidatePriority;
import kd.fi.bd.model.schema.property.Prop;
import kd.fi.gl.business.GLServiceFactory;
import kd.fi.gl.business.service.voucher.mc.IMulLocalEntryService;
import kd.fi.gl.business.service.voucher.mc.MulLocalConfig;
import kd.fi.gl.business.service.voucher.mc.arg.VoucherEntries;
import kd.fi.gl.business.service.voucher.mc.arg.VoucherEntryIds;
import kd.fi.gl.business.vo.voucher.IVoucher;
import kd.fi.gl.business.vo.voucher.IVoucherEntry;
import kd.fi.gl.business.vo.voucher.wrap.DynamicEntryWrap;
import kd.fi.gl.business.vo.voucher.wrap.DynamicVoucherWrap;
import kd.fi.gl.interfaces.service.voucher.IVoucherQueryService;
import kd.fi.gl.model.schema.VoucherSchema;
import kd.fi.gl.validate.bigdata.AbstractBigEntryValidator;
import kd.fi.gl.validate.bigdata.Context;
import kd.fi.gl.validate.bigdata.ExtDataEntityWrapper;
import kd.fi.gl.validate.bigdata.RowWrapper;
import kd.fi.gl.validate.bigdata.ValidateArg;
import kd.fi.gl.wrap.EntryWrapper;

public class BuildMCEntriesForDAPValidator
extends AbstractBigEntryValidator {
    public BuildMCEntriesForDAPValidator() {
        this.setSeq(1);
        this.setValidatePriority(ValidatePriority.First);
    }

    private boolean noneMatch(Collection<ExtDataEntityWrapper> extendedDataEntities) {
        return extendedDataEntities.stream().noneMatch(this::match);
    }

    private boolean match(ExtDataEntityWrapper extendedDataEntity) {
        return "4".equalsIgnoreCase(((ExtendedVoucherWrap)extendedDataEntity).getVoucher().getSourceType());
    }

    @Override
    public void validate() {
        if (!this.getOption().containsVariable("isFirstOperation")) {
            return;
        }
        if (MulLocalConfig.enabledConfigs().length == 0) {
            return;
        }
        super.validate();
    }

    @Override
    protected void beforeValidateAllDataEntities(ValidateArg arg) {
        super.beforeValidateAllDataEntities(arg);
        if (this.noneMatch(this.getContext().getAllDataEntityWrapper())) {
            arg.setCancel(true);
        }
    }

    @Override
    protected void beforeValidateDataEntities(ValidateArg arg, List<ExtDataEntityWrapper> dataEntities) {
        super.beforeValidateDataEntities(arg, dataEntities);
        if (this.noneMatch(dataEntities)) {
            arg.setCancel(true);
        }
    }

    @Override
    protected void beforeValidateDataEntity(ValidateArg arg, ExtDataEntityWrapper dataEntityWrapper) {
        super.beforeValidateDataEntity(arg, dataEntityWrapper);
        if (!this.match(dataEntityWrapper)) {
            arg.setCancel(true);
        }
    }

    @Override
    protected void validateEntry(ValidateArg dataValidateArg, ExtDataEntityWrapper dataEntityWrapper, EntryWrapper entryWrapper) {
        super.validateEntry(dataValidateArg, dataEntityWrapper, entryWrapper);
        ExtendedVoucherWrap wrap = (ExtendedVoucherWrap)dataEntityWrapper;
        if (wrap.getVoucherEntries() == null) {
            VoucherEntries entries = new VoucherEntries();
            entries.setVoucher((IVoucher)wrap.getVoucher());
            entries.setEntries(new ArrayList(wrap.getEntries().size()));
            wrap.setVoucherEntries((VoucherEntries<IVoucherEntry>)entries);
        }
        wrap.getVoucherEntries().getEntries().add((DynamicEntryWrap)entryWrapper);
    }

    @Override
    protected void beforeValidateDataEntitiesFormDb(ValidateArg arg, Map<Long, ExtDataEntityWrapper> idDataEntityMap) {
        super.beforeValidateDataEntitiesFormDb(arg, idDataEntityMap);
        if (this.noneMatch(idDataEntityMap.values())) {
            arg.setCancel(true);
        }
    }

    @Override
    protected void beforeValidateOneBillDataSetRow(ValidateArg arg, ExtDataEntityWrapper dataEntityWrapper) {
        super.beforeValidateOneBillDataSetRow(arg, dataEntityWrapper);
        if (!this.match(dataEntityWrapper)) {
            arg.setCancel(true);
        }
    }

    @Override
    protected void validateDataSetRow(ValidateArg dbValidateArg, ExtDataEntityWrapper dataEntityWrapper, long validateId, RowWrapper rowWrapper) {
        super.validateDataSetRow(dbValidateArg, dataEntityWrapper, validateId, rowWrapper);
        ExtendedVoucherWrap wrap = (ExtendedVoucherWrap)dataEntityWrapper;
        long entryId = VoucherSchema.instance.entryId.longOf(rowWrapper.getRow());
        EntryWrapper entryWrapper = wrap.getEntryWrapperMap().get(entryId);
        if (entryWrapper != null) {
            this.validateEntry(dbValidateArg, dataEntityWrapper, entryWrapper);
        } else {
            if (wrap.getVoucherEntryIds() == null) {
                VoucherEntryIds entryIds = new VoucherEntryIds();
                entryIds.setVoucher((IVoucher)wrap.getVoucher());
                entryIds.setEntryIds(new ArrayList(10));
                wrap.setVoucherEntryIds(entryIds);
            }
            wrap.getVoucherEntryIds().getEntryIds().add(entryId);
        }
    }

    @Override
    protected void afterValidateAllDataEntities(ValidateArg validateArg) {
        super.afterValidateAllDataEntities(validateArg);
        List<ExtDataEntityWrapper> allDataEntityWrapper = this.getContext().getAllDataEntityWrapper();
        ArrayList<VoucherEntries<IVoucherEntry>> entriesList = new ArrayList<VoucherEntries<IVoucherEntry>>(allDataEntityWrapper.size());
        ArrayList<VoucherEntryIds> entrtIdsList = new ArrayList<VoucherEntryIds>(allDataEntityWrapper.size());
        for (ExtDataEntityWrapper dataEntityWrapper : allDataEntityWrapper) {
            ExtendedVoucherWrap wrap = (ExtendedVoucherWrap)dataEntityWrapper;
            if (wrap.getVoucherEntries() != null) {
                entriesList.add(wrap.getVoucherEntries());
            }
            if (wrap.getVoucherEntryIds() == null) continue;
            entrtIdsList.add(wrap.getVoucherEntryIds());
        }
        if (!entriesList.isEmpty()) {
            IMulLocalEntryService.get().updateByEntries(entriesList);
        }
        if (!entrtIdsList.isEmpty()) {
            IMulLocalEntryService.get().updateByEntryIds(entrtIdsList);
        }
    }

    @Override
    protected Context buildContext() {
        return new Context();
    }

    @Override
    protected DataSet queryDataSetByIdSet(Set<Long> idSet) {
        return ((IVoucherQueryService)GLServiceFactory.getService(IVoucherQueryService.class)).queryByIds(idSet, null, this.getDataSetSelect(), "id");
    }

    @Override
    protected String getDataSetSelect() {
        return Prop.toSelectFieldStr((Prop[])new Prop[]{VoucherSchema.instance.id, VoucherSchema.instance.entryId});
    }

    @Override
    protected RowWrapper wrapRow(Row row) {
        return new RowWrapper(row);
    }

    @Override
    protected ExtDataEntityWrapper wrapDataEntity(ExtendedDataEntity extendedDataEntity) {
        ExtendedVoucherWrap wrap = new ExtendedVoucherWrap(extendedDataEntity);
        if (extendedDataEntity.getDataEntity().getDynamicObjectType().getProperty("entries") != null) {
            wrap.setEntries(extendedDataEntity.getDataEntity().getDynamicObjectCollection("entries"));
        }
        return wrap;
    }

    @Override
    protected EntryWrapper wrapEntryDyn(DynamicObject entryDyn) {
        return new DynamicEntryWrap(entryDyn);
    }

    private static class ExtendedVoucherWrap
    extends ExtDataEntityWrapper {
        private final DynamicVoucherWrap voucher;
        private VoucherEntryIds voucherEntryIds;
        private VoucherEntries<IVoucherEntry> voucherEntries;

        public ExtendedVoucherWrap(ExtendedDataEntity extendedDataEntity) {
            super(extendedDataEntity);
            this.voucher = new DynamicVoucherWrap(extendedDataEntity.getDataEntity());
        }

        public DynamicVoucherWrap getVoucher() {
            return this.voucher;
        }

        public VoucherEntryIds getVoucherEntryIds() {
            return this.voucherEntryIds;
        }

        public void setVoucherEntryIds(VoucherEntryIds voucherEntryIds) {
            this.voucherEntryIds = voucherEntryIds;
        }

        public VoucherEntries<IVoucherEntry> getVoucherEntries() {
            return this.voucherEntries;
        }

        public void setVoucherEntries(VoucherEntries<IVoucherEntry> voucherEntries) {
            this.voucherEntries = voucherEntries;
        }
    }
}

