/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.mc.validator.entry;

import java.math.BigDecimal;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.gl.business.service.voucher.mc.MulLocalConfig;
import kd.fi.gl.business.vo.voucher.CurrencyField;
import kd.fi.gl.business.vo.voucher.IVoucherEntry;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.util.MetadataUtil;
import kd.fi.gl.validate.bigdata.ValidateResult;
import kd.fi.gl.voucher.mc.validator.entry.AbstractMulLocalEntryValidator;
import kd.fi.gl.voucher.mc.wrap.MulLocalVoucherWrap;
import kd.fi.gl.voucher.validate.VchEntryWrapper;
import kd.fi.gl.voucher.validate.VchExtDataEntityWrapper;
import kd.fi.gl.voucher.validate.VoucherContext;
import kd.fi.gl.voucher.validate.VoucherRowWrapper;

public class MulLocalAmountValidator
extends AbstractMulLocalEntryValidator {
    @Override
    public ValidateResult validate(VchExtDataEntityWrapper entityWrapper, VchEntryWrapper vchEntryWrapper, VoucherContext voucherContext, MulLocalConfig config) {
        return this.doValidate(entityWrapper, vchEntryWrapper, config);
    }

    @Override
    public ValidateResult validate(VchExtDataEntityWrapper entityWrapper, VoucherRowWrapper vchRowWrapper, VoucherContext voucherContext, MulLocalConfig config) {
        return this.doValidate(entityWrapper, vchRowWrapper, config);
    }

    private ValidateResult doValidate(VchExtDataEntityWrapper entityWrapper, IVoucherEntry entry, MulLocalConfig config) {
        String dc;
        BigDecimal amount;
        ValidateResult result = ValidateResult.create();
        boolean usingLocalCalcMulLocal = config.isUsingLocalCalcMulLocal(Long.valueOf(entityWrapper.getOrgId()), Long.valueOf(entityWrapper.getBookTypeId()), entityWrapper.getVchDynWrapper().getSourceType());
        long currencyId = usingLocalCalcMulLocal ? entityWrapper.getVchDynWrapper().getLocCurId() : entry.getCurrencyId();
        if (currencyId == MulLocalVoucherWrap.getMulLocalCurrencyId(config, entityWrapper) && (amount = usingLocalCalcMulLocal ? entry.getLocAmt() : entry.getOriAmt()).compareTo(MulLocalVoucherWrap.getLocalAmount(config, entry, dc = entry.getEntryDC())) != 0) {
            String currencyName = usingLocalCalcMulLocal ? CurrencyField.LOCAL.getDesc() : CurrencyField.ORIGINAL.getDesc();
            result.setErrorMsg(ResManager.loadKDString((String)"%1$s\u91d1\u989d\u9700\u4e0e%2$s\u91d1\u989d\u4e00\u81f4", (String)"MulLocalAmountValidator_0", (String)GLApp.instance.oppluginModule(), (Object[])new Object[]{MetadataUtil.getDisplayName((String)"gl_voucher", (String)config.getCurrencyField()), currencyName}));
        }
        return result;
    }
}

