/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.opplugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.gl.util.GLUtil;

public abstract class AbstractVoucherCfAdjustPlugIn
extends AbstractOperationServicePlugIn {
    private String errorInfo;

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] successVous;
        ArrayList<Long> pkValues = new ArrayList<Long>(2);
        for (DynamicObject entity : e.getDataEntities()) {
            pkValues.add(entity.getLong("id"));
        }
        GLUtil.lockVouchers(pkValues);
        MainEntityType voucherType = EntityMetadataCache.getDataEntityType((String)"gl_voucher");
        DynamicObject[] vouchers = BusinessDataServiceHelper.load((Object[])pkValues.toArray(), (DynamicObjectType)voucherType);
        this.setCf(vouchers);
        HashMap<Long, Object[]> voucher2CreatorAndAuditor = new HashMap<Long, Object[]>(vouchers.length);
        DynamicObject[] billVous = BusinessDataServiceHelper.load((Object[])pkValues.toArray(), (DynamicObjectType)voucherType);
        ArrayList<DynamicObject> statusVous = new ArrayList<DynamicObject>(billVous.length);
        for (DynamicObject dynamicObject : billVous) {
            Object[] obj = new Object[]{dynamicObject.getString("billstatus"), dynamicObject.getString("ischeck"), dynamicObject.getBoolean("ispost"), dynamicObject.getDynamicObject("creator"), dynamicObject.getDynamicObject("submitter"), dynamicObject.getDynamicObject("auditor"), dynamicObject.getDynamicObject("poster"), dynamicObject.getDate("auditdate")};
            voucher2CreatorAndAuditor.put(dynamicObject.getLong("id"), obj);
            if (!"C".equals(dynamicObject.getString("billstatus"))) continue;
            dynamicObject.set("billstatus", (Object)"B");
            dynamicObject.set("ischeck", (Object)"b");
            dynamicObject.set("ispost", (Object)Boolean.FALSE);
            dynamicObject.set("creator", null);
            dynamicObject.set("submitter", null);
            dynamicObject.set("auditor", null);
            dynamicObject.set("poster", null);
            dynamicObject.set("auditdate", null);
            statusVous.add(dynamicObject);
        }
        SaveServiceHelper.save((DynamicObject[])statusVous.toArray(new DynamicObject[statusVous.size()]));
        OperateOption option = OperateOption.create();
        option.setVariableValue("ignorePeriod", "true");
        option.setVariableValue("isCfAdjust", "true");
        OperationResult opResult = OperationServiceHelper.executeOperate((String)"submit", (String)"gl_voucher", (DynamicObject[])vouchers, (OperateOption)option);
        for (DynamicObject voucher : successVous = BusinessDataServiceHelper.load((Object[])pkValues.toArray(), (DynamicObjectType)voucherType)) {
            Object[] creatorAndAuditor = (Object[])voucher2CreatorAndAuditor.get(voucher.getLong("id"));
            voucher.set("billstatus", creatorAndAuditor[0]);
            voucher.set("ischeck", creatorAndAuditor[1]);
            voucher.set("ispost", creatorAndAuditor[2]);
            voucher.set("creator", creatorAndAuditor[3]);
            voucher.set("submitter", creatorAndAuditor[4]);
            voucher.set("auditor", creatorAndAuditor[5]);
            voucher.set("poster", creatorAndAuditor[6]);
            voucher.set("auditdate", creatorAndAuditor[7]);
        }
        SaveServiceHelper.save((DynamicObject[])successVous);
        if (!opResult.isSuccess()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getFailMessage());
            List validateErrors = opResult.getValidateResult().getValidateErrors();
            for (ValidateResult validateError : validateErrors) {
                List allErrorInfo = validateError.getAllErrorInfo();
                for (OperateErrorInfo info : allErrorInfo) {
                    stringBuilder.append(info.getMessage()).append(" ");
                }
            }
            this.errorInfo = stringBuilder.toString();
        }
    }

    public void onReturnOperation(ReturnOperationArgs e) {
        e.getOperationResult().setMessage(this.errorInfo);
    }

    protected void setCf(DynamicObject[] vouchers) {
    }

    protected String getFailMessage() {
        return "";
    }

    protected Set<Long> getArchivedVocuher(Set<Long> voucherIds) {
        if (CollectionUtils.isEmpty(voucherIds)) {
            return Collections.emptySet();
        }
        QFilter billType = new QFilter("billtype", "=", (Object)"gl_voucher");
        QFilter type = new QFilter("type", "=", (Object)"1");
        QFilter billid = new QFilter("billid", "in", voucherIds);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)AbstractVoucherCfAdjustPlugIn.class.getName(), (String)"aef_acelre", (String)"billid", (QFilter[])new QFilter[]{billType, type, billid}, null);){
            HashSet<Long> result = new HashSet<Long>(voucherIds.size());
            for (Row row : ds) {
                result.add(row.getLong("billid"));
            }
            HashSet<Long> hashSet = result;
            return hashSet;
        }
    }
}

