/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.opplugin;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.operate.IOperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.service.voucher.TempVoucherCFService;
import kd.fi.bd.service.voucher.TempVoucherService;
import kd.fi.gl.cache.ThreadCacheKey;
import kd.fi.gl.common.VoucherOpOption;
import kd.fi.gl.notice.NoticeAction;
import kd.fi.gl.notice.NoticeMessenger;
import kd.fi.gl.notice.NoticeUtils;
import kd.fi.gl.reciprocal.ReciprocalUtils;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.voucher.IVoucherService;
import kd.fi.gl.voucher.count.VoucherCountHelper;
import kd.fi.gl.voucher.opplugin.VoucherStatusConvertConfig;
import kd.fi.gl.voucher.option.VoucherOption;
import kd.fi.gl.voucher.util.BalanceUpdateUtil;
import kd.fi.gl.voucher.util.VoucherUtils;
import kd.fi.gl.voucher.validate.VoucherNoticeValidator;

public abstract class AbstractVoucherServicePlugIn
extends AbstractOperationServicePlugIn {
    private static final Map<String, String> SERVICE_MAP = new HashMap<String, String>();
    private VoucherOption voucherOption;
    private Map<String, IVoucherService> service;

    protected VoucherOption getVoucherOption() {
        if (this.voucherOption == null) {
            this.voucherOption = new VoucherOption(this.getOption());
        }
        return this.voucherOption;
    }

    protected boolean editAction() {
        String editActionStr = this.getOption().getVariableValue("edit_action", Boolean.FALSE.toString());
        boolean editAction = Boolean.parseBoolean(editActionStr);
        VoucherOpOption.setEditAction((Boolean)editAction);
        return editAction;
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new VoucherNoticeValidator(this.getVoucherAction()));
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List keys = e.getFieldKeys();
        keys.add("org.id");
        keys.add("book");
        keys.add("period");
        keys.add("vouchertype");
        keys.add("billstatus");
        keys.add("bizdate");
        keys.add("bookeddate");
        keys.add("booktype");
        keys.add("creator");
        keys.add("auditor");
        keys.add("poster");
        keys.add("canceller");
        keys.add("ispost");
        keys.add("isreverse");
        keys.add("hasreverse");
        keys.add("sourcebill");
        keys.add("modifier");
        keys.add("modifytime");
        keys.add("sourcetype");
    }

    public IVoucherService getServiceImpl(String key) {
        if (this.service == null) {
            this.service = new HashMap<String, IVoucherService>(SERVICE_MAP.size());
        }
        if (this.service.get(key) == null) {
            try {
                IVoucherService is = (IVoucherService)Class.forName(SERVICE_MAP.get(key)).newInstance();
                is.init((IOperationResult)this.operationResult);
                this.service.put(key, is);
            }
            catch (Exception e) {
                throw new KDBizException(e.getMessage());
            }
        }
        return this.service.get(key);
    }

    public IVoucherService getService(DynamicObject o) {
        return this.getServiceImpl(this.getVoucherAction());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        this.lock(e.getDataEntities());
        if (this.isDeleteBalance()) {
            BalanceUpdateUtil.setDeductLog(e.getDataEntities(), this.getVoucherAction());
        }
        String voucherStatus = VoucherStatusConvertConfig.getStatus(this.getVoucherAction());
        boolean checkStatus = StringUtils.isNotBlank((CharSequence)voucherStatus);
        for (DynamicObject o : e.getDataEntities()) {
            this.getService(o).beforDealSingleVoucher(o, this.getOption());
            if (!checkStatus || voucherStatus.equals(o.getString("billstatus"))) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u8f6c\u6362\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u67e5\u770b\u3002", (String)"AbstractVoucherServicePlugIn_0", (String)"fi-gl-opplugin", (Object[])new Object[0]));
        }
        if (!this.getOption().containsVariable("isFirstOperation") && !this.getVoucherAction().equals("antiaudit")) {
            VoucherCountHelper.createChangeLog((DynamicObject[])e.getDataEntities(), (String)this.getVoucherAction(), (boolean)true);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        if ("submit".equals(this.getVoucherAction()) && this.getVoucherOption().existsCurrentAccount() || "anticancel".equals(this.getVoucherAction())) {
            DynamicObject[] vchIdSet = Arrays.stream(e.getDataEntities()).map(x -> x.getLong("id")).collect(Collectors.toSet());
            ReciprocalUtils.processReciprocalRecord(vchIdSet);
        } else if ("cancel".equals(this.getVoucherAction()) || "unsubmit".equals(this.getVoucherAction()) || "delete".equals(this.getVoucherAction())) {
            VoucherUtils.deleteReciprocalRecord((DynamicObject[])e.getDataEntities());
        }
        for (DynamicObject o : e.getDataEntities()) {
            this.getService(o).afterDealSingleVoucher(o, this.getOption());
        }
        if (this.isAddBalance()) {
            BalanceUpdateUtil.setAddLog(e.getDataEntities(), this.getVoucherAction());
        }
        if (this.isDeleteBalance() || this.isAddBalance()) {
            AbstractVoucherServicePlugIn.markVchBizDateChange(e);
            BalanceUpdateUtil.storeLog(this.getVoucherAction());
        }
        TX.addCommitListener((CommitListener)new CommitListener(){

            public void onEnded(boolean rollbacked) {
                BalanceUpdateUtil.updateBalance();
            }
        });
        Set ids = (Set)ThreadCache.get((Object)"vch_submit_ids");
        if (ids != null && !ids.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u51ed\u8bc1\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AbstractVoucherServicePlugIn_1", (String)"fi-gl-opplugin", (Object[])new Object[0]));
        }
        VoucherCountHelper.createChangeLog((DynamicObject[])e.getDataEntities(), (String)this.getVoucherAction(), (boolean)false);
    }

    private static void markVchBizDateChange(EndOperationTransactionArgs e) {
        HashSet<Long> vchIds = new HashSet<Long>(8);
        for (DynamicObject entity : e.getDataEntities()) {
            DynamicObjectCollection entries;
            Iterable changedProperties = entity.getDataEntityState().getBizChangedProperties();
            for (IDataEntityProperty ep : changedProperties) {
                if (!ep.getName().equals("bizdate")) continue;
                vchIds.add(entity.getLong("id"));
            }
            if (((BillEntityType)entity.getDataEntityType()).getProperty("entries") == null || !Objects.nonNull(entries = entity.getDynamicObjectCollection("entries")) || entries.size() <= 0) continue;
            Iterable bizChangedProperties = ((DynamicObject)entries.get(0)).getDataEntityState().getBizChangedProperties();
            for (IDataEntityProperty ep : bizChangedProperties) {
                if (!ep.getName().equals("businessnum") && !ep.getName().equals("expiredate")) continue;
                vchIds.add(entity.getLong("id"));
            }
        }
        ThreadCache.put((Object)ThreadCacheKey.buildBizDateChangeKey(), vchIds);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        Set filterVoucherIdsForNotice = NoticeUtils.preFilterVouchersForNotice((DynamicObject[])e.getDataEntities(), (String)this.getVoucherAction());
        NoticeAction noticeAction = NoticeAction.fromVoucherOperation((String)this.getVoucherAction());
        NoticeMessenger.delivery((Long[])filterVoucherIdsForNotice.toArray(new Long[0]), (NoticeAction)noticeAction);
    }

    protected abstract String getVoucherAction();

    private boolean isDeleteBalance() {
        return "submit".equals(this.getVoucherAction()) || "delete".equals(this.getVoucherAction()) || "cancel".equals(this.getVoucherAction()) || "unsubmit".equals(this.getVoucherAction());
    }

    private boolean isAddBalance() {
        return "submit".equals(this.getVoucherAction()) || "anticancel".equals(this.getVoucherAction());
    }

    private void lock(DynamicObject[] vchs) {
        if (vchs.length == 0) {
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>(vchs.length);
        for (DynamicObject vch : vchs) {
            ids.add(vch.getLong("id"));
        }
        GLUtil.lockVouchers(ids);
    }

    public static void updateTempVoucherIndex(DynamicObject[] entities) {
        HashMap<Long, Tuple> updateMap = new HashMap<Long, Tuple>(entities.length);
        HashMap<Long, Long[]> needQueryVids = new HashMap<Long, Long[]>(8);
        for (DynamicObject vchDyn : entities) {
            long vid = vchDyn.getLong("id");
            long orgId = vchDyn.getLong("org.id");
            long periodId = vchDyn.getLong("period.id");
            if (vchDyn.containsProperty("entries")) {
                Set newAccIds = vchDyn.getDynamicObjectCollection("entries").stream().map(x -> x.getLong("account_id")).collect(Collectors.toSet());
                updateMap.put(vid, new Tuple((Object)new Long[]{orgId, periodId}, newAccIds));
                continue;
            }
            needQueryVids.put(vid, new Long[]{orgId, periodId});
        }
        if (!needQueryVids.isEmpty()) {
            Map<Long, Set<Long>> vidToAccIds = AbstractVoucherServicePlugIn.getNewAccIds(new ArrayList<Object>(needQueryVids.keySet()));
            for (Map.Entry<Long, Set<Long>> vidToAccIdEntry : vidToAccIds.entrySet()) {
                long vid = vidToAccIdEntry.getKey();
                Set<Long> accIds = vidToAccIdEntry.getValue();
                Long[] orgPeriods = (Long[])needQueryVids.get(vid);
                updateMap.put(vid, new Tuple((Object)orgPeriods, accIds));
            }
        }
        TempVoucherService.updateOrInsert(updateMap);
    }

    public static Map<Long, Set<Long>> getNewAccIds(List<Object> vids) {
        HashMap<Long, Set<Long>> vidToAccIds = new HashMap<Long, Set<Long>>(8);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select distinct fid, faccountid from t_gl_voucherentry where ", new Object[0]);
        sqlBuilder.appendIn(" fid  ", vids);
        DataSet ds = DB.queryDataSet((String)"queryVoucherAccIds", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder);
        while (ds.hasNext()) {
            Row row = ds.next();
            long vid = row.getLong("fid");
            long accId = row.getLong("faccountid");
            vidToAccIds.computeIfAbsent(vid, x -> new HashSet(8)).add(accId);
        }
        return vidToAccIds;
    }

    public static void updateTempVoucherCFIndex(DynamicObject[] entities) {
        HashSet<Long> voucherIds = new HashSet<Long>(entities.length);
        HashMap<Long, Long> vId2orgId = new HashMap<Long, Long>(8);
        HashMap<Long, Set<Long>> voucher2Cashflow = new HashMap<Long, Set<Long>>(entities.length);
        int i = 0;
        for (DynamicObject vchDyn : entities) {
            long vid = vchDyn.getLong("id");
            voucherIds.add(vid);
            vId2orgId.put(vid, vchDyn.getLong("org.id"));
            Set<Long> newCfIds = AbstractVoucherServicePlugIn.getNewCfIds(vid);
            voucher2Cashflow.put(vid, newCfIds);
            if (++i < 1000) continue;
            TempVoucherCFService.updateOrInsert(voucherIds, vId2orgId, voucher2Cashflow);
            i = 0;
            voucherIds.clear();
            vId2orgId.clear();
            voucher2Cashflow.clear();
        }
        if (voucherIds.size() > 0) {
            TempVoucherCFService.updateOrInsert(voucherIds, vId2orgId, voucher2Cashflow);
        }
    }

    public static Set<Long> getNewCfIds(long vid) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select distinct fmaincfitemid,fsuppcfitemid from t_gl_voucherentry where ", new Object[0]);
        sqlBuilder.append(" fid = ? ", new Object[]{vid});
        return (Set)DB.query((DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<Set<Long>>(){

            public Set<Long> handle(ResultSet rs) throws Exception {
                HashSet<Long> cfIds = new HashSet<Long>(8);
                while (rs.next()) {
                    cfIds.add(rs.getLong("fmaincfitemid"));
                    cfIds.add(rs.getLong("fsuppcfitemid"));
                }
                return cfIds;
            }
        });
    }

    public static Map<Long, Set<Long>> getNewCfIds(Collection<Long> vids) {
        if (CollectionUtils.isEmpty(vids)) {
            return new HashMap<Long, Set<Long>>(1);
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select distinct fmaincfitemid,fsuppcfitemid,fid from t_gl_voucherentry where ", new Object[0]);
        sqlBuilder.appendIn(" fid  ", vids.toArray());
        return (Map)DB.query((DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<Map<Long, Set<Long>>>(){

            public Map<Long, Set<Long>> handle(ResultSet rs) throws Exception {
                HashMap<Long, Set<Long>> voucher2Cashflow = new HashMap<Long, Set<Long>>(8);
                while (rs.next()) {
                    long main = rs.getLong("fmaincfitemid");
                    long supp = rs.getLong("fsuppcfitemid");
                    voucher2Cashflow.compute(rs.getLong("fid"), (k, v) -> {
                        if (v == null) {
                            v = new HashSet<Long>(8);
                        }
                        if (main != 0L) {
                            v.add(main);
                        }
                        if (supp != 0L) {
                            v.add(supp);
                        }
                        return v;
                    });
                }
                return voucher2Cashflow;
            }
        });
    }

    static {
        SERVICE_MAP.put("submitStandrad", "kd.fi.gl.voucher.SubmitStandradVoucherService");
        SERVICE_MAP.put("submitReverse", "kd.fi.gl.voucher.SubmitReverseVoucherService");
        SERVICE_MAP.put("audit", "kd.fi.gl.voucher.AuditVoucherService");
        SERVICE_MAP.put("antiaudit", "kd.fi.gl.voucher.AntiAuditVoucherService");
        SERVICE_MAP.put("delete", "kd.fi.gl.voucher.DeleteVoucherService");
        SERVICE_MAP.put("deleteReverse", "kd.fi.gl.voucher.DeleteReverseVoucherService");
        SERVICE_MAP.put("cancel", "kd.fi.gl.voucher.CancelVoucherService");
        SERVICE_MAP.put("cancelReverse", "kd.fi.gl.voucher.CancelReverseVoucherService");
        SERVICE_MAP.put("anticancel", "kd.fi.gl.voucher.AntiCancelVoucherService");
        SERVICE_MAP.put("anticancelReverse", "kd.fi.gl.voucher.AntiCancelReverseVoucherService");
        SERVICE_MAP.put("post", "kd.fi.gl.voucher.PostVoucherService");
        SERVICE_MAP.put("antipost", "kd.fi.gl.voucher.AntiPostVoucherService");
        SERVICE_MAP.put("check", "kd.fi.gl.voucher.CheckVoucherService");
        SERVICE_MAP.put("uncheck", "kd.fi.gl.voucher.UnCheckVoucherService");
        SERVICE_MAP.put("unsubmit", "kd.fi.gl.voucher.UnSubmitVoucherService");
    }
}

