/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.opplugin;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.fi.gl.business.service.voucher.writeoff.WriteOffService;
import kd.fi.gl.voucher.IVoucherService;
import kd.fi.gl.voucher.opplugin.AbstractVoucherServicePlugIn;
import kd.fi.gl.voucher.validate.ReverseVoucherAntiCancelValidator;
import kd.fi.gl.voucher.validate.VoucherAntiCancelValidator;

public class VoucherAntiCancelOp
extends AbstractVoucherServicePlugIn {
    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = e.getFieldKeys();
        keys.add("entries.account");
        keys.add("assgrp");
        keys.add("measureunit");
        keys.add("debitori");
        keys.add("creditori");
        keys.add("debitlocal");
        keys.add("creditlocal");
        keys.add("quantity");
        keys.add("entrydc");
        keys.add("sourcetype");
        keys.add("localcur");
        keys.add("currency");
        keys.add("entries.expiredate");
        keys.add("entries.businessnum");
        keys.add("entries.edescription");
        keys.add("entries.maincfitem");
        keys.add("entries.maincfassgrp");
        keys.add("entries.maincfamount");
        keys.add("entries.suppcfitem");
        keys.add("entries.suppcfamount");
    }

    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new VoucherAntiCancelValidator());
        e.getValidators().add(new ReverseVoucherAntiCancelValidator());
    }

    @Override
    public IVoucherService getService(DynamicObject o) {
        IVoucherService i = null;
        i = o.getBoolean("isreverse") ? this.getServiceImpl("anticancelReverse") : super.getService(o);
        return i;
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
    }

    @Override
    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        List reverseVouchers = Arrays.stream(e.getDataEntities()).filter(x -> x.getBoolean("isreverse")).collect(Collectors.toList());
        WriteOffService.effective(reverseVouchers);
    }

    @Override
    protected String getVoucherAction() {
        return "anticancel";
    }
}

