/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.opplugin;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.common.AccountType;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.SystemParamHelper;
import kd.fi.gl.voucher.opplugin.AbstractVoucherCfAdjustPlugIn;

public class VoucherCfAdjustOp
extends AbstractVoucherCfAdjustPlugIn {
    private Map<Long, Long> masterIdMap = new HashMap<Long, Long>();

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                DynamicObject[] vouchers;
                ExtendedDataEntity[] entities = this.getDataEntities();
                HashSet<Long> vchSet = new HashSet<Long>(entities.length);
                for (ExtendedDataEntity entity : entities) {
                    vchSet.add(entity.getDataEntity().getLong("id"));
                }
                Long orgId = entities[0].getDataEntity().getLong("org_id");
                boolean mdifyhiscfitem = SystemParamHelper.getBooleanParam((String)"mdifyhiscfitem", (long)orgId, (boolean)false);
                Long bookType = null;
                HashMap<Long, DynamicObject> vchDyns = new HashMap<Long, DynamicObject>(vchSet.size());
                MainEntityType voucherType = EntityMetadataCache.getDataEntityType((String)"gl_voucher");
                for (DynamicObject vch : vouchers = BusinessDataServiceHelper.load((Object[])vchSet.toArray(), (DynamicObjectType)voucherType)) {
                    vchDyns.put(vch.getLong("id"), vch);
                    if (bookType != null) continue;
                    bookType = vch.getLong("booktype.id");
                }
                Map map = VoucherCfAdjustOp.getAccAddendMap(orgId, bookType);
                DynamicObjectCollection accts = QueryServiceHelper.query((String)"bd_accountview", (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "in", map.keySet())});
                for (DynamicObject acct : accts) {
                    long accId = acct.getLong("id");
                    long accMasterId = acct.getLong("masterid");
                    VoucherCfAdjustOp.this.masterIdMap.put(accMasterId, map.get(accId));
                }
                Set<Long> archivedVocuher = VoucherCfAdjustOp.this.getArchivedVocuher(vchSet);
                HashMap<Long, Boolean> closePeriods = new HashMap<Long, Boolean>(entities.length);
                for (ExtendedDataEntity entity : entities) {
                    Long vchId = entity.getDataEntity().getLong("id");
                    DynamicObject vchDyn = (DynamicObject)vchDyns.get(vchId);
                    if (archivedVocuher.contains(vchId)) {
                        this.addErrorMessage(entity, ResManager.loadKDString((String)"\u51ed\u8bc1\u5df2\u5f52\u6863\uff0c\u65e0\u6cd5\u8c03\u6574\u3002", (String)"VoucherCfAdjustOp_5", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    Boolean isClosePeriod = (Boolean)closePeriods.get(vchDyn.getLong("period.id"));
                    if (isClosePeriod == null) {
                        isClosePeriod = GLUtil.isClosePeriod((long)vchDyn.getLong("org.id"), (long)vchDyn.getLong("booktype.id"), (long)vchDyn.getLong("period.id"));
                        closePeriods.put(vchDyn.getLong("period.id"), isClosePeriod);
                    }
                    if (!mdifyhiscfitem && isClosePeriod.booleanValue()) {
                        this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u5df2\u7ed3\u8d26\uff0c\u5982\u9700\u4fee\u6539\u73b0\u91d1\u6d41\u91cf\uff0c\u8bf7\u6253\u5f00\u201c\u4fee\u6539\u7ed3\u8d26\u671f\u95f4\u73b0\u91d1\u6d41\u91cf\u201d\u53c2\u6570\u3002", (String)"VoucherCancelAdjustOp_1", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    if (!GLUtil.isCurrentVoucherAllowModifyCF((long)orgId, (long)bookType, (long)vchDyn.getLong("period.id"), (String)vchDyn.getString("billstatus"))) {
                        this.addErrorMessage(entity, ResManager.loadKDString((String)"\u201c\u4fee\u6539\u5df2\u5ba1\u6838\u51ed\u8bc1\u73b0\u91d1\u6d41\u91cf\u201d\u53c2\u6570\u5df2\u5173\u95ed\uff0c\u5df2\u5ba1\u6838\u51ed\u8bc1\u548c\u5df2\u8fc7\u8d26\u51ed\u8bc1\u4e0d\u5141\u8bb8\u4fee\u6539\u8865\u5145\u8d44\u6599\u3002", (String)"VoucherCfAdjustOp_4", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    DynamicObjectCollection entries = vchDyn.getDynamicObjectCollection("entries");
                    HashSet<Long> checkedAcc = new HashSet<Long>(VoucherCfAdjustOp.this.masterIdMap.size());
                    for (DynamicObject entry : entries) {
                        if (AccountType.isBudgetType((long)entry.getDynamicObject("account").getLong("accounttype_id"))) continue;
                        long accountId = entry.getLong("account.masterid");
                        Long suppId = (Long)VoucherCfAdjustOp.this.masterIdMap.get(accountId);
                        if (suppId != null || !checkedAcc.add(accountId)) continue;
                        String accountName = entry.getString("account.name");
                        this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u79d1\u76ee\uff1a%s\uff0c\u672a\u8bbe\u7f6e\u8865\u5145\u8d44\u6599\uff0c\u8bf7\u5148\u8bbe\u7f6e\u3002", (String)"VoucherCfAdjustOp_3", (String)"fi-gl-opplugin", (Object[])new Object[0]), accountName));
                    }
                }
            }
        });
    }

    @Override
    protected void setCf(DynamicObject[] vouchers) {
        for (DynamicObject voucher : vouchers) {
            DynamicObjectCollection entries = voucher.getDynamicObjectCollection("entries");
            for (DynamicObject entry : entries) {
                long accountId = entry.getLong("account.masterid");
                BigDecimal debitlocal = entry.getBigDecimal("debitlocal");
                BigDecimal creditlocal = entry.getBigDecimal("creditlocal");
                Long suppId = this.masterIdMap.get(accountId);
                if (suppId == null || suppId == 0L) continue;
                entry.set("suppcfitem", (Object)this.getCashFlowItemDyn(suppId));
                entry.set("suppcfamount", (Object)creditlocal.subtract(debitlocal));
            }
            voucher.set("suppstatus", (Object)"c");
        }
    }

    @Override
    protected String getFailMessage() {
        return ResManager.loadKDString((String)"\u5e94\u7528\u5931\u8d25\n", (String)"VoucherCfAdjustOp_2", (String)"fi-gl-opplugin", (Object[])new Object[0]);
    }

    private static Map<Long, Long> getAccAddendMap(Long org, Long booktype) {
        HashMap<Long, Long> map = new HashMap<Long, Long>(10);
        QFilter orgFilter = new QFilter("org", "=", (Object)org);
        QFilter booktypeFilter = new QFilter("booktype", "=", (Object)booktype);
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"gl_accedit", (String)"id", (QFilter[])new QFilter[]{orgFilter, booktypeFilter});
        if (dyn == null) {
            return Collections.EMPTY_MAP;
        }
        DynamicObject accedit = BusinessDataServiceHelper.loadSingleFromCache((Object)dyn.getLong("id"), (String)"gl_accedit");
        DynamicObjectCollection entryentity = accedit.getDynamicObjectCollection("entryentity");
        for (DynamicObject obj : entryentity) {
            long suppitem = obj.getLong("suppitem_id");
            DynamicObjectCollection accounts = obj.getDynamicObjectCollection("accounts");
            for (DynamicObject account : accounts) {
                long accId = account.getLong("fbasedataid_id");
                map.put(accId, suppitem);
            }
        }
        return map;
    }

    private DynamicObject getCashFlowItemDyn(long id) {
        DynamicObject item = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"gl_cashflowitem");
        return item;
    }
}

