/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.opplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.ext.fi.ai.DapValidator;
import kd.bos.ext.fi.ai.DapVoucherUtil;
import kd.bos.ext.fi.ai.Voucher;
import kd.bos.ext.fi.ai.VoucherOperation;
import kd.bos.ext.fi.ai.v2.fah.dto.BillToVchRelationDto;
import kd.bos.ext.fi.ai.v2.fah.service.impl.DapDelUpdDataServiceImpl;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.common.exception.DtxErrorCodeConstants;
import kd.bos.kdtx.sdk.exception.BeginDtxException;
import kd.bos.kdtx.sdk.session.ec.ECGlobalSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bd.indexing.constant.CDCRecOperationTypeEnum;
import kd.fi.bd.indexing.integrator.CDCServiceGLIntegrator;
import kd.fi.bd.service.voucher.TempVoucherCFService;
import kd.fi.bd.service.voucher.TempVoucherService;
import kd.fi.gl.business.GLServiceFactory;
import kd.fi.gl.business.service.voucher.writeoff.WriteOffService;
import kd.fi.gl.constant.basedata.CurrencyConstant;
import kd.fi.gl.enums.AmortStyle;
import kd.fi.gl.interfaces.service.dap.IDAPService;
import kd.fi.gl.notice.NoticeUtils;
import kd.fi.gl.util.ImrVoucherUtil;
import kd.fi.gl.util.TccUtil;
import kd.fi.gl.voucher.IVoucherService;
import kd.fi.gl.voucher.carryover.utils.BalanceCarryOverUtils;
import kd.fi.gl.voucher.dtxservice.VoucherIdsParam;
import kd.fi.gl.voucher.opplugin.AbstractVoucherServicePlugIn;
import kd.fi.gl.voucher.util.VoucherUtils;
import kd.fi.gl.voucher.validate.VoucherDeleteValidator;

public class VoucherDeleteOp
extends AbstractVoucherServicePlugIn {
    private static final Log logger = LogFactory.getLog(VoucherDeleteOp.class);
    private static final String STATUS_A = "A";
    private static final String STATUS_D = "D";

    private static IDAPService getDAPService() {
        return (IDAPService)GLServiceFactory.getService(IDAPService.class);
    }

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = e.getFieldKeys();
        keys.add("vouchertype");
        keys.add("bookeddate");
        keys.add("bizdate");
        keys.add("sourcetype");
        keys.add("sourcebilltype");
        keys.add("vdescription");
        keys.add("ischeck");
    }

    @Override
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
    }

    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new VoucherDeleteValidator());
        if (!this.getOption().containsVariable("ignoreDapValidator")) {
            e.getValidators().add(new DapValidator());
        }
    }

    @Override
    public IVoucherService getService(DynamicObject o) {
        IVoucherService i = o.getBoolean("isreverse") ? this.getServiceImpl("deleteReverse") : super.getService(o);
        return i;
    }

    public void deleteVoucherRelation(List<DynamicObject> voucheraDynList) {
        this.rewriteDelRelation(voucheraDynList);
    }

    private void rewriteDelRelation(List<DynamicObject> voucheraDynList) {
        HashMap pvMap = new HashMap(16);
        String sourceType = voucheraDynList.get(0).get("sourcetype").toString();
        boolean isAmort = "5".equals(sourceType);
        boolean isAdjust = "2".equals(sourceType);
        Map<Long, DynamicObject> voucherDynMap = voucheraDynList.stream().collect(Collectors.toMap(vch -> vch.getLong("id"), vch -> vch));
        DataSet relation = QueryServiceHelper.queryDataSet((String)"kd.fi.gl.voucher.opplugin.VoucherDeleteOp.rewriteDelRelation", (String)"gl_voucherrelation", (String)"id, period, targentity", (QFilter[])new QFilter("targentity", "in", voucherDynMap.keySet()).toArray(), null);
        while (relation.hasNext()) {
            Row row = relation.next();
            long periodId = row.getLong("period");
            long voucherId = row.getLong("targentity");
            if (pvMap.get(periodId) == null) {
                ArrayList<Long> list = new ArrayList<Long>();
                list.add(voucherId);
                pvMap.put(periodId, list);
                continue;
            }
            ((List)pvMap.get(periodId)).add(voucherId);
        }
        HashMap<Long, DynamicObject> id2amort = new HashMap<Long, DynamicObject>();
        for (Map.Entry pvEntry : pvMap.entrySet()) {
            List voucherIds = (List)pvEntry.getValue();
            long periodId = (Long)pvEntry.getKey();
            QFilter f1 = new QFilter("targentity", "in", (Object)voucherIds);
            QFilter f2 = new QFilter("period", "=", (Object)periodId);
            if (isAmort) {
                this.rewriteAmort(new QFilter[]{f1, f2}, voucherDynMap, periodId, id2amort);
            }
            DeleteServiceHelper.delete((String)"gl_voucherrelation", (QFilter[])f1.toArray());
            if (!isAdjust) continue;
            DeleteServiceHelper.delete((String)"gl_adjustratelog", (QFilter[])new QFilter[]{new QFilter("voucherid", "in", (Object)voucherIds)});
        }
        if (isAmort) {
            SaveServiceHelper.save((DynamicObject[])id2amort.values().toArray(new DynamicObject[0]));
        }
    }

    private void rewriteAmort(QFilter[] filters, Map<Long, DynamicObject> voucherDynMap, long periodId, Map<Long, DynamicObject> id2amort) {
        long amortId;
        MainEntityType amortEntityType = EntityMetadataCache.getDataEntityType((String)"gl_voucheramortacheme");
        DataSet relationSet = QueryServiceHelper.queryDataSet((String)"writeBackVoucherAmort", (String)"gl_voucherrelation", (String)"targentity,srcentity", (QFilter[])filters, null);
        HashMap<Long, Long> amortVoucherIdMap = new HashMap<Long, Long>();
        HashSet<Long> amortIdList = new HashSet<Long>();
        for (Row rowRelation : relationSet) {
            long voucherId = rowRelation.getLong("targentity");
            amortId = rowRelation.getLong("srcentity");
            amortVoucherIdMap.put(amortId, voucherId);
            amortIdList.add(amortId);
        }
        DynamicObject[] amortDynList = BusinessDataServiceHelper.load((Object[])amortIdList.toArray(new Long[0]), (DynamicObjectType)amortEntityType);
        List amortDynListReplaced = Arrays.stream(amortDynList).map(dynamicObject -> id2amort.getOrDefault((Long)dynamicObject.getPkValue(), (DynamicObject)dynamicObject)).collect(Collectors.toList());
        for (DynamicObject amortDyn : amortDynListReplaced) {
            amortId = amortDyn.getLong("id");
            long voucherId = amortVoucherIdMap.get(amortId) == null ? 0L : (Long)amortVoucherIdMap.get(amortId);
            DynamicObject voucherDyn = voucherDynMap.get(voucherId);
            if (voucherDyn == null) {
                logger.info("\u51ed\u8bc1\u644a\u9500:" + amortDyn.getString("name") + "\u5728\u5173\u7cfb\u8868\u4e2d\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u51ed\u8bc1\u4fe1\u606f");
                continue;
            }
            BigDecimal voucherAmortAmount = amortDyn.getBigDecimal("amortamount");
            DynamicObjectCollection coll = amortDyn.getDynamicObjectCollection("policies");
            BigDecimal curAmortPeriod = BigDecimal.ONE;
            for (int i = 0; i < coll.size(); ++i) {
                DynamicObject rowAmort = (DynamicObject)coll.get(i);
                long rowPeriodId = rowAmort.getLong("period_id");
                if (periodId != rowPeriodId) continue;
                coll.remove(i);
                BigDecimal amortAmountVal = rowAmort.getBigDecimal("amount");
                voucherAmortAmount = voucherAmortAmount.subtract(amortAmountVal);
                curAmortPeriod = rowAmort.getBigDecimal("curamortperiod");
                break;
            }
            curAmortPeriod = curAmortPeriod.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : curAmortPeriod;
            amortDyn.set("amortamount", (Object)voucherAmortAmount);
            if (!amortDyn.getString("status").equals("4")) {
                if (BigDecimal.ZERO.compareTo(voucherAmortAmount) == 0) {
                    amortDyn.set("status", (Object)"1");
                } else if (voucherAmortAmount.compareTo(amortDyn.getBigDecimal("totalamount")) == 0) {
                    amortDyn.set("status", (Object)"3");
                } else {
                    amortDyn.set("status", (Object)"2");
                }
            }
            amortDyn.set("planperiod", (Object)amortDyn.getBigDecimal("planperiod").add(curAmortPeriod));
            amortDyn.set("amortperiod", (Object)amortDyn.getBigDecimal("amortperiod").subtract(curAmortPeriod));
            int localScale = amortDyn.getDynamicObject("currency").getInt(CurrencyConstant.Entity_AMT_Scale.getKey());
            if (AmortStyle.AVERAGE.getValue().equals(amortDyn.get("amortstyle")) && amortDyn.getBigDecimal("planperiod").signum() != 0) {
                amortDyn.set("periodamortamount", (Object)amortDyn.getBigDecimal("totalamount").subtract(amortDyn.getBigDecimal("amortamount")).divide(amortDyn.getBigDecimal("planperiod"), localScale, RoundingMode.HALF_UP));
            }
            if (AmortStyle.DATE.getValue().equals(amortDyn.get("amortstyle")) && "1".equals(amortDyn.get("status"))) {
                BigDecimal total = amortDyn.getBigDecimal("totalAmount");
                total = total != null ? total : BigDecimal.ZERO;
                BigDecimal amortAmountVal = amortDyn.getBigDecimal("amortamount");
                amortAmountVal = amortAmountVal != null ? amortAmountVal : BigDecimal.ZERO;
                BigDecimal periodCount = amortDyn.getBigDecimal("planPeriod");
                if (periodCount.compareTo(BigDecimal.ZERO) > 0) {
                    BigDecimal periodAmount = total.subtract(amortAmountVal).divide(periodCount, localScale, RoundingMode.HALF_UP);
                    amortDyn.set("periodAmortAmount", (Object)periodAmount);
                } else {
                    amortDyn.set("periodAmortAmount", (Object)total);
                }
            }
            id2amort.put((Long)amortDyn.getPkValue(), amortDyn);
        }
    }

    @Override
    public void endOperationTransaction(EndOperationTransactionArgs e) {
        block3: {
            super.endOperationTransaction(e);
            List reverseVouchers = Arrays.stream(e.getDataEntities()).filter(x -> x.getBoolean("isreverse")).collect(Collectors.toList());
            WriteOffService.delete(reverseVouchers);
            this.dealVoucherRelation(e);
            this.deleteTempVoucherIndex(e.getDataEntities());
            this.deleteTempVoucherCFIndex(e.getDataEntities());
            VoucherUtils.updateVerifyLog((DynamicObject[])e.getDataEntities());
            this.deleteVoucherSynRelation(e);
            this.deleteVoucherFilingRelation(e.getDataEntities());
            this.recycleNumber(e);
            CDCServiceGLIntegrator.getInstance().registerCDCChangedRecord(CDCRecOperationTypeEnum.Delete, this.dataEntities);
            if (TccUtil.isDtxEnable() && !this.getOption().containsVariable("isTcc")) {
                logger.info("begin delete_voucher ");
                String message = this.getOperationResult().getMessage();
                try {
                    ECGlobalSession.begin((String)"delete_voucher", (DBRoute)DBRoute.of((String)"ai"), (boolean)true);
                }
                catch (Exception bde) {
                    if (bde instanceof BeginDtxException && DtxErrorCodeConstants.NEST_DTX_ERROR.getErrorCode().equals(((BeginDtxException)bde).getErrorCode().getCode())) break block3;
                    logger.error("VoucherDeleteOp--BeginDtxException", (Throwable)bde);
                    throw bde;
                }
            }
        }
        this.dealDap(e);
        this.deleteIsomerismRelation(e);
    }

    private void deleteIsomerismRelation(EndOperationTransactionArgs e) {
        HashSet<Long> voucherIds = new HashSet<Long>(1000);
        int i = 0;
        for (DynamicObject o : e.getDataEntities()) {
            String sourceType = o.get("sourcetype").toString();
            if (!"8".equals(sourceType)) continue;
            voucherIds.add(o.getLong("id"));
            if (++i % 1000 != 0) continue;
            ImrVoucherUtil.deleteIsomerismRelation(voucherIds);
            voucherIds.clear();
        }
        if (!voucherIds.isEmpty()) {
            ImrVoucherUtil.deleteIsomerismRelation(voucherIds);
        }
    }

    @Override
    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        BalanceCarryOverUtils.removeLog((DynamicObject[])e.getDataEntities());
        CDCServiceGLIntegrator.getInstance().raiseCDCEvent(CDCRecOperationTypeEnum.Delete, e.getDataEntities());
    }

    private void recycleNumber(EndOperationTransactionArgs e) {
        for (DynamicObject vch : e.getDataEntities()) {
            if (!STATUS_D.equals(vch.getString("billstatus"))) continue;
            vch.set("billstatus", (Object)"B");
            CodeRuleServiceHelper.recycleNumber((String)"gl_voucher", (DynamicObject)vch, (String)vch.getString("org_id"), (String)vch.getString("billno"));
        }
    }

    private void deleteVoucherSynRelation(EndOperationTransactionArgs e) {
        ArrayList<Long> list = new ArrayList<Long>(e.getDataEntities().length);
        for (DynamicObject vch : e.getDataEntities()) {
            list.add(vch.getLong("id"));
        }
        if (!list.isEmpty()) {
            QFilter fentryId = new QFilter("destvoucherid", "in", list);
            DeleteServiceHelper.delete((String)"gl_voucher_relation", (QFilter[])new QFilter[]{fentryId});
        }
    }

    private void deleteVoucherFilingRelation(DynamicObject[] entities) {
        List voucherIds;
        Object[] filingRecords;
        if (ArrayUtils.isNotEmpty((Object[])entities) && ArrayUtils.isNotEmpty((Object[])(filingRecords = BusinessDataServiceHelper.load((String)"gl_filingdata", (String)"voucherid,sendvoucherid,filingstatus,filingperson,filingdate", (QFilter[])new QFilter("voucherid", "in", voucherIds = Arrays.stream(entities).map(x -> x.getLong("id")).collect(Collectors.toList())).toArray())))) {
            for (Object filingRecord : filingRecords) {
                filingRecord.set("voucherid", (Object)0L);
                filingRecord.set("sendvoucherid", (Object)0L);
                filingRecord.set("filingstatus", (Object)"2");
                filingRecord.set("filingperson", (Object)0L);
                filingRecord.set("filingdate", null);
                logger.info(String.format("clear_voucher_filing relation on id: %s success", filingRecord.get("id")));
            }
            SaveServiceHelper.update((DynamicObject[])filingRecords);
        }
    }

    @Override
    protected String getVoucherAction() {
        return "delete";
    }

    private void dealDap(EndOperationTransactionArgs e) {
        HashMap<Long, Map<Long, Map<Long, String>>> dapVchMap = new HashMap<Long, Map<Long, Map<Long, String>>>();
        int i = 0;
        for (DynamicObject o : e.getDataEntities()) {
            String sourceType = o.get("sourcetype").toString();
            if (!"4".equals(sourceType)) continue;
            Long orgid = o.getLong("org.id");
            Map periodVch = dapVchMap.computeIfAbsent(orgid, k -> new HashMap());
            Long periodid = o.getLong("period.id");
            Map vchId2num = periodVch.computeIfAbsent(periodid, k -> new HashMap());
            vchId2num.put(o.getLong("id"), o.getString("billno"));
            if (++i % 100 != 0) continue;
            this.removeDap(dapVchMap);
            dapVchMap.clear();
        }
        if (!dapVchMap.isEmpty()) {
            this.removeDap(dapVchMap);
        }
    }

    private void dealVoucherRelation(EndOperationTransactionArgs e) {
        ArrayList<DynamicObject> amortVoucherDynList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> autoVoucherDynList = new ArrayList<DynamicObject>();
        int i = 0;
        HashSet<Long> ids = new HashSet<Long>(e.getDataEntities().length);
        HashSet<Long> synVchIds = new HashSet<Long>(16);
        for (DynamicObject o : e.getDataEntities()) {
            String sourceType = o.get("sourcetype").toString();
            if ("5".equals(sourceType)) {
                amortVoucherDynList.add(o);
                if (++i % 100 == 0) {
                    this.deleteVoucherRelation(amortVoucherDynList);
                    amortVoucherDynList.clear();
                }
            }
            if ("6".equals(sourceType) || "1".equals(sourceType) || "2".equals(sourceType)) {
                autoVoucherDynList.add(o);
                if (++i % 100 == 0) {
                    this.deleteVoucherRelation(autoVoucherDynList);
                    autoVoucherDynList.clear();
                }
            }
            if (o.getDynamicObject("sourcebilltype") != null && "gl_voucher".equalsIgnoreCase(o.getDynamicObject("sourcebilltype").getString("id"))) {
                synVchIds.add(o.getLong("id"));
            }
            ids.add(o.getLong("id"));
        }
        if (!amortVoucherDynList.isEmpty()) {
            this.deleteVoucherRelation(amortVoucherDynList);
        }
        if (!autoVoucherDynList.isEmpty()) {
            this.deleteVoucherRelation(autoVoucherDynList);
        }
        if (!synVchIds.isEmpty()) {
            DeleteServiceHelper.delete((String)"gl_voucher_relation", (QFilter[])new QFilter[]{new QFilter("destvoucherid", "in", synVchIds)});
        }
        ArrayList voucherIds = new ArrayList(ids);
        NoticeUtils.deleteNoticeByVoucherIds((String)"gl_acnotice", voucherIds);
        NoticeUtils.deleteNoticeByVoucherIds((String)"gl_cfnotice", voucherIds);
    }

    private void removeDap(Map<Long, Map<Long, Map<Long, String>>> dapVchMap) {
        String cloudId = "fi";
        String appId = "gl";
        for (Map.Entry<Long, Map<Long, Map<Long, String>>> meOrg : dapVchMap.entrySet()) {
            Long orgid = meOrg.getKey();
            Map<Long, Map<Long, String>> periodVchMap = meOrg.getValue();
            for (Map.Entry<Long, Map<Long, String>> mePe : periodVchMap.entrySet()) {
                Map<Long, String> vchID2BillNo = mePe.getValue();
                if (TccUtil.isDtxEnable() && !this.getOption().containsVariable("isTcc")) {
                    logger.info("begin--DtxVoucherDeleteService---");
                    Map map = DapVoucherUtil.getBilltypeAndVoucher(vchID2BillNo);
                    for (Map.Entry entry : map.entrySet()) {
                        List voucherList = (List)entry.getValue();
                        ArrayList<String> businessIds = new ArrayList<String>();
                        for (Map voucherMap : voucherList) {
                            for (Long billId : voucherMap.keySet()) {
                                businessIds.add(String.valueOf(billId));
                            }
                        }
                        ECGlobalSession.setBusinessType((String)("dap_" + (String)entry.getKey()));
                        ECGlobalSession.setBusinessInfo(businessIds);
                        VoucherIdsParam voucherIdsParam = new VoucherIdsParam();
                        HashMap<String, List<Map<Long, Voucher>>> param = new HashMap<String, List<Map<Long, Voucher>>>();
                        param.put((String)entry.getKey(), voucherList);
                        voucherIdsParam.setBilltypeAndVoucher(param);
                        ECGlobalSession.register((String)cloudId, (String)appId, (String)"DtxVoucherDeleteService", (Param)voucherIdsParam);
                    }
                } else {
                    DapVoucherUtil.dapWriteBack((VoucherOperation)VoucherOperation.Delete, vchID2BillNo);
                }
                this.insertintoIepBusinessTask(vchID2BillNo.keySet());
                DapDelUpdDataServiceImpl dapDelUpdDataService = new DapDelUpdDataServiceImpl();
                dapDelUpdDataService.deleteTrackerAndBizVchOption(orgid, vchID2BillNo.keySet(), this.getOption());
            }
        }
    }

    private void insertintoIepBusinessTask(Set<Long> ids) {
        BillToVchRelationDto voucherRelations = VoucherDeleteOp.getDAPService().getBillToVchRelationDtoByVchIDSet(ids);
        HashMap<String, List> billIdMap = new HashMap<String, List>(8);
        for (BillToVchRelationDto.BillToVoucherRelation voucherRelation : voucherRelations) {
            String billType = voucherRelation.getBillType();
            Long billid = voucherRelation.getBillId();
            List idList = billIdMap.computeIfAbsent(billType, k -> new ArrayList());
            idList.add(billid);
        }
        for (Map.Entry me : billIdMap.entrySet()) {
            int i;
            List billids = (List)me.getValue();
            int size = billids.size();
            if (size > 10000) {
                HashSet cache = new HashSet(10000);
                i = 0;
                for (Object billid : billids) {
                    cache.add(billid);
                    if (++i % 10000 != 0 && i != size) continue;
                    DynamicObject[] intellBusinesses = new DynamicObject[cache.size()];
                    int j = 0;
                    for (Object id : cache) {
                        intellBusinesses[j] = this.createIntellBusinessDb(id.toString(), me.getKey());
                        ++j;
                    }
                    SaveServiceHelper.save((DynamicObject[])intellBusinesses);
                    cache.clear();
                }
                continue;
            }
            DynamicObject[] intellBusinesses = new DynamicObject[size];
            i = 0;
            for (Object id : billids) {
                intellBusinesses[i] = this.createIntellBusinessDb(id.toString(), me.getKey());
                ++i;
            }
            SaveServiceHelper.save((DynamicObject[])intellBusinesses);
        }
    }

    private DynamicObject createIntellBusinessDb(String key, Object value) {
        DynamicObject intellBusiness = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"iep_businesstask"));
        intellBusiness.set("business", value);
        intellBusiness.set("oper", (Object)"buildvoucher");
        intellBusiness.set("entityid", (Object)key);
        return intellBusiness;
    }

    protected void deleteTempVoucherIndex(DynamicObject[] entities) {
        List<Long> tempStatusVouIds;
        if (ArrayUtils.isNotEmpty((Object[])entities) && !(tempStatusVouIds = Arrays.stream(entities).filter(x -> {
            String status = x.getString("billstatus");
            return STATUS_A.equals(status) || STATUS_D.equals(status);
        }).map(x -> x.getLong("id")).collect(Collectors.toList())).isEmpty()) {
            TempVoucherService.deleteByIds((Long[])tempStatusVouIds.toArray(new Long[tempStatusVouIds.size()]));
        }
    }

    protected void deleteTempVoucherCFIndex(DynamicObject[] entities) {
        List<Long> tempStatusVouIds;
        if (ArrayUtils.isNotEmpty((Object[])entities) && !(tempStatusVouIds = Arrays.stream(entities).filter(x -> {
            String status = x.getString("billstatus");
            return STATUS_A.equals(status) || STATUS_D.equals(status);
        }).map(x -> x.getLong("id")).collect(Collectors.toList())).isEmpty()) {
            TempVoucherCFService.deleteByIds((Long[])tempStatusVouIds.toArray(new Long[tempStatusVouIds.size()]));
        }
    }
}

