/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.preset;

import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.fi.ai.PresetCashItemUtil;
import kd.bos.ext.fi.ai.presetcf.PresetCashFlowItemParam;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.service.voucher.TempVoucherCFService;
import kd.fi.bd.util.TimerFactory;
import kd.fi.gl.assistitem.CashFLowItemFlexValueGetter;
import kd.fi.gl.business.GLServiceFactory;
import kd.fi.gl.common.AccountType;
import kd.fi.gl.flex.FlexValueJson;
import kd.fi.gl.interfaces.service.cf.ICashFlowFlexService;
import kd.fi.gl.util.CashFlowItemHelper;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.VoucherSaveValidatorParam;
import kd.fi.gl.voucher.dtxservice.VoucherPresetParm;
import kd.fi.gl.voucher.preset.PresetBatch;
import kd.fi.gl.voucher.preset.PresetType;
import kd.fi.gl.voucher.preset.VoucherBatchProcessor;
import kd.fi.gl.voucher.preset.VoucherHead;

public class BatchPresetProcessor {
    private TimerFactory.Timer timer;
    private CashFLowItemFlexValueGetter cashFLowItemFlexValueGetter;
    private VoucherBatchProcessor voucherBatchProcessor;
    private PresetBatch batch;
    private boolean existsPresetItem;
    private VoucherPresetParm param;

    private BatchPresetProcessor() {
    }

    protected static BatchPresetProcessor create(int batchSize, VoucherPresetParm param) {
        BatchPresetProcessor batchPresetProcessor = new BatchPresetProcessor();
        batchPresetProcessor.cashFLowItemFlexValueGetter = new CashFLowItemFlexValueGetter();
        batchPresetProcessor.voucherBatchProcessor = VoucherBatchProcessor.create(batchSize);
        batchPresetProcessor.batch = PresetBatch.create(batchSize);
        batchPresetProcessor.existsPresetItem = QueryServiceHelper.exists((String)"gl_presetcashflowitem", null);
        batchPresetProcessor.timer = TimerFactory.getTimer(batchPresetProcessor.getClass());
        batchPresetProcessor.param = param;
        return batchPresetProcessor;
    }

    private ICashFlowFlexService getFlexService() {
        return (ICashFlowFlexService)GLServiceFactory.getService(ICashFlowFlexService.class);
    }

    protected void processing(VoucherHead voucherHead, Row row) {
        if (this.batch.nextVoucher(voucherHead)) {
            this.voucherBatchProcessor.processing();
        }
        if (!this.batch.tryAddRow(voucherHead, row)) {
            this.timer.time("BatchPresetProcessor_doCurrentBatchPreset start");
            this.doCurrentBatchPreset();
            this.timer.time("BatchPresetProcessor_doCurrentBatchPreset end");
            this.batch.reset();
            this.batch.addRow(row);
        }
        this.afterAddRow(row);
    }

    private void afterAddRow(Row row) {
        if (this.existsPresetItem) {
            if ("1".equals(row.getString("mainstatus")) && !GLUtil.isCashAcct((Row)row)) {
                long entryId = row.getLong("entryid");
                this.buildPresetParam(row, false).ifPresent(tuple -> {
                    this.batch.getParamTable().put((Object)entryId, (Object)PresetType.MAIN, tuple.item1);
                    this.batch.getParamTable().put((Object)entryId, (Object)PresetType.SUPP, tuple.item2);
                });
            } else if ("1".equals(row.getString("suppstatus")) && !GLUtil.isPLAcct((long)row.getLong("entries.account.accounttype"))) {
                this.buildPresetParam(row, true).ifPresent(tuple -> {
                    PresetCashFlowItemParam cfr_ignored_0 = (PresetCashFlowItemParam)this.batch.getParamTable().put((Object)row.getLong("entryid"), (Object)PresetType.SUPP, tuple.item2);
                });
            }
        }
    }

    protected void endProcess() {
        this.batch.uploadLastVoucher();
        this.doCurrentBatchPreset();
        this.voucherBatchProcessor.endProcess();
        TempVoucherCFService.updateOrInsert(this.param.getVoucherIds(), this.param.getvId2orgId(), this.param.getVoucher2Cashflow());
        this.batch.reset();
    }

    private void doCurrentBatchPreset() {
        Table<Long, PresetType, PresetCashFlowItemParam> paramTable = this.batch.getParamTable();
        Map<Object, Object> itemMap = this.existsPresetItem ? this.loadPresetItem(paramTable) : Collections.emptyMap();
        for (Row row : this.batch.getProcessRowList()) {
            long cashFlowFlexValueId;
            Object[] param = null;
            long id = row.getLong("id");
            VoucherHead voucherHead = this.batch.getProcessVoucherHeadMap().get(id);
            voucherHead = voucherHead == null ? this.batch.getLastVoucherHead() : voucherHead;
            VoucherSaveValidatorParam cp = voucherHead.getVoucherSaveValidatorParam();
            long mainCfItemId = row.getLong("entries.maincfitem");
            long suppCfItemId = row.getLong("entries.suppcfitem");
            long mainCfAssgrpId = row.getLong("entries.maincfassgrp");
            long entryId = row.getLong("entryid");
            long accountTypeId = row.getLong("entries.account.accounttype");
            String accountAssgrpValue = row.getString("entries.assgrp.value");
            BigDecimal mainCfAmount = row.getBigDecimal("entries.maincfamount");
            BigDecimal suppCfAmount = row.getBigDecimal("entries.suppcfamount");
            BigDecimal debitLoc = row.getBigDecimal("entries.debitlocal");
            BigDecimal creditLoc = row.getBigDecimal("entries.creditlocal");
            String mainStatus = row.getString("mainstatus");
            String suppStatus = row.getString("suppstatus");
            boolean existsMainCfItem = mainCfItemId > 0L;
            boolean existsMainCfAssgrp = mainCfAssgrpId > 0L;
            boolean needSetMainCfFlexValue = existsMainCfItem && !existsMainCfAssgrp;
            cp.getTotal()[0] = cp.getTotal()[0].add(debitLoc);
            cp.getTotal()[1] = cp.getTotal()[1].add(creditLoc);
            boolean isCash = GLUtil.isCashAcct((Row)row);
            boolean isPLAcct = GLUtil.isPLAcct((long)accountTypeId);
            boolean isBudget = AccountType.isBudgetType((long)accountTypeId);
            if (isBudget) continue;
            if (isCash) {
                if (!cp.isHashCash()) {
                    cp.setHashCash(true);
                }
                cp.setCashtotalamt(cp.getCashtotalamt().add(debitLoc).subtract(creditLoc));
                continue;
            }
            if (!cp.isNotC_NotPL() && !isPLAcct) {
                cp.setNotC_NotPL(true);
            }
            if (!cp.isHasPL() && isPLAcct) {
                cp.setHasPL(true);
            }
            if (mainCfItemId != 0L) {
                DynamicObject mainItem = BusinessDataServiceHelper.loadSingleFromCache((Object)mainCfItemId, (String)"gl_cashflowitem");
                this.sumMainCfAmt(cp, mainItem, isPLAcct, mainCfAmount);
                if (isPLAcct && !cp.isPlMainCf()) {
                    cp.setPlMainCf(true);
                }
            }
            if (suppCfItemId != 0L) {
                if (!cp.isHasSuppCf()) {
                    cp.setHasSuppCf(true);
                }
                cp.getCashAmt()[2] = cp.getCashAmt()[2].add(suppCfAmount);
            }
            boolean autoSetCfAssGrp = this.getFlexService().isGetFromAccountFlexValueEnable(voucherHead.getOrgId());
            if (this.existsPresetItem) {
                DynamicObject suppItem;
                PresetCashFlowItemParam mainParam = (PresetCashFlowItemParam)paramTable.get((Object)entryId, (Object)PresetType.MAIN);
                PresetCashFlowItemParam suppParam = (PresetCashFlowItemParam)paramTable.get((Object)entryId, (Object)PresetType.SUPP);
                DynamicObject mainItem = mainParam == null ? null : (DynamicObject)itemMap.get(mainParam);
                DynamicObject dynamicObject = suppItem = suppParam == null ? null : (DynamicObject)itemMap.get(suppParam);
                if (mainItem != null) {
                    param = new Object[]{0, BigDecimal.ZERO, 0, BigDecimal.ZERO, 0, 0};
                    boolean flag = this.setMainCF(mainItem, suppItem, row, param, this.param.getVoucher2Cashflow());
                    if (flag) {
                        if (autoSetCfAssGrp) {
                            param[4] = this.cashFLowItemFlexValueGetter.getFromAccountFlexValueJson(new FlexValueJson(row.getString("entries.assgrp.value")), Long.parseLong(param[0].toString()), voucherHead.getOrgId());
                        }
                        needSetMainCfFlexValue = false;
                    }
                    this.sumMainCfAmt(cp, mainItem, isPLAcct, (BigDecimal)param[1]);
                } else if (suppItem != null && !isPLAcct && "0".equals(mainStatus) && ("1".equals(suppStatus) || "2".equals(suppStatus) || "3".equals(suppStatus))) {
                    param = new Object[]{0, 0, 0, 0, 0, 0};
                    param[0] = mainCfItemId;
                    param[1] = mainCfAmount;
                    param[2] = suppItem.getLong("id");
                    param[3] = creditLoc.subtract(debitLoc);
                    if (mainCfItemId != 0L) {
                        this.param.getVoucher2Cashflow().get(row.getLong("id")).add(mainCfItemId);
                    }
                    this.param.getVoucher2Cashflow().get(row.getLong("id")).add(suppItem.getLong("id"));
                    param[4] = needSetMainCfFlexValue && autoSetCfAssGrp ? Long.valueOf(this.cashFLowItemFlexValueGetter.getFromAccountFlexValueJson(new FlexValueJson(accountAssgrpValue), mainCfItemId, voucherHead.getOrgId())) : Long.valueOf(mainCfAssgrpId);
                    param[5] = entryId;
                    needSetMainCfFlexValue = false;
                    cp.getCashAmt()[2] = cp.getCashAmt()[2].add((BigDecimal)param[3]);
                }
            }
            if (needSetMainCfFlexValue && autoSetCfAssGrp && (cashFlowFlexValueId = this.cashFLowItemFlexValueGetter.getFromAccountFlexValueJson(new FlexValueJson(accountAssgrpValue), mainCfItemId, voucherHead.getOrgId())) > 0L) {
                param = new Object[]{0, 0, 0, 0, 0, 0};
                param[0] = mainCfItemId;
                param[1] = mainCfAmount;
                param[2] = suppCfItemId;
                param[3] = suppCfAmount;
                param[4] = cashFlowFlexValueId;
                param[5] = entryId;
            }
            if (isPLAcct) {
                cp.getCashAmt()[1] = cp.getCashAmt()[1].add(creditLoc).subtract(debitLoc);
            }
            if (param == null) continue;
            this.voucherBatchProcessor.addEntryParam(id, param);
        }
        Collection<VoucherHead> voucherHeads = this.batch.getProcessVoucherHeadMap().values();
        for (VoucherHead voucherHead : voucherHeads) {
            Object[] param = this.buildVoucherParam(voucherHead);
            this.voucherBatchProcessor.addVoucherParam(voucherHead.getId(), param);
        }
    }

    private boolean setMainCF(DynamicObject cfItem, DynamicObject suppItem, Row row, Object[] param, Map<Long, Set<Long>> voucher2CfItem) {
        if (cfItem != null) {
            BigDecimal dc = BigDecimal.ONE;
            if ("o".equals(cfItem.getString("direction"))) {
                dc = dc.negate();
            }
            param[0] = cfItem.getLong("id");
            param[1] = row.getBigDecimal("entries.creditlocal").subtract(row.getBigDecimal("entries.debitlocal")).multiply(dc);
            voucher2CfItem.get(row.getLong("id")).add(cfItem.getLong("id"));
            if (suppItem != null) {
                boolean isdealactivity = cfItem.getBoolean("isdealactivity");
                boolean isPL = GLUtil.isPLAcct((long)row.getLong("entries.account.accounttype"));
                if (isPL && !isdealactivity) {
                    param[2] = suppItem.getLong("id");
                    param[3] = row.getBigDecimal("entries.debitlocal").subtract(row.getBigDecimal("entries.creditlocal"));
                    voucher2CfItem.get(row.getLong("id")).add(cfItem.getLong("id"));
                } else if (!isPL && isdealactivity) {
                    param[2] = suppItem.getLong("id");
                    param[3] = row.getBigDecimal("entries.creditlocal").subtract(row.getBigDecimal("entries.debitlocal"));
                    voucher2CfItem.get(row.getLong("id")).add(cfItem.getLong("id"));
                }
            }
            param[5] = row.getLong("entryid");
            return true;
        }
        return false;
    }

    private void sumMainCfAmt(VoucherSaveValidatorParam cp, DynamicObject mainItem, boolean isPLAcct, BigDecimal mainCFAmt) {
        if (mainItem != null) {
            if (!cp.isHashMainCf()) {
                cp.setHashMainCf(true);
            }
            boolean in = true;
            if ("o".equals(mainItem.getString("direction"))) {
                cp.setCashtotalused(cp.getCashtotalused().subtract(mainCFAmt));
                in = false;
            } else {
                cp.setCashtotalused(cp.getCashtotalused().add(mainCFAmt));
            }
            boolean isDealactivity = mainItem.getBoolean("isdealactivity");
            if (isDealactivity) {
                cp.getCashAmt()[0] = in ? cp.getCashAmt()[0].add(mainCFAmt) : cp.getCashAmt()[0].subtract(mainCFAmt);
            }
        }
    }

    private Optional<Tuple<PresetCashFlowItemParam, PresetCashFlowItemParam>> buildPresetParam(Row row, boolean onlySupp) {
        long accId = row.getLong("entries.account");
        String accLongNum = row.getString("entries.account.longnumber");
        if (StringUtils.isBlank((CharSequence)accLongNum)) {
            return Optional.empty();
        }
        long assGrpId = row.getLong("entries.assgrp");
        String assGrpVal = row.getString("entries.assgrp.value");
        String dc = row.getString("entries.entrydc");
        return onlySupp ? Optional.of(Tuple.create(null, (Object)PresetCashFlowItemParam.create((long)accId, (String)accLongNum, (long)assGrpId, (String)assGrpVal, (String)dc, (String)"3"))) : Optional.of(Tuple.create((Object)PresetCashFlowItemParam.create((long)accId, (String)accLongNum, (long)assGrpId, (String)assGrpVal, (String)dc, (String)"1"), (Object)PresetCashFlowItemParam.create((long)accId, (String)accLongNum, (long)assGrpId, (String)assGrpVal, (String)dc, (String)"3")));
    }

    private Map<PresetCashFlowItemParam, DynamicObject> loadPresetItem(Table<Long, PresetType, PresetCashFlowItemParam> entryParamTable) {
        List paramList = entryParamTable.values().stream().filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map presetCashFlowItemIdMap = PresetCashItemUtil.batchGetCashFlowItemIds(paramList, (long)this.batch.getBatchGroup().getOrgId(), (long)this.batch.getBatchGroup().getAccTabId(), (long)this.batch.getBatchGroup().getPeriodId());
        Map itemIdDynMap = BusinessDataServiceHelper.loadFromCache((Object[])presetCashFlowItemIdMap.values().toArray(), (String)"gl_cashflowitem");
        HashMap<PresetCashFlowItemParam, DynamicObject> result = new HashMap<PresetCashFlowItemParam, DynamicObject>(presetCashFlowItemIdMap.size());
        for (Map.Entry entry : presetCashFlowItemIdMap.entrySet()) {
            DynamicObject value = (DynamicObject)itemIdDynMap.get(entry.getValue());
            if (value == null) continue;
            result.put((PresetCashFlowItemParam)entry.getKey(), value);
        }
        return result;
    }

    private Object[] buildVoucherParam(VoucherHead voucherHead) {
        Object[] param = new Object[]{voucherHead.getMainStatus(), voucherHead.getSuppStatus(), voucherHead.getId()};
        CashFlowItemHelper.setCFStatus((Object[])param, (VoucherSaveValidatorParam)voucherHead.getVoucherSaveValidatorParam());
        return param;
    }
}

