/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.synplugin;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class GLVoucherSynOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.addAll(this.billEntityType.getAllFields().keySet());
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntry : this.dataEntities) {
                    DynamicObject voucherView = dataEntry.getDataEntity();
                    String orgnum = voucherView.getString("org");
                    boolean orgishave = QueryServiceHelper.exists((String)"bos_org", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)orgnum)});
                    if (!orgishave) {
                        this.addErrorMessage(dataEntry, ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e3a\u7a7a\u6216\u8005\u627e\u4e0d\u5230\u6570\u636e\u3002", (String)"GLVoucherSynOp_0", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    String booktypenum = voucherView.getString("booktype");
                    boolean booktypeishave = QueryServiceHelper.exists((String)"bd_accountbookstype", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)booktypenum)});
                    if (!booktypeishave) {
                        this.addErrorMessage(dataEntry, ResManager.loadKDString((String)"\u8d26\u7c3f\u7c7b\u578b\u4e3a\u7a7a\u6216\u8005\u627e\u4e0d\u5230\u6570\u636e\u3002", (String)"GLVoucherSynOp_1", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    String vouchertypenum = voucherView.getString("vouchertype");
                    boolean vouchertypeishave = QueryServiceHelper.exists((String)"gl_vouchertype", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)vouchertypenum)});
                    if (!vouchertypeishave) {
                        this.addErrorMessage(dataEntry, ResManager.loadKDString((String)"\u51ed\u8bc1\u7c7b\u578b\u4e3a\u7a7a\u6216\u8005\u627e\u4e0d\u5230\u6570\u636e\u3002", (String)"GLVoucherSynOp_2", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    DynamicObjectCollection dynamicObjectCollection = voucherView.getDynamicObjectCollection("entryentity");
                    for (DynamicObject entry : dynamicObjectCollection) {
                        String accountnum = entry.getString("accountinfo");
                        boolean accountishave = QueryServiceHelper.exists((String)"bd_accountview", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)accountnum)});
                        if (!accountishave) {
                            this.addErrorMessage(dataEntry, ResManager.loadKDString((String)"\u4f1a\u8ba1\u79d1\u76ee\u4e3a\u7a7a\u6216\u8005\u627e\u4e0d\u5230\u6570\u636e\u3002", (String)"GLVoucherSynOp_3", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                            return;
                        }
                        String currencynum = entry.getString("currencyinfo");
                        boolean currencyishave = QueryServiceHelper.exists((String)"bd_currency", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)currencynum)});
                        if (currencyishave) continue;
                        this.addErrorMessage(dataEntry, ResManager.loadKDString((String)"\u5e01\u79cd\u4e3a\u7a7a\u6216\u8005\u627e\u4e0d\u5230\u6570\u636e\u3002", (String)"GLVoucherSynOp_4", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                        return;
                    }
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.beginOperationTransaction(e);
        for (DynamicObject voucher : dataEntities = e.getDataEntities()) {
            voucher.set("org", GLVoucherSynOp.parseValueForJson(voucher.getString("org")));
            voucher.set("booktype", GLVoucherSynOp.parseValueForJson(voucher.getString("booktype")));
            voucher.set("vouchertype", GLVoucherSynOp.parseValueForJson(voucher.getString("vouchertype")));
            DynamicObjectCollection dynamicObjectCollection = voucher.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : dynamicObjectCollection) {
                entry.set("accountinfo", GLVoucherSynOp.parseValueForJson(entry.getString("accountinfo")));
                entry.set("assgrpinfo", GLVoucherSynOp.parseAssistForJson(entry.getDynamicObjectCollection("subentryentity")));
                entry.set("currencyinfo", GLVoucherSynOp.parseValueForJson(entry.getString("currencyinfo")));
                entry.set("measureunitinfo", GLVoucherSynOp.parseValueForJson(entry.getString("measureunitinfo")));
                entry.set("maincfiteminfo", GLVoucherSynOp.parseValueForJson(entry.getString("maincfiteminfo")));
                entry.set("maincfassgrpinfo", GLVoucherSynOp.parseValueForJson(entry.getString("maincfassgrpinfo")));
                entry.set("suppcfiteminfo", GLVoucherSynOp.parseValueForJson(entry.getString("suppcfiteminfo")));
            }
        }
    }

    private static Object parseValueForJson(String value) {
        if (value == null || value.equals("")) {
            return null;
        }
        HashMap<String, String> numberToJson = new HashMap<String, String>();
        numberToJson.put("number", value);
        return JSON.toJSON(numberToJson);
    }

    private static Object parseAssistForJson(DynamicObjectCollection subentries) {
        if (subentries.isEmpty()) {
            return null;
        }
        HashMap result = new HashMap(subentries.size());
        for (DynamicObject subentry : subentries) {
            String assid;
            DynamicObject assist;
            String type = subentry.getString("type");
            if ("Company".equals(type) || "Account".equals(type) || (assist = BusinessDataServiceHelper.loadSingle((String)"bd_asstacttype", (String)"id,name", (QFilter[])new QFilter("number", "=", (Object)(assid = subentry.getString("key"))).toArray())) == null) continue;
            HashMap<String, String> assvalueMap = new HashMap<String, String>(1);
            String assvalue = subentry.getString("value");
            assvalueMap.put("number", assvalue);
            result.put(assist.getString("name"), assvalueMap);
        }
        Object json = JSON.toJSON(result);
        return json;
    }
}

