/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.util.Tuple2;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.bd.business.service.LocalCurrencyConfigService;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import kd.fi.bd.business.vo.MetaField;
import kd.fi.bd.consts.MCT;
import kd.fi.gl.balcal.BalanceLog;
import kd.fi.gl.balcal.BalanceLogKey;
import kd.fi.gl.balcal.CashflowLog;
import kd.fi.gl.balcal.CashflowLogKey;
import kd.fi.gl.balcal.Key;
import kd.fi.gl.balcal.Log;
import kd.fi.gl.balcal.LogList;
import kd.fi.gl.business.GLServiceFactory;
import kd.fi.gl.business.service.common.BillParamService;
import kd.fi.gl.business.service.reciprocal.UnAcccurrentUpdateUtil;
import kd.fi.gl.cache.ThreadCacheKey;
import kd.fi.gl.comassist.ComassistContext;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.interfaces.service.voucher.IVoucherQueryService;
import kd.fi.gl.reciprocal.ReciprocalUtils;
import kd.fi.gl.util.CashFlowItemHelper;
import kd.fi.gl.util.FlexUtils;
import kd.fi.gl.util.cashflow.CashFlowSumHelper;
import kd.fi.gl.voucher.ballog.CashflowLogCal;
import kd.fi.gl.voucher.util.BookKey;
import org.apache.commons.lang3.tuple.Pair;

public class BalanceLogRecord {
    public static final String ACC_MAP = "BalanceUpdateUtil_acc_map";
    public static final String VCH_BAL_DATA = "vch_bal_data";
    public static final String VCH_CASH_DATA = "vch_cash_data";
    public static final String VCH_SUBMITID = "vch_submit_ids";
    public static final String VCH_BAL_LOG_BOOK = "vch_bal_log_book";
    public static final String VCH_CASH_LOG_BOOK = "vch_cash_log_book";
    public static final String VCH_CASH_PROFITITEM = "vch_cash_profititem";
    public static final int MAX_LOG_ITEM_SIZE = 20000;
    private static final String VOUCHER_SELECT = "id,org,booktype,bookeddate,bizdate,period,localcur,book,mainstatus,suppstatus,entries.account account,entries.account.iscash,entries.account.isbank,entries.account.iscashequivalent,entries.account.accounttype,entries.account.accounttype.accounttype,entries.account.masterid masterid,entries.account.accounttable accounttable,entries.assgrp assgrp,entries.measureunit measureunit,entries.currency currency,entries.id,entries.entrydc dc,entries.quantity quantity,entries.debitori debitori,entries.debitlocal debitlocal,entries.creditori creditori, entries.creditlocal creditlocal,entries.maincfitem maincfitem,entries.maincfitem.masterid mcfmasterid,entries.maincfassgrp maincfassgrp,entries.maincfamount maincfamount,entries.suppcfitem suppcfitem,entries.suppcfitem.masterid scfmasterid,entries.suppcfamount suppcfamount, sourcetype";
    private static final String insertBalLogSql = "INSERT INTO t_gl_balance_log(FID,FCREATETIME,FVOUCHERID,FORGID,FBOOKTYPEID,FPERIODID,FACCOUNTID,FACCOUNTTABLEID,FCURRENCYID,FASSGRPID,FMEASUREUNITID,%1$s FDEBITFOR,FCREDITFOR,FDEBITLOCAL,FCREDITLOCAL,FDEBITQTY,FCREDITQTY,FCOUNT,FOPERATION,FCALCULATED,FACCASSGRPID,FBIZDATE,FACCCALCULATED %2$s) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?%3$s)";
    private static final String insertCashLogSql = "INSERT INTO t_gl_cashflow_log(FID,FCREATETIME,FVOUCHERID,FORGID,FBOOKTYPEID,FPERIODID,FCFITEMID,FCURRENCYID,FASSGRPID,#FAMOUNT,FCOUNT,FOPERATION,FCALCULATED) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?@)";
    LogList balLogList;
    LogList cashFlowLogList;
    Set<Long> submitIds;
    Map<Long, DynamicObject> vchs = new HashMap<Long, DynamicObject>(100);
    List<LocalCurrencyConfigVO> localCurList = new ArrayList<LocalCurrencyConfigVO>(3);

    public BalanceLogRecord(Map<Long, DynamicObject> dataEntity) {
        this.submitIds = (Set)ThreadCache.get((Object)VCH_SUBMITID);
        if (this.submitIds == null) {
            this.submitIds = new HashSet<Long>();
        }
        this.balLogList = (LogList)ThreadCache.get((Object)VCH_BAL_DATA);
        if (this.balLogList == null) {
            this.balLogList = new LogList();
        }
        this.cashFlowLogList = (LogList)ThreadCache.get((Object)VCH_CASH_DATA);
        if (this.cashFlowLogList == null) {
            this.cashFlowLogList = new LogList();
        }
        this.vchs = dataEntity;
        this.localCurList = LocalCurrencyConfigService.queryEnableCurrencies();
    }

    public void deductLog(String voucherAction) {
        Map<Long, Tuple2<Long, Boolean>> accMap = BalanceLogRecord.getAccMap();
        List<QFilter> filters = this.getDeductVchQFilter(this.vchs);
        Map<Long, DataSet> deductInfos = this.getDesignInfos();
        Map vEntryDeducts = null;
        long voucherId = 0L;
        try (DataSet oldVoucherSet = ((IVoucherQueryService)GLServiceFactory.getService(IVoucherQueryService.class)).queryByIds(this.vchs.keySet(), filters.toArray(new QFilter[0]), BalanceLogRecord.getVoucherSelect(this.localCurList), "id");){
            int size = ComAssistTable.getMaxCommonAssistKeys().size();
            Map<Object, Object> map = size > 0 ? BalanceLogRecord.collectComAssistData(oldVoucherSet.copy(), size) : new HashMap();
            ComassistContext context = new ComassistContext();
            context.init(map);
            boolean isSubmit = "submit".equals(voucherAction);
            CashflowLogCal cal = new CashflowLogCal();
            for (Row row : oldVoucherSet) {
                if (!this.process(row)) continue;
                Long vid = row.getLong("id");
                if (isSubmit) {
                    this.submitIds.add(vid);
                }
                long masterid = row.getLong("masterid");
                Tuple2<Long, Boolean> accInfo = this.getAcctInfo(accMap, masterid);
                this.addBalLog(-1, row, (Long)accInfo.t1, voucherAction, context);
                if (voucherId == 0L || vid != voucherId) {
                    vEntryDeducts = CashFlowSumHelper.tranVchDataSetToMap((DataSet)deductInfos.get(vid));
                    voucherId = vid;
                }
                if (!CashFlowItemHelper.permitDesignCashflow((long)row.getLong("book"), (long)row.getLong("period"))) continue;
                cal.addCashflowLog(-1, this.cashFlowLogList, row, (Long)accInfo.t1, voucherAction, context, vEntryDeducts);
            }
            cal.handleLogList(this.cashFlowLogList, cal, -1, voucherAction);
            ThreadCache.put((Object)ACC_MAP, accMap);
            this.putToThreadCache();
        }
    }

    private Map<Long, DataSet> getDesignInfos() {
        HashSet<Long> voucherIds = new HashSet<Long>(16);
        HashSet<Long> orgIds = new HashSet<Long>(16);
        HashSet<Long> periodIds = new HashSet<Long>(16);
        for (Map.Entry<Long, DynamicObject> entry : this.vchs.entrySet()) {
            voucherIds.add(entry.getKey());
            DynamicObject voucher = entry.getValue();
            orgIds.add(voucher.getLong("org.id"));
            periodIds.add(voucher.getLong("period.id"));
        }
        return CashFlowSumHelper.batchQueryDesignInfos(voucherIds, orgIds, periodIds);
    }

    protected Tuple2<Long, Boolean> getAcctInfo(Map<Long, Tuple2<Long, Boolean>> accMap, long masterId) {
        Tuple2 accInfo = accMap.get(masterId);
        if (accInfo == null) {
            DynamicObject account = BusinessDataServiceHelper.loadSingleFromCache((Object)masterId, (String)"bd_accountview", (String)"accounttable,accounttype");
            Long accounttable = account.getLong("accounttable_id");
            DynamicObject accounttype = account.getDynamicObject("accounttype");
            accInfo = new Tuple2((Object)accounttable, (Object)"4".equals(accounttype.getString("accounttype")));
            accMap.put(masterId, (Tuple2<Long, Boolean>)accInfo);
        }
        return accInfo;
    }

    protected boolean process(Row row) {
        return true;
    }

    protected List<QFilter> getDeductVchQFilter(Map<Long, DynamicObject> vchs) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
        filters.add(new QFilter("id", "in", vchs.keySet()));
        filters.add(new QFilter("billstatus", "in", (Object)new String[]{"B", "C"}));
        return filters;
    }

    public void addLog(String voucherAction) {
        Map<Long, Tuple2<Long, Boolean>> accMap = BalanceLogRecord.getAccMap();
        boolean isSubmit = "submit".equals(voucherAction);
        QFilter idFilter = new QFilter("id", "in", this.vchs.keySet());
        try (DataSet vouSet = ((IVoucherQueryService)GLServiceFactory.getService(IVoucherQueryService.class)).queryByIds(this.vchs.keySet(), null, BalanceLogRecord.getVoucherSelect(this.localCurList), null);){
            int size = ComAssistTable.getMaxCommonAssistKeys().size();
            Map<Object, Object> map = size > 0 ? BalanceLogRecord.collectComAssistData(vouSet.copy(), size) : new HashMap();
            ComassistContext context = new ComassistContext();
            context.init(map);
            CashflowLogCal cal = new CashflowLogCal();
            for (Row row : vouSet) {
                if (isSubmit) {
                    this.submitIds.remove(row.getLong("id"));
                }
                Tuple2<Long, Boolean> accInfo = this.getAcctInfo(accMap, row.getLong("masterid"));
                this.addBalLog(1, row, (Long)accInfo.t1, voucherAction, context);
                if (!CashFlowItemHelper.permitDesignCashflow((long)row.getLong("book"), (long)row.getLong("period"))) continue;
                cal.addCashflowLog(1, this.cashFlowLogList, row, (Long)accInfo.t1, voucherAction, context, null);
            }
            cal.handleLogList(this.cashFlowLogList, cal, 1, voucherAction);
        }
        this.putToThreadCache();
    }

    public void putToThreadCache() {
        ThreadCache.put((Object)VCH_BAL_DATA, (Object)this.balLogList);
        ThreadCache.put((Object)VCH_CASH_DATA, (Object)this.cashFlowLogList);
        ThreadCache.put((Object)VCH_SUBMITID, this.submitIds);
    }

    protected void addBalLog(int negate, Row row, long acctTableId, String voucherAction, ComassistContext context) {
        BalanceLogKey balKey = new BalanceLogKey(row, acctTableId, context.getComassistTable(acctTableId));
        BalanceLog balLog = new BalanceLog();
        balLog.setCount(1);
        balLog.setDebitFor(row.getBigDecimal("debitori"));
        balLog.setCreditFor(row.getBigDecimal("creditori"));
        balLog.setDebitLocal(row.getBigDecimal("debitlocal"));
        balLog.setCreditLocal(row.getBigDecimal("creditlocal"));
        if ("1".equals(row.getString("dc"))) {
            balLog.setDebitQty(row.getBigDecimal("quantity"));
        } else {
            balLog.setCreditQty(row.getBigDecimal("quantity"));
        }
        for (LocalCurrencyConfigVO localCur : this.localCurList) {
            Collection voucherFields = localCur.getVoucherFields(new MCT[]{MCT.DEBIT, MCT.CREDIT});
            for (MetaField field : voucherFields) {
                balLog.putMulLocalAmt(field, row.getBigDecimal(field.getMetaId()));
            }
        }
        balLog.setBizDate(row.getDate("bizdate"));
        if (negate == -1) {
            balLog.negate();
        }
        this.balLogList.add((Key)balKey, (Log)balLog);
        if (this.balLogList.size() > 20000) {
            BalanceLogRecord.storeBalanceLog(this.balLogList, voucherAction, this.localCurList);
            this.balLogList.clear();
        }
    }

    protected void addCashflowLog(int negate, Row row, long acctTableId, String voucherAction, ComassistContext context) {
        Long suppCFId;
        CashflowLog cashFlowLog;
        Long mainCFId = row.getLong("maincfitem");
        if (mainCFId > 0L) {
            CashflowLogKey cashFlowKey = new CashflowLogKey(row, row.getLong("mcfmasterid").longValue(), row.getLong("maincfassgrp").longValue(), context.getComassistTable(acctTableId));
            cashFlowLog = new CashflowLog();
            cashFlowLog.setAmount(row.getBigDecimal("maincfamount"));
            cashFlowLog.setCount(1);
            if (negate == -1) {
                cashFlowLog.negate();
            }
            this.cashFlowLogList.add((Key)cashFlowKey, (Log)cashFlowLog);
        }
        if ((suppCFId = row.getLong("suppcfitem")) > 0L) {
            cashFlowLog = new CashflowLog();
            cashFlowLog.setAmount(row.getBigDecimal("suppcfamount"));
            cashFlowLog.setCount(1);
            if (negate == -1) {
                cashFlowLog.negate();
            }
            this.cashFlowLogList.add((Key)new CashflowLogKey(row, row.getLong("scfmasterid").longValue(), 0L, context.getComassistTable(acctTableId)), (Log)cashFlowLog);
            if (this.cashFlowLogList.size() > 20000) {
                BalanceLogRecord.storeCashflowLog(this.cashFlowLogList, voucherAction);
                this.cashFlowLogList.clear();
            }
        }
    }

    protected void addProfitCashflowLog(Row row, int negate, BigDecimal profitAmt, Long acctTableId, ComassistContext context) {
        Long orgId = row.getLong("org");
        DynamicObject profitItem = BalanceLogRecord.getProfitItem(orgId);
        if (profitItem == null) {
            return;
        }
        long profitItemId = profitItem.getLong("masterid");
        CashflowLogKey cashFlowKey = new CashflowLogKey(row, profitItemId, 0L, context.getComassistTable(acctTableId.longValue()));
        CashflowLog cashFlowLog = new CashflowLog();
        cashFlowLog.setAmount(profitAmt);
        cashFlowLog.setCount(1);
        if (negate == -1) {
            cashFlowLog.negate();
        }
        this.cashFlowLogList.add((Key)cashFlowKey, (Log)cashFlowLog);
    }

    protected static DynamicObject getProfitItem(long orgId) {
        HashMap<Long, DynamicObject> profitMap = (HashMap<Long, DynamicObject>)ThreadCache.get((Object)VCH_CASH_PROFITITEM);
        if (null == profitMap) {
            profitMap = new HashMap<Long, DynamicObject>();
            DynamicObject profitItem = BalanceLogRecord.loadProfitItem(orgId);
            profitMap.put(orgId, profitItem);
            ThreadCache.put((Object)VCH_CASH_PROFITITEM, profitMap);
            return profitItem;
        }
        if (profitMap.containsKey(orgId)) {
            return (DynamicObject)profitMap.get(orgId);
        }
        DynamicObject profitItem = BalanceLogRecord.loadProfitItem(orgId);
        profitMap.put(orgId, profitItem);
        ThreadCache.put((Object)VCH_CASH_PROFITITEM, profitMap);
        return profitItem;
    }

    private static DynamicObject loadProfitItem(long orgId) {
        QFilter fid = BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)orgId);
        DynamicObject profitItem = BusinessDataServiceHelper.loadSingleFromCache((String)"gl_cashflowitem", (QFilter[])new QFilter[]{new QFilter("isprefit", "=", (Object)"1"), fid});
        return profitItem;
    }

    public static void storeLog(String voucherAction, List<LocalCurrencyConfigVO> localCurList) {
        LogList balLogList = (LogList)ThreadCache.get((Object)VCH_BAL_DATA);
        BalanceLogRecord.storeBalanceLog(balLogList, voucherAction, localCurList);
        LogList cashFlowLogList = (LogList)ThreadCache.get((Object)VCH_CASH_DATA);
        CashflowLogCal cal = new CashflowLogCal();
        cal.storeCashflowLog(cashFlowLogList, voucherAction);
        ThreadCache.remove((Object)VCH_BAL_DATA);
        ThreadCache.remove((Object)VCH_CASH_DATA);
        ThreadCache.remove((Object)ThreadCacheKey.buildAccAccountKey());
        ThreadCache.remove((Object)ThreadCacheKey.buildBizDateChangeKey());
        ThreadCache.remove((Object)ThreadCacheKey.buildAcctAssgrpToAccAssgrpKey());
    }

    protected static void storeBalanceLog(LogList balLogList, String voucherAction, List<LocalCurrencyConfigVO> localCurList) {
        if (balLogList != null && !balLogList.isEmpty()) {
            List<Object[]> newBalParams;
            Set curAccountSet;
            if (BillParamService.isEnableRealTimeWriteOff() && Objects.nonNull(curAccountSet = (Set)ThreadCache.get((Object)ThreadCacheKey.buildAccAccountKey())) && curAccountSet.size() > 0) {
                BalanceLogRecord.balLogAttributeComplement(balLogList, curAccountSet);
            }
            if (!(newBalParams = BalanceLogRecord.getInsertBalParams(balLogList, voucherAction, localCurList)).isEmpty()) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)BalanceLogRecord.getInsertBalLogSql(localCurList), newBalParams);
            }
        }
    }

    protected static void balLogAttributeComplement(LogList balLogList, Set<Long> curAccountSet) {
        Map balMap = balLogList.getData();
        int logSize = balMap.size();
        HashMap<Pair, List> logMap = new HashMap<Pair, List>(logSize);
        Map assgrpMap = ReciprocalUtils.getAssgrpMap();
        for (Map.Entry entry : balMap.entrySet()) {
            BalanceLog balLog = (BalanceLog)entry.getValue();
            BalanceLogKey balKey = (BalanceLogKey)entry.getKey();
            if (!curAccountSet.contains(balKey.getAccountId())) {
                balLog.setAcccalculated("1");
                continue;
            }
            Pair acctToAssgrp = Pair.of((Object)balKey.getAccountId(), (Object)balKey.getAssgrpId());
            Long assgrpId = (Long)assgrpMap.get(acctToAssgrp);
            if (Objects.nonNull(assgrpId)) {
                balLog.setAcccalculated("0");
                balLog.setAccassgrp(assgrpId);
                continue;
            }
            logMap.computeIfAbsent(acctToAssgrp, x -> new ArrayList(8)).add(balLog);
        }
        int size = logMap.size();
        if (size > 0) {
            HashSet<Object> acctIds = new HashSet<Object>(size);
            ArrayList<Pair> acctToAssgrpIdPair = new ArrayList<Pair>(size);
            for (Pair acctToAssgrp : logMap.keySet()) {
                acctIds.add(acctToAssgrp.getLeft());
                acctToAssgrpIdPair.add(acctToAssgrp);
            }
            Map acctIdToFlexFields = ReciprocalUtils.acctIdToFlexFields(acctIds);
            Map entireDataMap = UnAcccurrentUpdateUtil.buildCurrentAssgrp(acctToAssgrpIdPair, (Map)acctIdToFlexFields);
            Map assgrpValueMap = FlexUtils.batchSaveFlexData(entireDataMap.values(), (boolean)false);
            for (Map.Entry entry : entireDataMap.entrySet()) {
                List logs;
                Long assgrpId = (Long)assgrpValueMap.get(entry.getValue());
                if (!Objects.nonNull(assgrpId) || assgrpId <= 0L || !Objects.nonNull(logs = (List)logMap.get(entry.getKey()))) continue;
                for (BalanceLog balanceLog : logs) {
                    balanceLog.setAcccalculated("0");
                    balanceLog.setAccassgrp(assgrpId);
                }
            }
        }
    }

    protected static void storeCashflowLog(LogList cashFlowLogList, String voucherAction) {
        List<Object[]> newCashParams;
        if (cashFlowLogList != null && !cashFlowLogList.isEmpty() && !(newCashParams = BalanceLogRecord.getInsertCashflowParams(cashFlowLogList, voucherAction)).isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)BalanceLogRecord.getInsertCashLogSql(), newCashParams);
        }
    }

    private static String getInsertBalLogSql(List<LocalCurrencyConfigVO> localCurList) {
        int comassiSize = ComAssistTable.getMaxCommonAssistKeys().size();
        int mulLocalSize = localCurList.size() * 2;
        return String.format(insertBalLogSql, BalanceLogRecord.dynComassistField(comassiSize), BalanceLogRecord.dynMulLocalField(localCurList), BalanceLogRecord.dynParam(comassiSize + mulLocalSize));
    }

    private static String dynMulLocalField(List<LocalCurrencyConfigVO> localCurList) {
        StringBuilder sb = new StringBuilder();
        localCurList.forEach(x -> {
            MetaField debit = x.getBalanceLogField(MCT.DEBIT);
            MetaField credit = x.getBalanceLogField(MCT.CREDIT);
            sb.append(",").append(debit.getDbId()).append(",").append(credit.getDbId());
        });
        return sb.toString();
    }

    private static String getInsertCashLogSql() {
        int size = ComAssistTable.getMaxCommonAssistKeys().size();
        return insertCashLogSql.replace("#", BalanceLogRecord.dynComassistField(size)).replace("@", BalanceLogRecord.dynParam(size));
    }

    private static String dynComassistField(int size) {
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i <= size; ++i) {
            sb.append("fcomassist").append(i).append("id,");
        }
        return sb.toString();
    }

    private static String dynParam(int size) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            sb.append(",?");
        }
        return sb.toString();
    }

    private static List<Object[]> getInsertBalParams(LogList logList, String operate, List<LocalCurrencyConfigVO> localCurList) {
        ArrayList<Object[]> result = new ArrayList<Object[]>(logList.getData().size());
        Map balMap = logList.getData();
        HashSet<BookKey> bookSet = (HashSet<BookKey>)ThreadCache.get((Object)VCH_BAL_LOG_BOOK);
        if (bookSet == null) {
            bookSet = new HashSet<BookKey>(1);
            ThreadCache.put((Object)VCH_BAL_LOG_BOOK, bookSet);
        }
        Set bizDateChangeVchIds = (Set)ThreadCache.get((Object)ThreadCacheKey.buildBizDateChangeKey());
        long[] balLogIds = DB.genLongIds((String)"t_gl_balance_log", (int)balMap.size());
        int balLogIdIndex = 0;
        for (Map.Entry entry : balMap.entrySet()) {
            BalanceLog balLog = (BalanceLog)entry.getValue();
            BalanceLogKey balKey = (BalanceLogKey)entry.getKey();
            bookSet.add(new BookKey(balKey));
            Long[] groupKey = balKey.getKeyValues();
            if (balLog.isZero() && Objects.nonNull(bizDateChangeVchIds) && !bizDateChangeVchIds.contains(groupKey[0])) continue;
            int size = 11 + groupKey.length;
            ArrayList<Object> params = new ArrayList<Object>(size);
            long id = balLogIds[balLogIdIndex++];
            params.add(id);
            params.add(new Date());
            for (int i = 0; i < groupKey.length; ++i) {
                params.add(groupKey[i]);
            }
            params.add(balLog.getDebitFor());
            params.add(balLog.getCreditFor());
            params.add(balLog.getDebitLocal());
            params.add(balLog.getCreditLocal());
            params.add(balLog.getDebitQty());
            params.add(balLog.getCreditQty());
            params.add(balLog.getCount());
            params.add(operate);
            params.add(false);
            params.add(balLog.getAccassgrp());
            params.add(balLog.getBizDate());
            params.add(balLog.getAcccalculated());
            for (LocalCurrencyConfigVO localCur : localCurList) {
                MetaField debit = localCur.getVoucherField(MCT.DEBIT);
                MetaField credit = localCur.getVoucherField(MCT.CREDIT);
                params.add(balLog.getMulLocalAmt(debit));
                params.add(balLog.getMulLocalAmt(credit));
            }
            result.add(params.toArray());
        }
        return result;
    }

    private static List<Object[]> getInsertCashflowParams(LogList logList, String operate) {
        Map balMap = logList.getData();
        HashSet<BookKey> bookSet = (HashSet<BookKey>)ThreadCache.get((Object)VCH_CASH_LOG_BOOK);
        if (bookSet == null) {
            bookSet = new HashSet<BookKey>(1);
            ThreadCache.put((Object)VCH_CASH_LOG_BOOK, bookSet);
        }
        ArrayList<Object[]> result = new ArrayList<Object[]>(balMap.size());
        long[] balLogIds = DB.genLongIds((String)"t_gl_cashflow_log", (int)balMap.size());
        int balLogIdIndex = 0;
        for (Map.Entry entry : balMap.entrySet()) {
            CashflowLog cashLog = (CashflowLog)entry.getValue();
            if (cashLog.isZero()) continue;
            bookSet.add(new BookKey((CashflowLogKey)entry.getKey()));
            Long[] groupKey = ((Key)entry.getKey()).getKeyValues();
            int size = 11 + groupKey.length;
            ArrayList<Object> params = new ArrayList<Object>(size);
            long id = balLogIds[balLogIdIndex++];
            params.add(id);
            params.add(new Date());
            for (int i = 0; i < groupKey.length; ++i) {
                params.add(groupKey[i]);
            }
            params.add(cashLog.getAmount());
            params.add(cashLog.getCount());
            params.add(operate);
            params.add(false);
            result.add(params.toArray());
        }
        return result;
    }

    protected static Map<Long, Tuple2<Long, Boolean>> getAccMap() {
        return (Map)ThreadCache.get((Object)ACC_MAP, () -> {
            HashMap<Long, Tuple2> result = new HashMap<Long, Tuple2>(100);
            QFilter filter = new QFilter("id", "=", (Object)"masterid", true);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.gl.voucher.util.BalanceUpdateUtil.getAccMap", (String)"bd_accountview", (String)"id,accounttable,accounttype.accounttype accttype", (QFilter[])filter.toArray(), null, (int)10000);){
                for (Row row : dataSet) {
                    Long id = row.getLong("id");
                    Long accounttable = row.getLong("accounttable");
                    String accounttype = row.getString("accttype");
                    result.put(id, new Tuple2((Object)accounttable, (Object)"4".equals(accounttype)));
                }
            }
            return result;
        });
    }

    protected static Map<Long, Map<Integer, Set<Long>>> collectComAssistData(DataSet dataSet, int size) {
        HashMap<Long, Map<Integer, Set<Long>>> map = new HashMap<Long, Map<Integer, Set<Long>>>();
        for (Row row : dataSet) {
            long accttable = row.getLong("accounttable");
            Map setMap = map.computeIfAbsent(accttable, x -> new HashMap());
            for (int i = 1; i <= size; ++i) {
                Set ids = setMap.computeIfAbsent(i, x -> new HashSet());
                ids.add(row.getLong("comassist" + i));
            }
        }
        return map;
    }

    protected static String getVoucherSelect(List<LocalCurrencyConfigVO> localCurList) {
        int size = ComAssistTable.getMaxCommonAssistKeys().size();
        StringBuilder sb = new StringBuilder(VOUCHER_SELECT);
        if (size > 0) {
            for (int i = 1; i <= size; ++i) {
                sb.append(BalanceLogRecord.getComSelField(i));
            }
        }
        for (LocalCurrencyConfigVO cur : localCurList) {
            Collection voucherFields = cur.getVoucherFields(new MCT[]{MCT.DEBIT, MCT.CREDIT});
            voucherFields.forEach(x -> sb.append(",entries.").append(x.getMetaId()).append(" ").append(x.getMetaId()));
        }
        return sb.toString();
    }

    private static String getComSelField(int i) {
        return String.format(",entries.comassist%1$s comassist%1$s", i);
    }
}

