/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.bd.business.service.LocalCurrencyConfigService;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import kd.fi.gl.balcal.CalculatorCFs;
import kd.fi.gl.voucher.util.BalanceLogRecord;
import kd.fi.gl.voucher.util.BigEntryBalanceLogRecord;
import kd.fi.gl.voucher.util.BookKey;
import kd.fi.gl.voucher.util.VoucherUtils;
import org.apache.commons.collections4.list.UnmodifiableList;

public class BalanceUpdateUtil {
    public static final String ACC_MAP = "BalanceUpdateUtil_acc_map";
    private static final String VCH_BAL_LOG_BOOK = "vch_bal_log_book";
    public static final String VCH_CASH_LOG_BOOK = "vch_cash_log_book";
    private static final Log logger = LogFactory.getLog((String)"kd.fi.gl.voucher.util.BalanceUpdateUtil");
    public static final String VCH_SUBMITID = "vch_submit_ids";
    private static final int BIG_ENTRY_SIZE = 5000;
    private static final String T_GL_VOUCHERENTRY = "t_gl_voucherentry";

    public static void setDeductLog(DynamicObject[] vchs, String voucherAction) {
        HashMap<Long, DynamicObject> bigEntryMap = new HashMap<Long, DynamicObject>(vchs.length);
        HashMap<Long, DynamicObject> vchMap = new HashMap<Long, DynamicObject>(vchs.length);
        Map statusMap = (Map)ThreadCache.get((Object)"voucherInfoMap");
        if (CollectionUtils.isEmpty((Map)statusMap)) {
            statusMap = VoucherUtils.getVoucherStatus((DynamicObject[])vchs);
        }
        boolean isSubmitOp = "submit".equals(voucherAction);
        for (DynamicObject obj : vchs) {
            boolean bigEntry;
            boolean isSubmitAndNoEntry;
            boolean isFromDB = obj.getDataEntityState().getFromDatabase();
            boolean submitted = "B".equals(statusMap.get(obj.getPkValue()) != null ? ((Map)statusMap.get(obj.getPkValue())).get("billstatus") : null);
            boolean bl = isSubmitAndNoEntry = isSubmitOp && submitted && !obj.getDataEntityType().getProperties().containsKey((Object)"entries");
            if (!isFromDB || isSubmitAndNoEntry) continue;
            boolean bl2 = bigEntry = !obj.getDataEntityState().getPkSnapshotSet().Snapshots.stream().filter(x -> T_GL_VOUCHERENTRY.equalsIgnoreCase(x.TableName) && x.Oids.length >= 5000).collect(Collectors.toList()).isEmpty();
            if (isSubmitOp && submitted && bigEntry && obj.getString("period.id").equals(String.valueOf(((Map)statusMap.get(obj.getPkValue())).get("period")))) {
                bigEntryMap.put(obj.getLong("id"), obj);
                continue;
            }
            vchMap.put(obj.getLong("id"), obj);
        }
        if (!vchMap.isEmpty()) {
            BalanceLogRecord record = new BalanceLogRecord(vchMap);
            record.deductLog(voucherAction);
        }
        if (!bigEntryMap.isEmpty()) {
            BigEntryBalanceLogRecord bigEntryRecord = new BigEntryBalanceLogRecord(bigEntryMap);
            bigEntryRecord.deductLog(voucherAction);
        }
    }

    public static void setAddLog(DynamicObject[] vchs, String voucherAction) {
        HashMap<Long, DynamicObject> bigEntryMap = new HashMap<Long, DynamicObject>(vchs.length);
        HashMap<Long, DynamicObject> vchMap = new HashMap<Long, DynamicObject>(vchs.length);
        Map statusMap = (Map)ThreadCache.get((Object)"voucherInfoMap");
        if (CollectionUtils.isEmpty((Map)statusMap)) {
            statusMap = VoucherUtils.getVoucherStatus((DynamicObject[])vchs);
        }
        boolean isSubmitOp = "submit".equals(voucherAction);
        for (DynamicObject obj : vchs) {
            boolean bigEntry;
            boolean submitted = "B".equals(statusMap.get(obj.getPkValue()) != null ? ((Map)statusMap.get(obj.getPkValue())).get("billstatus") : null);
            if (isSubmitOp && submitted && !obj.getDataEntityType().getProperties().containsKey((Object)"entries")) continue;
            boolean bl = bigEntry = obj.getDataEntityState().getFromDatabase() && !obj.getDataEntityState().getPkSnapshotSet().Snapshots.stream().filter(x -> T_GL_VOUCHERENTRY.equalsIgnoreCase(x.TableName) && x.Oids.length >= 5000).collect(Collectors.toList()).isEmpty();
            if (isSubmitOp && submitted && bigEntry && obj.getString("period.id").equals(String.valueOf(((Map)statusMap.get(obj.getPkValue())).get("period")))) {
                bigEntryMap.put(obj.getLong("id"), obj);
                continue;
            }
            vchMap.put(obj.getLong("id"), obj);
        }
        if (!vchMap.isEmpty()) {
            BalanceLogRecord record = new BalanceLogRecord(vchMap);
            record.addLog(voucherAction);
        }
        if (!bigEntryMap.isEmpty()) {
            BigEntryBalanceLogRecord bigEntryRecord = new BigEntryBalanceLogRecord(bigEntryMap);
            bigEntryRecord.addLog(voucherAction);
        }
    }

    public static void updateBalance() {
        Set cashBookKeys;
        Set balBookKeys = (Set)ThreadCache.get((Object)VCH_BAL_LOG_BOOK);
        logger.info("###calculate balBookKeys:" + (balBookKeys == null ? null : balBookKeys.toString()));
        if (balBookKeys != null) {
            for (BookKey book : balBookKeys) {
                CalculatorCFs.calculator((long)book.getOrgId(), (long)book.getBookTypeId(), null, (String)"gl_balance_log", (boolean)false);
            }
        }
        if ((cashBookKeys = (Set)ThreadCache.get((Object)VCH_CASH_LOG_BOOK)) != null) {
            for (BookKey book : cashBookKeys) {
                CalculatorCFs.calculator((long)book.getOrgId(), (long)book.getBookTypeId(), null, (String)"gl_cashflow_log", (boolean)false);
            }
        }
    }

    public static void storeLog(String voucherAction) {
        UnmodifiableList localCurList = LocalCurrencyConfigService.queryEnableCurrencies();
        BalanceLogRecord.storeLog(voucherAction, (List<LocalCurrencyConfigVO>)localCurList);
    }
}

