/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.util;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Row;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import kd.fi.bd.business.vo.MetaField;
import kd.fi.bd.consts.MCT;
import kd.fi.gl.balcal.BalanceLog;
import kd.fi.gl.balcal.BalanceLogKey;
import kd.fi.gl.balcal.CashflowLog;
import kd.fi.gl.balcal.CashflowLogKey;
import kd.fi.gl.balcal.Key;
import kd.fi.gl.balcal.Log;
import kd.fi.gl.balcal.LogList;
import kd.fi.gl.comassist.ComassistContext;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.util.CashFlowItemHelper;
import kd.fi.gl.voucher.util.BalanceLogRecord;

public class BigEntryBalanceLogRecord
extends BalanceLogRecord {
    private Set<Object> entryIds = new HashSet<Object>(100);

    public BigEntryBalanceLogRecord(Map<Long, DynamicObject> dataEntity) {
        super(dataEntity);
        this.initSnapshotIds();
    }

    public final void initSnapshotIds() {
        this.vchs.values().stream().forEach(x -> {
            List<Object[]> objects = x.getDataEntityState().getPkSnapshotSet().Snapshots.stream().filter(y -> y.TableName.equalsIgnoreCase("T_GL_VOUCHERENTRY") && y.Oids != null).map(t -> t.Oids).collect(Collectors.toList());
            objects.forEach(obj -> this.entryIds.addAll(Arrays.asList(obj)));
        });
    }

    @Override
    protected boolean process(Row row) {
        return this.entryIds.contains(row.getLong("entries.id"));
    }

    @Override
    public void addLog(String voucherAction) {
        Map<Long, Tuple2<Long, Boolean>> accMap = BigEntryBalanceLogRecord.getAccMap();
        boolean isSubmit = "submit".equals(voucherAction);
        int size = ComAssistTable.getMaxCommonAssistKeys().size();
        Map<Object, Object> map = size > 0 ? this.collectComAssistData(size) : new HashMap();
        ComassistContext context = new ComassistContext();
        context.init(map);
        for (DynamicObject obj : this.vchs.values()) {
            if (isSubmit) {
                this.submitIds.remove(obj.getLong("id"));
            }
            DynamicObjectCollection collection = obj.getDynamicObjectCollection("entries");
            for (DynamicObject entry : collection) {
                Tuple2<Long, Boolean> accInfo = this.getAcctInfo(accMap, entry.getLong("account.masterid"));
                this.addBalLog(1, this.balLogList, obj, entry, (Long)accInfo.t1, voucherAction, context);
                BigEntryBalanceLogRecord.addCashflowLog(1, this.cashFlowLogList, obj, entry, (Long)accInfo.t1, voucherAction, context);
                boolean isProfitVch = "1".equals(obj.getString("sourcetype"));
                if (isProfitVch || !Boolean.TRUE.equals(accInfo.t2) || !CashFlowItemHelper.permitDesignCashflow((long)obj.getLong(GLField.id_((String)"book")), (long)obj.getLong(GLField.id_((String)"period")))) continue;
                BigDecimal profitAmt = entry.getBigDecimal("creditlocal").subtract(entry.getBigDecimal("debitlocal"));
                BigEntryBalanceLogRecord.addProfitCashflowLog(obj, entry, this.cashFlowLogList, 1, profitAmt, (Long)accInfo.t1, context);
            }
        }
        this.putToThreadCache();
    }

    protected Map<Long, Map<Integer, Set<Long>>> collectComAssistData(int size) {
        HashMap<Long, Map<Integer, Set<Long>>> map = new HashMap<Long, Map<Integer, Set<Long>>>();
        for (DynamicObject obj : this.vchs.values()) {
            long accttable = ((DynamicObject)obj.getDynamicObjectCollection("entries").get(0)).getDynamicObject("account").getLong(GLField.id_((String)"accounttable"));
            Map setMap = map.computeIfAbsent(accttable, x -> new HashMap());
            for (int i = 1; i <= size; ++i) {
                for (DynamicObject entry : obj.getDynamicObjectCollection("entries")) {
                    Set ids = setMap.computeIfAbsent(i, x -> new HashSet());
                    ids.add(entry.getLong(GLField.id_((String)("comassist" + i))));
                }
            }
        }
        return map;
    }

    protected static void addCashflowLog(int negate, LogList cashFlowLogList, DynamicObject vch, DynamicObject entry, long acctTableId, String voucherAction, ComassistContext context) {
        Long suppCFId;
        CashflowLog cashFlowLog;
        Long mainCFId = entry.getLong(GLField.id_((String)"maincfitem"));
        if (mainCFId > 0L) {
            CashflowLogKey cashFlowKey = new CashflowLogKey(vch, entry, entry.getLong("maincfitem.masterid"), entry.getLong(GLField.id_((String)"maincfassgrp")), context.getComassistTable(acctTableId));
            cashFlowLog = new CashflowLog();
            cashFlowLog.setAmount(entry.getBigDecimal("maincfamount"));
            cashFlowLog.setCount(1);
            if (negate == -1) {
                cashFlowLog.negate();
            }
            cashFlowLogList.add((Key)cashFlowKey, (Log)cashFlowLog);
        }
        if ((suppCFId = Long.valueOf(entry.getLong(GLField.id_((String)"suppcfitem")))) > 0L) {
            cashFlowLog = new CashflowLog();
            cashFlowLog.setAmount(entry.getBigDecimal("suppcfamount"));
            cashFlowLog.setCount(1);
            if (negate == -1) {
                cashFlowLog.negate();
            }
            cashFlowLogList.add((Key)new CashflowLogKey(vch, entry, entry.getLong("suppcfitem.masterid"), 0L, context.getComassistTable(acctTableId)), (Log)cashFlowLog);
            if (cashFlowLogList.size() > 20000) {
                BigEntryBalanceLogRecord.storeCashflowLog(cashFlowLogList, voucherAction);
                cashFlowLogList.clear();
            }
        }
    }

    protected static void addProfitCashflowLog(DynamicObject vch, DynamicObject entry, LogList cashFlowLogList, int negate, BigDecimal profitAmt, Long acctTableId, ComassistContext context) {
        Long orgId = vch.getLong(GLField.id_((String)"org"));
        DynamicObject profitItem = BigEntryBalanceLogRecord.getProfitItem(orgId);
        if (profitItem == null) {
            return;
        }
        long profitItemId = profitItem.getLong("masterid");
        CashflowLogKey cashFlowKey = new CashflowLogKey(vch, entry, profitItemId, 0L, context.getComassistTable(acctTableId.longValue()));
        CashflowLog cashFlowLog = new CashflowLog();
        cashFlowLog.setAmount(profitAmt);
        cashFlowLog.setCount(1);
        if (negate == -1) {
            cashFlowLog.negate();
        }
        cashFlowLogList.add((Key)cashFlowKey, (Log)cashFlowLog);
    }

    protected void addBalLog(int negate, LogList balLogList, DynamicObject v, DynamicObject ve, long acctTableId, String voucherAction, ComassistContext context) {
        BalanceLogKey balKey = new BalanceLogKey(v, ve, context.getComassistTable(acctTableId));
        BalanceLog balLog = new BalanceLog();
        balLog.setCount(1);
        balLog.setDebitFor(ve.getBigDecimal("debitori"));
        balLog.setCreditFor(ve.getBigDecimal("creditori"));
        balLog.setDebitLocal(ve.getBigDecimal("debitlocal"));
        balLog.setCreditLocal(ve.getBigDecimal("creditlocal"));
        if ("1".equals(ve.getString("entrydc"))) {
            balLog.setDebitQty(ve.getBigDecimal("quantity"));
        } else {
            balLog.setCreditQty(ve.getBigDecimal("quantity"));
        }
        if (negate == -1) {
            balLog.negate();
        }
        for (LocalCurrencyConfigVO localCur : this.localCurList) {
            Collection voucherFields = localCur.getVoucherFields(new MCT[]{MCT.DEBIT, MCT.CREDIT});
            for (MetaField field : voucherFields) {
                balLog.putMulLocalAmt(field, ve.getBigDecimal(field.getMetaId()));
            }
        }
        balLogList.add((Key)balKey, (Log)balLog);
        if (balLogList.size() > 20000) {
            BigEntryBalanceLogRecord.storeBalanceLog(balLogList, voucherAction, this.localCurList);
            balLogList.clear();
        }
    }
}

