/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.validate;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.StringUtils;
import kd.fi.bd.util.CashflowLocalSetUtil;
import kd.fi.gl.util.CashFlowItemHelper;
import kd.fi.gl.util.SystemParamHelper;
import kd.fi.gl.validate.AssGrpMustInputValidator;

public class CashFlowItemValidator
extends AbstractValidator {
    public static final Log logger = LogFactory.getLog(CashFlowItemValidator.class);
    private static final String CHECK_NO = "0";
    private static final String CHECK_MAIN = "1";
    private static final String CHECK_ALL = "2";

    public void validate() {
        DynamicObject voucher = this.dataEntities[0].getDataEntity();
        long voucherId = voucher.getLong("id");
        boolean hasSuppCf = false;
        BigDecimal suppCfAmount = BigDecimal.ZERO;
        for (DynamicObject entry : voucher.getDynamicObjectCollection("entries")) {
            DynamicObject mainCf = entry.getDynamicObject("maincfitem");
            DynamicObject suppCf = entry.getDynamicObject("suppcfitem");
            if (mainCf == null && BigDecimal.ZERO.compareTo(entry.getBigDecimal("maincfamount")) != 0) {
                this.addErrorMessage(this.dataEntities[0], ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\u672a\u5f55\u5165\u4e3b\u8868\u9879\u76ee\u4f46\u662f\u4e3b\u8868\u9879\u76ee\u91d1\u989d\u4e0d\u4e3a0\u3002", (String)"CashFlowItemValidator_7", (String)"fi-gl-opplugin", (Object[])new Object[]{entry.getInt("seq")}));
                return;
            }
            if (suppCf == null && BigDecimal.ZERO.compareTo(entry.getBigDecimal("suppcfamount")) != 0) {
                this.addErrorMessage(this.dataEntities[0], ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\u672a\u5f55\u5165\u9644\u8868\u9879\u76ee\u4f46\u662f\u9644\u8868\u9879\u76ee\u91d1\u989d\u4e0d\u4e3a0\u3002", (String)"CashFlowItemValidator_8", (String)"fi-gl-opplugin", (Object[])new Object[]{entry.getInt("seq")}));
                return;
            }
            if (suppCf != null) {
                hasSuppCf = true;
                suppCfAmount = suppCfAmount.add(entry.getBigDecimal("suppcfamount"));
            }
            if (mainCf == null || !mainCf.getBoolean("isassist")) continue;
            DynamicObjectCollection assistentries = mainCf.getDynamicObjectCollection("assistentry");
            for (DynamicObject assistentry : assistentries) {
                String idAndSeq;
                String errorMsg;
                if (!assistentry.getBoolean("isrequire") || StringUtils.isEmpty((Object)(errorMsg = AssGrpMustInputValidator.validateCFItem(idAndSeq = voucherId + "+" + entry.getInt("seq"), entry)))) continue;
                this.addErrorMessage(this.dataEntities[0], errorMsg);
                return;
            }
        }
        CashFlowItemHelper.calculateEntry((DynamicObject)voucher, (boolean)CashflowLocalSetUtil.isLocalSetThread((long)voucher.getLong("org_id"), (Date)voucher.getDate("bookeddate")));
        String mainStatus = voucher.getString("mainstatus");
        String plStatus = voucher.getString("suppstatus");
        if (CHECK_ALL.equals(mainStatus)) {
            this.addErrorMessage(this.dataEntities[0], ResManager.loadKDString((String)"\u4e3b\u8868\u9879\u76ee\u91d1\u989d\u6307\u5b9a\u4e0d\u5e73\u8861\u3002", (String)"CashFlowItemValidator_4", (String)"fi-gl-opplugin", (Object[])new Object[0]));
            return;
        }
        if (CHECK_ALL.equals(plStatus)) {
            this.addErrorMessage(this.dataEntities[0], ResManager.loadKDString((String)"\u8865\u5145\u8d44\u6599\u91d1\u989d\u6307\u5b9a\u4e0d\u5e73\u8861\u3002", (String)"CashFlowItemValidator_5", (String)"fi-gl-opplugin", (Object[])new Object[0]));
            return;
        }
        if (CHECK_MAIN.equals(mainStatus) && (CHECK_ALL.equals(plStatus) || "3".equals(plStatus))) {
            this.addErrorMessage(this.dataEntities[0], ResManager.loadKDString((String)"\u4e3b\u8868\u9879\u76ee\u672a\u6307\u5b9a\uff0c\u4e0d\u53ef\u4ee5\u6307\u5b9a\u8865\u5145\u8d44\u6599\u3002", (String)"CashFlowItemValidator_6", (String)"fi-gl-opplugin", (Object[])new Object[0]));
            return;
        }
        String checkmaincf = (String)SystemParamHelper.getObjectParam((String)"checkmaincf", (long)voucher.getLong("org.id"));
        if (CHECK_NO.equals(checkmaincf)) {
            return;
        }
        if (CHECK_MAIN.equals(checkmaincf) && (CHECK_MAIN.equals(mainStatus) || CHECK_ALL.equals(mainStatus))) {
            this.addErrorMessage(this.dataEntities[0], ResManager.loadKDString((String)"\u7cfb\u7edf\u53c2\u6570\u8bbe\u7f6e\u4e3a\u4e3b\u8868\u9879\u76ee\u5fc5\u5f55\uff0c\u4e3b\u8868\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CashFlowItemValidator_1", (String)"fi-gl-opplugin", (Object[])new Object[0]));
            return;
        }
        if (CHECK_ALL.equals(checkmaincf)) {
            if (CHECK_MAIN.equals(mainStatus) || CHECK_ALL.equals(mainStatus)) {
                this.addErrorMessage(this.dataEntities[0], ResManager.loadKDString((String)"\u7cfb\u7edf\u53c2\u6570\u8bbe\u7f6e\u4e3a\u4e3b\u9644\u8868\u9879\u76ee\u5fc5\u5f55\uff0c\u4e3b\u8868\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CashFlowItemValidator_2", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                return;
            }
            if (CHECK_MAIN.equals(plStatus) || CHECK_ALL.equals(plStatus)) {
                this.addErrorMessage(this.dataEntities[0], ResManager.loadKDString((String)"\u7cfb\u7edf\u53c2\u6570\u8bbe\u7f6e\u4e3a\u4e3b\u9644\u8868\u9879\u76ee\u5fc5\u5f55\uff0c\u9644\u8868\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CashFlowItemValidator_3", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                return;
            }
        }
    }
}

