/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.validate;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.gl.common.VoucherAgainst;
import kd.fi.gl.voucher.util.VoucherUtils;
import kd.fi.gl.voucher.validate.VoucherAntiCancelValidator;

public class ReverseVoucherAntiCancelValidator
extends VoucherAntiCancelValidator {
    @Override
    public void validate() {
        Map map = VoucherUtils.getStatusFromDB((ExtendedDataEntity[])this.dataEntities);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            boolean isReverse = dataEntity.getDataEntity().getBoolean("isreverse");
            if (!isReverse) continue;
            DynamicObject v = dataEntity.getDataEntity();
            if (v.getDataEntityState().getFromDatabase() && !map.containsKey(v.getLong("id"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u6761\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664\u3002", (String)"ReverseVoucherAntiCancelValidator_0", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                continue;
            }
            String status = map.get(v.getLong("id")) != null ? (String)map.get(v.getLong("id")) : v.getString("billstatus");
            this.validateHandle(dataEntity, status);
        }
    }

    @Override
    protected void validateHandle(ExtendedDataEntity voucher, String status) {
        super.validateHandle(voucher, status);
        this.checkReverse(voucher);
    }

    private void checkReverse(ExtendedDataEntity v) {
        long id = v.getDataEntity().getLong("sourcebill");
        DynamicObject srcV = BusinessDataServiceHelper.loadSingle((Object)id, (String)"gl_voucher");
        if (!"C".equals(srcV.getString("billstatus"))) {
            this.addErrorMessage(v, ResManager.loadKDString((String)"\u975e\u8bb0\u8d26\u51ed\u8bc1\u4e0d\u5141\u8bb8\u88ab\u51b2\u9500\u3002", (String)"ReverseVoucherAntiCancelValidator_1", (String)"fi-gl-opplugin", (Object[])new Object[0]));
            return;
        }
        String errormsg = VoucherAgainst.judgeBalance((DynamicObject)srcV);
        if (StringUtils.isNotBlank((CharSequence)VoucherAgainst.judgeBalance((DynamicObject)srcV))) {
            this.addErrorMessage(v, errormsg);
            return;
        }
    }
}

