/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.validate;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.TextAreaProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.bd.util.CashflowLocalSetUtil;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.util.PeriodUtil;
import kd.fi.gl.business.service.BatchReplacerFactory;
import kd.fi.gl.business.service.voucher.mc.MulLocalConfig;
import kd.fi.gl.business.service.voucher.option.helper.VoucherArgConfigServiceHelper;
import kd.fi.gl.business.service.voucher.option.key.ArgKey;
import kd.fi.gl.business.service.voucher.writeoff.WriteOffOptionService;
import kd.fi.gl.business.service.voucher.writeoff.WriteOffService;
import kd.fi.gl.business.vo.voucher.AmountField;
import kd.fi.gl.business.vo.voucher.BookedDate;
import kd.fi.gl.business.vo.voucher.IVoucherEntry;
import kd.fi.gl.business.vo.voucher.wrap.DynamicEntryWrap;
import kd.fi.gl.common.VoucherOpOption;
import kd.fi.gl.common.WriteOffBalance;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.enums.WriteOffTypeEnum;
import kd.fi.gl.formplugin.voucher.VoucherEditArgHelper;
import kd.fi.gl.util.CommonAssistUtil;
import kd.fi.gl.util.ContextUtil;
import kd.fi.gl.util.DateUtil;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.SystemParamHelper;
import kd.fi.gl.util.replace.CashFlowItemBatchReplacer;
import kd.fi.gl.voucher.carryover.utils.BalanceCarryOverUtils;
import kd.fi.gl.voucher.vo.VoucherEntryPK;
import kd.fi.gl.voucher.writeoff.WriteOffBalanceMap;

public class VoucherAgainstValidator
extends AbstractValidator {
    private final WriteOffTypeEnum writeOffType;
    private static final Log logger = LogFactory.getLog((String)"VoucherAgainstValidator");
    private static final String COVERYEARGAINST = "coveryeargainst";
    private DynamicObject glAppData;
    private Map<Long, BookedDate> bookedDateConfig;

    public VoucherAgainstValidator() {
        this(WriteOffTypeEnum.RED);
    }

    public VoucherAgainstValidator(WriteOffTypeEnum writeOffType) {
        this.writeOffType = writeOffType;
    }

    private DynamicObject getGlAppData() {
        if (this.glAppData == null) {
            BasedataProp sourcesysProp = (BasedataProp)this.getValidateContext().getBillEntityType().findProperty("sourcesys");
            this.glAppData = BusinessDataServiceHelper.loadSingleFromCache((Object)"83bfebc8000017ac", (DynamicObjectType)((DynamicObjectType)sourcesysProp.getComplexType()));
        }
        return this.glAppData;
    }

    public void initializeConfiguration() {
        super.initializeConfiguration();
        this.setOperationName((String)this.writeOffType.getOperationNameGetter().get());
    }

    public void validate() {
        DynamicObject oldDataEntity;
        long vchId;
        if (this.dataEntities.length == 1 && VoucherOpOption.isEditAction() && (vchId = (oldDataEntity = this.dataEntities[0].getDataEntity()).getLong("id")) > 0L) {
            DynamicObjectType dynamicObjectType = oldDataEntity.getDynamicObjectType();
            DynamicObject newDataEntity = BusinessDataServiceHelper.loadSingle((Object)vchId, (DynamicObjectType)dynamicObjectType);
            if (newDataEntity != null) {
                this.dataEntities[0].setDataEntity(newDataEntity);
            }
        }
        this.bookedDateConfig = WriteOffOptionService.getBookedDate((OperateOption)this.getOption());
        HashSet<Long> curPeriodIdIdSet = new HashSet<Long>(8);
        HashSet<Long> accounttableIdSet = new HashSet<Long>(8);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject vou = dataEntity.getDataEntity();
            DynamicObject bookDyn = vou.getDynamicObject("book");
            curPeriodIdIdSet.add(bookDyn.getLong("curperiod.id"));
            accounttableIdSet.add(bookDyn.getLong("accounttable.id"));
        }
        Map accountTypeMap = BusinessDataServiceHelper.loadFromCache((String)"bd_accounttype", (String)"id,accounttype", (QFilter[])new QFilter("accounttableid", "in", accounttableIdSet).toArray());
        Map curPeriodDynMap = BusinessDataServiceHelper.loadFromCache((Object[])curPeriodIdIdSet.toArray(new Long[0]), (String)"bd_period");
        boolean notRepeatAgainst = BillParamUtil.getBooleanValue((String)"83bfebc8000017ac", (String)"fi.gl.opplugin.voucher.repeatagainst", (boolean)false);
        List dataEntityList = Arrays.stream(this.dataEntities).collect(Collectors.toList());
        Lists.partition(dataEntityList, (int)999).forEach(batchEntities -> {
            ArrayList<DynamicObject> againstVou = new ArrayList<DynamicObject>(batchEntities.size());
            HashMap<Long, Object> tempMap = new HashMap<Long, Object>(batchEntities.size() * 2);
            HashSet<Long> bookIdSet = new HashSet<Long>(batchEntities.size());
            HashSet<Long> orgIdSet = new HashSet<Long>(batchEntities.size());
            HashSet<Long> voucherIds = new HashSet<Long>(8);
            for (ExtendedDataEntity dataEntity : batchEntities) {
                DynamicObject vou = dataEntity.getDataEntity();
                bookIdSet.add(vou.getLong("book.id"));
                orgIdSet.add(vou.getLong("org.id"));
                voucherIds.add(vou.getLong("id"));
            }
            Map<Long, Boolean> orgId2Param = this.getOrgId2ParamMap(orgIdSet);
            HashMap<Long, Integer> cuPeriodMap = new HashMap<Long, Integer>(bookIdSet.size());
            DynamicObjectCollection cuPeriodCollection = QueryServiceHelper.query((String)"gl_accountbook", (String)"id,curperiod.periodyear periodyear", (QFilter[])new QFilter("id", "in", bookIdSet).toArray());
            for (DynamicObject dyn : cuPeriodCollection) {
                cuPeriodMap.put(dyn.getLong("id"), dyn.getInt("periodyear"));
            }
            Map sourceVoucherBalances = WriteOffService.querySourceVoucherBalances((Collection)batchEntities.stream().map(ExtendedDataEntity::getBillPkId).filter(Objects::nonNull).map(x -> Long.parseLong(x.toString())).collect(Collectors.toSet()), null, (AmountField[])MulLocalConfig.getEnabledAmountFields());
            HashSet targVoucherIds = new HashSet(8);
            if (!notRepeatAgainst) {
                Map reverseRelationMap = BusinessDataServiceHelper.loadFromCache((String)"gl_reverserelation", (String)"targentity", (QFilter[])new QFilter[]{new QFilter("targentity", "in", voucherIds)});
                targVoucherIds.addAll(reverseRelationMap.values().stream().map(dynamicObject -> dynamicObject.getLong("targentity")).collect(Collectors.toSet()));
            }
            for (ExtendedDataEntity dataEntity : batchEntities) {
                String errorRows;
                DynamicObject vou = dataEntity.getDataEntity();
                Long id = vou.getLong("id");
                if (!vou.getBoolean("ispost")) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u8fc7\u8d26\u51ed\u8bc1\u624d\u80fd\u8fdb\u884c\u51b2\u9500\u3002", (String)"VoucherAgainstValidator_1", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]), ErrorLevel.Error);
                    continue;
                }
                if (!notRepeatAgainst && targVoucherIds.contains(id)) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6e90\u51ed\u8bc1\u662f\u51b2\u9500\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u51b2\u9500\u3002", (String)"VoucherAgainstValidator_9", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]), ErrorLevel.Error);
                    continue;
                }
                int vn = vou.getDynamicObject("period").getInt("periodyear");
                int bn = (Integer)cuPeriodMap.get(vou.getLong("book.id"));
                boolean hasProfit = false;
                if (vn != bn) {
                    DynamicObjectCollection entries = vou.getDynamicObjectCollection("entries");
                    for (DynamicObject entry : entries) {
                        long accounttypeid = entry.getDynamicObject("account").getDynamicObject("accounttype").getLong("id");
                        DynamicObject accounttype = (DynamicObject)accountTypeMap.get(accounttypeid);
                        if (accounttype == null || !"4".equals(accounttype.getString("accounttype"))) continue;
                        hasProfit = true;
                        break;
                    }
                }
                long orgId = vou.getLong("org.id");
                if (hasProfit && !orgId2Param.get(orgId).booleanValue()) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u635f\u76ca\u7c7b\u79d1\u76ee\u4e0d\u5141\u8bb8\u8de8\u5e74\u51b2\u9500\uff0c\u5efa\u8bae\u901a\u8fc7\u201c\u4ee5\u524d\u5e74\u5ea6\u635f\u76ca\u8c03\u6574\u201d\u79d1\u76ee\u505a\u8c03\u6574\u51ed\u8bc1\u3002", (String)"VoucherAgainstValidator_3", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]), ErrorLevel.Error);
                    continue;
                }
                long bookTypeId = vou.getLong("booktype.id");
                AmountField[] localAmountFields = MulLocalConfig.getEnabledLocalAmountFields((Long)orgId, (Long)bookTypeId);
                WriteOffBalanceMap writeOffBalanceMap = (WriteOffBalanceMap)sourceVoucherBalances.get(id);
                boolean canReverse = writeOffBalanceMap.values().stream().anyMatch(WriteOffBalance::hasRemaining);
                if (!canReverse) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u51ed\u8bc1\u672a\u51b2\u9500\u91d1\u989d\u4e3a\u96f6\u6216\u4e3a\u8d1f\uff0c\u4e0d\u53ef\u8fdb\u884c\u51b2\u9500\u3002", (String)"VoucherAgainstValidator_4", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]), ErrorLevel.Error);
                    continue;
                }
                if (WriteOffTypeEnum.BLUE == this.writeOffType && StringUtils.isNotBlank((CharSequence)(errorRows = writeOffBalanceMap.getEntrySeqValueMap().entrySet().stream().filter(x -> ((WriteOffBalance)x.getValue()).getLocalBalance().signum() == 0 && Arrays.stream(localAmountFields).allMatch(f -> ((WriteOffBalance)x.getValue()).getAmountBalance(f).isZero()) && (((WriteOffBalance)x.getValue()).hasRemainingOriginal() || ((WriteOffBalance)x.getValue()).hasRemainingQuantity())).map(x -> String.valueOf(x.getKey())).collect(Collectors.joining("\u3001"))))) {
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u53ea\u6709\u6570\u91cf\u6216\u539f\u5e01\u91d1\u989d\uff0c\u51ed\u8bc1\u53ea\u652f\u6301\u7ea2\u5b57\u51b2\u9500\u3002", (String)"VoucherAgainstValidator_8", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]), errorRows), ErrorLevel.Error);
                    continue;
                }
                if (BalanceCarryOverUtils.isCarryOverVoucher((DynamicObject)vou)) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u51b2\u9500\u5931\u8d25\uff0c\u4f59\u989d\u7ed3\u8f6c\u7684\u51ed\u8bc1\u4e0d\u80fd\u8fdb\u884c\u51b2\u9500\u64cd\u4f5c\u3002", (String)"VoucherAgainstValidator_7", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]), ErrorLevel.Error);
                    continue;
                }
                DynamicObject temp = this.createVoucher(dataEntity, vou, writeOffBalanceMap, curPeriodDynMap, localAmountFields);
                if (temp == null) continue;
                againstVou.add(temp);
                tempMap.put(vou.getLong("id"), dataEntity);
                tempMap.put(temp.getLong("id"), temp);
            }
            if (!againstVou.isEmpty()) {
                OperateOption op = OperateOption.create();
                op.setVariableValue("edit_action", "true");
                BusinessDataServiceHelper.loadRefence((Object[])againstVou.toArray(), (IDataEntityType)((DynamicObject)againstVou.get(0)).getDataEntityType());
                OperationResult result = SaveServiceHelper.saveOperate((String)"gl_voucher", (DynamicObject[])againstVou.toArray(new DynamicObject[0]), (OperateOption)op);
                ArrayList<DynamicObject> tempList = new ArrayList<DynamicObject>(againstVou.size());
                if (!result.isSuccess()) {
                    List succIds = result.getSuccessPkIds();
                    Map<Long, String> errInfo = this.getErrorResult(result);
                    for (DynamicObject v : againstVou) {
                        Long id = v.getLong("id");
                        if (!succIds.contains(id)) {
                            this.addMessage((ExtendedDataEntity)tempMap.get(v.getLong("sourcebill")), errInfo.get(id));
                            continue;
                        }
                        tempList.add(v);
                    }
                    this.saveReversRelation(tempList);
                } else {
                    this.saveReversRelation(againstVou);
                }
            }
        });
    }

    private Map<Long, Boolean> getOrgId2ParamMap(Set<Long> orgIdSet) {
        HashMap<Long, Boolean> orgId2Param = new HashMap<Long, Boolean>(orgIdSet.size());
        for (Long orgId : orgIdSet) {
            orgId2Param.put(orgId, SystemParamHelper.getBooleanParam((String)COVERYEARGAINST, (long)orgId, (boolean)false));
        }
        return orgId2Param;
    }

    private Map<Long, String> getErrorResult(OperationResult result) {
        HashMap<Long, String> map = new HashMap<Long, String>(16);
        List vR = result.getValidateResult().getValidateErrors();
        for (ValidateResult validateResult : vR) {
            List infos = validateResult.getAllErrorInfo();
            for (OperateErrorInfo info : infos) {
                map.put(Long.valueOf(info.getPkValue().toString()), info.getMessage());
                if (!DebugTrace.enable()) continue;
                logger.info("save fail: pkValue: " + info.getPkValue() + ",errorInfo:" + info.getMessage() + "---");
            }
        }
        return map;
    }

    private void saveReversRelation(List<DynamicObject> datas) {
        WriteOffService.insertRelations(datas);
    }

    private DynamicObject createVoucher(ExtendedDataEntity dataEntity, DynamicObject voucher, WriteOffBalanceMap writeOffBalanceMap, Map<Object, DynamicObject> curPeriodDynMap, AmountField[] localAmountFields) {
        boolean partialOffset = writeOffBalanceMap.values().stream().anyMatch(x -> !x.hasRemaining());
        DynamicObject vou = BusinessDataServiceHelper.newDynamicObject((String)"gl_voucher");
        if (partialOffset) {
            try {
                DynamicObjectType clone = (DynamicObjectType)vou.getDynamicObjectType().clone();
                vou = new DynamicObject(clone);
            }
            catch (CloneNotSupportedException e) {
                throw new KDBizException((Throwable)e, new ErrorCode("fi.gl.voucher.write_off_error", "Write off error: %s. "), new Object[]{e.getMessage()});
            }
        }
        String prefix = String.format("%1$s %2$s %3$s %4$s %5$s", ResManager.loadKDString((String)"\u51b2\u9500", (String)"VoucherAgainstValidator_5", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]), voucher.getLocaleString("period.name").getLocaleValue(), voucher.getLocaleString("vouchertype.name").getLocaleValue(), voucher.getString("billno"), ResManager.loadKDString((String)"\u53f7\u51ed\u8bc1", (String)"VoucherAgainstValidator_6", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
        vou.set("id", (Object)DB.genLongId((String)"t_gl_voucher"));
        vou.set("book", (Object)voucher.getDynamicObject("book"));
        vou.set("org", (Object)voucher.getDynamicObject("org"));
        vou.set("description", (Object)voucher.getString("description"));
        vou.set("vouchertype", (Object)voucher.getDynamicObject("vouchertype"));
        vou.set("billstatus", (Object)"A");
        vou.set("isreverse", (Object)true);
        vou.set("againsttype", (Object)this.writeOffType.getCode());
        BookedDate bookedDate = this.bookedDateConfig.get(voucher.getLong("id"));
        if (bookedDate != null) {
            vou.set("bizdate", (Object)bookedDate.getBizDate());
            vou.set("bookeddate", (Object)bookedDate.getBookedDate());
            vou.set("period_id", (Object)bookedDate.getPeriodId());
            vou.set("creator", (Object)voucher.getDynamicObject("creator"));
        } else {
            DynamicObject curperiod = voucher.getDynamicObject("book").getDynamicObject("curperiod");
            long curPeriodId = curperiod.getLong("id");
            curperiod = curPeriodDynMap.get(curPeriodId);
            long sourcePeriodId = voucher.getLong("period_id");
            if (sourcePeriodId <= curPeriodId) {
                long periodId;
                Date bookDate;
                boolean isUseSysTime = (Boolean)VoucherArgConfigServiceHelper.getArgValue((long)voucher.getLong("org.id"), (long)ContextUtil.getUserId(), (ArgKey)ArgKey.isusesystime);
                if (isUseSysTime) {
                    bookDate = DateUtil.makeDateOnDayStrart((Date)new Date());
                    DynamicObject periodByDate = PeriodUtil.getPeriodByDate((Date)bookDate, (long)curperiod.getDynamicObject("periodtype").getLong("id"));
                    if (periodByDate == null) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7cfb\u7edf\u65e5\u671f\u6240\u5bf9\u5e94\u7684\u4f1a\u8ba1\u671f\u95f4\uff0c\u8bf7\u5148\u7ef4\u62a4\u671f\u95f4\u57fa\u7840\u8d44\u6599\u3002", (String)"VoucherAgainstValidator_10", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
                        return null;
                    }
                    periodId = periodByDate.getLong("id");
                } else {
                    periodId = curPeriodId;
                    bookDate = sourcePeriodId == curPeriodId ? voucher.getDate("bookeddate") : curperiod.getDate("enddate");
                }
                vou.set("bookeddate", (Object)bookDate);
                vou.set(GLField.id_((String)"period"), (Object)periodId);
                BusinessDataReader.loadRefence((Object[])new DynamicObject[]{vou}, (IDataEntityType)vou.getDataEntityType());
            } else {
                vou.set("bookeddate", (Object)voucher.getDate("bookeddate"));
                DynamicObject period = voucher.getDynamicObject("period");
                vou.set("period", (Object)period);
                vou.set(GLField.id_((String)"period"), (Object)period.getLong("id"));
            }
            vou.set("bizdate", (Object)voucher.getDate("bizdate"));
            vou.set("creator_id", (Object)RequestContext.get().getCurrUserId());
        }
        EntryProp eprop = (EntryProp)voucher.getDynamicObjectType().getProperty("entries");
        TextAreaProp edescProp = (TextAreaProp)eprop.getDynamicCollectionItemPropertyType().getProperty("edescription");
        int length = edescProp.getMaxLenth();
        vou.set("vdescription", (Object)this.getNewDesc(prefix, voucher.getString("vdescription"), length));
        vou.set("booktype", (Object)voucher.getDynamicObject("booktype"));
        vou.set("mainstatus", (Object)voucher.getString("mainstatus"));
        vou.set("suppstatus", (Object)voucher.getString("suppstatus"));
        vou.set("sourcebill", (Object)voucher.getLong("id"));
        String handtype = this.getOption().getVariableValue("handtype", Boolean.TRUE.toString());
        if (Boolean.TRUE.toString().equals(handtype)) {
            vou.set("sourcetype", (Object)"0");
            vou.set("sourcesys", (Object)this.getGlAppData());
            vou.set("sourcebilltype_id", (Object)"gl_voucher");
        } else {
            vou.set("sourcetype", voucher.get("sourcetype"));
            vou.set("sourcesys", voucher.get("sourcesys"));
            vou.set("sourcebilltype", voucher.get("sourcebilltype"));
        }
        vou.set("createtime", (Object)new Date());
        for (AmountField amountField : localAmountFields) {
            String currencyIdProp = amountField.getCurrencyField().getField() + "_id";
            vou.set(currencyIdProp, (Object)voucher.getLong(currencyIdProp));
        }
        int seq = 1;
        DynamicObjectCollection entries = voucher.getDynamicObjectCollection("entries");
        DynamicObjectCollection writeOffEntries = vou.getDynamicObjectCollection("entries");
        writeOffEntries.clear();
        boolean isLocalSet = CashflowLocalSetUtil.isLocalSetThread((long)voucher.getLong("org.id"), (Date)voucher.getDate("bookeddate"));
        DynamicProperty sourceEntryProp = null;
        if (partialOffset) {
            sourceEntryProp = writeOffEntries.getDynamicObjectType().registerProperty("writeoffsourceentryid", Long.class, (Object)0L, false);
            sourceEntryProp.setDbIgnore(true);
        }
        long[] entryIds = DB.genLongIds((String)"t_gl_voucherentry", (int)entries.size());
        CashFlowItemBatchReplacer cashFlowItemBatchReplacer = BatchReplacerFactory.createCombinedBatchReplacer((long)vou.getLong("org.id"), (long)vou.getLong(GLField.id_((String)"period")), (boolean)false, (String)"maincfassgrp");
        for (DynamicObject entry : entries) {
            DynamicProperty propertyBuf;
            DynamicObject suppCfItem;
            VoucherEntryPK sourceEntryPK = new VoucherEntryPK(entry);
            WriteOffBalance rowBal = writeOffBalanceMap.get((Object)sourceEntryPK);
            if (!rowBal.hasRemaining()) continue;
            DynamicObject newEntry = writeOffEntries.addNew();
            newEntry.set("id", (Object)entryIds[seq - 1]);
            newEntry.set("seq", (Object)seq);
            if (sourceEntryProp != null) {
                sourceEntryProp.setValue((Object)newEntry, (Object)sourceEntryPK.getEntryId());
            }
            newEntry.set("edescription", (Object)this.getNewDesc(prefix, entry.getString("edescription"), length));
            newEntry.set("account", (Object)entry.getDynamicObject("account"));
            if (entry.getDate("expiredate") != null) {
                newEntry.set("expiredate", VoucherEditArgHelper.getExpireDateOption((DynamicObject)vou).getDateParser().apply(vou));
            }
            newEntry.set("assgrp", entry.get("assgrp"));
            newEntry.set("currency", (Object)entry.getDynamicObject("currency"));
            newEntry.set("localrate", entry.get("localrate"));
            newEntry.set("measureunit", (Object)entry.getDynamicObject("measureunit"));
            newEntry.set("price", (Object)entry.getBigDecimal("price"));
            newEntry.set("businessnum", (Object)entry.getString("businessnum"));
            for (AmountField amountField : localAmountFields) {
                newEntry.set(amountField.getExRateField(), (Object)entry.getBigDecimal(amountField.getExRateField()));
            }
            this.writeOffType.getEntryAmountSetter().setValue(rowBal, localAmountFields, newEntry);
            DynamicObject mainCfItem = entry.getDynamicObject("maincfitem");
            if (mainCfItem != null) {
                BigDecimal crSubDr = newEntry.getBigDecimal("creditlocal").subtract(newEntry.getBigDecimal("debitlocal"));
                newEntry.set("maincfitem", (Object)mainCfItem);
                newEntry.set("maincfassgrp", (Object)entry.getLong("maincfassgrp.id"));
                BigDecimal mainCfAmount = mainCfItem.getString("direction").equals("o") ? crSubDr.negate() : crSubDr;
                newEntry.set("maincfamount", (Object)(isLocalSet ? mainCfAmount.negate() : mainCfAmount));
            }
            if ((suppCfItem = entry.getDynamicObject("suppcfitem")) != null) {
                BigDecimal crSubDr = newEntry.getBigDecimal("creditlocal").subtract(newEntry.getBigDecimal("debitlocal"));
                if (mainCfItem != null && GLUtil.isPLAcct((DynamicObject)entry.getDynamicObject("account"))) {
                    crSubDr = newEntry.getBigDecimal("debitlocal").subtract(newEntry.getBigDecimal("creditlocal"));
                }
                newEntry.set("suppcfitem", (Object)suppCfItem);
                newEntry.set("suppcfamount", (Object)(isLocalSet ? crSubDr.negate() : crSubDr));
            }
            cashFlowItemBatchReplacer.addReplace((IVoucherEntry)new DynamicEntryWrap(newEntry));
            int index = 0;
            while ((propertyBuf = entry.getDynamicObjectType().getProperty(GLField.id_((String)CommonAssistUtil.getComassistField((int)(++index))))) != null) {
                newEntry.set(propertyBuf.getName(), propertyBuf.getValueFast((Object)entry));
            }
            ++seq;
        }
        cashFlowItemBatchReplacer.finish();
        return vou;
    }

    private String getNewDesc(String prefix, String desc, int maxLength) {
        if (StringUtils.isNotBlank((CharSequence)desc)) {
            prefix = prefix + "-" + desc;
        }
        if (-1 != maxLength && prefix.length() > maxLength) {
            prefix = prefix.substring(0, maxLength);
        }
        return prefix;
    }
}

