/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.validate;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bd.service.balance.BalanceQueryExecutor;
import kd.fi.bd.service.balance.QueryParam;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.SystemParamHelper;
import kd.fi.gl.vo.CurAccountBalance;
import kd.fi.gl.voucher.validate.AccountWrapper;
import kd.fi.gl.voucher.validate.VoucherSubmitQueryUtil;
import kd.fi.gl.voucher.validate.VoucherSubmitValidator;
import kd.fi.gl.voucher.validate.VoucherValidateMsgFormatter;

public class VoucherSubmitDeficitValidator
extends VoucherSubmitValidator {
    private List<ValidationErrorInfo> errorInfoList;
    private Map<String, CurAccountBalance> allCurAccountBalanceMap = new HashMap<String, CurAccountBalance>(16);

    public VoucherSubmitDeficitValidator(List<ValidationErrorInfo> errorInfos) {
        this.errorInfoList = errorInfos;
    }

    @Override
    public void validate() {
        Serializable orgId;
        HashSet errorDataIndexs = this.getValidateContext().getValidateResults().getErrorDataIndexs();
        LinkedHashMap<Long, LinkedHashMap<String, CurAccountBalance>> loadedVch = new LinkedHashMap<Long, LinkedHashMap<String, CurAccountBalance>>(16);
        HashMap<Long, ExtendedDataEntity> idAndIndex = new HashMap<Long, ExtendedDataEntity>(this.dataEntities.length);
        ArrayList<Long> ids = new ArrayList<Long>(this.dataEntities.length);
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject v;
            if (errorDataIndexs.contains(i) || !this.dataEntities[i].getDataEntity().getDataEntityState().getFromDatabase() || !this.doCashCheck((Long)(orgId = Long.valueOf((v = this.dataEntities[i].getDataEntity()).getLong("org_id")))) && !this.doCurrentCheck((Long)orgId)) continue;
            ids.add(v.getLong("id"));
            idAndIndex.put(v.getLong("id"), this.dataEntities[i]);
        }
        if (ids.size() > 0) {
            if (this.dataEntities[0].getDataEntity().getDynamicObjectType().getProperty("entries") != null) {
                this.voucherFormPage(errorDataIndexs);
            } else {
                QFilter[] filters = new QFilter[]{new QFilter("id", "in", ids)};
                DataSet ds = VoucherSubmitQueryUtil.query(ids, "id,entries.seq");
                orgId = null;
                try {
                    int index = 1;
                    for (Row row : ds) {
                        Long id = row.getLong("id");
                        ExtendedDataEntity entity = (ExtendedDataEntity)idAndIndex.get(id);
                        long acctId = row.getLong("entries.account");
                        AccountWrapper acct = (AccountWrapper)((Object)this.getAccCache().get(Long.valueOf(acctId)));
                        boolean isCash = false;
                        boolean isRec = false;
                        if (acct.isCash()) {
                            isCash = true;
                        }
                        if (acct.isAccheck()) {
                            isRec = true;
                        }
                        if (loadedVch.containsKey(id)) {
                            this.setAccountInfo(row.getLong("entries.assgrp"), row.getBigDecimal("entries.debitori"), row.getBigDecimal("entries.creditori"), acct.getNumber(), acct.getDc(), row.getLong("entries.currency"), entity, isCash, isRec, (Map)loadedVch.get(id), index);
                        } else {
                            index = 1;
                            LinkedHashMap<String, CurAccountBalance> curAccountBalanceMap = new LinkedHashMap<String, CurAccountBalance>(16);
                            this.setAccountInfo(row.getLong("entries.assgrp"), row.getBigDecimal("entries.debitori"), row.getBigDecimal("entries.creditori"), acct.getNumber(), acct.getDc(), row.getLong("entries.currency"), entity, isCash, isRec, curAccountBalanceMap, index);
                            loadedVch.put(id, curAccountBalanceMap);
                        }
                        ++index;
                    }
                }
                catch (Throwable index) {
                    orgId = index;
                    throw index;
                }
                finally {
                    if (ds != null) {
                        if (orgId != null) {
                            try {
                                ds.close();
                            }
                            catch (Throwable index) {
                                ((Throwable)orgId).addSuppressed(index);
                            }
                        } else {
                            ds.close();
                        }
                    }
                }
                for (Map.Entry entry : loadedVch.entrySet()) {
                    LinkedHashMap curAccountBalanceMap = (LinkedHashMap)entry.getValue();
                    if (!this.check(curAccountBalanceMap, false)) continue;
                    for (Map.Entry cabMap : curAccountBalanceMap.entrySet()) {
                        if (this.allCurAccountBalanceMap.containsKey(cabMap.getKey())) {
                            CurAccountBalance cab = this.allCurAccountBalanceMap.get(cabMap.getKey());
                            BigDecimal ampunt = cab.getAmount().add(((CurAccountBalance)cabMap.getValue()).getAmount());
                            cab.setAmount(ampunt);
                            continue;
                        }
                        this.allCurAccountBalanceMap.put((String)cabMap.getKey(), (CurAccountBalance)cabMap.getValue());
                    }
                }
            }
        } else {
            this.voucherFormPage(errorDataIndexs);
        }
    }

    private void voucherFormPage(HashSet<Integer> errorDataIndexs) {
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject dynamicObject;
            Long orgId;
            if (errorDataIndexs.contains(i) || !this.doCashCheck(orgId = Long.valueOf((dynamicObject = this.dataEntities[i].getDataEntity()).getLong("org_id"))) && !this.doCurrentCheck(orgId)) continue;
            DynamicObjectCollection entries = dynamicObject.getDynamicObjectCollection("entries");
            LinkedHashMap<String, CurAccountBalance> curAccountBalanceMap = new LinkedHashMap<String, CurAccountBalance>(entries.size());
            for (int j = 0; j < entries.size(); ++j) {
                DynamicObject dyn = (DynamicObject)entries.get(j);
                boolean isCash = false;
                boolean isRec = false;
                DynamicObject acct = (DynamicObject)dyn.get("account");
                if (GLUtil.isCashAcct((DynamicObject)acct)) {
                    isCash = true;
                }
                if (acct.getBoolean("accheck")) {
                    isRec = true;
                }
                this.setAccountInfo(dyn.getLong("assgrp.id"), (BigDecimal)dyn.get("debitori"), (BigDecimal)dyn.get("creditori"), acct.getString("number"), acct.getString("dc"), dyn.getLong("currency.id"), this.dataEntities[i], isCash, isRec, curAccountBalanceMap, j + 1);
            }
            if (!this.check(curAccountBalanceMap, true)) continue;
            this.allCurAccountBalanceMap.putAll(curAccountBalanceMap);
        }
    }

    private boolean check(Map<String, CurAccountBalance> curAccountBalanceMap, boolean isFromPage) {
        boolean result = true;
        HashSet<String> accountNumbers = new HashSet<String>();
        CurAccountBalance curAccountBalance = curAccountBalanceMap.values().iterator().next();
        DynamicObject dyn = curAccountBalance.getEntity().getDataEntity();
        long orgId = dyn.getLong("org_id");
        long bookTypeId = dyn.getLong("booktype.id");
        DynamicObject period = dyn.getDynamicObject("period");
        long periodId = period.getLong("id");
        long curAccountTableId = AccSysUtil.getCurPeriodAccountTableId((long)orgId, (long)bookTypeId, (long)periodId);
        this.checkDifcit(curAccountBalance.getEntity(), curAccountBalanceMap);
        for (Map.Entry<String, CurAccountBalance> cabMap : curAccountBalanceMap.entrySet()) {
            CurAccountBalance cab = cabMap.getValue();
            if (this.doCashCheck(orgId) && cab.getType().contains("checkdeficit")) {
                accountNumbers.add(cab.getAccNumber());
            }
            if (!this.doCurrentCheck(orgId) || !cab.getType().contains("currentdeficit")) continue;
            accountNumbers.add(cab.getAccNumber());
        }
        if (accountNumbers.size() > 0) {
            result = this.checkCashDificit(orgId, bookTypeId, periodId, curAccountTableId, accountNumbers, curAccountBalanceMap, isFromPage);
        }
        return result;
    }

    private void setAccountInfo(Long assgrp, BigDecimal debitOri, BigDecimal creditOri, String acctNumber, String dc, Long currency, ExtendedDataEntity entity, boolean isCash, boolean isRec, Map<String, CurAccountBalance> curAccountBalanceMap, int index) {
        CurAccountBalance curAccountBalance = new CurAccountBalance();
        String key = acctNumber + "&" + assgrp + "&" + currency;
        BigDecimal amount = debitOri.compareTo(BigDecimal.ZERO) != 0 ? ("1".equals(dc) ? debitOri : debitOri.negate()) : ("-1".equals(dc) ? creditOri : creditOri.negate());
        CurAccountBalance old = curAccountBalanceMap.get(key);
        if (old == null) {
            curAccountBalance.setOrg(Long.valueOf(entity.getDataEntity().getLong("org_id")));
            curAccountBalance.setAccNumber(acctNumber);
            curAccountBalance.setAssgrp(assgrp);
            curAccountBalance.setCurrency(currency);
            curAccountBalance.setEntity(entity);
            curAccountBalance.setAmount(amount);
            ArrayList<Integer> list = new ArrayList<Integer>();
            list.add(index);
            curAccountBalance.setIndexs(list);
            HashSet<String> set = new HashSet<String>(1);
            if (isCash) {
                set.add("checkdeficit");
            }
            if (isRec) {
                set.add("currentdeficit");
            }
            curAccountBalance.setType(set);
            curAccountBalanceMap.put(key, curAccountBalance);
        } else {
            CurAccountBalance oldAmount = curAccountBalanceMap.get(key);
            oldAmount.setAmount(oldAmount.getAmount().add(amount));
            oldAmount.getIndexs().add(index);
            curAccountBalanceMap.put(key, oldAmount);
        }
    }

    private void checkDifcit(ExtendedDataEntity dataEntity, Map<String, CurAccountBalance> curAccountBalanceMap) {
        DynamicObject v = dataEntity.getDataEntity();
        String billstatus = v.getString("billstatus");
        if (billstatus.equals("B")) {
            long oldPeriodId;
            DynamicObject dbVoucher = BusinessDataServiceHelper.loadSingle((String)"gl_voucher", (String)"entries.account,entries.assgrp,entries.debitori,entries.creditori,entries.currency,vouchertype,book.accounttable,booktype,localcur,period.id", (QFilter[])new QFilter[]{new QFilter("id", "=", v.getPkValue())});
            DynamicObjectCollection dbEntry = dbVoucher.getDynamicObjectCollection("entries");
            long newPeriodId = dataEntity.getDataEntity().getLong("period.id");
            if (newPeriodId >= (oldPeriodId = dbVoucher.getLong("period.id"))) {
                for (DynamicObject dbEntryRow : dbEntry) {
                    BigDecimal newAmount;
                    String dbAccount = dbEntryRow.getString("account.number");
                    long dbAssgrop = dbEntryRow.getLong("assgrp.id");
                    long dbCurrency = dbEntryRow.getLong("currency.id");
                    String dc = dbEntryRow.getString("account.dc");
                    String dbKey = dbAccount + "&" + dbAssgrop + "&" + dbCurrency;
                    CurAccountBalance cab = curAccountBalanceMap.get(dbKey);
                    if (cab == null || (newAmount = cab.getAmount()) == null) continue;
                    BigDecimal debitOri = dbEntryRow.getBigDecimal("debitori");
                    BigDecimal creditOri = dbEntryRow.getBigDecimal("creditori");
                    BigDecimal dbAmount = dbEntryRow.getBigDecimal("debitori").compareTo(BigDecimal.ZERO) != 0 ? ("1".equals(dc) ? debitOri : debitOri.negate()) : ("-1".equals(dc) ? creditOri : creditOri.negate());
                    cab.setAmount(newAmount.subtract(dbAmount));
                }
            }
        }
    }

    private boolean checkCashDificit(long orgId, long bookTypeId, long periodId, long curAccountTableId, Set<String> acctNumbers, Map<String, CurAccountBalance> curAccountBalanceMap, boolean isFromPage) {
        CurAccountBalance cab;
        QueryParam param = new QueryParam();
        param.setOnlyLeafAcctBal(true);
        param.setAccountFilter(new QFilter("number", "in", acctNumbers));
        BalanceQueryExecutor bq = BalanceQueryExecutor.getInstance();
        HashMap<String, BigDecimal> dbBalanceMap = new HashMap<String, BigDecimal>();
        try (DataSet ds = bq.getBalance("account.number,account.dc,assgrp,endfor,currency", new Long[]{orgId}, bookTypeId, curAccountTableId, periodId, periodId, param);){
            for (Row r : ds) {
                BigDecimal endfor;
                String key = r.getString("account.number") + "&" + r.getLong("assgrp") + "&" + r.getLong("currency");
                BigDecimal bigDecimal = endfor = "-1".equals(r.getString("account.dc")) ? r.getBigDecimal("endfor").negate() : r.getBigDecimal("endfor");
                if (this.allCurAccountBalanceMap.containsKey(key)) {
                    dbBalanceMap.put(key, endfor.add(this.allCurAccountBalanceMap.get(key).getAmount()));
                    continue;
                }
                if (!curAccountBalanceMap.containsKey(key)) continue;
                dbBalanceMap.put(key, endfor);
            }
        }
        ArrayList<ValidationErrorInfo> validationErrorInfos = new ArrayList<ValidationErrorInfo>(16);
        ArrayList<String> failEntries = new ArrayList<String>(16);
        Boolean result = true;
        for (Map.Entry<String, CurAccountBalance> entry : curAccountBalanceMap.entrySet()) {
            String currentDeficit;
            cab = entry.getValue();
            BigDecimal dbBalance = (BigDecimal)dbBalanceMap.get(entry.getKey());
            if (this.doCashCheck(orgId) && cab.getType().contains("checkdeficit") && cab.getAmount().compareTo(BigDecimal.ZERO) < 0 && (dbBalance == null || dbBalance.add(cab.getAmount()).compareTo(BigDecimal.ZERO) < 0)) {
                this.addMessage(cab.getEntity(), this.createEntryErrorMsg(cab.getIndexs(), cab.getAccNumber(), ResManager.loadKDString((String)"\u73b0\u91d1\u7c7b\u79d1\u76ee\u5bf9\u5e94\u6838\u7b97\u7ef4\u5ea6\u4f59\u989d\u5c0f\u4e8e0\u3002", (String)"VoucherSubmitDeficitValidator_0", (String)"fi-gl-opplugin", (Object[])new Object[0])), ErrorLevel.Error);
                result = false;
            }
            if (!this.doCurrentCheck(orgId) || !cab.getType().contains("currentdeficit") || cab.getAmount().compareTo(BigDecimal.ZERO) >= 0 || dbBalance != null && dbBalance.add(cab.getAmount()).compareTo(BigDecimal.ZERO) >= 0) continue;
            switch (currentDeficit = (String)SystemParamHelper.getObjectParam((String)"currentdeficit", (long)orgId)) {
                case "1": {
                    if (isFromPage) {
                        failEntries.add(entry.getKey());
                        break;
                    }
                    if (!result.booleanValue()) break;
                    ExtendedDataEntity entity = cab.getEntity();
                    Object pkId = entity.getBillPkId();
                    int dataIndex = entity.getDataEntityIndex();
                    String tip = ResManager.loadKDString((String)"\u5f80\u6765\u7c7b\u79d1\u76ee\u5bf9\u5e94\u6838\u7b97\u7ef4\u5ea6\u4f59\u989d\u5c0f\u4e8e0\u3002", (String)"VoucherSubmitDeficitValidator_2", (String)"fi-gl-opplugin", (Object[])new Object[0]);
                    String content = ResManager.loadKDString((String)"%1$s: \u63d0\u4ea4\u6210\u529f\uff0c\u4f46%2$s\u3002", (String)"VoucherSubmitDeficitValidator_1", (String)"fi-gl-opplugin", (Object[])new Object[]{entity.getBillNo(), this.createEntryErrorMsg(cab.getIndexs(), cab.getAccNumber(), tip)});
                    ValidationErrorInfo info = new ValidationErrorInfo("", pkId, dataIndex, entity.getRowIndex(), "errorcode_001", ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"VoucherSubmitDeficitValidator_3", (String)"fi-gl-opplugin", (Object[])new Object[0]), content, ErrorLevel.Error);
                    info.setEntityKey(this.getEntityKey());
                    info.setSubRowIndex(entity.getSubRowIndex());
                    validationErrorInfos.add(info);
                    break;
                }
                case "2": {
                    this.addMessage(cab.getEntity(), this.createEntryErrorMsg(cab.getIndexs(), cab.getAccNumber(), ResManager.loadKDString((String)"\u5f80\u6765\u7c7b\u79d1\u76ee\u5bf9\u5e94\u6838\u7b97\u7ef4\u5ea6\u4f59\u989d < 0\u3002", (String)"VoucherSubmitDeficitValidator_4", (String)"fi-gl-opplugin", (Object[])new Object[0])), ErrorLevel.Error);
                    result = false;
                }
            }
        }
        if (result.booleanValue()) {
            if (isFromPage) {
                for (String failEntrieKey : failEntries) {
                    cab = curAccountBalanceMap.get(failEntrieKey);
                    this.addMessage(cab.getEntity(), "dificit", this.createEntryErrorMsg(cab.getIndexs(), cab.getAccNumber(), ResManager.loadKDString((String)"\u5f80\u6765\u7c7b\u79d1\u76ee\u5bf9\u5e94\u6838\u7b97\u7ef4\u5ea6\u4f59\u989d\u5c0f\u4e8e0\u3002", (String)"VoucherSubmitDeficitValidator_5", (String)"fi-gl-opplugin", (Object[])new Object[0])), ErrorLevel.Warning);
                }
            } else {
                this.errorInfoList.addAll(validationErrorInfos);
            }
        }
        return result;
    }

    private boolean doCashCheck(Long orgId) {
        return SystemParamHelper.getBooleanParam((String)"checkdeficit", (long)orgId, (boolean)false);
    }

    private boolean doCurrentCheck(Long orgId) {
        Object currentControl = SystemParamHelper.getObjectParam((String)"currentdeficit", (long)orgId);
        return currentControl != null && !"0".equals(currentControl);
    }

    protected String createEntryErrorMsg(List<Integer> entrySeq, String accountNumber, String errorMsg) {
        return VoucherValidateMsgFormatter.get().createEntryErrorMsg(entrySeq.get(0), accountNumber, errorMsg);
    }
}

