/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.validate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.fi.gl.validate.bigdata.ValidateResult;
import kd.fi.gl.voucher.validate.VchEntryWrapper;
import kd.fi.gl.voucher.validate.VchExtDataEntityWrapper;
import kd.fi.gl.voucher.validate.VoucherContext;
import kd.fi.gl.voucher.validate.VoucherRowWrapper;
import kd.fi.gl.voucher.validate.VoucherValidateMsgFormatter;
import kd.fi.gl.voucher.validate.bill.BillContextInitializer;
import kd.fi.gl.voucher.validate.bill.BillValidator;
import kd.fi.gl.voucher.validate.bill.DtxVchValidator;
import kd.fi.gl.voucher.validate.bill.IVoucherValidator;
import kd.fi.gl.voucher.validate.bill.PeriodValidator;
import kd.fi.gl.voucher.validate.bill.VoucherNumberValidator;
import kd.fi.gl.voucher.validate.bill.VoucherTypeValidator;
import kd.fi.gl.voucher.validate.entry.AccountControlValidator;
import kd.fi.gl.voucher.validate.entry.AccountInitValidator;
import kd.fi.gl.voucher.validate.entry.CashFlowDesignValidator;
import kd.fi.gl.voucher.validate.entry.CashFlowSummaryValidator;
import kd.fi.gl.voucher.validate.entry.CashFlowValidator;
import kd.fi.gl.voucher.validate.entry.ComAssistValidator;
import kd.fi.gl.voucher.validate.entry.DataSetRowFilter;
import kd.fi.gl.voucher.validate.entry.DescValidator;
import kd.fi.gl.voucher.validate.entry.EntryAmountValidator;
import kd.fi.gl.voucher.validate.entry.EntryCountValidator;
import kd.fi.gl.voucher.validate.entry.EntryQuantityValidator;
import kd.fi.gl.voucher.validate.entry.ExpireDateValidator;
import kd.fi.gl.voucher.validate.entry.FlexValueValidator;
import kd.fi.gl.voucher.validate.entry.IVchEntriesSummaryValidator;
import kd.fi.gl.voucher.validate.entry.IVchEntryValidator;
import kd.fi.gl.voucher.validate.entry.LocAmountTotalValidator;
import kd.fi.gl.voucher.validate.entry.OriAmountTotalValidator;
import kd.fi.gl.voucher.validate.entry.ReciEntryValidator;
import kd.fi.gl.voucher.validate.entry.ReciValidator;
import kd.fi.gl.voucher.validate.entry.VchEntriesSummarySetter;
import kd.fi.gl.voucher.validate.entry.VchEntryCollector;
import kd.fi.gl.voucher.validate.entry.VoucherCheckValidator;
import kd.fi.gl.voucher.validate.entry.VoucherTypeControlValidator;

public class VoucherValidateService {
    private static final List<IVoucherValidator> BILL_VALIDATORS = new ArrayList<IVoucherValidator>(5);
    private static final List<IVchEntryValidator> VCH_ENTRY_VALIDATORS = new ArrayList<IVchEntryValidator>(8);
    private static final List<IVchEntriesSummaryValidator> VCH_ENTRIES_VALIDATORS = new ArrayList<IVchEntriesSummaryValidator>(9);

    private VoucherValidateService() {
    }

    public static synchronized void register(IVchEntryValidator ... entryValidators) {
        if (entryValidators != null) {
            VCH_ENTRY_VALIDATORS.addAll(Arrays.asList(entryValidators));
        }
    }

    public static List<ValidateResult> validateBill(VchExtDataEntityWrapper vchExtDataEntityWrapper, VoucherContext voucherContext) {
        ArrayList<ValidateResult> resultList = new ArrayList<ValidateResult>(BILL_VALIDATORS.size());
        for (IVoucherValidator validator : BILL_VALIDATORS) {
            if (!validator.isEnable(vchExtDataEntityWrapper, voucherContext)) continue;
            ValidateResult result = validator.validate(vchExtDataEntityWrapper, voucherContext);
            resultList.add(result);
            if (result.isSuccess()) continue;
            vchExtDataEntityWrapper.getMsgBuilder().appendErrorMsg(result.getMsg());
            break;
        }
        return resultList;
    }

    public static List<ValidateResult> validateEntry(VchExtDataEntityWrapper vchExtDataEntityWrapper, VchEntryWrapper vchEntryWrapper, VoucherContext voucherContext) {
        ArrayList<ValidateResult> resultList = new ArrayList<ValidateResult>(VCH_ENTRY_VALIDATORS.size());
        ArrayList<String> errList = new ArrayList<String>(VCH_ENTRY_VALIDATORS.size());
        for (IVchEntryValidator vchEntryValidator : VCH_ENTRY_VALIDATORS) {
            if (!vchEntryValidator.isEnable(vchExtDataEntityWrapper, vchEntryWrapper, voucherContext)) continue;
            ValidateResult result = vchEntryValidator.validate(vchExtDataEntityWrapper, vchEntryWrapper, voucherContext);
            resultList.add(result);
            if (!result.isSuccess() && StringUtils.isNotBlank((CharSequence)result.getMsg())) {
                errList.add(result.getMsg());
            }
            if (!vchEntryValidator.cancelValidate(result)) continue;
            break;
        }
        if (!errList.isEmpty()) {
            vchExtDataEntityWrapper.getMsgBuilder().appendEntryMsg(VoucherValidateMsgFormatter.get().createEntryErrorMsg(vchEntryWrapper.getSeq(), vchEntryWrapper.getAccNum(), VoucherValidateMsgFormatter.get().join(errList)));
        }
        return resultList;
    }

    public static List<ValidateResult> validateDataSetRow(VchExtDataEntityWrapper vchExtDataEntityWrapper, VchEntryWrapper vchEntryWrapper, VoucherRowWrapper voucherRowWrapper, VoucherContext voucherContext) {
        ArrayList<ValidateResult> resultList = new ArrayList<ValidateResult>(VCH_ENTRY_VALIDATORS.size());
        ArrayList<String> errList = new ArrayList<String>(VCH_ENTRY_VALIDATORS.size());
        for (IVchEntryValidator vchEntryValidator : VCH_ENTRY_VALIDATORS) {
            if (!vchEntryValidator.isEnable(vchExtDataEntityWrapper, vchEntryWrapper, voucherRowWrapper, voucherContext)) continue;
            ValidateResult result = vchEntryValidator.validate(vchExtDataEntityWrapper, vchEntryWrapper, voucherRowWrapper, voucherContext);
            resultList.add(result);
            if (!result.isSuccess() && StringUtils.isNotBlank((CharSequence)result.getMsg())) {
                errList.add(result.getMsg());
            }
            if (!vchEntryValidator.cancelValidate(result)) continue;
            break;
        }
        if (!errList.isEmpty()) {
            if (vchEntryWrapper != null) {
                vchExtDataEntityWrapper.getMsgBuilder().appendEntryMsg(VoucherValidateMsgFormatter.get().createEntryErrorMsg(vchEntryWrapper.getSeq(), vchEntryWrapper.getAccNum(), VoucherValidateMsgFormatter.get().join(errList)));
            } else {
                vchExtDataEntityWrapper.getMsgBuilder().appendEntryMsg(VoucherValidateMsgFormatter.get().createEntryErrorMsg(voucherRowWrapper.getSeq(), voucherRowWrapper.getAccount() == null ? "" : voucherRowWrapper.getAccount().getNumber(), VoucherValidateMsgFormatter.get().join(errList)));
            }
        }
        return resultList;
    }

    public static List<ValidateResult> validateEntries(VchExtDataEntityWrapper vchExtDataEntityWrapper, VoucherContext voucherContext) {
        ArrayList<ValidateResult> resultList = new ArrayList<ValidateResult>(VCH_ENTRIES_VALIDATORS.size());
        ArrayList<String> errList = new ArrayList<String>(VCH_ENTRIES_VALIDATORS.size());
        for (IVchEntriesSummaryValidator validator : VCH_ENTRIES_VALIDATORS) {
            if (!validator.isEnable(vchExtDataEntityWrapper, voucherContext)) continue;
            ValidateResult result = validator.validate(vchExtDataEntityWrapper, voucherContext);
            resultList.add(result);
            if (result.isSuccess()) continue;
            errList.add(result.getMsg());
        }
        if (!errList.isEmpty()) {
            vchExtDataEntityWrapper.getMsgBuilder().appendErrorMsg(VoucherValidateMsgFormatter.get().join(errList));
        }
        return resultList;
    }

    static {
        BILL_VALIDATORS.add(new PeriodValidator());
        BILL_VALIDATORS.add(new BillValidator());
        BILL_VALIDATORS.add(new VoucherTypeValidator());
        BILL_VALIDATORS.add(new DtxVchValidator());
        BILL_VALIDATORS.add(new BillContextInitializer());
        BILL_VALIDATORS.add(new VoucherNumberValidator());
        VCH_ENTRY_VALIDATORS.add(new DataSetRowFilter());
        VCH_ENTRY_VALIDATORS.add(new AccountInitValidator());
        VCH_ENTRY_VALIDATORS.add(new ReciEntryValidator());
        VCH_ENTRY_VALIDATORS.add(new VchEntryCollector());
        VCH_ENTRY_VALIDATORS.add(new DescValidator());
        VCH_ENTRY_VALIDATORS.add(new AccountControlValidator());
        VCH_ENTRY_VALIDATORS.add(new FlexValueValidator());
        VCH_ENTRY_VALIDATORS.add(new ExpireDateValidator());
        VCH_ENTRY_VALIDATORS.add(new EntryAmountValidator());
        VCH_ENTRY_VALIDATORS.add(new EntryQuantityValidator());
        VCH_ENTRY_VALIDATORS.add(new CashFlowValidator());
        VCH_ENTRY_VALIDATORS.add(new ComAssistValidator());
        VCH_ENTRIES_VALIDATORS.add(new VchEntriesSummarySetter());
        VCH_ENTRIES_VALIDATORS.add(new EntryCountValidator());
        VCH_ENTRIES_VALIDATORS.add(new LocAmountTotalValidator());
        VCH_ENTRIES_VALIDATORS.add(new OriAmountTotalValidator());
        VCH_ENTRIES_VALIDATORS.add(new CashFlowDesignValidator());
        VCH_ENTRIES_VALIDATORS.add(new CashFlowSummaryValidator());
        VCH_ENTRIES_VALIDATORS.add(new VoucherCheckValidator());
        VCH_ENTRIES_VALIDATORS.add(new ReciValidator());
        VCH_ENTRIES_VALIDATORS.add(new VoucherTypeControlValidator());
    }
}

