/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.validate.entry;

import java.math.BigDecimal;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.util.VoucherEntriesSummary;
import kd.fi.gl.validate.bigdata.ValidateResult;
import kd.fi.gl.voucher.validate.VchExtDataEntityWrapper;
import kd.fi.gl.voucher.validate.VoucherContext;
import kd.fi.gl.voucher.validate.entry.IVchEntriesSummaryValidator;

public class CashFlowSummaryValidator
implements IVchEntriesSummaryValidator {
    private static final Log logger = LogFactory.getLog(CashFlowSummaryValidator.class);
    private static final String CHECK_ALL = "2";

    @Override
    public boolean isEnable(VchExtDataEntityWrapper vchExtDataEntityWrapper, VoucherContext voucherContext) {
        VoucherEntriesSummary voucherEntriesSummary = vchExtDataEntityWrapper.getVoucherEntriesSummary();
        logger.info("CashFlowSummaryValidator option : {} " + voucherContext.getVoucherOption().noVerifyBal());
        return !voucherContext.getVoucherOption().noVerifyBal() && (voucherEntriesSummary.isMainCfDesignated() || voucherEntriesSummary.isSuppCfDesignated());
    }

    @Override
    public ValidateResult validate(VchExtDataEntityWrapper vchExtDataEntityWrapper, VoucherContext voucherContext) {
        ValidateResult result = ValidateResult.create();
        VoucherEntriesSummary summary = vchExtDataEntityWrapper.getVoucherEntriesSummary();
        boolean mainCfDesignated = summary.isMainCfDesignated();
        if (mainCfDesignated) {
            BigDecimal temp;
            if (!summary.isExistsCashAccount() && !voucherContext.getVoucherOption().isIgnoreMainCFItemCheck()) {
                return result.setErrorMsg(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u73b0\u91d1\u79d1\u76ee\uff0c\u4f46\u4e3b\u8868\u9879\u76ee\u5f55\u5165\u6709\u503c\u3002", (String)"CashFlowSummaryValidator_0", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
            }
            if (!summary.isExistsNotCachNotPlAccount() && !summary.isExistsPlAccount()) {
                return result.setErrorMsg(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u975e\u73b0\u91d1\u79d1\u76ee\uff0c\u4f46\u4e3b\u8868\u9879\u76ee\u5f55\u5165\u6709\u503c", (String)"CashFlowSummaryValidator_3", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
            }
            if (summary.getCashAccountDebitTotal().compareTo(summary.getDesiginatedMainAmt()) != 0) {
                return result.setErrorMsg(ResManager.loadKDString((String)"\u4e3b\u8868\u9879\u76ee\u91d1\u989d\u6307\u5b9a\u4e0d\u5e73\u8861\u3002", (String)"CashFlowSummaryValidator_1", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
            }
            if ((summary.isSuppCfDesignated() || BigDecimal.ZERO.compareTo(summary.getDesiginatedSuppAmt()) != 0) && (temp = summary.getNetProfit().add(summary.getDesiginatedSuppAmt())).compareTo(summary.getAmtOnActivities()) != 0) {
                return result.setErrorMsg(ResManager.loadKDString((String)"\u8865\u5145\u8d44\u6599\u91d1\u989d\u6307\u5b9a\u4e0d\u5e73\u8861\u3002", (String)"CashFlowSummaryValidator_2", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
            }
        } else if (summary.isExistsPlAccount()) {
            BigDecimal temp = summary.getNetProfit().add(summary.getDesiginatedSuppAmt());
            if (temp.compareTo(summary.getAmtOnActivities()) != 0) {
                return result.setErrorMsg(ResManager.loadKDString((String)"\u8865\u5145\u8d44\u6599\u91d1\u989d\u6307\u5b9a\u4e0d\u5e73\u8861\u3002", (String)"CashFlowSummaryValidator_2", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
            }
            if (!summary.isExistsNotCachNotPlAccount() && !summary.isExistsCashAccount()) {
                return result.setErrorMsg(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u975e\u635f\u76ca\u79d1\u76ee\uff0c\u4f46\u8865\u5145\u8d44\u6599\u5f55\u5165\u6709\u503c", (String)"CashFlowSummaryValidator_4", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
            }
        } else if (summary.getDesiginatedSuppAmt().compareTo(BigDecimal.ZERO) != 0) {
            return result.setErrorMsg(ResManager.loadKDString((String)"\u8865\u5145\u8d44\u6599\u91d1\u989d\u6307\u5b9a\u4e0d\u5e73\u8861\u3002", (String)"CashFlowSummaryValidator_2", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
        }
        logger.info(summary.toString());
        return result;
    }

    private String getCashFlowValidateConfig(VchExtDataEntityWrapper vchExtDataEntityWrapper, VoucherContext voucherContext) {
        return (String)voucherContext.getCashFlowValidateConfigCache().get((Object)vchExtDataEntityWrapper.getOrgId());
    }
}

