/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.validate.entry;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bd.consts.MeasureUnit;
import kd.fi.gl.common.VoucherSourceType;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.util.QuantityAmountCalculator;
import kd.fi.gl.util.SystemParamHelper;
import kd.fi.gl.validate.bigdata.ValidateResult;
import kd.fi.gl.voucher.option.VoucherOption;
import kd.fi.gl.voucher.relation.SyncVoucherSource;
import kd.fi.gl.voucher.validate.AccountWrapper;
import kd.fi.gl.voucher.validate.VchDynWrapper;
import kd.fi.gl.voucher.validate.VchEntryWrapper;
import kd.fi.gl.voucher.validate.VchExtDataEntityWrapper;
import kd.fi.gl.voucher.validate.VoucherContext;
import kd.fi.gl.voucher.validate.VoucherRowWrapper;
import kd.fi.gl.voucher.validate.entry.IVchEntryValidator;

public class EntryQuantityValidator
implements IVchEntryValidator {
    @Override
    public ValidateResult validate(VchExtDataEntityWrapper vchExtDataEntityWrapper, VchEntryWrapper vchEntryWrapper, VoucherContext voucherContext) {
        BigDecimal originalAmount = "1".equals(vchEntryWrapper.getString("entrydc")) ? vchEntryWrapper.getDebitOriAmt() : vchEntryWrapper.getCreditOriAmt();
        DynamicObject currency = vchEntryWrapper.getDynamicObject("currency");
        DynamicObject unit = vchEntryWrapper.getDynamicObject("measureunit");
        int quantityPrecision = unit == null ? 0 : unit.getInt("precision");
        long unitId = unit != null ? unit.getLong("id") : 0L;
        return this.doValidate(voucherContext, vchExtDataEntityWrapper, vchEntryWrapper, vchEntryWrapper.getAccount(), originalAmount, currency.getInt("amtprecision"), vchEntryWrapper.getBigDecimal("quantity"), quantityPrecision, vchEntryWrapper.getBigDecimal("price"), currency.getInt("priceprecision"), unitId);
    }

    @Override
    public ValidateResult validate(VchExtDataEntityWrapper vchExtDataEntityWrapper, VchEntryWrapper vchEntryWrapper, VoucherRowWrapper vchRowWrapper, VoucherContext voucherContext) {
        if (vchEntryWrapper != null) {
            return this.validate(vchExtDataEntityWrapper, vchEntryWrapper, voucherContext);
        }
        BigDecimal originalAmount = "1".equals(vchRowWrapper.getDirection()) ? vchRowWrapper.getDebitOriAmt() : vchRowWrapper.getCreditOriAmt();
        long unitId = vchRowWrapper.getLong(25);
        int quantityPrecision = unitId == 0L ? 0 : vchRowWrapper.getInt(32);
        return this.doValidate(voucherContext, vchExtDataEntityWrapper, null, vchRowWrapper.getAccount(), originalAmount, vchRowWrapper.getInt(30), vchRowWrapper.getBigDecimal(19), quantityPrecision, vchRowWrapper.getBigDecimal(22), vchRowWrapper.getInt(28), unitId);
    }

    private ValidateResult doValidate(VoucherContext voucherContext, VchExtDataEntityWrapper vchExtDataEntityWrapper, VchEntryWrapper entryWrapper, AccountWrapper account, BigDecimal originalAmount, int amountPrecision, BigDecimal quantity, int quantityPrecision, BigDecimal price, int pricePrecision, long unitId) {
        boolean enteredPrice;
        boolean enteredUnit = unitId > 0L;
        boolean enteredQuantity = quantity != null && quantity.signum() != 0;
        boolean bl = enteredPrice = price != null && price.signum() != 0;
        if (account.isQty()) {
            boolean fromTransPLSynVoucher;
            if (!enteredUnit && (enteredQuantity || enteredPrice)) {
                return ValidateResult.create().setErrorMsg(ResManager.loadKDString((String)"\u672a\u586b\u5199\u8ba1\u91cf\u5355\u4f4d\uff0c\u8bf7\u6e05\u9664\u5355\u4ef7\u548c\u6570\u91cf\u3002", (String)"EntryQuantityValidator_0", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
            }
            if (VoucherOption.enablePriceCheck() && enteredPrice && price.signum() < 0) {
                return ValidateResult.create().setErrorMsg(ResManager.loadKDString((String)"\u5355\u4ef7\u4e0d\u80fd\u4e3a\u8d1f\u6570\u3002", (String)"EntryQuantityValidator_1", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
            }
            if (!MeasureUnit.matchGroup((long)unitId, (long)account.getMeasureUnitGroupId())) {
                return ValidateResult.create().setErrorMsg(ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d\u4e0d\u5728\u79d1\u76ee\u7684\u8ba1\u91cf\u5355\u4f4d\u5206\u7ec4\u5185\u3002", (String)"EntryQuantityValidator_2", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
            }
            VchDynWrapper vchDynWrapper = vchExtDataEntityWrapper.getVchDynWrapper();
            SyncVoucherSource synSourceVoucher = voucherContext.getSyncVch().get(vchExtDataEntityWrapper.getId());
            if (!((Boolean)voucherContext.getIgnoreQPAConsistencyCheckConfigCache().get((Object)vchExtDataEntityWrapper.getOrgId())).booleanValue()) {
                boolean srcVchIsNotAutoTrans = synSourceVoucher != null && "6".equals(synSourceVoucher.getSourceType());
                boolean consistencyCheck = QuantityAmountCalculator.consistencyCheck((BigDecimal)quantity, (int)quantityPrecision, (BigDecimal)price, (int)pricePrecision, (BigDecimal)originalAmount, (int)amountPrecision, (vchDynWrapper.isReverse() || VoucherSourceType.fromEndingProcess((String)vchDynWrapper.getSourceType()) || vchExtDataEntityWrapper.isCarryOverVch() || srcVchIsNotAutoTrans ? 1 : 0) != 0);
                if (!consistencyCheck) {
                    return ValidateResult.create().setErrorMsg(ResManager.loadKDString((String)"\u6570\u91cf*\u5355\u4ef7\u4e0d\u7b49\u4e8e\u501f\u8d37\u65b9\u53d1\u751f\u989d\u3002", (String)"EntryQuantityValidator_3", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
                }
            }
            boolean bl2 = fromTransPLSynVoucher = synSourceVoucher != null && "1".equals(synSourceVoucher.getSourceType());
            if (!(!this.quantityAndPriceMustInput(vchExtDataEntityWrapper) || enteredQuantity && enteredPrice || vchExtDataEntityWrapper.isProfitVch() || vchExtDataEntityWrapper.isCarryOverVch() || vchExtDataEntityWrapper.isExchangeRateVch() || fromTransPLSynVoucher)) {
                return ValidateResult.create().setErrorMsg(ResManager.loadKDString((String)"\u672a\u5f55\u6570\u91cf\u548c\u5355\u4ef7", (String)"EntryQuantityValidator_4", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
            }
        } else if (enteredQuantity || enteredPrice || enteredUnit) {
            if (entryWrapper != null) {
                entryWrapper.set("measureunit", null);
                entryWrapper.set("measureunit_id", 0L);
                entryWrapper.set("quantity", BigDecimal.ZERO);
                entryWrapper.set("price", BigDecimal.ZERO);
            } else {
                return ValidateResult.create().setErrorMsg(ResManager.loadKDString((String)"\u4e0d\u5305\u542b\u6570\u91cf\u6838\u7b97\uff0c\u8bf7\u6e05\u9664\u8ba1\u91cf\u5355\u4f4d\u3001\u5355\u4ef7\u548c\u6570\u91cf", (String)"EntryQuantityValidator_5", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
            }
        }
        return ValidateResult.create();
    }

    private boolean quantityAndPriceMustInput(VchExtDataEntityWrapper vchExtDataEntityWrapper) {
        return SystemParamHelper.getBooleanParam((String)"qtymustinput", (long)vchExtDataEntityWrapper.getOrgId(), (boolean)false);
    }
}

