/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.common.parttime.enums;

import kd.hr.hdm.common.reg.util.MultiLangEnumBridge;

public enum PosTypeEnum {
    STD_POS("0", "stdposition", "astdposition", new MultiLangEnumBridge("\u6807\u51c6\u5c97\u4f4d", "PosTypeEnum_0", "hr-hdm-common")),
    POS("1", "position", "aposition", new MultiLangEnumBridge("\u5c97\u4f4d", "PosTypeEnum_1", "hr-hdm-common")),
    JOB("2", "job", "bjob", new MultiLangEnumBridge("\u804c\u4f4d", "PosTypeEnum_2", "hr-hdm-common"));

    private final String code;
    private final String filedName;
    private final String filedNameOfPartTime;
    private MultiLangEnumBridge bridge = null;

    private PosTypeEnum(String code, String filedName, String filedNameOfPartTime, MultiLangEnumBridge bridge) {
        this.code = code;
        this.filedName = filedName;
        this.filedNameOfPartTime = filedNameOfPartTime;
        this.bridge = bridge;
    }

    public String getCode() {
        return this.code;
    }

    public static String getName(String code) {
        if (code == null) {
            return null;
        }
        for (PosTypeEnum se : PosTypeEnum.values()) {
            if (!code.equals(se.getCode())) continue;
            return se.getName();
        }
        return null;
    }

    public static String[] getFiledName(String code) {
        if (code == null) {
            return new String[]{" "};
        }
        switch (code) {
            case "0": {
                return new String[]{STD_POS.getFiledName(), JOB.getFiledName()};
            }
            case "1": {
                return new String[]{POS.getFiledName(), JOB.getFiledName()};
            }
            case "2": {
                return new String[]{JOB.getFiledName()};
            }
        }
        throw new IllegalStateException("Unexpected value: " + code);
    }

    public static String[] getFiledNameOfPartTime(String code) {
        if (code == null) {
            return null;
        }
        switch (code) {
            case "0": {
                return new String[]{STD_POS.getFiledNameOfPartTime(), JOB.getFiledNameOfPartTime()};
            }
            case "1": {
                return new String[]{POS.getFiledNameOfPartTime(), JOB.getFiledNameOfPartTime()};
            }
            case "2": {
                return new String[]{JOB.getFiledNameOfPartTime()};
            }
        }
        throw new IllegalStateException("Unexpected value: " + code);
    }

    public String getFiledNameOfPartTime() {
        return this.filedNameOfPartTime;
    }

    public String getFiledName() {
        return this.filedName;
    }

    public String getName() {
        return this.bridge.loadKDString();
    }
}

