/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.common.reg.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.TextProp;
import kd.bos.list.IListColumn;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;

public class RegCommonUtil {
    public static void addTextProps(DynamicObjectCollection rows, String[] fieldNames) {
        if (fieldNames == null || fieldNames.length == 0) {
            return;
        }
        IDataEntityType dataEntityType = ((DynamicObject)rows.get(0)).getDataEntityType();
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        for (String fieldName : fieldNames) {
            TextProp textProp = new TextProp();
            textProp.setName(fieldName);
            properties.add((Object)textProp);
        }
    }

    public static void registerCommonProp(DynamicObjectCollection collection, String[] propertyNames) {
        DynamicObjectType type = collection.getDynamicObjectType();
        Arrays.stream(propertyNames).filter(propertyName -> HRObjectUtils.isEmpty((Object)type.getProperty(propertyName))).forEach(propertyName -> {
            DynamicSimpleProperty property = new DynamicSimpleProperty(propertyName, String.class, (Object)"");
            type.registerSimpleProperty(property);
        });
    }

    public static String getHandleTime(Date startTime, Date endTime) {
        long total = HRDateTimeUtils.dateDiff((Date)startTime, (Date)(endTime != null ? endTime : new Date()));
        int totalHours = BigDecimal.valueOf(total).divide(new BigDecimal(3600000), 0, RoundingMode.DOWN).intValue();
        int days = totalHours / 24;
        int hours = totalHours % 24;
        String hoursStr = hours == 0 ? "" : ResManager.loadKDString((String)"%s\u5c0f\u65f6", (String)"RegCommonUtil_0", (String)"hr-hdm-common", (Object[])new Object[]{hours});
        String daysStr = days == 0 ? "" : ResManager.loadKDString((String)"%s\u5929", (String)"RegCommonUtil_1", (String)"hr-hdm-common", (Object[])new Object[]{days});
        return daysStr + hoursStr;
    }

    public static Date getNowDate() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static void fixedListColumns(List<IListColumn> columns, List<String> fixedFieldKeys) {
        for (IListColumn column : columns) {
            String fieldKey = column.getListFieldKey();
            if (!fixedFieldKeys.contains(fieldKey)) continue;
            column.setFixed(true);
        }
    }
}

