/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.common.transfer.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.control.LabelAp;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.common.transfer.util.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class TransferCommonUtil {
    private static final Log LOGGER = LogFactory.getLog(TransferCommonUtil.class);
    private static String TAG_AUDIT_VIEW = "SCENE";
    private static String PROPERTY_NAME = "name";
    private static String HRPERSON_BASEDATAID = "fbasedataid";
    private static final List<String> SHOW_BILL_STATUS = Arrays.asList("A", "G", "B", "D", "E");
    public static final Function<Date, Date> GETYESTERDAY = today -> {
        if (null == today) {
            today = new Date();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime((Date)today);
        calendar.add(5, -1);
        return calendar.getTime();
    };
    public static final Supplier<Date> GETZEROCLOCK = () -> {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    };
    public static final Supplier<Date> GETTOMORROWZEROCLOCK = () -> {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.add(5, 1);
        return calendar.getTime();
    };
    public static final Function<Date, Date> GETTOMORROWRDAY = today -> {
        if (null == today) {
            today = new Date();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime((Date)today);
        calendar.add(5, 1);
        return calendar.getTime();
    };
    public static final Function<String, Date> string2Date = stringDate -> {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            return simpleDateFormat.parse((String)stringDate);
        }
        catch (ParseException e) {
            LOGGER.error((Throwable)e);
            return null;
        }
    };
    public static final Function<Date, String> formatDate = source -> {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return simpleDateFormat.format((Date)source);
    };
    public static final Function<Date, String> formatDate1 = source -> {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        return simpleDateFormat.format((Date)source);
    };
    public static final Function<Date, String> formatStandardDate = source -> {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:dd");
        return simpleDateFormat.format((Date)source);
    };
    public static final Function<String, String> STRINGADDONE = temp -> {
        int count = Integer.parseInt(temp) + 1;
        return String.valueOf(count);
    };

    public static String getBarCode(IDataModel model) {
        String barCode = (String)model.getValue("barcode");
        String billno = (String)model.getValue("billno");
        if (HRStringUtils.isEmpty((String)barCode) && HRStringUtils.isNotEmpty((String)billno)) {
            model.setValue("barcode", (Object)billno);
        }
        return billno;
    }

    public static void setLblText(IFormView view, String key, String text) {
        Label label = (Label)view.getControl(key);
        label.setText(text);
    }

    public static boolean isOverDue(Date transferDate) {
        if (transferDate == null) {
            return false;
        }
        return HRDateTimeUtils.dayBefore((Date)transferDate, (Date)HRDateTimeUtils.truncateDate((Date)new Date()));
    }

    public static boolean isModifyToView(String operateKey) {
        return "save".equals(operateKey) || "unsubmit".equals(operateKey) || "submit".equals(operateKey) || "submiteffect".equals(operateKey);
    }

    public static void setLblBaseDataText(IFormView view, IDataModel model, String labelName, String propertyName, Boolean flag) {
        Label lblsource = (Label)view.getControl(labelName);
        DynamicObject dy = (DynamicObject)model.getValue(propertyName);
        if (!ObjectUtils.isEmpty(dy)) {
            if (StringUtils.isNotEmpty((CharSequence)dy.getString("name"))) {
                lblsource.setText(dy.getString("name"));
            }
        } else {
            lblsource.setText("-");
        }
    }

    public static boolean isOrginator(String menuflag, String originator) {
        if (HRStringUtils.equals((String)"out", (String)menuflag) && HRStringUtils.equals((String)"1", (String)originator)) {
            return true;
        }
        if (HRStringUtils.equals((String)"in", (String)menuflag) && HRStringUtils.equals((String)"2", (String)originator)) {
            return true;
        }
        return HRStringUtils.equals((String)"apply", (String)menuflag);
    }

    public static String getMenuflagStr(IFormView formView) {
        String formId = formView.getFormShowParameter().getFormId();
        String menuflag = "";
        if (formId.contains("hdm_transferoutbill")) {
            menuflag = "out";
        } else if (formId.contains("hdm_transferinbill")) {
            menuflag = "in";
        } else if (formId.contains("hdm_transferapply")) {
            menuflag = "apply";
        }
        return menuflag;
    }

    public static Map<String, Object> buildPersonalInfo(DynamicObject transferDy) {
        if (ObjectUtils.isEmpty(transferDy.getDynamicObject("person"))) {
            return null;
        }
        HashMap<String, Object> personMap = new HashMap<String, Object>();
        personMap.put("person", transferDy.getDynamicObject("person"));
        TransferCommonUtil.setPersonPropertyToMap(transferDy, "postype", personMap, "employmenttype");
        TransferCommonUtil.setPersonPropertyToMap(transferDy, "laborreltype", personMap, "laborreltype");
        TransferCommonUtil.setPersonPropertyToMap(transferDy, "laborrelstatus", personMap, "laborrelstatus");
        TransferCommonUtil.setPersonPropertyToMap(transferDy, "bcompany", personMap, "company");
        TransferCommonUtil.setPersonPropertyToMap(transferDy, "borg", personMap, "department");
        TransferCommonUtil.setPersonPropertyToMap(transferDy, "bposition", personMap, "position");
        TransferCommonUtil.setPersonPropertyToMap(transferDy, "bstposition", personMap, "stposition");
        TransferCommonUtil.setPersonPropertyToMap(transferDy, "bsuperior", personMap, "supervisor");
        TransferCommonUtil.setPersonPropertyToMap(transferDy, "borgleader", personMap, "orgleader");
        TransferCommonUtil.setPersonPropertyToMap(transferDy, "bpostpattern", personMap, "postpattern");
        TransferCommonUtil.setPersonPropertyToMap(transferDy, "bjob", personMap, "job");
        return personMap;
    }

    private static void setPersonPropertyToMap(DynamicObject sourceDy, String sourceKey, Map<String, Object> targetMap, String targetKey) {
        Object sourceValue = sourceDy.get(sourceKey);
        if (ObjectUtils.isEmpty(sourceValue)) {
            return;
        }
        if (sourceValue instanceof DynamicObject) {
            String propertyName = String.format("%s.%s", sourceKey, PROPERTY_NAME);
            targetMap.put(targetKey, sourceDy.getString(propertyName));
        } else if (sourceValue instanceof DynamicObjectCollection) {
            DynamicObject leader = (DynamicObject)((DynamicObject)sourceDy.getDynamicObjectCollection(sourceKey).stream().findFirst().get()).get(HRPERSON_BASEDATAID);
            targetMap.put(targetKey, leader);
        } else if (sourceValue instanceof String) {
            targetMap.put(targetKey, (String)sourceValue);
        }
    }

    public static void setLblMultiBaseDataText(IFormView view, IDataModel model, String labelName, String propertyName, Boolean flag) {
        Label lblsource = (Label)view.getControl(labelName);
        DynamicObjectCollection dy = (DynamicObjectCollection)model.getValue(propertyName);
        if (!ObjectUtils.isEmpty(dy)) {
            DynamicObjectCollection value = (DynamicObjectCollection)model.getValue(propertyName);
            List collect = value.stream().filter(temp -> temp.get("fbasedataid") != null).map(temp -> ((DynamicObject)temp.get("fbasedataid")).getString("name")).collect(Collectors.toList());
            String join = StringUtils.join((Object[])collect.toArray(), (String)"\uff0c");
            lblsource.setText(join);
        } else {
            lblsource.setText("-");
        }
    }

    public static String getTransferStatusDesc(String transferStatus) {
        String content = "";
        switch (transferStatus) {
            case "0": {
                content = ResManager.loadKDString((String)"\u5f85\u8c03\u52a8", (String)"TransferCommonUtil_0", (String)"hr-hdm-common", (Object[])new Object[0]);
                break;
            }
            case "1": {
                content = ResManager.loadKDString((String)"\u8c03\u52a8\u4e2d", (String)"TransferCommonUtil_1", (String)"hr-hdm-common", (Object[])new Object[0]);
                break;
            }
            case "4": {
                content = ResManager.loadKDString((String)"\u5f85\u751f\u6548", (String)"TransferCommonUtil_2", (String)"hr-hdm-common", (Object[])new Object[0]);
                break;
            }
            case "2": {
                content = ResManager.loadKDString((String)"\u8c03\u52a8\u5b8c\u6210", (String)"TransferCommonUtil_3", (String)"hr-hdm-common", (Object[])new Object[0]);
                break;
            }
            case "3": {
                content = ResManager.loadKDString((String)"\u8c03\u52a8\u7ec8\u6b62", (String)"TransferCommonUtil_4", (String)"hr-hdm-common", (Object[])new Object[0]);
                break;
            }
        }
        return content;
    }

    public static boolean isAuditView(IFormView formView) {
        Object scene = formView.getFormShowParameter().getCustomParam(TAG_AUDIT_VIEW);
        return null != scene;
    }

    public static void setTransferStatusShow(IFormView formView, IDataModel model, String labelTransferStatus) {
        String entityId = formView.getEntityId();
        String billStatus = (String)model.getValue("billstatus");
        String transferStatus = (String)model.getValue("transferstatus");
        String content = "";
        content = entityId.equals("hdm_mytransferbill") ? (SHOW_BILL_STATUS.contains(billStatus) ? TransferCommonUtil.getBillStatusDesc(billStatus) : TransferCommonUtil.getTransferStatusDesc(transferStatus)) : TransferCommonUtil.getTransferStatusDesc(transferStatus);
        LabelAp statusLabel = new LabelAp();
        statusLabel.setKey(labelTransferStatus);
        statusLabel.setName(new LocaleString(content));
        Style style = new Style();
        Border border = new Border();
        String borderColor = "";
        style.setBorder(border);
        switch (transferStatus) {
            case "0": 
            case "1": 
            case "4": {
                statusLabel.setForeColor("#276FF5");
                statusLabel.setBackColor("#F2F9FF");
                borderColor = "#85B8FF";
                break;
            }
            case "2": {
                statusLabel.setForeColor("#1BA854");
                statusLabel.setBackColor("#F2FFF5");
                borderColor = "#6DD18E";
                break;
            }
            case "3": {
                statusLabel.setForeColor("#666666");
                statusLabel.setBackColor("#F5F5F5");
                borderColor = " #CCCCCC";
                break;
            }
        }
        String borderType = "1px_solid_" + borderColor;
        border.setTop(borderType);
        border.setBottom(borderType);
        border.setLeft(borderType);
        border.setRight(borderType);
        style.setBorder(border);
        Padding padding = new Padding();
        padding.setTop("2px");
        padding.setBottom("2px");
        padding.setLeft("8px");
        padding.setRight("8px");
        style.setPadding(padding);
        statusLabel.setStyle(style);
        formView.updateControlMetadata(statusLabel.getKey(), statusLabel.createControl());
    }

    public static String getBillStatusDesc(String billStatus) {
        String content = "";
        switch (billStatus) {
            case "A": {
                content = ResManager.loadKDString((String)"\u6682\u5b58", (String)"TransferCommonUtil_5", (String)"hr-hdm-common", (Object[])new Object[0]);
                break;
            }
            case "B": {
                content = ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4", (String)"TransferCommonUtil_6", (String)"hr-hdm-common", (Object[])new Object[0]);
                break;
            }
            case "C": {
                content = ResManager.loadKDString((String)"\u5ba1\u6279\u901a\u8fc7", (String)"TransferCommonUtil_7", (String)"hr-hdm-common", (Object[])new Object[0]);
                break;
            }
            case "D": {
                content = ResManager.loadKDString((String)"\u5ba1\u6279\u4e2d", (String)"TransferCommonUtil_8", (String)"hr-hdm-common", (Object[])new Object[0]);
                break;
            }
            case "E": {
                content = ResManager.loadKDString((String)"\u5ba1\u6279\u4e0d\u901a\u8fc7", (String)"TransferCommonUtil_9", (String)"hr-hdm-common", (Object[])new Object[0]);
                break;
            }
            case "F": {
                content = ResManager.loadKDString((String)"\u5df2\u5e9f\u5f03", (String)"TransferCommonUtil_10", (String)"hr-hdm-common", (Object[])new Object[0]);
                break;
            }
            case "G": {
                content = ResManager.loadKDString((String)"\u5f85\u91cd\u65b0\u63d0\u4ea4", (String)"TransferCommonUtil_11", (String)"hr-hdm-common", (Object[])new Object[0]);
                break;
            }
        }
        return content;
    }
}

