/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.common.transfer.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.common.transfer.util.ObjectUtils;

public class TransferPageUtil {
    private static final Log LOGGER = LogFactory.getLog(TransferPageUtil.class);

    public static void setLblText(IFormView view, String key, String text) {
        Label label = (Label)view.getControl(key);
        label.setText(text);
    }

    public static void setLabelValue(IFormView formView, String labelName, Object labelText) {
        Label label = (Label)formView.getControl(labelName);
        if (label == null) {
            return;
        }
        if (HRObjectUtils.isEmpty((Object)labelText)) {
            formView.setVisible(Boolean.FALSE, new String[]{labelName});
        } else {
            label.setText(labelText.toString());
        }
    }

    public static void showFormViewOfModal(IFormView view, String formId, Object id, String menuflag) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("id", id);
        showParameter.setCustomParam("menuflag", (Object)menuflag);
        view.showForm(showParameter);
    }

    public static void showFormViewOfModal(IFormView view, String formId, Map<String, Object> params) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParams(params);
        view.showForm(showParameter);
    }

    public static void showFormViewOfNewTable(IFormView view, String formId, Map<String, Object> params) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.getOpenStyle().setTargetKey("_submaintab_");
        showParameter.setCustomParams(params);
        view.showForm(showParameter);
        view.sendFormAction(view);
    }

    public static void showBillPage(IFormView view, String formId, Map<String, Object> params, Object id, String caption) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setFormId(formId);
        showParameter.setCaption(caption);
        if (!ObjectUtils.isEmpty(id)) {
            showParameter.setPkId(id);
        }
        if (params != null && !params.isEmpty()) {
            showParameter.setCustomParams(params);
        }
        view.showForm((FormShowParameter)showParameter);
    }

    public static void showModalWithCloseCallback(AbstractFormPlugin plugin, String formId, Map<String, Object> params, String closeCallBackId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParams(params);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, closeCallBackId));
        plugin.getView().showForm(showParameter);
    }

    public static void showNewAddPage(IFormView view, String formId, String caption) {
        ListShowParameter param = (ListShowParameter)view.getFormShowParameter();
        HashMap<String, String> customParams = new HashMap<String, String>();
        String menuflag = (String)param.getCustomParam("menuflag");
        customParams.put("menuflag", menuflag);
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setCaption(caption);
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setCustomParams(customParams);
        view.showForm((FormShowParameter)parameter);
    }

    public static void showPage(IFormView view, String formId, Object id, String caption, Map<String, Object> customs) {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId(formId);
        showParameter.setPkId(id);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setPageId(view.getPageId() + "_" + "hdm" + "_" + id);
        if (!ObjectUtils.isEmpty(customs)) {
            showParameter.setCustomParams(customs);
        }
        if (!HRStringUtils.isEmpty((String)caption)) {
            showParameter.setCaption(caption);
        }
        view.showForm((FormShowParameter)showParameter);
    }

    public static void showFormPage(IFormView view, String formId, String caption, Map<String, Object> customs) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        if (!ObjectUtils.isEmpty(customs)) {
            showParameter.setCustomParams(customs);
        }
        if (!HRStringUtils.isEmpty((String)caption)) {
            showParameter.setCaption(caption);
        }
        view.showForm(showParameter);
    }

    public static void showPageInContainer(IFormView view, String formId, String targetKey, Map<String, Object> customs) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(targetKey);
        if (!ObjectUtils.isEmpty(customs)) {
            showParameter.setCustomParams(customs);
        }
        view.showForm(showParameter);
    }

    public static void showPageInContainerByPkId(IFormView view, String formId, String targetKey, Map<String, Object> customMap) {
        BillShowParameter showParameter = TransferPageUtil.buildBillShowParameter(formId, targetKey, ShowType.InContainer, customMap);
        view.showForm((FormShowParameter)showParameter);
    }

    private static BillShowParameter buildBillShowParameter(String formId, String targetKey, ShowType showType, Map<String, Object> customMap) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(showType);
        if (HRStringUtils.isNotEmpty((String)targetKey)) {
            showParameter.getOpenStyle().setTargetKey(targetKey);
        }
        if (!ObjectUtils.isEmpty(customMap)) {
            showParameter.setCustomParams(customMap);
            showParameter.setPkId(customMap.get("id"));
            Object status = customMap.get("status");
            if (!HRObjectUtils.isEmpty((Object)status)) {
                showParameter.setStatus((OperationStatus)status);
            }
        }
        return showParameter;
    }

    public static void showPageNoAuthByPkId(IFormView view, String formId, String targetKey, ShowType showType, Map<String, Object> customMap) {
        BillShowParameter showParameter = TransferPageUtil.buildBillShowParameter(formId, targetKey, showType, customMap);
        showParameter.setHasRight(true);
        view.showForm((FormShowParameter)showParameter);
    }

    public static List<Map<String, Object>> getTemplateExportDataList(Map<String, List<DynamicObject>> source, String reason) {
        ArrayList<Map<String, Object>> exportdatalist = new ArrayList<Map<String, Object>>();
        List<DynamicObject> success = source.get("success");
        List<DynamicObject> fail = source.get("fail");
        TransferPageUtil.buildExceportInfo(success, exportdatalist, "");
        TransferPageUtil.buildExceportInfo(fail, exportdatalist, reason);
        return exportdatalist;
    }

    private static void buildExceportInfo(List<DynamicObject> source, List<Map<String, Object>> exportdatalist, String reason) {
        List temp = Optional.ofNullable(source).orElseGet(() -> new ArrayList());
        for (DynamicObject dynamicObject : temp) {
            HashMap<String, String> map = new HashMap<String, String>(source.size());
            map.put("name", dynamicObject.getString("person.name"));
            map.put("worknumber", dynamicObject.getString("person.number"));
            map.put("isSuccess", ResManager.loadKDString((String)"\u662f", (String)"TransferPageUtil_0", (String)"hr-hdm-common", (Object[])new Object[0]));
            map.put("reason", reason);
            exportdatalist.add(map);
        }
    }

    public static FormShowParameter getResultPage(String workNumber, String successPerson, String successOperation, String failPerson, String failOperation, String excelName, List<Map<String, Object>> exportDataList, List<HRExportHeadObject> headDataList) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.getOpenStyle().setTargetKey("_submaintab_");
        formShowParameter.setFormId("hdm_result");
        formShowParameter.setCustomParam("successperson", (Object)successPerson);
        formShowParameter.setCustomParam("successoperation", (Object)successOperation);
        formShowParameter.setCustomParam("worknumber", (Object)workNumber);
        formShowParameter.setCustomParam("failperson", (Object)failPerson);
        formShowParameter.setCustomParam("failoperation", (Object)failOperation);
        formShowParameter.setCustomParam("excelname", (Object)excelName);
        formShowParameter.setCustomParam("exportdatalist", exportDataList);
        formShowParameter.setCustomParam("headdatalist", headDataList);
        return formShowParameter;
    }

    public static List<HRExportHeadObject> getAuditHeadDataList() {
        ArrayList<HRExportHeadObject> headdatalist = new ArrayList<HRExportHeadObject>();
        headdatalist.add(new HRExportHeadObject("name", ResManager.loadKDString((String)"\u59d3\u540d", (String)"TransferPageUtil_1", (String)"hr-hdm-common", (Object[])new Object[0])));
        headdatalist.add(new HRExportHeadObject("worknumber", ResManager.loadKDString((String)"\u5de5\u53f7", (String)"TransferPageUtil_2", (String)"hr-hdm-common", (Object[])new Object[0])));
        headdatalist.add(new HRExportHeadObject("isSuccess", ResManager.loadKDString((String)"\u662f\u5426\u6210\u529f", (String)"TransferPageUtil_3", (String)"hr-hdm-common", (Object[])new Object[0])));
        headdatalist.add(new HRExportHeadObject("reason", ResManager.loadKDString((String)"\u9519\u8bef\u539f\u56e0", (String)"TransferPageUtil_4", (String)"hr-hdm-common", (Object[])new Object[0])));
        return headdatalist;
    }

    public static void showSecondConfirm(AbstractBillPlugIn plugin, Map<String, List<DynamicObject>> operationResult, String menuFlag, String errormesg) {
        Map<String, List<DynamicObject>> operationResult1 = operationResult;
        List success = Optional.ofNullable(operationResult.get("success")).orElseGet(() -> new ArrayList());
        List fail = Optional.ofNullable(operationResult.get("fail")).orElseGet(() -> new ArrayList());
        List<HRExportHeadObject> headDataList = TransferPageUtil.getAuditHeadDataList();
        String reason = ResManager.loadKDString((String)"\u8be5\u4eba\u5458\u8fd8\u6709\u672a\u68c0\u6d4b\u901a\u8fc7\u7684\u4fe1\u606f\u3002", (String)"TransferPageUtil_5", (String)"hr-hdm-common", (Object[])new Object[0]);
        if (errormesg != null && errormesg.equals(ResManager.loadKDString((String)"\u5728\u9700\u8981\u6307\u5b9a\u4e0b\u4e00\u6b65\u53c2\u4e0e\u4eba\u7684\u60c5\u51b5\u4e0b\u4e0d\u5141\u8bb8\u591a\u9009\u3002", (String)"", (String)"hr-hdm-common", (Object[])new Object[0]))) {
            reason = errormesg;
        }
        List<Map<String, Object>> exportDataList = TransferPageUtil.getTemplateExportDataList(operationResult1, reason);
        FormShowParameter formShowParameter = TransferPageUtil.getResultPage("", String.valueOf(success.size()), ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"TransferPageUtil_6", (String)"hr-hdm-common", (Object[])new Object[0]), String.valueOf(fail.size()), ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"TransferPageUtil_7", (String)"hr-hdm-common", (Object[])new Object[0]), String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u7ed3\u679c", (String)"TransferPageUtil_8", (String)"hr-hdm-common", (Object[])new Object[0]), menuFlag), exportDataList, headDataList);
        String temp = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u7ed3\u679c", (String)"TransferPageUtil_8", (String)"hr-hdm-common", (Object[])new Object[0]), menuFlag);
        LOGGER.info("TransferPageUtil excel name first param:{} ,total name:{}", (Object)menuFlag, (Object)temp);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "hdm_result"));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u64cd\u4f5c\u7ed3\u679c", (String)"TransferPageUtil_9", (String)"hr-hdm-common", (Object[])new Object[0]));
        plugin.getView().showForm(formShowParameter);
    }

    public static void showSecondConfirmForDelete(AbstractBillPlugIn plugin, Map<String, List<DynamicObject>> operationResult, int successNum, int failNum, String menuFlag) {
        Map<String, List<DynamicObject>> operationResult1 = operationResult;
        List<HRExportHeadObject> headDataList = TransferPageUtil.getAuditHeadDataList();
        List<Map<String, Object>> exportDataList = TransferPageUtil.getTemplateExportDataList(operationResult1, ResManager.loadKDString((String)"\u8be5\u4eba\u5458\u8fd8\u6709\u672a\u68c0\u6d4b\u901a\u8fc7\u7684\u4fe1\u606f\u3002", (String)"TransferPageUtil_5", (String)"hr-hdm-common", (Object[])new Object[0]));
        FormShowParameter formShowParameter = TransferPageUtil.getResultPage("", String.valueOf(successNum), ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"TransferPageUtil_6", (String)"hr-hdm-common", (Object[])new Object[0]), String.valueOf(failNum), ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"TransferPageUtil_7", (String)"hr-hdm-common", (Object[])new Object[0]), String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u7ed3\u679c", (String)"TransferPageUtil_8", (String)"hr-hdm-common", (Object[])new Object[0]), menuFlag), exportDataList, headDataList);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "hdm_result"));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u64cd\u4f5c\u7ed3\u679c", (String)"TransferPageUtil_9", (String)"hr-hdm-common", (Object[])new Object[0]));
        plugin.getView().showForm(formShowParameter);
    }
}

