/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.common.util;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import org.apache.commons.lang3.time.StopWatch;

public class HRServiceUtil {
    private static final Log LOG = LogFactory.getLog(HRServiceUtil.class);

    public static List<Map<String, Long>> getHrBuByBusinessType(List<Long> adminorgIds) {
        if (ObjectUtils.isEmpty(adminorgIds)) {
            return Collections.EMPTY_LIST;
        }
        HashMap<Long, Set<Long>> param = new HashMap<Long, Set<Long>>(16);
        for (Long adminorg : adminorgIds) {
            param.put(adminorg, Collections.singleton(103010L));
        }
        List result = (List)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSStrategyService", (String)"getHrBuByBusinessType", (Object[])new Object[]{param, 1010L});
        LOG.info("getHrBuByBusinessType result :{}", (Object)result);
        if (ObjectUtils.isEmpty((Object)result)) {
            LOG.error("getHrBuByBusinessType is null, adminorgId:{}", adminorgIds);
            return Collections.EMPTY_LIST;
        }
        return result;
    }

    public static Map<String, Map<String, Object>> adminOrgInfoQuery(List<Long> adminorgIds) {
        StopWatch stopWatch = new StopWatch("adminOrgInfoQuery");
        stopWatch.start();
        if (ObjectUtils.isEmpty(adminorgIds)) {
            return Collections.EMPTY_MAP;
        }
        if (adminorgIds.size() <= 2000) {
            Map result = (Map)HRMServiceHelper.invokeHRMPService((String)"haos", (String)"IHAOSBatchAdminOrgInfoQueryService", (String)"adminOrgInfoQuery", (Object[])new Object[]{adminorgIds, new Date()});
            LOG.info("adminOrgInfoQuery result :{}", (Object)result);
            if (ObjectUtils.isEmpty((Object)result)) {
                LOG.error("adminOrgInfoQuery is null, adminorgId:{}", adminorgIds);
                return Collections.EMPTY_MAP;
            }
            stopWatch.stop();
            LOG.info("adminOrgInfoQuery finish ,cost time :{}", (Object)stopWatch.getNanoTime());
            return result;
        }
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        List adminorgIdsList = Lists.partition(adminorgIds, (int)2000);
        for (List adminorgIdList : adminorgIdsList) {
            Map partionResult = (Map)HRMServiceHelper.invokeHRMPService((String)"haos", (String)"IHAOSBatchAdminOrgInfoQueryService", (String)"adminOrgInfoQuery", (Object[])new Object[]{adminorgIdList, new Date()});
            if (ObjectUtils.isEmpty((Object)partionResult)) {
                LOG.error("adminOrgInfoQuery is null, adminorgId:{}", adminorgIds);
                continue;
            }
            result.putAll(partionResult);
        }
        stopWatch.stop();
        LOG.info("adminOrgInfoQuery finish ,cost time :{}", (Object)stopWatch.getNanoTime());
        return result;
    }

    public static Map<String, Object> getErManFileById(Long fileId) {
        List personFiles = (List)HRMServiceHelper.invokeBizService((String)"hr", (String)"hspm", (String)"IHSPMService", (String)"getCardFields", (Object[])new Object[]{Collections.singletonList(fileId)});
        if (!ObjectUtils.isEmpty((Object)personFiles)) {
            return (Map)personFiles.get(0);
        }
        return Collections.EMPTY_MAP;
    }

    public static List<Map<String, Object>> getErManFileByIds(List<Long> fileIdList) {
        List personFiles = (List)HRMServiceHelper.invokeBizService((String)"hr", (String)"hspm", (String)"IHSPMService", (String)"getCardFields", (Object[])new Object[]{fileIdList});
        if (ObjectUtils.isEmpty((Object)personFiles)) {
            return Collections.EMPTY_LIST;
        }
        return personFiles;
    }

    public static DynamicObject getPrimaryErmanFile(Long personId) {
        return (DynamicObject)HRMServiceHelper.invokeBizService((String)"hr", (String)"hspm", (String)"IHSPMService", (String)"getPrimaryErmanfFile", (Object[])new Object[]{personId});
    }

    public static Map<Long, DynamicObject> listPrimaryErmanFile(List<Long> personIds) {
        return (Map)HRMServiceHelper.invokeBizService((String)"hr", (String)"hspm", (String)"IHSPMService", (String)"listPrimaryErmanFile", (Object[])new Object[]{personIds});
    }

    public static DynamicObject[] queryPrimaryErmanFile(List<Long> employeeIdList, String selectProperties) {
        QFilter qFilters = new QFilter("employee", "in", employeeIdList).and(new QFilter("businessstatus", "=", (Object)"1")).and(new QFilter("datastatus", "=", (Object)"1")).and(new QFilter("empposrel.isprimary", "=", (Object)"1").and(new QFilter("empentrel.labrelstatusprd", "=", (Object)1010L)).and(new QFilter("iscurrentversion", "=", (Object)"1")).and(new QFilter("datastatus", "=", (Object)"1")));
        String entityName = "hspm_ermanfile";
        return (DynamicObject[])HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrpi", (String)"IHRPIPersonSyncService", (String)"listFieldsFilterInfo", (Object[])new Object[]{selectProperties, qFilters, entityName});
    }
}

