/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.common.batch;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.BeforeImportEntryEventArgs;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.importentry.resolving.ImportEntryData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.hr.hdm.business.common.batch.EntryImportController;
import kd.hr.hdm.business.domain.transfer.batchimport.TransferEntryImportDataBuilder;
import kd.hr.hdm.business.domain.transfer.entity.ValidateContext;

public abstract class CommonEntryImportEdit
extends HRCoreBaseBillEdit {
    private static final Log LOGGER = LogFactory.getLog(TransferEntryImportDataBuilder.class);
    private static final String EXCELROWINDEX = "excelRowIndex";

    public void beforeImportEntry(BeforeImportEntryEventArgs e) {
        LOGGER.info("entryimportedit beforeimportentry start");
        this.extendMethod(e);
        Map source = (Map)e.getSource();
        List entry = (List)source.get("entryentity");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        try {
            List importData = entry.stream().map(temp -> {
                JSONObject data = temp.getData();
                data.put(EXCELROWINDEX, (Object)temp.getEndIndex());
                data.put("mainbillorg", (Object)org.getLong("id"));
                return data;
            }).collect(Collectors.toList());
            Map logMap = e.getEntryDataMap();
            List entryImportWrappers = this.getEntryImportController().importEntry(importData);
            LOGGER.info("entryimportedit transfer main execute end");
            HashMap<Integer, ValidateContext> executeResult = new HashMap<Integer, ValidateContext>(16);
            entryImportWrappers.forEach(temp -> {
                if (temp.getValidateContext().getValidateResult().size() > 0) {
                    executeResult.put(temp.getJsonObject().getInteger("rowNum"), temp.getValidateContext());
                }
            });
            ImportLogger importLogger = (ImportLogger)((List)logMap.get("entryentity")).get(0);
            executeResult.forEach((excelRowIndex, value) -> {
                importLogger.log(excelRowIndex, value.compllexMap2String());
                importLogger.fail();
                importLogger.setTotal(importLogger.getTotal() + 1);
            });
            Iterator iterator = entry.iterator();
            while (iterator.hasNext()) {
                ImportEntryData entryData = (ImportEntryData)iterator.next();
                Integer rowNum = (Integer)entryData.getData().get((Object)"rowNum");
                if (executeResult.get(rowNum) == null) continue;
                iterator.remove();
            }
            LOGGER.info("entryimportedit beforeimportentry end");
        }
        catch (Exception exception) {
            LOGGER.error("entryimportedit beforeimportentry end", (Throwable)exception);
        }
    }

    protected abstract EntryImportController getEntryImportController();

    protected abstract void extendMethod(BeforeImportEntryEventArgs var1);
}

