/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.parttime.file;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListColumnConfig;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.DatePattern;
import kd.hr.hbp.common.util.DateUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.query.QueryListPlugin;
import kd.hr.hdm.business.domain.parttime.ParttimeServiceHelper;
import kd.hr.hdm.business.domain.parttime.external.IParttimePersonService;
import kd.hr.hdm.common.parttime.constants.ParttimeErmanFileConstants;

public class PartTimeFileListPlugin
extends QueryListPlugin {
    private static final String CALLBACK_ENDPARTTIMEFILE = "endparttimefile";
    private static final String KEY_ENDPARTTIME = "endparttime";

    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        List<Long> filetypeIds = this.getFiletypeId();
        QFilter filter = new QFilter("filetype", "in", filetypeIds);
        QFilter currentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter datastatusFilter = new QFilter("datastatus", "=", (Object)"1");
        QFilter islatestrecordFilter = new QFilter("hrpi_empposorgrel.islatestrecord", "=", (Object)"1");
        QFilter businessstatusFilter = new QFilter("hrpi_empposorgrel.businessstatus", "=", (Object)"1");
        QFilter empposorgrelFilter = islatestrecordFilter.or(businessstatusFilter);
        setFilterEvent.getQFilters().add(filter);
        setFilterEvent.getQFilters().add(currentVersionFilter);
        setFilterEvent.getQFilters().add(datastatusFilter);
        setFilterEvent.getQFilters().add(empposorgrelFilter);
        setFilterEvent.setOrderBy("businessstatus desc,startdate desc");
    }

    private List<Long> getFiletypeId() {
        HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper("hspm_erfiletype");
        QFilter qFilter = new QFilter("postype.postcategory", "=", (Object)1020L);
        DynamicObject[] dynamicObjects = baseServiceHelper.query(new QFilter[]{qFilter});
        return Arrays.stream(dynamicObjects).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)KEY_ENDPARTTIME)) {
            ListView listView = (ListView)this.getView();
            List<Long> selectPkIds = this.getListSelectedPkIds(listView);
            DynamicObject[] erManFiles = IParttimePersonService.getInstance().listErManFileByPkIds(selectPkIds);
            HashMap failMap = Maps.newHashMapWithExpectedSize((int)erManFiles.length);
            this.parseErManFileInfo(erManFiles, failMap);
            if (failMap.size() == selectPkIds.size()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6863\u6848\u5df2\u7ec8\u6b62\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"PartTimeFileListPlugin_1", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
            } else if (failMap.size() == 0) {
                this.showEndPartTimeFile(failMap.keySet(), selectPkIds);
            } else if (selectPkIds.size() > failMap.size()) {
                this.showConfirmDialog(selectPkIds, failMap, erManFiles);
            }
            args.setCancel(true);
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        ArrayList<String> fixedColumnList = new ArrayList<String>();
        fixedColumnList.add("person.headsculpture");
        fixedColumnList.add("name");
        fixedColumnList.add("person.name");
        List listColumns = args.getListColumns();
        List collect = listColumns.stream().map(IListColumnConfig::getListFieldKey).collect(Collectors.toList());
        fixedColumnList.stream().filter(collect::contains).forEach(column -> args.getListColumn(column).setFixed(true));
    }

    public void packageData(PackageDataEvent event) {
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)event.getSource();
        String fieldKey = columnDesc.getFieldKey();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"enddate")) {
            String dateFormat = InteServiceHelper.getDateFormat((Long)RequestContext.get().getCurrUserId());
            Date endDate = event.getRowData().getDate("enddate");
            String dateFormatted = HRDateTimeUtils.format((Date)endDate, (String)dateFormat);
            if (!ParttimeErmanFileConstants.FILTER_DATES.contains(dateFormatted)) {
                event.setFormatValue((Object)dateFormatted);
            } else {
                event.setFormatValue((Object)" ");
            }
        }
    }

    private List<Long> getListSelectedPkIds(ListView listView) {
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        ArrayList selectPkIds = Lists.newArrayListWithExpectedSize((int)selectedRows.size());
        for (ListSelectedRow selectedRow : selectedRows) {
            Long primaryKeyValue = HRJSONUtils.getLongValOfCustomParam((Object)selectedRow.getPrimaryKeyValue());
            selectPkIds.add(primaryKeyValue);
        }
        return selectPkIds;
    }

    private void parseErManFileInfo(DynamicObject[] erManFiles, Map<Long, Object> reasonMap) {
        for (DynamicObject erManFile : erManFiles) {
            String status = erManFile.getString("businessstatus");
            Long erManFileId = erManFile.getLong("id");
            if (HRStringUtils.equals((String)status, (String)"1")) continue;
            reasonMap.put(erManFileId, ResManager.loadKDString((String)"\u517c\u804c\u6863\u6848\u5df2\u5931\u6548\u3002", (String)"PartTimeFileListPlugin_2", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
        }
    }

    private void showEndPartTimeFile(Set<Long> effectPkIds, List<Long> selectIds) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("hdm_endparttime");
        formShowParameter.setCustomParam("partfilepkid", effectPkIds);
        formShowParameter.setCustomParam("selectIds", selectIds);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_ENDPARTTIMEFILE));
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getActionId().equals("hdm_endparttime")) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void showConfirmDialog(List<Long> selectPkIds, Map<Long, Object> failMap, DynamicObject[] erManFiles) {
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        String excelName = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e_\u7ec8\u6b62\u517c\u804c\u64cd\u4f5c\u53cd\u9988_%s", (String)"PartTimeFileListPlugin_6", (String)"hr-hdm-formplugin", (Object[])new Object[0]), DateUtils.dateToString((Date)new Date(), (DatePattern)DatePattern.YYYY_MM_DD_PURE));
        int failNum = failMap.size();
        params.put("sumlabel", selectPkIds.size());
        params.put("incongruentlabel", failNum);
        params.put("coincidentlabel", selectPkIds.size() - failNum);
        params.put("filename", excelName);
        Map excelHeads = ParttimeServiceHelper.getExcelHeads();
        params.put("headDataList", ParttimeServiceHelper.getExcelExportHeads((Map)excelHeads));
        params.put("exportDataList", this.buildExceportInfo(failMap, erManFiles));
        params.put("selectIds", selectPkIds);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hdm_mulconfirmendpartfile");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParams(params);
        this.getView().showForm(showParameter);
    }

    private Object buildExceportInfo(Map<Long, Object> failMap, DynamicObject[] erManFiles) {
        ArrayList exportDataList = new ArrayList(erManFiles.length);
        String success = ResManager.loadKDString((String)"\u6210\u529f", (String)"ParttimeServiceHelper_11", (String)"hr-hdm-business", (Object[])new Object[0]);
        String fail = ResManager.loadKDString((String)"\u5931\u8d25", (String)"ParttimeServiceHelper_12", (String)"hr-hdm-business", (Object[])new Object[0]);
        Map apositiontypeMap = ParttimeServiceHelper.getApositiontype();
        for (DynamicObject erManFile : erManFiles) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Long id = (Long)erManFile.get("id");
            map.put("name", erManFile.get("name"));
            map.put("worknumber", erManFile.get("number"));
            if (erManFile.getDynamicObject("empposrel.company") == null) {
                map.put("empposrel.company.name", "");
            } else {
                map.put("empposrel.company.name", erManFile.getDynamicObject("empposrel.company").getLocaleString("name").getLocaleValue());
            }
            if (erManFile.getDynamicObject("empposrel.adminorg") == null) {
                map.put("empposrel.adminorg.name", "");
            } else {
                map.put("empposrel.adminorg.name", erManFile.getDynamicObject("empposrel.adminorg").getLocaleString("name").getLocaleValue());
            }
            map.put("empposrel.apositiontype", apositiontypeMap.get(erManFile.getString("empposrel.apositiontype")));
            map.put("empposrel.position.name", erManFile.getDynamicObject("empposrel.position").getLocaleString("name").getLocaleValue());
            String stdposition = erManFile.getDynamicObject("empposrel.stdposition") == null ? "" : erManFile.getDynamicObject("empposrel.stdposition").getLocaleString("name").getLocaleValue();
            map.put("empposrel.stdposition.name", stdposition);
            String job = erManFile.getDynamicObject("empposrel.job") == null ? "" : erManFile.getDynamicObject("empposrel.job").getLocaleString("name").getLocaleValue();
            map.put("empposrel.job.name", job);
            if (failMap.containsKey(id)) {
                map.put("validate.result", fail);
                map.put("validate.description", failMap.get(id));
            } else {
                map.put("validate.result", success);
                map.put("validate.description", "");
            }
            exportDataList.add(map);
        }
        return exportDataList;
    }
}

