/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.parttime.validator;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hdm.business.common.batch.EntryImportWrapper;
import kd.hr.hdm.business.domain.parttime.batchimport.PartTimeEntryImportValidateServiceImpl;
import kd.hr.hdm.business.domain.transfer.entity.ValidateContext;
import kd.hr.hdm.formplugin.parttime.validator.ParttimeBaseValidator;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportLog;

public class BatchBusinessValidator
extends ParttimeBaseValidator {
    private static final Log LOGGER = LogFactory.getLog(BatchBusinessValidator.class);
    private Map<Integer, String> partpersonNumbers;
    private PartTimeEntryImportValidateServiceImpl service = new PartTimeEntryImportValidateServiceImpl();

    public BatchBusinessValidator(Map<Integer, String> partpersonNumbers) {
        this.partpersonNumbers = partpersonNumbers;
    }

    @Override
    public void validate(List<ImportBillData> billDataList, ImportLog importLog) {
        LOGGER.info("BatchBusinessValidator.partpersonNumbers={}", this.partpersonNumbers);
        ArrayList entryImportWrappers = new ArrayList();
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hdm_parttimebillentry");
        ArrayList entryParttimeBillList = new ArrayList(billDataList.size());
        HashMap map = new HashMap();
        billDataList.forEach(importBillData -> {
            JSONObject entry = importBillData.getData().getJSONObject("entryentity");
            JSONObject partperson = entry.getJSONObject("partperson");
            String number = partperson != null ? partperson.getString("number") : "";
            int startIndex = importBillData.getStartIndex();
            if (this.partpersonNumbers.containsKey(startIndex) && number.equals(this.partpersonNumbers.get(startIndex))) {
                return;
            }
            EntryImportWrapper entryImportWrapper = new EntryImportWrapper(entry, new ValidateContext());
            entryImportWrappers.add(entryImportWrapper);
            entryParttimeBillList.add(helper.generateEmptyDynamicObject());
            map.put(entryImportWrapper, importBillData);
        });
        List batchRegentryNumbers = CodeRuleServiceHelper.getNumbers((String)"hdm_parttimebillentry", entryParttimeBillList);
        for (int i = 0; i < entryImportWrappers.size(); ++i) {
            EntryImportWrapper entryImportWrapper2 = (EntryImportWrapper)entryImportWrappers.get(i);
            entryImportWrapper2.getJsonObject().put("ebillno", batchRegentryNumbers.get(i));
        }
        try {
            this.service.validatePartTimeRepeatByProcessStatus().test(entryImportWrappers);
            this.service.validateLicence().test(entryImportWrappers);
            this.service.crossValidateBatch().test(entryImportWrappers);
            entryImportWrappers.forEach(entryImportWrapper -> {
                if (entryImportWrapper.getValidateContext().getValidateResult().size() > 0) {
                    this.writeErrorInfo((ImportBillData)map.get(entryImportWrapper), importLog, entryImportWrapper.getValidateContext().compllexMap2StringEnter());
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("BatchBusinessValidator.validate error:", (Throwable)e);
        }
    }
}

