/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.parttime.validator;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hdm.formplugin.parttime.validator.ParttimeBaseValidator;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportLog;

public class FirstBsedAndParttimeValidator
extends ParttimeBaseValidator {
    private static final Log LOGGER = LogFactory.getLog(FirstBsedAndParttimeValidator.class);
    private Map<Integer, String> partpersonNumbers;
    private Map<String, String> apositiontypeComboMap;

    public FirstBsedAndParttimeValidator(Map<Integer, String> partpersonNumbers, Map<String, String> apositiontypeComboMap) {
        this.partpersonNumbers = partpersonNumbers;
        this.apositiontypeComboMap = apositiontypeComboMap;
    }

    @Override
    public void validate(List<ImportBillData> billDataList, ImportLog importLog) {
        HashSet<Long> positionIds = new HashSet<Long>(billDataList.size());
        HashSet<Long> jobIds = new HashSet<Long>(billDataList.size());
        HashSet<Long> stdPositionIds = new HashSet<Long>(billDataList.size());
        HashSet<Long> aadminorgIds = new HashSet<Long>(billDataList.size());
        HashMap map = new HashMap();
        billDataList.forEach(importBillData -> {
            String apositiontype;
            JSONObject data = importBillData.getData().getJSONObject("entryentity");
            JSONObject partperson = data.getJSONObject("partperson");
            String number = partperson != null ? partperson.getString("number") : "";
            int startIndex = importBillData.getStartIndex();
            if (this.partpersonNumbers.containsKey(startIndex) && number.equals(this.partpersonNumbers.get(startIndex))) {
                return;
            }
            aadminorgIds.add(data.getJSONObject("aadminorg").getLong("boid"));
            switch (apositiontype = this.apositiontypeComboMap.get(data.getString("apositiontype"))) {
                case "0": {
                    stdPositionIds.add(data.getJSONObject("astdposition").getLong("boid"));
                    data.put("aposition", null);
                    data.put("bjob", null);
                    break;
                }
                case "1": {
                    positionIds.add(data.getJSONObject("aposition").getLong("boid"));
                    data.put("astdposition", null);
                    data.put("bjob", null);
                    break;
                }
                case "2": {
                    jobIds.add(data.getJSONObject("bjob").getLong("boid"));
                    data.put("aposition", null);
                    data.put("astdposition", null);
                    break;
                }
            }
            List dataValidateList = map.getOrDefault(apositiontype, new ArrayList());
            dataValidateList.add(importBillData);
            map.put(apositiontype, dataValidateList);
        });
        List<ImportBillData> collect = map.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        this.validateEffectiveDate(aadminorgIds, "haos_adminorghr", "aadminorg", collect, importLog);
        this.validateEffectiveDate(positionIds, "hbpm_positionhr", "aposition", map.getOrDefault("1", new ArrayList()), importLog);
        this.validateEffectiveDate(stdPositionIds, "hbpm_stposition", "astdposition", map.getOrDefault("0", new ArrayList()), importLog);
        this.validateEffectiveDate(jobIds, "hbjm_jobhr", "bjob", map.getOrDefault("2", new ArrayList()), importLog);
    }

    private void validateEffectiveDate(Set<Long> ids, String entityName, String field, List<ImportBillData> dataValidates, ImportLog importLog) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        String selectField = "id,boid,firstbsed";
        if ("aposition".equals(field)) {
            selectField = "id,boid,firstbsed,adminorg.boid";
        }
        DynamicObjectCollection dys = ORM.create().query(entityName, selectField, new QFilter("id", "in", ids).toArray());
        Map hisMap = dys.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("boid"), Function.identity()));
        dataValidates.forEach(importBillData -> {
            JSONObject data = importBillData.getData().getJSONObject("entryentity");
            long boid = data.getJSONObject(field).getLong("boid");
            Date firstbsed = ((DynamicObject)hisMap.get(boid)).getDate("firstbsed");
            Date effectDate = data.getDate("effectdate");
            if (firstbsed != null && firstbsed.after(effectDate)) {
                String errorMsg = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u5f53\u524d\u6240\u9009\u7684%1$s\u7684\u751f\u6548\u65e5\u671f\u665a\u4e8e%2$s\u3002", (String)"ErmanfileValidator_1", (String)"hr-hdm-formplugin", (Object[])new Object[]{data.getJSONObject(field).getString("number"), HRDateTimeUtils.format((Date)effectDate, (String)"yyyy-MM-dd")});
                this.writeErrorInfo((ImportBillData)importBillData, importLog, errorMsg);
            }
            if ("aposition".equals(field)) {
                long adminOrgId = data.getJSONObject("aadminorg").getLongValue("boid");
                long positionAdminOrgId = ((DynamicObject)hisMap.get(boid)).getLong("adminorg.boid");
                LOGGER.info("PartBillPChValidator positionAdminOrgId={}, adminOrgId={}", (Object)positionAdminOrgId, (Object)adminOrgId);
                if (positionAdminOrgId != adminOrgId) {
                    this.writeErrorInfo((ImportBillData)importBillData, importLog, ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u8be5\u517c\u804c\u5c97\u4f4d\u6240\u5c5e\u884c\u653f\u7ec4\u7ec7\u4e0e\u517c\u804c\u90e8\u95e8\u4e0d\u4e00\u81f4\u3002", (String)"FirstBsedAndParttimeValidator_1", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                }
            }
        });
    }
}

