/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.parttime.validator;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.formplugin.parttime.validator.ParttimeBaseValidator;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportLog;

public class MainAndPartPositionTypeValidator
extends ParttimeBaseValidator {
    private static final Log LOGGER = LogFactory.getLog(MainAndPartPositionTypeValidator.class);
    private Map<Integer, String> partpersonNumbers;
    private Map<String, String> apositiontypeComboMap;

    public MainAndPartPositionTypeValidator(Map<Integer, String> partpersonNumbers, Map<String, String> apositiontypeComboMap) {
        this.partpersonNumbers = partpersonNumbers;
        this.apositiontypeComboMap = apositiontypeComboMap;
    }

    @Override
    public void validate(List<ImportBillData> billDataList, ImportLog importLog) {
        billDataList.forEach(importBillData -> {
            long jobId;
            JSONObject bjob;
            long bjobId;
            JSONObject entry = importBillData.getData().getJSONObject("entryentity");
            JSONObject partperson = entry.getJSONObject("partperson");
            String number = partperson != null ? partperson.getString("number") : "";
            int startIndex = importBillData.getStartIndex();
            if (this.partpersonNumbers.containsKey(startIndex) && number.equals(this.partpersonNumbers.get(startIndex))) {
                return;
            }
            String apositiontype = this.apositiontypeComboMap.get(entry.getString("apositiontype"));
            String positiontype = entry.getString("positiontype");
            long aadminorg = entry.getJSONObject("aadminorg").getLong("id");
            long adminorg = entry.getJSONObject("adminorg").getLong("id");
            if (!HRStringUtils.equals((String)apositiontype, (String)positiontype)) {
                return;
            }
            LOGGER.info("apositiontype ={}, positiontype={}", (Object)apositiontype, (Object)positiontype);
            if ("1".equals(apositiontype)) {
                long positionId;
                JSONObject aposition = entry.getJSONObject("aposition");
                long apositionId = aposition.getLongValue("boid");
                if (apositionId == (positionId = entry.getJSONObject("position").getLongValue("id"))) {
                    this.writeErrorInfo((ImportBillData)importBillData, importLog, ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u5728\u5c97\u4f4d\u201c%1$s %2$s\u201d\u4e0a\u5df2\u5b58\u5728\u4efb\u804c\uff0c\u8bf7\u4fee\u6539\u3002", (String)"MainAndPartPositionTypeValidator_0", (String)"hr-hdm-formplugin", (Object[])new Object[]{aposition.getString("number"), aposition.getString("name")}));
                }
            } else if ("0".equals(apositiontype) && aadminorg == adminorg) {
                long stdpositionId;
                JSONObject astdposition = entry.getJSONObject("astdposition");
                long astdpositionId = astdposition.getLong("boid");
                if (astdpositionId == (stdpositionId = entry.getJSONObject("stdposition").getLong("id").longValue())) {
                    this.writeErrorInfo((ImportBillData)importBillData, importLog, ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u5728\u6807\u51c6\u5c97\u4f4d\u201c%1$s %2$s\u201d\u4e0a\u5df2\u5b58\u5728\u4efb\u804c\uff0c\u8bf7\u4fee\u6539\u3002", (String)"MainAndPartPositionTypeValidator_1", (String)"hr-hdm-formplugin", (Object[])new Object[]{astdposition.getString("number"), astdposition.getString("name")}));
                }
            } else if ("2".equals(apositiontype) && aadminorg == adminorg && (bjobId = (bjob = entry.getJSONObject("bjob")).getLong("boid").longValue()) == (jobId = entry.getJSONObject("job").getLong("id").longValue())) {
                this.writeErrorInfo((ImportBillData)importBillData, importLog, ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u5728\u804c\u4f4d\u201c%1$s %2$s\u201d\u4e0a\u5df2\u5b58\u5728\u4efb\u804c\uff0c\u8bf7\u4fee\u6539\u3002", (String)"MainAndPartPositionTypeValidator_2", (String)"hr-hdm-formplugin", (Object[])new Object[]{bjob.getString("number"), bjob.getString("name")}));
            }
        });
    }
}

