/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.parttime.validator;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.formplugin.parttime.validator.ParttimeBaseValidator;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportLog;

public class PositionTypeValidator
extends ParttimeBaseValidator {
    private static final Log LOGGER = LogFactory.getLog(PositionTypeValidator.class);
    private Map<Integer, String> partpersonNumbers;
    private Map<String, String> apositiontypeComboMap;

    public PositionTypeValidator(Map<Integer, String> partpersonNumbers, Map<String, String> apositiontypeComboMap) {
        this.partpersonNumbers = partpersonNumbers;
        this.apositiontypeComboMap = apositiontypeComboMap;
    }

    @Override
    public void validate(List<ImportBillData> billDataList, ImportLog importLog) {
        billDataList.forEach(importBillData -> {
            JSONObject entry = importBillData.getData().getJSONObject("entryentity");
            JSONObject partperson = entry.getJSONObject("partperson");
            String number = partperson != null ? partperson.getString("number") : "";
            ConcurrentHashMap conMap = (ConcurrentHashMap)importLog.getRowErrors().get(importBillData.getSheetName());
            if (!HRMapUtils.isEmpty((Map)conMap) && conMap.get(importBillData.getStartIndex()) != null) {
                this.partpersonNumbers.put(importBillData.getStartIndex(), number);
                return;
            }
            String apositiontypeName = entry.getString("apositiontype");
            String apositiontype = this.apositiontypeComboMap.get(apositiontypeName);
            LOGGER.info("validatePositionType apositiontype = {}, apositiontypeName={}", (Object)apositiontype, (Object)apositiontypeName);
            if (!this.apositiontypeComboMap.containsKey(apositiontypeName)) {
                this.partpersonNumbers.put(importBillData.getStartIndex(), number);
                this.writeErrorInfo((ImportBillData)importBillData, importLog, ResManager.loadKDString((String)"\u4efb\u5c97\u6a21\u5f0f\u586b\u5199\u6709\u8bef", (String)"PositionTypeValidator_0", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                return;
            }
            String errorMsg = "";
            switch (apositiontype) {
                case "0": {
                    if (entry.get((Object)"astdposition") != null) break;
                    errorMsg = ResManager.loadKDString((String)"\u517c\u804c\u4efb\u5c97\u6a21\u5f0f\u4e3a\u6807\u51c6\u5c97\u4f4d\uff0c\u6807\u51c6\u5c97\u4f4d\u5fc5\u987b\u586b\u5199\u3002", (String)"PositionTypeValidator_1", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
                    break;
                }
                case "1": {
                    if (entry.get((Object)"aposition") != null) break;
                    errorMsg = ResManager.loadKDString((String)"\u517c\u804c\u4efb\u5c97\u6a21\u5f0f\u4e3a\u5c97\u4f4d\uff0c\u5c97\u4f4d\u5fc5\u987b\u586b\u5199\u3002", (String)"PositionTypeValidator_2", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
                    break;
                }
                case "2": {
                    if (entry.get((Object)"bjob") != null) break;
                    errorMsg = ResManager.loadKDString((String)"\u517c\u804c\u4efb\u5c97\u6a21\u5f0f\u4e3a\u804c\u4f4d\uff0c\u517c\u804c\u804c\u4f4d\u5fc5\u987b\u586b\u5199\u3002", (String)"PositionTypeValidator_3", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
                    break;
                }
            }
            LOGGER.info("validatePositionType errorMsg = {}", (Object)errorMsg);
            if (HRStringUtils.isNotEmpty((String)errorMsg)) {
                this.partpersonNumbers.put(importBillData.getStartIndex(), number);
                this.writeErrorInfo((ImportBillData)importBillData, importLog, errorMsg);
            }
        });
    }
}

