/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.parttime.web;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.util.SerializationUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hdm.business.domain.parttime.ParttimeServiceHelper;
import kd.hr.hdm.business.domain.parttime.validate.ParttimeValidateHelper;
import kd.hr.hdm.business.repository.ParttimeApplyRepository;
import kd.hr.hdm.common.parttime.entity.DataValidate;
import kd.hr.hdm.common.parttime.entity.DataValidateBuilder;
import kd.hr.hdm.common.parttime.util.ParttimeUtils;
import kd.hr.hdm.common.transfer.util.TransferPageUtil;

public class ParttimeApplyBillList
extends HRDataBaseList {
    private static final Log LOGGER = LogFactory.getLog(ParttimeApplyBillList.class);
    private static final String SELECT_FIELDS = "billno,effectdate,partperson,billstatus,auditstatus,person,apositiontype,aposition,astdposition,bjob,affaction";

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        IListView listview = (IListView)this.getView();
        long id = HRJSONUtils.getLongValOfCustomParam((Object)listview.getFocusRowPkId());
        String caption = ResManager.loadKDString((String)"\u517c\u804c\u7533\u8bf7\u5355-{0}", (String)"ParttimeApplyBillList_1", (String)"hr-hdm-formplugin", (Object[])new Object[]{this.getParttimePersonName(id)});
        TransferPageUtil.showPage((IFormView)this.getView(), (String)"hdm_parttimeapplybill", (Object)id, (String)caption, null);
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        QFilter batchParttimeFilter = new QFilter("mid", "=", (Object)0L);
        setFilterEvent.getQFilters().add(batchParttimeFilter);
        setFilterEvent.setOrderBy("effectdate DESC,auditstatus ASC");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object[] primaryKeyValues;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        OperateOption option = formOperate.getOption();
        String operateKey = formOperate.getOperateKey();
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        if ("submit".equals(operateKey) || "submiteffect".equals(operateKey)) {
            if (ParttimeValidateHelper.getCallbackCheckFlag((OperateOption)option, (String)operateKey)) {
                return;
            }
            primaryKeyValues = selectedRows.getPrimaryKeyValues();
            List billIds = Arrays.stream(primaryKeyValues).map(pk -> (Long)pk).collect(Collectors.toList());
            DynamicObject[] partBills = ParttimeApplyRepository.getInstance().queryByIds(SELECT_FIELDS, billIds);
            Set billstatusSet = Arrays.stream(partBills).map(bill -> bill.getString("billstatus")).filter(billstatus -> "A".equals(billstatus) || "G".equals(billstatus)).collect(Collectors.toSet());
            if ("submit".equals(operateKey) && !billstatusSet.contains("A") && !billstatusSet.contains("G")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u63d0\u4ea4\u5355\u636e\u72b6\u6001\u4e3a\u201c\u6682\u5b58\u201d\u201c\u5f85\u91cd\u65b0\u63d0\u4ea4\u201d\u7684\u5355\u636e\u3002", (String)"ParttimeApplyBillList_17", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if ("submiteffect".equals(operateKey) && !billstatusSet.contains("A")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u63d0\u4ea4\u5e76\u751f\u6548\u5355\u636e\u72b6\u6001\u4e3a\u201c\u6682\u5b58\u201d\u7684\u5355\u636e\u3002", (String)"ParttimeApplyBillList_18", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (selectedRows.size() == 1 && !this.validateData(partBills[0], operateKey)) {
                args.setCancel(true);
                return;
            }
        }
        if ("discard".equals(operateKey)) {
            if (option.containsVariable("batchop_completed")) {
                LOGGER.info("already process the data, then pass");
                return;
            }
            primaryKeyValues = selectedRows.getPrimaryKeyValues();
            Set failIds = ParttimeServiceHelper.validateTerminateFlow((Object[])primaryKeyValues);
            if (failIds.size() == primaryKeyValues.length) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u7ec8\u6b62\u5355\u636e\u72b6\u6001\u4e3a\u201c\u5f85\u91cd\u65b0\u63d0\u4ea4\u201d\u201c\u5df2\u63d0\u4ea4\u201d\u201c\u5ba1\u6279\u4e2d\u201d\u201c\u5ba1\u6279\u901a\u8fc7\u201d\u4e14\u517c\u804c\u6d41\u7a0b\u72b6\u6001\u4e3a\u201c\u517c\u804c\u6d41\u7a0b\u4e2d\u201d\u7684\u5355\u636e\u3002", (String)"PartBillDiscardOp_0", (String)"hr-hdm-opplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
            if (failIds.size() == 0) {
                option.setVariableValue("success", "1");
            } else {
                option.setVariableValue("failIds", SerializationUtils.toJsonString((Object)failIds));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (HRStringUtils.equals((String)"discard", (String)formOperate.getOperateKey())) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        List<String> fixedColumnList = this.initDefaultFixedColumnList();
        fixedColumnList.forEach(column -> args.getListColumn(column).setFixed(true));
    }

    public void packageData(PackageDataEvent event) {
        super.packageData(event);
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)event.getSource();
        if (HRStringUtils.equals((String)columnDesc.getFieldKey(), (String)"person.headsculpture")) {
            String photo = event.getRowData().getString("person.headsculpture");
            if (HRStringUtils.isEmpty((String)photo) || "null".equals(photo)) {
                photo = "/images/pc/emotion/default_person_82_82.png";
            }
            event.setFormatValue((Object)photo);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (this.isValidOp(callBackId) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue(callBackId, "true");
            operateOption.setVariableValue("currbizappid", this.getView().getFormShowParameter().getAppId());
            this.getView().invokeOperation(callBackId, operateOption);
        }
    }

    private String getParttimePersonName(Object billId) {
        DynamicObject bill = ParttimeApplyRepository.getInstance().queryOne("person.name", billId);
        String localePersonName = bill.getString("person.name");
        if (HRStringUtils.isEmpty((String)localePersonName)) {
            return ResManager.loadKDString((String)"\u672a\u77e5", (String)"ParttimeApplyBillList_2", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
        }
        return localePersonName;
    }

    private boolean isValidOp(String callBackId) {
        return HRStringUtils.equals((String)"save", (String)callBackId) || HRStringUtils.equals((String)"submit", (String)callBackId) || HRStringUtils.equals((String)"submiteffect", (String)callBackId);
    }

    protected List<String> initDefaultFixedColumnList() {
        ArrayList<String> fixedColumnList = new ArrayList<String>();
        fixedColumnList.add("person.headsculpture");
        fixedColumnList.add("person.name");
        return fixedColumnList;
    }

    private boolean validateData(DynamicObject partBill, String operateKey) {
        DataValidate dataValidate = DataValidateBuilder.builderSinge((Object)partBill);
        boolean validateResult = ParttimeValidateHelper.quitValidate.and(ParttimeValidateHelper.ermanfFileChangeValidate).and(ParttimeValidateHelper.crossValidate).test(dataValidate);
        if (!validateResult) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(operateKey, (IFormPlugin)this);
            ParttimeUtils.showWarnConfirmOrErrorMsg((IFormView)this.getView(), (ConfirmCallBackListener)confirmCallBacks, (DataValidate)dataValidate);
            return false;
        }
        return true;
    }
}

