/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.parttime.web;

import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;

public class ParttimeButtonEdit
extends HRCoreBaseBillEdit {
    private static final List<String> BUTTON_LIST_TEMPORARYSTORAGE_EDIT = Arrays.asList("bar_save", "bar_submit", "bar_submiteffect", "bar_close");
    private static final List<String> BUTTON_LIST_TEMPORARYSTORAGE_VIEW = Arrays.asList("bar_modify", "bar_submit", "bar_submiteffect", "bar_close");
    private static final List<String> BUTTON_LIST_TORESUBMIT_VIEW = Arrays.asList("bar_modify", "bar_submit", "bar_discard", "bar_viewflowchart", "bar_close");
    private static final List<String> BUTTON_LIST_TORESUBMIT_EDIT = Arrays.asList("bar_save", "bar_submit", "bar_close");
    private static final List<String> BUTTON_LIST_SUBMIT = Arrays.asList("bar_unsubmit", "bar_discard", "bar_viewflowchart", "bar_close");
    private static final List<String> BUTTON_LIST_TOBE_EFFECT = Arrays.asList("bar_discard", "bar_viewflowchart", "bar_close");
    private static final List<String> BUTTON_LIST_FINNISH = Arrays.asList("bar_viewflowchart", "bar_close");
    private static final List<String> BUTTON_LIST_DEFAULT = Collections.singletonList("bar_close");
    private static final List<String> BUTTON_LIST_ALL = Arrays.asList("bar_save", "bar_modify", "bar_submit", "bar_submiteffect", "bar_viewflowchart", "bar_unsubmit", "bar_discard");

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        this.setButtonVisible();
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        super.afterDoOperation(event);
        String operateKey = event.getOperateKey();
        OperationResult operationResult = event.getOperationResult();
        if ((HRStringUtils.equals((String)"bar_close", (String)operateKey) || HRStringUtils.equals((String)"bar_viewflowchart", (String)operateKey)) && !operationResult.isSuccess()) {
            return;
        }
        this.setButtonVisible();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"submiteffect")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_viewflowchart", "rightmainpanel"});
        }
    }

    private void setButtonVisible() {
        this.setAllButtonInvisible(BUTTON_LIST_ALL);
        this.partTimeBillStatusHandle();
    }

    private void partTimeBillStatusHandle() {
        String billStatus = (String)this.getModel().getValue("billstatus");
        Boolean isExistWorkFlow = (Boolean)this.getModel().getValue("isexistsworkflow");
        switch (billStatus) {
            case "A": {
                this.setTemporaryStorageButtonVisibility();
                break;
            }
            case "B": 
            case "D": {
                this.setAllButtonVisible(BUTTON_LIST_SUBMIT);
                break;
            }
            case "G": {
                this.setReSubmitButtonVisibility();
                break;
            }
            case "C": {
                this.setAuditedButtonVisibility();
                this.getView().setVisible(isExistWorkFlow, new String[]{"bar_viewflowchart"});
                break;
            }
            case "E": 
            case "F": {
                this.setAllButtonVisible(BUTTON_LIST_FINNISH);
                break;
            }
            default: {
                this.setAllButtonVisible(BUTTON_LIST_DEFAULT);
            }
        }
    }

    private void setTemporaryStorageButtonVisibility() {
        OperationStatus formStatus = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.VIEW == formStatus) {
            this.setAllButtonVisible(BUTTON_LIST_TEMPORARYSTORAGE_VIEW);
        } else {
            this.setAllButtonVisible(BUTTON_LIST_TEMPORARYSTORAGE_EDIT);
        }
    }

    private void setAuditedButtonVisibility() {
        String partTimeStatus = (String)this.getModel().getValue("parttimestatus");
        if (StringUtils.equals((CharSequence)partTimeStatus, (CharSequence)"0")) {
            this.setAllButtonVisible(BUTTON_LIST_TOBE_EFFECT);
        } else {
            this.setAllButtonVisible(BUTTON_LIST_FINNISH);
        }
    }

    private void setReSubmitButtonVisibility() {
        OperationStatus formStatus = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.VIEW == formStatus) {
            this.setAllButtonVisible(BUTTON_LIST_TORESUBMIT_VIEW);
            ((IBillView)this.getView()).setBillStatus(BillOperationStatus.VIEW);
        } else {
            this.setAllButtonVisible(BUTTON_LIST_TORESUBMIT_EDIT);
        }
    }

    private void setAllButtonInvisible(List<String> buttonList) {
        buttonList.stream().forEach(button -> this.getView().setVisible(Boolean.FALSE, new String[]{button}));
    }

    private void setAllButtonVisible(List<String> buttonList) {
        buttonList.stream().forEach(button -> this.getView().setVisible(Boolean.TRUE, new String[]{button}));
    }
}

