/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.parttime.web.batch;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.application.transfer.service.ITransferBillApplicationService;
import kd.hr.hdm.business.common.SihcConfigUtil;
import kd.hr.hdm.business.domain.service.hspm.IHSPMService;
import kd.hr.hdm.business.personnelchange.servicehelper.PersonnelChangeServiceHelper;
import kd.hr.hdm.formplugin.parttime.validator.BatchBusinessValidator;
import kd.hr.hdm.formplugin.parttime.validator.ErmanfileValidator;
import kd.hr.hdm.formplugin.parttime.validator.FirstBsedAndParttimeValidator;
import kd.hr.hdm.formplugin.parttime.validator.MainAndPartPositionTypeValidator;
import kd.hr.hdm.formplugin.parttime.validator.PositionTypeValidator;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hrmp.hies.entry.common.enu.EntryValidatorEnum;
import kd.hrmp.hies.entry.common.plugin.impt.BeforeBackFillDataEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.BeforeInitValidatorEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.BeforeQueryRefBdEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.HREntryImportPlugin;
import kd.hrmp.hies.entry.core.validate.AbstractEntryValidateHandler;
import kd.sdk.hr.importutil.MethodUtil;

public class BatchPartTimeEntryImportHREdit
implements HREntryImportPlugin {
    public void beforeQueryRefBd(BeforeQueryRefBdEventArgs args) {
        if ("partperson".equals(args.getFieldId()) && "hspm_ermanfile".equals(args.getBaseDataName())) {
            if (!args.isImportInvoke()) {
                return;
            }
            QFilter[] filters = args.getFilters();
            ArrayList<QFilter> filterList = new ArrayList<QFilter>(filters.length);
            for (QFilter filter : filters) {
                filterList.add(filter);
            }
            args.setFilters(filterList.toArray(new QFilter[0]));
            ArrayList empNumberList = new ArrayList(args.getBillDataList().size());
            args.getBillDataList().forEach(data -> {
                JSONObject jsonObject = data.getData().getJSONObject(args.getEntryKey()).getJSONObject("partperson");
                if (jsonObject != null && jsonObject.containsKey((Object)"number")) {
                    empNumberList.add(jsonObject.getString("number"));
                }
            });
            DynamicObject[] dynamicObjects = IHSPMService.getInstance().listPrimaryErManFilesByEmpNumber(empNumberList);
            Set ermanfileIds = Arrays.stream(dynamicObjects).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
            filterList.add(new QFilter("id", "in", ermanfileIds));
            args.setFilters(filterList.toArray(new QFilter[0]));
        } else if ("affaction".equals(args.getFieldId()) && "hpfs_chgaction".equals(args.getBaseDataName())) {
            List affactionIds = PersonnelChangeServiceHelper.getAffactionMapByBusinessKey((String)"hdm_parttime_hpfs_new", (String)"hdm_parttimeapplybill");
            args.setFilters(new QFilter("id", "in", (Object)affactionIds).toArray());
        }
    }

    public void beforeInitValidator(BeforeInitValidatorEventArgs args) {
        long orgId = ((DynamicObject)args.getDataModel().getValue("org")).getLong("id");
        Map apositiontypeComboMap = MethodUtil.getComboValueKey((String)"hdm_batchparttime", (String)"apositiontype");
        HashMap<Integer, String> partpersonNumbers = new HashMap<Integer, String>();
        args.setValidator(EntryValidatorEnum.CUSTOM_VALIDATOR, (AbstractEntryValidateHandler)new PositionTypeValidator(partpersonNumbers, apositiontypeComboMap));
        args.setValidator(EntryValidatorEnum.CUSTOM_VALIDATOR, (AbstractEntryValidateHandler)new ErmanfileValidator(partpersonNumbers, orgId));
        args.setValidator(EntryValidatorEnum.CUSTOM_VALIDATOR, (AbstractEntryValidateHandler)new FirstBsedAndParttimeValidator(partpersonNumbers, apositiontypeComboMap));
        args.setValidator(EntryValidatorEnum.CUSTOM_VALIDATOR, (AbstractEntryValidateHandler)new MainAndPartPositionTypeValidator(partpersonNumbers, apositiontypeComboMap));
        args.setValidator(EntryValidatorEnum.CUSTOM_VALIDATOR, (AbstractEntryValidateHandler)new BatchBusinessValidator(partpersonNumbers));
    }

    public void beforeBackFillData(BeforeBackFillDataEventArgs args) {
        boolean enableSihc = SihcConfigUtil.enableSihc();
        Map comboKeyValue = MethodUtil.getComboKeyValue((String)"hdm_batchparttime", (String)"positiontype");
        for (ImportBillData data : args.getRowData()) {
            String appDispatchNum;
            JSONObject entry = data.getData().getJSONObject("entryentity");
            String positiontype = entry.getString("positiontype");
            entry.put("positiontype", comboKeyValue.get(positiontype));
            if (!enableSihc || HRStringUtils.isBlank((CharSequence)(appDispatchNum = entry.getString("appdispatchnum")))) continue;
            Long employeeId = entry.getJSONObject("primaryemployee").getLong("id");
            DynamicObject appointRemoveRelObj = ITransferBillApplicationService.getInstance().getAppointRemoveRelObj(appDispatchNum, employeeId.longValue());
            if (HRObjectUtils.isEmpty((Object)appointRemoveRelObj)) continue;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("importprop", (Object)"id");
            jsonObject.put("id", (Object)appointRemoveRelObj.getLong("id"));
            entry.put("appremoverel", (Object)jsonObject);
        }
    }
}

