/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.parttime.web.batch;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.hr.hdm.common.transfer.util.TransferJudgementUtil;

public class BatchParttimeButtonEdit
extends HRCoreBaseBillEdit {
    private static final String BAR_MODIFY = "barmodify";
    private static final String BAR_SUBMITEFFECT = "bar_submiteffect";
    private static final String BAR_NEWENTRY = "newentry";
    private static final String BAR_DELETEENTRY = "deleteentry";
    private static final String BAR_TERMINATE = "bar_terminate";
    private static final List<String> BUTTON_LIST_ALL = Arrays.asList("newentry", "deleteentry", "barmodify", "bar_submiteffect", "bar_save", "bar_submit", "bar_unsubmit", "donothing_close", "bar_termination", "bar_viewflowchart", "bar_terminate");
    private static final List<String> BUTTON_LIST_ADD_ADDNEW = Arrays.asList("newentry", "deleteentry", "bar_save", "donothing_close");
    private static final List<String> BUTTON_LIST_ADD_VIEW = Arrays.asList("barmodify", "bar_submit", "bar_submiteffect", "donothing_close");
    private static final List<String> BUTTON_LIST_ADD_EDIT = Arrays.asList("newentry", "deleteentry", "bar_save", "donothing_close");
    private static final List<String> BUTTON_LIST_SUBMIT = Arrays.asList("bar_unsubmit", "donothing_close", "bar_termination", "bar_viewflowchart", "bar_terminate");
    private static final List<String> BUTTON_LIST_TO_RESUBMIT = Arrays.asList("barmodify", "bar_submit", "donothing_close", "bar_terminate");
    private static final List<String> BUTTON_LIST_TO_RESUBMIT_EDIT = Arrays.asList("bar_save", "donothing_close");
    private static final List<String> BUTTON_LIST_AUDITING = Arrays.asList("bar_unsubmit", "bar_termination", "bar_viewflowchart", "donothing_close", "bar_terminate");
    private static final List<String> BUTTON_LIST_AUDITED = Arrays.asList("donothing_close", "bar_viewflowchart");
    private static final List<String> BUTTON_LIST_REJECTED = Arrays.asList("donothing_close", "bar_viewflowchart");
    private static final List<String> BUTTON_LIST_ABANDON = Arrays.asList("donothing_close", "bar_viewflowchart");

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        this.setButtonVisible();
    }

    private void setButtonVisible() {
        this.setAllButtonInvisible(BUTTON_LIST_ALL);
        this.BillStatusHandle();
    }

    private void BillStatusHandle() {
        String billStatus = (String)this.getModel().getValue("billstatus");
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        switch (billStatus) {
            case "A": {
                if (TransferJudgementUtil.ADDNEW.test(operationStatus)) {
                    this.setAllButtonVisible(BUTTON_LIST_ADD_ADDNEW);
                    break;
                }
                if (TransferJudgementUtil.VIEW.test(operationStatus)) {
                    this.setAllButtonVisible(BUTTON_LIST_ADD_VIEW);
                    break;
                }
                this.setAllButtonVisible(BUTTON_LIST_ADD_EDIT);
                break;
            }
            case "B": {
                this.setAllButtonVisible(BUTTON_LIST_SUBMIT);
                break;
            }
            case "G": {
                if (TransferJudgementUtil.EDIT.test(operationStatus)) {
                    this.setAllButtonVisible(BUTTON_LIST_TO_RESUBMIT_EDIT);
                    break;
                }
                this.setAllButtonVisible(BUTTON_LIST_TO_RESUBMIT);
                break;
            }
            case "D": {
                this.setAllButtonVisible(BUTTON_LIST_AUDITING);
                break;
            }
            case "C": {
                this.setAllButtonVisible(BUTTON_LIST_AUDITED);
                this.setTerminateButton();
                break;
            }
            case "E": {
                this.setAllButtonVisible(BUTTON_LIST_REJECTED);
                break;
            }
            case "F": {
                this.setAllButtonVisible(BUTTON_LIST_ABANDON);
                break;
            }
        }
    }

    private void setTerminateButton() {
        DynamicObjectCollection entryentities = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        Optional<DynamicObject> any = entryentities.stream().filter(dy -> "0".equals(dy.getString("parttimestatus"))).findAny();
        if (any.isPresent()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{BAR_TERMINATE});
        }
    }

    private void setAllButtonInvisible(List<String> buttonList) {
        buttonList.stream().forEach(button -> this.getView().setVisible(Boolean.FALSE, new String[]{button}));
    }

    private void setAllButtonVisible(List<String> buttonList) {
        buttonList.stream().forEach(button -> this.getView().setVisible(Boolean.TRUE, new String[]{button}));
    }
}

