/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.parttime.web.batch;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.control.LabelAp;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.hr.hdm.business.domain.parttime.service.IParttimeBillService;
import kd.hr.hdm.business.domain.parttime.validate.BatchParttimeValidateHelper;
import kd.hr.hdm.business.domain.parttime.validate.ParttimeValidateHelper;
import kd.hr.hdm.common.parttime.entity.DataValidateBuilder;
import kd.hr.hdm.common.transfer.enums.TransferOperateTypeEnum;
import kd.hr.hdm.common.transfer.util.TransferCommonUtil;
import kd.hr.hdm.common.transfer.util.TransferJudgementUtil;
import kd.hr.hdm.common.transfer.util.TransferPageUtil;
import kd.hr.hdm.formplugin.reg.web.tools.RegBillDrawLabelUtil;
import org.apache.commons.lang3.time.StopWatch;

public class BatchParttimeEdit
extends HRCoreBaseBillEdit {
    private static final Log LOGGER = LogFactory.getLog(ParttimeValidateHelper.class);
    private static final String LBL_BILLNO = "lblbillnoedit";
    private static final String LBL_CREATOR = "lblcreatoredit";
    private static final String LBL_CREATETIME = "lblcreatetimeedit";
    private static final String LBL_BIILLSTATUS = "lblbiillstatus";

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        TransferPageUtil.setLblText((IFormView)view, (String)LBL_BILLNO, (String)((String)model.getValue("billno")));
        TransferPageUtil.setLblText((IFormView)view, (String)LBL_CREATOR, (String)((DynamicObject)model.getValue("creator")).getString("name"));
        TransferPageUtil.setLblText((IFormView)view, (String)LBL_CREATETIME, (String)HRDateTimeUtils.format((Date)((Date)model.getValue("createtime")), (String)"yyyy-MM-dd"));
        if (TransferJudgementUtil.ADDNEW.test(view.getFormShowParameter().getStatus())) {
            view.setVisible(Boolean.FALSE, new String[]{LBL_BIILLSTATUS});
        } else {
            view.setVisible(Boolean.TRUE, new String[]{LBL_BIILLSTATUS});
        }
        this.setAuditStatusLabelWithColorful((String)this.getModel().getValue("billstatus"));
        this.setAuditPanelVisible(this.getModel(), this.getView());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String auditstatus = (String)this.getModel().getValue("auditstatus");
        if ("F".equals(auditstatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"fieldsetpanelap"});
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("afterconfirm", "true");
            operateOption.setVariableValue("currbizappid", this.getView().getFormShowParameter().getAppId());
            this.getView().invokeOperation(messageBoxClosedEvent.getCallBackId(), operateOption);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "save": {
                this.beforeSaveAndSubmitValidate(args, TransferOperateTypeEnum.SAVE);
                break;
            }
            case "submit": {
                this.beforeSaveAndSubmitValidate(args, TransferOperateTypeEnum.SUBMIT);
                break;
            }
            case "submiteffect": {
                this.beforeSaveAndSubmitValidate(args, TransferOperateTypeEnum.SUBMITEFFECT);
                break;
            }
            case "unsubmit": {
                IParttimeBillService.getInstance().beforeValidateUnSubmit((AbstractFormPlugin)this, args, this.getModel().getDataEntity().getString("billstatus"));
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) {
            return;
        }
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"save") || HRStringUtils.equals((String)operateKey, (String)"submit") || HRStringUtils.equals((String)operateKey, (String)"submiteffect") || HRStringUtils.equals((String)operateKey, (String)"unsubmit")) {
            this.getView().setStatus(OperationStatus.VIEW);
            this.getView().invokeOperation("refresh");
        }
    }

    private void beforeSaveAndSubmitValidate(BeforeDoOperationEventArgs args, TransferOperateTypeEnum operateTypeEnum) {
        String billstatus;
        if (TransferOperateTypeEnum.SUBMIT == operateTypeEnum && !"A".equals(billstatus = (String)this.getModel().getValue("billstatus")) && !"G".equals(billstatus)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u63d0\u4ea4\u5355\u636e\u72b6\u6001\u4e3a\u201c\u6682\u5b58\u201d\u201c\u5f85\u91cd\u65b0\u63d0\u4ea4\u201d\u7684\u5355\u636e\u3002", (String)"BatchParttimeList_3", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (TransferOperateTypeEnum.SUBMITEFFECT == operateTypeEnum && !"A".equals(billstatus = (String)this.getModel().getValue("billstatus"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u63d0\u4ea4\u5e76\u751f\u6548\u5355\u636e\u72b6\u6001\u4e3a\u201c\u6682\u5b58\u201d\u7684\u5355\u636e\u3002", (String)"BatchParttimeList_2", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        ArrayList entryData = Lists.newArrayList((Iterable)this.getModel().getEntryEntity("entryentity"));
        if (entryData.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u517c\u804c\u4eba\u5458\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u53d1\u8d77\u6279\u91cf\u517c\u804c\u7533\u8bf7\u65f6\u81f3\u5c11\u5b58\u5728\u4e00\u884c\u5b8c\u6574\u7684\u517c\u804c\u4eba\u5458\u4fe1\u606f\u3002", (String)"BatchParttimeEdit_0", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        StopWatch stopWatch = new StopWatch("builderCollection");
        stopWatch.start();
        List dataValidates = DataValidateBuilder.builderCollection((List)entryData);
        stopWatch.stop();
        LOGGER.info("builderCollection finish ,cost time :{}", (Object)stopWatch.getNanoTime());
        BatchParttimeValidateHelper.getInstance().saveValidate(this.getModel().getDataEntity(), dataValidates);
        StopWatch buildOperateInfoByValResult = new StopWatch("buildOperateInfoByValResult");
        buildOperateInfoByValResult.start();
        Map valResult = BatchParttimeValidateHelper.getInstance().buildOperateInfoByValResult(dataValidates, operateTypeEnum);
        if ((Integer)valResult.get("failperson") != 0) {
            TransferPageUtil.showFormViewOfModal((IFormView)this.getView(), (String)"hdm_parttimeoperateresult", (Map)valResult);
            args.setCancel(true);
            return;
        }
        buildOperateInfoByValResult.stop();
        LOGGER.info("buildOperateInfoByValResult finish ,cost time :{}", (Object)buildOperateInfoByValResult.getNanoTime());
        BatchParttimeValidateHelper.validateAffiliationOrg((BeforeDoOperationEventArgs)args, (AbstractFormPlugin)this, (DynamicObject)this.getModel().getDataEntity(), (List)this.getModel().getEntryEntity("entryentity"));
    }

    private void setAuditStatusLabelWithColorful(String labelValue) {
        LabelAp statusLabel = RegBillDrawLabelUtil.setAuditStatusLabelWithColorful(LBL_BIILLSTATUS, labelValue);
        this.getView().updateControlMetadata(statusLabel.getKey(), statusLabel.createControl());
        if (TransferJudgementUtil.VIEW.test(this.getView().getFormShowParameter().getStatus())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{statusLabel.getKey()});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{statusLabel.getKey()});
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"lbregstatus"});
    }

    private void setAuditPanelVisible(IDataModel model, IFormView view) {
        if (((Boolean)model.getValue("issubmit")).booleanValue() && !TransferCommonUtil.isAuditView((IFormView)this.getView())) {
            view.setVisible(Boolean.TRUE, new String[]{"rightmainpanel"});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"rightmainpanel"});
        }
    }
}

