/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.parttime.web.batch;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.DateUtils;
import kd.bos.mvc.bill.BillViewForWebApi;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.util.SerializationUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.hr.hdm.business.application.transfer.service.ITransferBillApplicationService;
import kd.hr.hdm.business.common.HPFSTemplatePropertyHandler;
import kd.hr.hdm.business.common.SihcConfigUtil;
import kd.hr.hdm.business.domain.parttime.ParttimeServiceHelper;
import kd.hr.hdm.business.domain.parttime.external.IParttimeAdminOrgExternalService;
import kd.hr.hdm.business.domain.parttime.external.IParttimePersonService;
import kd.hr.hdm.business.domain.parttime.service.IParttimeBillService;
import kd.hr.hdm.business.domain.parttime.service.impl.helper.DirectLeaderHelper;
import kd.hr.hdm.business.personnelchange.servicehelper.PersonnelChangeServiceHelper;
import kd.hr.hdm.common.parttime.enums.PosTypeEnum;

public class BatchParttimeEntryEdit
extends HRCoreBaseBillEdit
implements BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(BatchParttimeEntryEdit.class);
    private static final String HRCS = "hrcs";
    private static final String IHRCS_PERM_SERVICE = "IHRCSBizDataPermissionService";
    private static final String AADMINORG = "aadminorg";
    private static final String EFFECTDATE = "effectdate";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BasedataEdit aadminorg = (BasedataEdit)this.getView().getControl(AADMINORG);
        aadminorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit positionF7 = (BasedataEdit)this.getView().getControl("aposition");
        positionF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit stdPositionF7 = (BasedataEdit)this.getView().getControl("astdposition");
        stdPositionF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit hisJob = (BasedataEdit)this.getView().getControl("bjob");
        hisJob.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit affaction = (BasedataEdit)this.getView().getControl("affaction");
        affaction.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        List fieldEdits = entryGrid.getFieldEdits();
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        DynamicObjectCollection entryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        if (!entryentity.isEmpty()) {
            for (int rowIndex = 0; rowIndex < entryentity.size(); ++rowIndex) {
                String apositiontype = ((DynamicObject)entryentity.get(rowIndex)).getString("apositiontype");
                this.setPostionStdPositionAndJobEnable(apositiontype, rowIndex);
            }
        }
        boolean visible = !status.equals((Object)OperationStatus.ADDNEW) && !status.equals((Object)OperationStatus.EDIT);
        for (FieldEdit fieldEdit : fieldEdits) {
            String fieldKey = fieldEdit.getFieldKey();
            if (!fieldKey.equals("parttimestatus")) continue;
            fieldEdit.setVisible("parttimestatus", visible);
        }
        List orgDesignIdList = IParttimeAdminOrgExternalService.getInstance().invokeGetEntityDimValue(new Object[]{RequestContext.get().getCurrUserId(), "1WX49GDDDZ0V", "hdm_batchparttime", "47150e89000000ac", "orgdesign"});
        this.getPageCache().put("orgDesignIdList", SerializationUtils.toJsonString((Object)orgDesignIdList));
    }

    public void propertyChanged(PropertyChangedArgs args) {
        if (this.getView() instanceof BillViewForWebApi && ((Boolean)Optional.ofNullable(this.getModel().getContextVariable("IGNORE_RELOADDATAMODEL")).orElse(Boolean.FALSE)).booleanValue()) {
            return;
        }
        String propertyName = args.getProperty().getName();
        ChangeData[] changeDataArray = args.getChangeSet();
        ChangeData changeData = changeDataArray[0];
        int rowIndex = changeData.getRowIndex();
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        if (dynamicObjectCollection.isEmpty() || rowIndex < 0) {
            return;
        }
        DynamicObject entryDy = (DynamicObject)dynamicObjectCollection.get(rowIndex);
        switch (propertyName) {
            case "aadminorg": {
                this.dealAadminorgChange(changeData, rowIndex, entryDy);
                break;
            }
            case "apositiontype": {
                this.clearAndSetPostionStdPositionAndJob(changeData, rowIndex, entryDy);
                break;
            }
            case "aposition": {
                this.dealPositionChange(entryDy, changeData, rowIndex);
                break;
            }
            case "astdposition": {
                this.dealStdPositionChange(changeData, rowIndex);
                break;
            }
            case "effectdate": {
                this.changeVersionApositionAndJobValue(rowIndex, entryDy);
                break;
            }
            case "appdispatchnum": {
                this.changeAppDispatchNum(rowIndex, entryDy);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        switch (key = evt.getProperty().getName()) {
            case "aadminorg": {
                break;
            }
            case "aposition": {
                int rowIndex = evt.getRow();
                DynamicObject dynamicObject = (DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").get(rowIndex);
                Date effectdate = this.getEffectdate(dynamicObject);
                long adminorg = dynamicObject.getLong("aadminorg.boid");
                String positiontype = dynamicObject.getString("positiontype");
                DynamicObject primaryPosition = dynamicObject.getDynamicObject("position");
                List customQFilters = evt.getCustomQFilters();
                if (adminorg > 0L) {
                    customQFilters.add(new QFilter("adminorg", "=", (Object)adminorg));
                }
                if (primaryPosition != null && PosTypeEnum.POS.getCode().equals(positiontype)) {
                    customQFilters.add(new QFilter("boid", "!=", (Object)primaryPosition.getLong("boid")));
                }
                customQFilters.add(new QFilter("bsed", "<=", (Object)effectdate));
                customQFilters.add(new QFilter("bsled", ">=", (Object)effectdate));
                evt.getFormShowParameter().getCustomParams().put(EFFECTDATE, effectdate);
                break;
            }
            case "bjob": {
                this.setHrJobFilter(evt);
                break;
            }
            case "astdposition": {
                this.setStdPostionFilter(evt);
                break;
            }
            case "affaction": {
                boolean isnewchgaction = HPFSTemplatePropertyHandler.isNewChgAction((String)"hdm_parttime_hpfs_new");
                List affactionIds = PersonnelChangeServiceHelper.getAffactionMapByBusinessKey((String)"hdm_parttime_hpfs_new", (String)"hdm_parttimeapplybill");
                evt.getFormShowParameter().setCustomParam("businessvalue", (Object)(isnewchgaction ? "1" : "0"));
                evt.getCustomQFilters().add(new QFilter("id", "in", (Object)affactionIds));
                break;
            }
        }
    }

    private void dealAadminorgChange(ChangeData changeData, int rowIndex, DynamicObject entryDy) {
        DynamicObject newValue = (DynamicObject)changeData.getNewValue();
        String partApositiontype = entryDy.getString("apositiontype");
        if (newValue == null) {
            this.getModel().setValue("acompany", null, rowIndex);
            if (PosTypeEnum.POS.getCode().equals(partApositiontype)) {
                this.getModel().setValue("aposition", null, rowIndex);
                this.getModel().setValue("bjob", null, rowIndex);
            }
            return;
        }
        DynamicObject company = newValue.getDynamicObject("company");
        this.getModel().setValue("acompany", (Object)company, rowIndex);
        String mainPositiontype = entryDy.getString("positiontype");
        if (PosTypeEnum.JOB.getCode().equals(partApositiontype) && PosTypeEnum.JOB.getCode().equals(mainPositiontype) && newValue.getLong("boid") == entryDy.getLong("adminorg.boid") && entryDy.getLong("bjob.boid") == entryDy.getLong("job.boid")) {
            this.getModel().setValue("bjob", null, rowIndex);
        } else if (PosTypeEnum.STD_POS.getCode().equals(partApositiontype) && PosTypeEnum.STD_POS.getCode().equals(mainPositiontype) && newValue.getLong("boid") == entryDy.getLong("adminorg.boid") && entryDy.getLong("astdposition.boid") == entryDy.getLong("stdposition.boid")) {
            this.getModel().setValue("astdposition", null, rowIndex);
        }
        if (PosTypeEnum.STD_POS.getCode().equals(partApositiontype)) {
            this.setAdminOrgAndSuperior(entryDy, rowIndex);
        } else if (!PosTypeEnum.POS.getCode().equals(partApositiontype)) {
            this.getModel().setValue("asuperior", null, rowIndex);
        }
        if (entryDy.getDynamicObject("aposition") != null && entryDy.getLong("aposition.adminorg.id") != newValue.getLong("id")) {
            this.getModel().setValue("aposition", null, rowIndex);
        }
    }

    private void setStdPostionFilter(BeforeF7SelectEvent evt) {
        DynamicObject entry = (DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").get(evt.getRow());
        Date effectdate = this.getEffectdate(entry);
        List customQFilters = evt.getCustomQFilters();
        String positiontype = entry.getString("positiontype");
        if (PosTypeEnum.STD_POS.getCode().equals(positiontype)) {
            long partAdminorg = entry.getLong("aadminorg.boid");
            long mainAdminorg = entry.getLong("adminorg.boid");
            DynamicObject mainStdPosition = entry.getDynamicObject("stdposition");
            if (partAdminorg == mainAdminorg && mainStdPosition != null) {
                customQFilters.add(new QFilter("boid", "!=", (Object)mainStdPosition.getLong("boid")));
            }
        }
        customQFilters.add(new QFilter("bsed", "<=", (Object)effectdate));
        customQFilters.add(new QFilter("bsled", ">=", (Object)effectdate));
        evt.getFormShowParameter().getCustomParams().put(EFFECTDATE, effectdate);
    }

    private Date getEffectdate(DynamicObject entry) {
        Date effectdate = entry.getDate(EFFECTDATE);
        if (effectdate == null) {
            effectdate = new Date();
        }
        return effectdate;
    }

    private void setHrJobFilter(BeforeF7SelectEvent evt) {
        long mainAdminorg;
        DynamicObject entry = (DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").get(evt.getRow());
        Date effectdate = this.getEffectdate(entry);
        long partAdminorg = entry.getLong("aadminorg.boid");
        String positiontype = entry.getString("positiontype");
        DynamicObject job = entry.getDynamicObject("job");
        List customQFilters = evt.getCustomQFilters();
        if (PosTypeEnum.JOB.getCode().equals(positiontype) && partAdminorg == (mainAdminorg = entry.getLong("adminorg.boid")) && job != null) {
            customQFilters.add(new QFilter("boid", "!=", (Object)job.getLong("boid")));
        }
        customQFilters.add(new QFilter("bsed", "<=", (Object)effectdate));
        customQFilters.add(new QFilter("bsled", ">=", (Object)effectdate));
        evt.getFormShowParameter().getCustomParams().put(EFFECTDATE, effectdate);
    }

    private void setPostionStdPositionAndJobEnable(String apositiontype, int rowIndex) {
        if (apositiontype.equals("1")) {
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"astdposition", "bjob"});
            this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"aposition"});
        } else if (apositiontype.equals("0")) {
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"aposition", "bjob"});
            this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"astdposition"});
        } else if (apositiontype.equals("2")) {
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"aposition", "astdposition"});
            this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"bjob"});
        }
    }

    private void changeVersionApositionAndJobValue(int rowIndex, DynamicObject entryDy) {
        Map map;
        Date effectdate = entryDy.getDate(EFFECTDATE);
        if (effectdate == null) {
            return;
        }
        DynamicObject aposition = entryDy.getDynamicObject("aposition");
        DynamicObject astdposition = entryDy.getDynamicObject("astdposition");
        DynamicObject bjob = entryDy.getDynamicObject("bjob");
        String partApositiontype = entryDy.getString("apositiontype");
        if (PosTypeEnum.POS.getCode().equals(partApositiontype) && this.checkParam(aposition, effectdate)) {
            map = IParttimeBillService.getInstance().getJobHisOfPosition(Long.valueOf(aposition.getLong("boid")), effectdate);
            this.getModel().setValue("aposition", map.get("vid"), rowIndex);
            this.getModel().setValue("bjob", map.get("jobVid"), rowIndex);
        } else if (PosTypeEnum.STD_POS.getCode().equals(partApositiontype) && this.checkParam(astdposition, effectdate)) {
            map = IParttimeBillService.getInstance().getJobHisOfStdPosition(Long.valueOf(astdposition.getLong("boid")), effectdate);
            this.getModel().setValue("astdposition", map.get("vid"), rowIndex);
            this.getModel().setValue("bjob", map.get("jobVid"), rowIndex);
        } else if (PosTypeEnum.JOB.getCode().equals(partApositiontype) && this.checkParam(bjob, effectdate)) {
            Map hisJobMap = IParttimeBillService.getInstance().getNewHisJob(Long.valueOf(bjob.getLong("boid")), effectdate);
            this.getModel().setValue("bjob", hisJobMap.get("jobVid"), rowIndex);
        }
        Date startdate = entryDy.getDate("startdate");
        if (startdate == null) {
            long employeeId = entryDy.getLong("partperson.employee.id");
            Map empentrel = IParttimePersonService.getInstance().getEmpentrel(employeeId);
            if (empentrel != null) {
                startdate = (Date)empentrel.get("startdate");
                entryDy.set("startdate", (Object)startdate);
            }
        }
        Date now = HRDateTimeUtils.truncateDate((Date)new Date());
        if (HRDateTimeUtils.dayAfter((Date)startdate, (Date)effectdate)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u517c\u804c\u5f00\u59cb\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u7528\u5de5\u5f00\u59cb\u65e5\u671f\u201c{0}\u201d\u3002", (String)"BatchParttimeEntryEdit_0", (String)"hr-hdm-formplugin", (Object[])new Object[]{HRDateTimeUtils.format((Date)startdate, (String)"yyyy-MM-dd")}));
        } else if (HRDateTimeUtils.dayAfter((Date)now, (Date)effectdate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u517c\u804c\u5f00\u59cb\u65e5\u671f\u65e9\u4e8e\u5f53\u524d\u65e5\u671f\uff0c\u8bf7\u518d\u6b21\u786e\u8ba4\u3002", (String)"ParttimeApplyBillEdit_1", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean checkParam(DynamicObject aposition, Date effectdate) {
        if (aposition == null) {
            return false;
        }
        return !DateUtils.isSameDay((Date)effectdate, (Date)aposition.getDate("bsed")) && !DateUtils.isSameDay((Date)effectdate, (Date)aposition.getDate("bsled")) && (!effectdate.after(aposition.getDate("bsed")) || !effectdate.before(aposition.getDate("bsled")));
    }

    private void clearAndSetPostionStdPositionAndJob(ChangeData changeData, int rowIndex, DynamicObject entryDy) {
        String apositiontype;
        String oldValue = (String)changeData.getOldValue();
        if (HRStringUtils.equals((String)oldValue, (String)(apositiontype = (String)changeData.getNewValue()))) {
            return;
        }
        this.getModel().setValue("asuperior", null, rowIndex);
        if (apositiontype.equals("1")) {
            this.getModel().setValue("astdposition", null, rowIndex);
            this.getModel().setValue("bjob", null, rowIndex);
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"astdposition", "bjob"});
            this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"aposition"});
        } else if (apositiontype.equals("0")) {
            this.getModel().setValue("aposition", null, rowIndex);
            this.getModel().setValue("bjob", null, rowIndex);
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"aposition", "bjob"});
            this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"astdposition"});
        } else if (apositiontype.equals("2")) {
            this.getModel().setValue("aposition", null, rowIndex);
            this.getModel().setValue("astdposition", null, rowIndex);
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"aposition", "astdposition"});
            this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"bjob"});
        }
        this.setAdminOrgAndSuperior(entryDy, rowIndex);
    }

    private void dealPositionChange(DynamicObject entryDy, ChangeData changeData, int rowIndex) {
        if (this.checkPropetyValueChange(changeData, rowIndex)) {
            return;
        }
        if (entryDy.getDynamicObject(AADMINORG) == null) {
            DynamicObject aadminorg = entryDy.getDynamicObject("aposition.adminorg");
            this.getModel().setValue(AADMINORG, (Object)aadminorg, rowIndex);
        }
        Date effectdate = this.getEffectdate(entryDy);
        DynamicObject apositionNewValue = (DynamicObject)changeData.getNewValue();
        Map map = IParttimeBillService.getInstance().getJobHisOfPosition(Long.valueOf(apositionNewValue.getLong("boid")), effectdate);
        this.getModel().setValue("bjob", map.get("jobVid"), rowIndex);
        this.setAdminOrgAndSuperior(entryDy, rowIndex);
    }

    private void changeAppDispatchNum(int rowIndex, DynamicObject entryDy) {
        String appDispatchNum = entryDy.getString("appdispatchnum");
        if (HRStringUtils.isBlank((CharSequence)appDispatchNum)) {
            this.getModel().setValue("appremoverel_id", null, rowIndex);
            return;
        }
        IPageCache pageCache = this.getView().getPageCache();
        String enableSihc = pageCache.get("enableSihc");
        if (HRStringUtils.isBlank((CharSequence)enableSihc)) {
            enableSihc = SihcConfigUtil.enableSihc().toString();
            pageCache.put("enableSihc", enableSihc);
        }
        if (Boolean.TRUE.toString().equals(enableSihc)) {
            long employeeId = entryDy.getLong("partperson.employee_id");
            DynamicObject appointRemoveRelObj = ITransferBillApplicationService.getInstance().getAppointRemoveRelObj(appDispatchNum, employeeId);
            if (!HRObjectUtils.isEmpty((Object)appointRemoveRelObj)) {
                long appRemRelId = appointRemoveRelObj.getLong("id");
                if (ITransferBillApplicationService.getInstance().needConfirmAppointmentWritten()) {
                    this.getPageCache().put("appremoverel", String.valueOf(appRemRelId));
                    String tipContent = ParttimeServiceHelper.getAppDispatchNumChangeTip((DynamicObject)appointRemoveRelObj, (DynamicObject)entryDy);
                    String callBackId = HRStringUtils.format((String)"{}_{}_{}", (Object[])new Object[]{"appdispatchnum", rowIndex, appRemRelId});
                    ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener(callBackId, (IFormPlugin)this);
                    this.getView().showConfirm(tipContent, MessageBoxOptions.OKCancel, confirmCallBack);
                } else {
                    this.getModel().setValue("appremoverel_id", (Object)appRemRelId, rowIndex);
                }
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (HRStringUtils.startsWithIgnoreCase((String)callBackId, (String)"appdispatchnum")) {
            String[] callBackIdArr = callBackId.split("_");
            int rowIndex = Integer.parseInt(callBackIdArr[1]);
            long appRemRelId = Long.parseLong(callBackIdArr[2]);
            if (result.equals((Object)MessageBoxResult.Yes)) {
                this.getModel().setValue("appremoverel_id", (Object)appRemRelId, rowIndex);
            } else {
                this.getModel().setValue("appremoverel", null, rowIndex);
            }
        }
    }

    private void dealStdPositionChange(ChangeData changeData, int rowIndex) {
        if (this.checkPropetyValueChange(changeData, rowIndex)) {
            return;
        }
        this.getModel().setValue("bjob", null);
        long jobId = ((DynamicObject)changeData.getNewValue()).getLong("job.id");
        this.getModel().setValue("bjob", (Object)jobId, rowIndex);
    }

    private boolean checkPropetyValueChange(ChangeData changeData, int rowIndex) {
        DynamicObject stdPositionOldValue = (DynamicObject)changeData.getOldValue();
        DynamicObject stdPpositionNewValue = (DynamicObject)changeData.getNewValue();
        if (stdPositionOldValue == null && stdPpositionNewValue == null) {
            return true;
        }
        if (stdPositionOldValue != null && stdPpositionNewValue != null && stdPositionOldValue == stdPpositionNewValue) {
            return true;
        }
        if (stdPpositionNewValue == null) {
            this.getModel().setValue("bjob", null, rowIndex);
            return true;
        }
        return false;
    }

    private void setAdminOrgAndSuperior(DynamicObject entryDy, int rowIndex) {
        try {
            DynamicObject positionObject = entryDy.getDynamicObject("aposition");
            if (Objects.nonNull(positionObject)) {
                Long roleId = positionObject.getLong("workrole.id");
                this.getModel().setValue("aworkrole", (Object)roleId, rowIndex);
            }
            long dummyId = ORM.create().genLongId("hrpi_person");
            LinkedHashMap dynVsIdMap = Maps.newLinkedHashMapWithExpectedSize((int)1);
            dynVsIdMap.put(entryDy, dummyId);
            List infInParamList = DirectLeaderHelper.buildParamMap((DynamicObject[])new DynamicObject[]{entryDy}, (Map)dynVsIdMap);
            Map idVsLeaderListMap = IParttimeBillService.getInstance().getLeaderByRuleFromHRPI(infInParamList);
            List leaderList = idVsLeaderListMap.getOrDefault(dummyId, Lists.newArrayListWithExpectedSize((int)0));
            if (leaderList.size() > 0) {
                List personIdList = leaderList.stream().filter(map -> Objects.nonNull(map.get("person.id"))).map(map -> (Long)map.get("person.id")).collect(Collectors.toList());
                Object[] objects = personIdList.toArray();
                LOGGER.info("leaderList: {}", objects);
                this.getModel().setValue("asuperior", (Object)objects, rowIndex);
            }
        }
        catch (Exception exception) {
            LOGGER.error("\u83b7\u53d6\u76f4\u63a5\u4e0a\u7ea7\u5931\u8d25\uff1a", (Throwable)exception);
        }
    }

    private void setAdminOrgLeader(DynamicObject adminOrg, int rowIndex) {
        if (adminOrg == null) {
            return;
        }
        List orgChargers = IParttimeBillService.getInstance().getOrgChargers(Collections.singletonList(adminOrg.getLong("id")));
        Object[] objects = orgChargers.toArray();
        this.getModel().setValue("asuperior", (Object)objects, rowIndex);
    }
}

